/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.io.DigestUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.CidrSourceFileLocator$WhenMappings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J<\u0010\u0010\u001a\u00020\r2\u000b\u0010\u0011\u001a\u00070\b\u00a2\u0006\u0002\b\u00122\u000b\u0010\u0013\u001a\u00070\b\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\nJ\u001c\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010'\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010(\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrSourceFileLocator;", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "forcedMappingList", "", "Lcom/intellij/openapi/util/Pair;", "", "hashMappingList", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerSourceFileHash;", "pathMappingList", "addPathMapping", "", "from", "to", "askUserAndDoForceFileMapping", "title", "Lorg/jetbrains/annotations/Nls;", "message", "path", "hash", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "doForceFileMapping", "forceFileMapping", "askUser", "", "getCommonValidPathSuffixLength", "", "getDigest", "Ljava/security/MessageDigest;", "type", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerSourceFileHash$Type;", "isHashMatched", "isMappingApplicable", "mapping", "locate", "locateFileByName", "locateFileByPath", "locateFileByPathMappings", "intellij.cidr.debugger"})
public final class CidrSourceFileLocator {
    private final List<Pair<DebuggerSourceFileHash, String>> hashMappingList;
    private final List<Pair<String, String>> forcedMappingList;
    private final List<Pair<String, String>> pathMappingList;
    private final CidrDebugProcess process;

    public final void forceFileMapping(@NotNull String path, @Nullable DebuggerSourceFileHash hash, @NotNull VirtualFile file, boolean askUser) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (askUser) {
            if (hash != null) {
                if (!this.isHashMatched(file, hash)) {
                    String string = CidrDebuggerBundle.message("debug.force.file.mapping.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrDebuggerBundle.messa\u2026orce.file.mapping.title\")");
                    String string2 = CidrDebuggerBundle.message("debug.force.file.mapping.invalid.hash", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CidrDebuggerBundle.messa\u2026le.mapping.invalid.hash\")");
                    this.askUserAndDoForceFileMapping(string, string2, path, hash, file);
                    return;
                }
            } else if (!StringsKt.equals((String)PathUtil.getFileName((String)path), (String)file.getName(), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                String string = CidrDebuggerBundle.message("debug.force.file.mapping.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrDebuggerBundle.messa\u2026orce.file.mapping.title\")");
                String string3 = CidrDebuggerBundle.message("debug.force.file.mapping.invalid.name", file.getName(), PathUtil.getFileName((String)path));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"CidrDebuggerBundle.messa\u2026thUtil.getFileName(path))");
                this.askUserAndDoForceFileMapping(string, string3, path, hash, file);
                return;
            }
        }
        this.doForceFileMapping(path, hash, file);
    }

    private final void askUserAndDoForceFileMapping(String title, String message, String path, DebuggerSourceFileHash hash, VirtualFile file) {
        ModalityUiUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, title, message, path, hash, file){
            final /* synthetic */ CidrSourceFileLocator this$0;
            final /* synthetic */ String $title;
            final /* synthetic */ String $message;
            final /* synthetic */ String $path;
            final /* synthetic */ DebuggerSourceFileHash $hash;
            final /* synthetic */ VirtualFile $file;

            public final void run() {
                MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(this.$title, this.$message).icon(Messages.getWarningIcon());
                if (yesNo.ask(CidrSourceFileLocator.access$getProcess$p(this.this$0).getProject())) {
                    CidrSourceFileLocator.access$doForceFileMapping(this.this$0, this.$path, this.$hash, this.$file);
                }
            }
            {
                this.this$0 = cidrSourceFileLocator;
                this.$title = string;
                this.$message = string2;
                this.$path = string3;
                this.$hash = debuggerSourceFileHash;
                this.$file = virtualFile;
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private final void doForceFileMapping(String path, DebuggerSourceFileHash hash, VirtualFile file) {
        Pair pair;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        String toPath = string;
        int index = 0;
        if (hash != null) {
            index = 0;
            Pair pair2 = Pair.create((Object)hash, (Object)toPath);
            Intrinsics.checkNotNullExpressionValue((Object)pair2, (String)"Pair.create(hash, toPath)");
            pair = pair2;
            if (this.hashMappingList.contains(pair)) {
                return;
            }
            this.hashMappingList.add(0, (Pair<DebuggerSourceFileHash, String>)pair);
        } else {
            index = this.hashMappingList.size();
            Pair pair3 = Pair.create((Object)path, (Object)toPath);
            Intrinsics.checkNotNullExpressionValue((Object)pair3, (String)"Pair.create(path, toPath)");
            pair = pair3;
            if (this.forcedMappingList.contains(pair)) {
                return;
            }
            this.forcedMappingList.add(0, (Pair<String, String>)pair);
        }
        this.process.postCommand(new CidrDebugProcess.VoidDebuggerCommand(index, path, hash, toPath){
            final /* synthetic */ int $index;
            final /* synthetic */ String $path;
            final /* synthetic */ DebuggerSourceFileHash $hash;
            final /* synthetic */ String $toPath;

            public final void run(@NotNull DebuggerDriver driver) {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                driver.addForcedFileMapping(this.$index, this.$path, this.$hash, this.$toPath);
            }
            {
                this.$index = n;
                this.$path = string;
                this.$hash = debuggerSourceFileHash;
                this.$toPath = string2;
            }
        });
        this.addPathMapping(path, toPath);
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)this.process.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(process.project)");
        XBreakpointManager xBreakpointManager = xDebuggerManager.getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"XDebuggerManager.getInst\u2026roject).breakpointManager");
        XBreakpointManager breakpointManager = xBreakpointManager;
        Iterator iterator2 = breakpointManager.getBreakpoints(CidrLineBreakpointType.class).iterator();
        while (iterator2.hasNext()) {
            XLineBreakpoint bp;
            XLineBreakpoint xLineBreakpoint = bp = (XLineBreakpoint)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)xLineBreakpoint, (String)"bp");
            if (!Intrinsics.areEqual((Object)VfsUtilCore.urlToPath((String)xLineBreakpoint.getFileUrl()), (Object)toPath)) continue;
            XLineBreakpoint xLineBreakpoint2 = bp;
            if (!(xLineBreakpoint2 instanceof XBreakpointBase)) {
                xLineBreakpoint2 = null;
            }
            XBreakpointBase xBreakpointBase = (XBreakpointBase)xLineBreakpoint2;
            if (xBreakpointBase == null) continue;
            xBreakpointBase.fireBreakpointChanged();
        }
        XExecutionStack[] xExecutionStackArray = this.process.getSession();
        if (xExecutionStackArray != null && (xExecutionStackArray = xExecutionStackArray.getSuspendContext()) != null && (xExecutionStackArray = xExecutionStackArray.getExecutionStacks()) != null) {
            XExecutionStack[] $this$forEach$iv = xExecutionStackArray;
            boolean $i$f$forEach = false;
            XExecutionStack[] xExecutionStackArray2 = $this$forEach$iv;
            int n = xExecutionStackArray2.length;
            for (int i = 0; i < n; ++i) {
                XExecutionStack element$iv;
                XExecutionStack stack = element$iv = xExecutionStackArray2[i];
                boolean bl = false;
                if (!(stack instanceof CidrExecutionStack)) continue;
                ((CidrExecutionStack)stack).renewTopFrame();
            }
        }
        ModalityUiUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
            final /* synthetic */ CidrSourceFileLocator this$0;

            public final void run() {
                CidrSourceFileLocator.access$getProcess$p(this.this$0).getSession().rebuildViews();
                CidrSourceFileLocator.access$getProcess$p(this.this$0).getSession().showExecutionPoint();
            }
            {
                this.this$0 = cidrSourceFileLocator;
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    @Nullable
    public final VirtualFile locate(@NotNull String path, @Nullable DebuggerSourceFileHash hash) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        VirtualFile file = this.locateFileByPath(path, hash);
        if (file != null) {
            return file;
        }
        file = this.locateFileByPathMappings(path, hash);
        if (file != null) {
            return file;
        }
        file = (VirtualFile)SlowOperations.allowSlowOperations((ThrowableComputable)new ThrowableComputable(this, path, hash){
            final /* synthetic */ CidrSourceFileLocator this$0;
            final /* synthetic */ String $path;
            final /* synthetic */ DebuggerSourceFileHash $hash;

            public final VirtualFile compute() {
                return CidrSourceFileLocator.access$locateFileByName(this.this$0, this.$path, this.$hash);
            }
            {
                this.this$0 = cidrSourceFileLocator;
                this.$path = string;
                this.$hash = debuggerSourceFileHash;
            }
        });
        if (file != null) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            this.addPathMapping(path, string);
            return file;
        }
        return null;
    }

    private final VirtualFile locateFileByPath(String path, DebuggerSourceFileHash hash) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        return file != null && (hash == null || this.isHashMatched(file, hash)) ? file : null;
    }

    private final VirtualFile locateFileByPathMappings(String path, DebuggerSourceFileHash hash) {
        VirtualFile file;
        if (hash != null) {
            for (Pair pair : this.hashMappingList) {
                if (Intrinsics.areEqual((Object)hash, (Object)((DebuggerSourceFileHash)pair.first)) ^ true || (file = LocalFileSystem.getInstance().findFileByPath((String)pair.second)) == null) continue;
                return file;
            }
        }
        for (Pair pair : this.forcedMappingList) {
            if (Intrinsics.areEqual((Object)path, (Object)((String)pair.first)) ^ true || (file = LocalFileSystem.getInstance().findFileByPath((String)pair.second)) == null) continue;
            return file;
        }
        for (Pair pair : this.pathMappingList) {
            Object object = pair.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapping.first");
            if (!this.isMappingApplicable(path, (String)object)) continue;
            StringBuilder stringBuilder = new StringBuilder().append((String)pair.second);
            String string = path;
            int n = ((String)pair.first).length();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            file = this.locateFileByPath(stringBuilder.append(string3).toString(), hash);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private final VirtualFile locateFileByName(String path, DebuggerSourceFileHash hash) {
        Ref bestFile = new Ref();
        int[] bestSuffixLen = new int[]{-1};
        try {
            FilenameIndex.processFilesByName((String)PathUtil.getFileName((String)path), (boolean)false, (boolean)SystemInfo.isFileSystemCaseSensitive, (Processor)new Processor(this, hash, path, bestSuffixLen, bestFile){
                final /* synthetic */ CidrSourceFileLocator this$0;
                final /* synthetic */ DebuggerSourceFileHash $hash;
                final /* synthetic */ String $path;
                final /* synthetic */ int[] $bestSuffixLen;
                final /* synthetic */ Ref $bestFile;

                public final boolean process(@NotNull PsiFileSystemItem psiFile) {
                    Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                    VirtualFile currFile = psiFile.getVirtualFile();
                    if (this.$hash == null) {
                        VirtualFile virtualFile = currFile;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"currFile");
                        String string = virtualFile.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currFile.path");
                        int suffixLen = CidrSourceFileLocator.access$getCommonValidPathSuffixLength(this.this$0, this.$path, string);
                        if (suffixLen > this.$bestSuffixLen[0]) {
                            this.$bestFile.set((Object)currFile);
                            this.$bestSuffixLen[0] = suffixLen;
                            return true;
                        }
                    } else {
                        VirtualFile virtualFile = currFile;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"currFile");
                        if (CidrSourceFileLocator.access$isHashMatched(this.this$0, virtualFile, this.$hash)) {
                            this.$bestFile.set((Object)currFile);
                            return false;
                        }
                    }
                    return true;
                }
                {
                    this.this$0 = cidrSourceFileLocator;
                    this.$hash = debuggerSourceFileHash;
                    this.$path = string;
                    this.$bestSuffixLen = nArray;
                    this.$bestFile = ref;
                }
            }, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.process.getProject()), (Project)this.process.getProject());
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return (VirtualFile)bestFile.get();
    }

    private final void addPathMapping(String from, String to) {
        int i;
        int suffixLen = this.getCommonValidPathSuffixLength(from, to);
        int fromSubstrLen = from.length() - suffixLen;
        for (i = 0; i < this.pathMappingList.size() && ((String)this.pathMappingList.get((int)i).first).length() > fromSubstrLen; ++i) {
        }
        int index = i;
        String string = from;
        int n = 0;
        int n2 = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, fromSubstrLen);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String fromCut = string3;
        String string4 = to;
        n2 = 0;
        int n3 = to.length() - suffixLen;
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n2, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String toCut = string6;
        if (StringsKt.equals((String)fromCut, (String)toCut, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
            return;
        }
        Pair pair = Pair.create((Object)fromCut, (Object)toCut);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"Pair.create(fromCut, toCut)");
        Pair pair2 = pair;
        if (this.pathMappingList.contains(pair2) || this.forcedMappingList.contains(pair2)) {
            return;
        }
        this.pathMappingList.add(index, (Pair<String, String>)pair2);
        this.process.postCommand(new CidrDebugProcess.VoidDebuggerCommand(this, index, fromCut, toCut){
            final /* synthetic */ CidrSourceFileLocator this$0;
            final /* synthetic */ int $index;
            final /* synthetic */ String $fromCut;
            final /* synthetic */ String $toCut;

            public final void run(@NotNull DebuggerDriver driver) {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                driver.addPathMapping(CidrSourceFileLocator.access$getHashMappingList$p(this.this$0).size() + CidrSourceFileLocator.access$getForcedMappingList$p(this.this$0).size() + this.$index, this.$fromCut, this.$toCut);
            }
            {
                this.this$0 = cidrSourceFileLocator;
                this.$index = n;
                this.$fromCut = string;
                this.$toCut = string2;
            }
        });
    }

    private final boolean isHashMatched(VirtualFile file, DebuggerSourceFileHash hash) {
        ProgressManager.checkCanceled();
        DebuggerSourceFileHash.Type type = hash.getType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"hash.type");
        MessageDigest digest = this.getDigest(type);
        try {
            digest.update(file.contentsToByteArray());
        }
        catch (IOException ignored) {
            return false;
        }
        return StringsKt.equals((String)DigestUtil.digestToHash((MessageDigest)digest), (String)hash.getHash(), (boolean)true);
    }

    private final MessageDigest getDigest(DebuggerSourceFileHash.Type type) {
        MessageDigest messageDigest;
        switch (CidrSourceFileLocator$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                messageDigest = DigestUtil.md5();
                break;
            }
            case 2: {
                messageDigest = DigestUtil.sha1();
                break;
            }
            case 3: {
                messageDigest = DigestUtil.sha256();
                break;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException();
            }
        }
        return messageDigest;
    }

    private final boolean isMappingApplicable(String path, String mapping) {
        if (!StringsKt.startsWith$default((String)path, (String)mapping, (boolean)false, (int)2, null)) {
            return false;
        }
        if (mapping.length() == path.length()) {
            return true;
        }
        if (StringsKt.endsWith$default((String)mapping, (String)"\\", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)mapping, (String)"/", (boolean)false, (int)2, null)) {
            return true;
        }
        String string = path;
        int n = mapping.length();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String suffix = string3;
        return StringsKt.startsWith$default((String)suffix, (String)"\\", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)suffix, (String)"/", (boolean)false, (int)2, null);
    }

    private final int getCommonValidPathSuffixLength(String from, String to) {
        int suffixLen;
        String fromNormalized = null;
        String toNormalized = null;
        if (!SystemInfo.isFileSystemCaseSensitive) {
            String string = from;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
            Locale locale2 = locale;
            boolean bl = false;
            String string2 = string;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
            fromNormalized = string4;
            string = to;
            Locale locale3 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"Locale.getDefault()");
            locale2 = locale3;
            bl = false;
            string2 = string;
            bl2 = false;
            String string5 = string2;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
            toNormalized = string6;
        } else {
            fromNormalized = from;
            toNormalized = to;
        }
        for (suffixLen = StringUtil.commonSuffixLength((CharSequence)fromNormalized, (CharSequence)toNormalized); suffixLen > 0; --suffixLen) {
            char cutChar = fromNormalized.charAt(fromNormalized.length() - suffixLen);
            if (cutChar != '\\' && cutChar != '/') continue;
            break;
        }
        return suffixLen;
    }

    public CidrSourceFileLocator(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        this.process = process;
        boolean bl = false;
        this.hashMappingList = new ArrayList();
        bl = false;
        this.forcedMappingList = new ArrayList();
        bl = false;
        this.pathMappingList = new ArrayList();
    }

    public static final /* synthetic */ CidrDebugProcess access$getProcess$p(CidrSourceFileLocator $this) {
        return $this.process;
    }

    public static final /* synthetic */ void access$doForceFileMapping(CidrSourceFileLocator $this, String path, DebuggerSourceFileHash hash, VirtualFile file) {
        $this.doForceFileMapping(path, hash, file);
    }

    public static final /* synthetic */ VirtualFile access$locateFileByName(CidrSourceFileLocator $this, String path, DebuggerSourceFileHash hash) {
        return $this.locateFileByName(path, hash);
    }

    public static final /* synthetic */ int access$getCommonValidPathSuffixLength(CidrSourceFileLocator $this, String from, String to) {
        return $this.getCommonValidPathSuffixLength(from, to);
    }

    public static final /* synthetic */ boolean access$isHashMatched(CidrSourceFileLocator $this, VirtualFile file, DebuggerSourceFileHash hash) {
        return $this.isHashMatched(file, hash);
    }

    public static final /* synthetic */ List access$getHashMappingList$p(CidrSourceFileLocator $this) {
        return $this.hashMappingList;
    }

    public static final /* synthetic */ List access$getForcedMappingList$p(CidrSourceFileLocator $this) {
        return $this.forcedMappingList;
    }
}

