/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.MemoryViewPanel;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\f\u001a\u00020\u0004*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/ShowMemoryViewInEditorAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getCurrentSession", "Lcom/intellij/xdebugger/XDebugSession;", "getDebugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "update", "withClosingToReopen", "Lcom/intellij/openapi/vfs/VirtualFile;", "action", "Lkotlin/Function0;", "intellij.cidr.debugger"})
public final class ShowMemoryViewInEditorAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CidrDebugProcess cidrDebugProcess = this.getDebugProcess(e);
        if (cidrDebugProcess == null) {
            return;
        }
        CidrDebugProcess debugProcess = cidrDebugProcess;
        Project project = debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"debugProcess.project");
        Project project2 = project;
        MemoryViewPanel memoryViewPanel = debugProcess.getHexdumpViewPanel();
        if (memoryViewPanel == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)memoryViewPanel, (String)"debugProcess.hexdumpViewPanel ?: return");
        MemoryViewPanel memoryViewPanel2 = memoryViewPanel;
        FileEditor fileEditor = memoryViewPanel2.getFileEditor();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"memoryViewPanel.fileEditor");
        VirtualFile virtualFile = fileEditor.getFile();
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"memoryViewPanel.fileEditor.file ?: return");
        VirtualFile file = virtualFile;
        this.withClosingToReopen(file, (Function0<Unit>)((Function0)new Function0<Unit>(project2, file, memoryViewPanel2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ MemoryViewPanel $memoryViewPanel;

            public final void invoke() {
                Object[] objectArray = FileEditorManager.getInstance((Project)this.$project).openFile(this.$file, true);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FileEditorManager.getIns\u2026ect).openFile(file, true)");
                FileEditor fileEditor = (FileEditor)ArraysKt.firstOrNull((Object[])objectArray);
                if (fileEditor == null) {
                    return;
                }
                FileEditor fileEditor2 = fileEditor;
                GotoAddressPanel gotoAddressPanel = (GotoAddressPanel)((Object)GotoAddressPanel.GOTO_ADDRESS_FILE_EDITOR_KEY.get((UserDataHolder)fileEditor2));
                CidrPhysicalValue lastNavigatedValue = this.$memoryViewPanel.getGotoAddressPanel().getLastNavigatedValue();
                if (gotoAddressPanel != null && lastNavigatedValue != null) {
                    GotoAddressPanel.navigateToValue$default(gotoAddressPanel, lastNavigatedValue, false, 2, null);
                }
            }
            {
                this.$project = project;
                this.$file = virtualFile;
                this.$memoryViewPanel = memoryViewPanel;
                super(0);
            }
        }));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CidrDebugProcess debugProcess = this.getDebugProcess(e);
        Object object = debugProcess;
        VirtualFile memoryViewFile = object != null && (object = ((CidrDebugProcess)object).getHexdumpViewPanel()) != null && (object = ((MemoryViewPanel)object).getFileEditor()) != null ? object.getFile() : null;
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setVisible(debugProcess != null);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(memoryViewFile != null);
    }

    private final CidrDebugProcess getDebugProcess(AnActionEvent e) {
        XDebugSession debugSession;
        XDebugSession xDebugSession = debugSession = this.getCurrentSession(e);
        Object object = xDebugSession != null ? xDebugSession.getDebugProcess() : null;
        if (!(object instanceof CidrDebugProcess)) {
            object = null;
        }
        return (CidrDebugProcess)object;
    }

    private final XDebugSession getCurrentSession(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return null");
        Project project2 = project;
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(project)");
        return xDebuggerManager.getCurrentSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withClosingToReopen(VirtualFile $this$withClosingToReopen, Function0<Unit> action) {
        $this$withClosingToReopen.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, (Object)true);
        try {
            action.invoke();
        }
        finally {
            $this$withClosingToReopen.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
        }
    }
}

