/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponseVisitor;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbLexer;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbParser;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;

public class GDBResponse {
    public static GDBResponse parse(String s) throws ResponseParseException {
        return new Parser(s).parse();
    }

    private static String formatRecord(RecordCategory kind, RecordType name, GDBTuple resultList) {
        StringBuilder buffer = new StringBuilder(kind.toString());
        buffer.append(name);
        if (!resultList.isEmpty()) {
            buffer.append(",");
            GDBResponse.doFormat(buffer, resultList, false);
        }
        return buffer.toString();
    }

    private static void doFormat(StringBuilder buffer, Object obj, boolean closed) {
        if (obj instanceof Pair) {
            buffer.append(((Pair)obj).first);
            buffer.append("=");
            GDBResponse.doFormat(buffer, ((Pair)obj).second, true);
        } else if (obj instanceof List) {
            if (closed) {
                buffer.append(obj instanceof GDBTuple ? (char)'{' : '[');
            }
            boolean first = true;
            for (Object each : (List)obj) {
                if (!first) {
                    buffer.append(',');
                }
                first = false;
                GDBResponse.doFormat(buffer, each, true);
            }
            if (closed) {
                buffer.append(obj instanceof GDBTuple ? (char)'}' : ']');
            }
        } else if (obj instanceof String) {
            buffer.append("\"").append(StringUtil.escapeQuotes((String)((String)obj))).append("\"");
        } else {
            throw new RuntimeException("unknown object: " + obj);
        }
    }

    public String toString() {
        return super.toString();
    }

    public static class ResponseParseException
    extends Exception {
        public ResponseParseException(String text, Throwable cause) {
            super(text, cause);
        }
    }

    public static class StreamRecord
    extends GDBResponse {
        private final Category myCategory;
        private final String myText;

        public StreamRecord(@org.jetbrains.annotations.NotNull Category category, @org.jetbrains.annotations.NotNull String text) {
            if (category == null) {
                StreamRecord.$$$reportNull$$$0(0);
            }
            if (text == null) {
                StreamRecord.$$$reportNull$$$0(1);
            }
            this.myCategory = category;
            this.myText = text;
        }

        @org.jetbrains.annotations.NotNull
        public Category getCategory() {
            Category category = this.myCategory;
            if (category == null) {
                StreamRecord.$$$reportNull$$$0(2);
            }
            return category;
        }

        @NlsSafe
        @org.jetbrains.annotations.NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                StreamRecord.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public String toString() {
            return this.myCategory.myPrefix + "\"" + StringUtil.escapeStringCharacters((String)this.myText) + "\"";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCategory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Category implements RecordCategory
        {
            console("~"),
            target("@"),
            log("&");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            @Override
            @NlsSafe
            @org.jetbrains.annotations.NotNull
            public String getPrefix() {
                String string = this.myPrefix;
                if (string == null) {
                    Category.$$$reportNull$$$0(0);
                }
                return string;
            }

            public String toString() {
                return this.myPrefix;
            }

            static Category forPrefix(@org.jetbrains.annotations.NotNull String prefix) {
                if (prefix == null) {
                    Category.$$$reportNull$$$0(1);
                }
                return (Category)RecordCategory.forPrefix((RecordCategory[])Category.values(), (String)prefix);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord$Category";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prefix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPrefix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord$Category";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "forPrefix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    public static class AsyncRecord
    extends Record<Category, Type> {
        public AsyncRecord(@org.jetbrains.annotations.NotNull Category category, @org.jetbrains.annotations.NotNull String type, @org.jetbrains.annotations.NotNull GDBTuple resultList) {
            if (category == null) {
                AsyncRecord.$$$reportNull$$$0(0);
            }
            if (type == null) {
                AsyncRecord.$$$reportNull$$$0(1);
            }
            if (resultList == null) {
                AsyncRecord.$$$reportNull$$$0(2);
            }
            super(category, new Type(type), resultList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "category";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultList";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static class Type
        implements RecordType {
            @org.jetbrains.annotations.NotNull
            private final String myValue;

            public Type(@org.jetbrains.annotations.NotNull String value) {
                if (value == null) {
                    Type.$$$reportNull$$$0(0);
                }
                this.myValue = value;
            }

            @NlsSafe
            @org.jetbrains.annotations.NotNull
            public String getValue() {
                String string = this.myValue;
                if (string == null) {
                    Type.$$$reportNull$$$0(1);
                }
                return string;
            }

            public String toString() {
                return this.myValue;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Type name = (Type)o;
                return this.myValue.equals(name.myValue);
            }

            public int hashCode() {
                return this.myValue.hashCode();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord$Type";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord$Type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        public static enum Category implements RecordCategory
        {
            exec("*"),
            notify("="),
            status("+");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            @Override
            @NlsSafe
            @org.jetbrains.annotations.NotNull
            public String getPrefix() {
                String string = this.myPrefix;
                if (string == null) {
                    Category.$$$reportNull$$$0(0);
                }
                return string;
            }

            public String toString() {
                return this.myPrefix;
            }

            static Category forPrefix(@org.jetbrains.annotations.NotNull String prefix) {
                if (prefix == null) {
                    Category.$$$reportNull$$$0(1);
                }
                return (Category)RecordCategory.forPrefix((RecordCategory[])Category.values(), (String)prefix);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord$Category";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prefix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPrefix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord$Category";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "forPrefix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    public static class ResultRecord
    extends Record<Category, Type> {
        public ResultRecord(@org.jetbrains.annotations.NotNull Category kind, @org.jetbrains.annotations.NotNull Type type, @org.jetbrains.annotations.NotNull GDBTuple resultList) {
            if (kind == null) {
                ResultRecord.$$$reportNull$$$0(0);
            }
            if (type == null) {
                ResultRecord.$$$reportNull$$$0(1);
            }
            if (resultList == null) {
                ResultRecord.$$$reportNull$$$0(2);
            }
            super(kind, type, resultList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultList";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$ResultRecord";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static enum Type implements RecordType
        {
            done,
            running,
            connected,
            error,
            exit,
            stepping,
            continuing,
            result,
            tuple_value,
            list_value,
            str_value;

        }

        public static enum Category implements RecordCategory
        {
            result("^");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            @Override
            @NlsSafe
            @org.jetbrains.annotations.NotNull
            public String getPrefix() {
                String string = this.myPrefix;
                if (string == null) {
                    Category.$$$reportNull$$$0(0);
                }
                return string;
            }

            public String toString() {
                return this.myPrefix;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$ResultRecord$Category", "getPrefix"));
            }
        }
    }

    public static abstract class Record<CATEGORY_TYPE extends RecordCategory, TYPE_TYPE extends RecordType>
    extends GDBResponse {
        @org.jetbrains.annotations.NotNull
        private final CATEGORY_TYPE myCategory;
        @org.jetbrains.annotations.NotNull
        private final TYPE_TYPE myType;
        @org.jetbrains.annotations.NotNull
        private final GDBTuple myResultList;

        public Record(@org.jetbrains.annotations.NotNull CATEGORY_TYPE category, @org.jetbrains.annotations.NotNull TYPE_TYPE type, @org.jetbrains.annotations.NotNull GDBTuple resultList) {
            if (category == null) {
                Record.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Record.$$$reportNull$$$0(1);
            }
            if (resultList == null) {
                Record.$$$reportNull$$$0(2);
            }
            this.myCategory = category;
            this.myType = type;
            this.myResultList = resultList;
        }

        @org.jetbrains.annotations.NotNull
        public CATEGORY_TYPE getCategory() {
            CATEGORY_TYPE CATEGORY_TYPE = this.myCategory;
            if (CATEGORY_TYPE == null) {
                Record.$$$reportNull$$$0(3);
            }
            return CATEGORY_TYPE;
        }

        @org.jetbrains.annotations.NotNull
        public TYPE_TYPE getType() {
            TYPE_TYPE TYPE_TYPE = this.myType;
            if (TYPE_TYPE == null) {
                Record.$$$reportNull$$$0(4);
            }
            return TYPE_TYPE;
        }

        @org.jetbrains.annotations.NotNull
        public GDBTuple getResultList() {
            GDBTuple gDBTuple = this.myResultList;
            if (gDBTuple == null) {
                Record.$$$reportNull$$$0(5);
            }
            return gDBTuple;
        }

        @Override
        public String toString() {
            return GDBResponse.formatRecord(this.getCategory(), this.getType(), this.myResultList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultList";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$Record";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$Record";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCategory";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface RecordType {
    }

    public static interface RecordCategory {
        @NlsSafe
        @org.jetbrains.annotations.NotNull
        public String getPrefix();

        @org.jetbrains.annotations.NotNull
        public static <T extends RecordCategory> T forPrefix(T @org.jetbrains.annotations.NotNull [] values, @org.jetbrains.annotations.NotNull String prefix) {
            if (prefix == null) {
                RecordCategory.$$$reportNull$$$0(0);
            }
            if (values == null) {
                RecordCategory.$$$reportNull$$$0(1);
            }
            for (T each : values) {
                if (!each.getPrefix().equals(prefix)) continue;
                T t = each;
                if (t == null) {
                    RecordCategory.$$$reportNull$$$0(2);
                }
                return t;
            }
            throw new IllegalArgumentException("Unknown RecordCategory prefix, expected one of " + Arrays.toString(values));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$RecordCategory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$RecordCategory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forPrefix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Parser {
        String text;

        private Parser(String s) {
            this.text = s;
        }

        public GDBResponse parse() throws ResponseParseException {
            ANTLRInputStream input = new ANTLRInputStream(this.text);
            GdbLexer lexer = new GdbLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            GdbParser parser = new GdbParser((TokenStream)tokens);
            parser.removeErrorListeners();
            parser.addErrorListener(new ANTLRErrorListener(){

                public void syntaxError(Recognizer<?, ?> recognizer, @Nullable Object o, int line, int position, String msg, @Nullable RecognitionException e) {
                    throw new RuntimeException("Syntax error: " + msg + " in \"" + text + "\" line " + line + " position " + position);
                }

                public void reportAmbiguity(@NotNull org.antlr.v4.runtime.Parser parser, @NotNull DFA dfa, int startIndex, int stopIndex, boolean b, @NotNull BitSet bitSet, @NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.warn("Ambiguity in \"" + text + "\" started " + startIndex + " stopped " + stopIndex);
                }

                public void reportAttemptingFullContext(@NotNull org.antlr.v4.runtime.Parser parser, @NotNull DFA dfa, int startIndex, int stopIndex, @Nullable BitSet bitSet, @NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.warn("Attempting full context in \"" + text + "\" started " + startIndex + " stopped " + stopIndex);
                }

                public void reportContextSensitivity(@NotNull org.antlr.v4.runtime.Parser parser, @NotNull DFA dfa, int startIndex, int stopIndex, int i3, @NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.error("Context sensitivity in \"" + text + "\" started " + startIndex + " stopped " + stopIndex);
                }
            });
            try {
                GdbParser.ResponseContext tree = parser.response();
                GDBResponseVisitor visitor = new GDBResponseVisitor();
                return (GDBResponse)visitor.visit((ParseTree)tree);
            }
            catch (Throwable e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }
}

