/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.GLogOutputReaders;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLSection;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Broadcasts;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.ProtocolResponses;
import com.jetbrains.cidr.execution.debugger.backend.lldb.lang.LLDBLanguage;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufServer;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufTimedOutException;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufUtils;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import com.pty4j.unix.Pty;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class LLDBDriver
extends DebuggerDriver
implements Consumer<Message> {
    public static final Logger LOG = CidrDebuggerLog.LOG;
    public static final Key<Boolean> ENABLE_STL_RENDERERS = Key.create((String)"LLDBDriver.synthethicsEnabled");
    private static final Key<Integer> LLVALUE_ID = Key.create((String)"LLDBDriver.LLVALUE_ID");
    private static final Key<LLValueDataLoader> LLVALUE_DATA_LOADER = Key.create((String)"LLDBDriver.LLVALUE_DATA_LOADER");
    private static final Key<LLValueData> LLVALUE_DATA = Key.create((String)"LLDBDriver.LLVALUE_DATA");
    private static final Key<Integer> CHILDREN_COUNT_CACHE = Key.create((String)"LLDBDriver.CHILDREN_COUNT_CACHE");
    public static final String NO_RESULT = "<no result>";
    private static final String LOCKED_DEVICE_RESPONSE = "process launch failed: Locked";
    private static final String TERMINATED_DUE_TO_SIGNAL = "Terminated due to signal ";
    private GeneralCommandLine myLLDBCommandLine;
    private BaseProcessHandler myLLDBFrontendHandler;
    private final CompletableFuture<ProtobufServer<ProtocolResponses.CompositeResponse>> myConnectedClient;
    private final Set<Integer> myTemporaryBreakpoints;
    private final OutputStream myProcessInputProxy;
    @Nullable
    private volatile OutputStream myProcessInput;
    private volatile Integer myAsyncAttachingTo;
    private final LLDBDriverConfiguration myStarter;
    private boolean myValuesFilteringEnabled;
    private ProtobufServer<ProtocolResponses.CompositeResponse> myProtobufServer;
    private final GLogOutputReaders myGLogOutputReaders;
    private final AtomicReference<DebuggerFatalException> myAsyncFatalException;
    @Nullable
    private ToolVersion myLLDBVersion;
    private long myCapabilities;
    private volatile long myStoppedThreadID;
    @Nullable
    private Map<String, List<LLSection>> mySectionsMap;
    @Nullable
    private String myAutorunScriptName;
    @Nullable
    private String myStepIntoClassName;
    @Nullable
    private String myStepOverClassName;
    @Nullable
    private String myStepOutClassName;

    private void dispatchInput(String input, Model.DispatchTarget target) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.dispatchInput(input, target);
        this.getProtobufClient().sendMessage((Message)request, ProtocolResponses.DispatchInput_Res.class, dispatchInput_res -> {});
    }

    protected ProtobufServer<ProtocolResponses.CompositeResponse> getProtobufClient() throws ExecutionException {
        this.checkErrors();
        return ExecutionResult.get(this.myConnectedClient);
    }

    private void storeAsyncFatalException(DebuggerFatalException e) {
        this.myAsyncFatalException.compareAndSet(null, e);
    }

    @Override
    public void checkErrors() throws ExecutionException {
        DebuggerFatalException exception = this.myAsyncFatalException.get();
        if (exception != null) {
            this.myAsyncFatalException.compareAndSet(exception, null);
            throw new DebuggerFatalException((Throwable)((Object)exception));
        }
    }

    @NotNull
    private <R extends Message, E extends Exception> DebuggerDriver.StopPlace sendAndHandleJumpRequest(@NotNull LLThread thread, @NotNull Message message, @NotNull Class<R> responseClass, @NotNull @NotNull Function<R,  @NotNull Model.LLDBFrame> getNewFrame) throws ExecutionException, DebuggerCommandException, E {
        if (thread == null) {
            LLDBDriver.$$$reportNull$$$0(0);
        }
        if (message == null) {
            LLDBDriver.$$$reportNull$$$0(1);
        }
        if (responseClass == null) {
            LLDBDriver.$$$reportNull$$$0(2);
        }
        if (getNewFrame == null) {
            LLDBDriver.$$$reportNull$$$0(3);
        }
        ThrowDebuggerCommandExceptionIfNotValid errorHandler = new ThrowDebuggerCommandExceptionIfNotValid(LLDBBundle.message("error.invalid.response", new Object[0]));
        try {
            R response = this.sendMessageAndWaitForReply(message, responseClass, errorHandler, 0L);
            Model.LLDBFrame newFrame = (Model.LLDBFrame)getNewFrame.fun(response);
            return new DebuggerDriver.StopPlace(thread, this.newLLFrame(newFrame));
        }
        catch (DebuggerCommandException ex) {
            String errorMessage = ex.getMessage();
            if (errorMessage != null && errorMessage.contains("is outside the current function")) {
                throw new DebuggerDriver.JumpToLineOutsideCurrentFunctionException(errorMessage, ex);
            }
            throw ex;
        }
    }

    @NotNull
    public <R extends Message> R sendMessageAndWaitForReply(@NotNull Message message, @NotNull Class<R> responseClass) throws ExecutionException {
        if (message == null) {
            LLDBDriver.$$$reportNull$$$0(4);
        }
        if (responseClass == null) {
            LLDBDriver.$$$reportNull$$$0(5);
        }
        ThrowIfNotValid errorHandler = new ThrowIfNotValid(LLDBBundle.message("error.invalid.response", new Object[0]));
        R r = this.sendMessageAndWaitForReply(message, responseClass, errorHandler, 0L);
        if (r == null) {
            LLDBDriver.$$$reportNull$$$0(6);
        }
        return r;
    }

    @NotNull
    public <R extends Message, E extends Exception> R sendMessageAndWaitForReply(@NotNull Message message, @NotNull Class<R> responseClass, @NotNull ResponseMessageConsumer<? super R, E> errorHandler) throws ExecutionException, E {
        if (message == null) {
            LLDBDriver.$$$reportNull$$$0(7);
        }
        if (responseClass == null) {
            LLDBDriver.$$$reportNull$$$0(8);
        }
        if (errorHandler == null) {
            LLDBDriver.$$$reportNull$$$0(9);
        }
        R r = this.sendMessageAndWaitForReply(message, responseClass, errorHandler, 0L);
        if (r == null) {
            LLDBDriver.$$$reportNull$$$0(10);
        }
        return r;
    }

    @NotNull
    public <R extends Message, E extends Exception> R sendMessageAndWaitForReply(@NotNull Message message, @NotNull Class<R> responseClass, @NotNull ResponseMessageConsumer<? super R, E> errorHandler, long msTimeout) throws ExecutionException, E {
        if (message == null) {
            LLDBDriver.$$$reportNull$$$0(11);
        }
        if (responseClass == null) {
            LLDBDriver.$$$reportNull$$$0(12);
        }
        if (errorHandler == null) {
            LLDBDriver.$$$reportNull$$$0(13);
        }
        Ref responseRef = Ref.create();
        Consumer responseHandler = responseMessage -> {
            errorHandler.consume((Object)responseMessage);
            if (!errorHandler.isValid()) {
                return;
            }
            responseRef.set(responseMessage);
        };
        this.getProtobufClient().sendMessageAndWaitForReply(message, responseClass, responseHandler, msTimeout);
        errorHandler.throwIfNeeded();
        Message response = (Message)responseRef.get();
        if (response == null) {
            throw new ExecutionException(LLDBBundle.message("error.null.response.to.message", message));
        }
        Message message2 = response;
        if (message2 == null) {
            LLDBDriver.$$$reportNull$$$0(14);
        }
        return (R)message2;
    }

    public void setAutorunScriptName(@Nullable String autorunScriptName) {
        this.myAutorunScriptName = autorunScriptName;
    }

    public void setStepIntoClassName(@Nullable String stepIntoClassName) {
        this.myStepIntoClassName = stepIntoClassName;
    }

    public void setStepOverClassName(@Nullable String stepOverClassName) {
        this.myStepOverClassName = stepOverClassName;
    }

    public void setStepOutClassName(@Nullable String stepOutClassName) {
        this.myStepOutClassName = stepOutClassName;
    }

    public LLDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull LLDBDriverConfiguration starter, @NotNull ArchitectureType architectureType) throws ExecutionException {
        if (handler == null) {
            LLDBDriver.$$$reportNull$$$0(15);
        }
        if (starter == null) {
            LLDBDriver.$$$reportNull$$$0(16);
        }
        if (architectureType == null) {
            LLDBDriver.$$$reportNull$$$0(17);
        }
        super(handler);
        this.myConnectedClient = new CompletableFuture();
        this.myTemporaryBreakpoints = new HashSet<Integer>();
        this.myProcessInputProxy = new OutputStream(){

            @Override
            public void write(int i) throws IOException {
                OutputStream input = LLDBDriver.this.myProcessInput;
                if (input != null) {
                    input.write(i);
                }
            }

            @Override
            public void write(byte[] bytes, int i, int i1) throws IOException {
                OutputStream input = LLDBDriver.this.myProcessInput;
                if (input != null) {
                    input.write(bytes, i, i1);
                }
            }

            @Override
            public void close() throws IOException {
                OutputStream input = LLDBDriver.this.myProcessInput;
                if (input != null) {
                    input.close();
                }
            }

            @Override
            public void flush() throws IOException {
                OutputStream input = LLDBDriver.this.myProcessInput;
                if (input != null) {
                    input.flush();
                }
            }
        };
        this.myAsyncFatalException = new AtomicReference();
        this.myCapabilities = 0L;
        this.myAutorunScriptName = null;
        this.myStepIntoClassName = null;
        this.myStepOverClassName = null;
        this.myStepOutClassName = null;
        this.myStarter = starter;
        this.myGLogOutputReaders = new GLogOutputReaders(LLDBDriver.getLogDir(), "LLDBFrontend"){

            @Override
            protected void onTextAvailable(@NotNull String text, @NotNull GLogOutputReaders.LogType type) {
                if (text == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(text.trim());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.startDriver(architectureType);
    }

    @NotNull
    private static File getLogDir() {
        return new File((String)(ApplicationManager.getApplication().isUnitTestMode() ? PathManager.getSystemPath() + "/testlog" : PathManager.getLogPath()));
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return false;
    }

    @Override
    public boolean supportsDisasm() {
        return true;
    }

    @Override
    public boolean supportsJumpToLine() {
        return true;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        LLDBLanguage lLDBLanguage = LLDBLanguage.INSTANCE;
        if (lLDBLanguage == null) {
            LLDBDriver.$$$reportNull$$$0(18);
        }
        return lLDBLanguage;
    }

    @Override
    @NotNull
    public BaseProcessHandler getProcessHandler() {
        BaseProcessHandler baseProcessHandler = this.myLLDBFrontendHandler;
        if (baseProcessHandler == null) {
            LLDBDriver.$$$reportNull$$$0(19);
        }
        return baseProcessHandler;
    }

    @Override
    public boolean isInPromptMode() {
        return false;
    }

    public int getPort() {
        return this.myProtobufServer.getPort();
    }

    @Override
    @NotNull
    public HostMachine getHostMachine() {
        HostMachine hostMachine = this.myStarter.getHostMachine();
        if (hostMachine == null) {
            LLDBDriver.$$$reportNull$$$0(20);
        }
        return hostMachine;
    }

    private void startDriver(@NotNull ArchitectureType architectureType) throws ExecutionException {
        if (architectureType == null) {
            LLDBDriver.$$$reportNull$$$0(21);
        }
        try {
            this.myProtobufServer = new ProtobufServer<ProtocolResponses.CompositeResponse>((Consumer)this, (ProtobufServer.ProtobufParser)new ProtobufServer.ProtobufParser<ProtocolResponses.CompositeResponse>(){

                @Override
                public ProtocolResponses.CompositeResponse parse(byte[] buffer) throws IOException {
                    return ProtocolResponses.CompositeResponse.parseFrom(buffer);
                }

                @Override
                public boolean decompose(Message response) {
                    return response instanceof ProtocolResponses.CompositeResponse || response instanceof Broadcasts.CompositeBroadcast;
                }
            }){

                private boolean decomposeRequest(@NotNull Message request) {
                    if (request == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return request instanceof Protocol.CompositeRequest;
                }

                @Override
                public <ResponseType extends Message> void sendMessageAndWaitForReply(@NotNull Message message, @NotNull Class<ResponseType> responseClass, @NotNull Consumer<? super ResponseType> responseHandler, long msTimeout) throws ProtobufTimedOutException, ExecutionFinishedException {
                    if (message == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    if (responseClass == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    if (responseHandler == null) {
                        4.$$$reportNull$$$0(3);
                    }
                    try (CidrEventSpan ignored = new CidrEventSpan("debug", () -> "sendMessageAndWaitForReply (" + ProtobufUtils.unpackComposite(message, this::decomposeRequest).getClass().getSimpleName() + ")", () -> message.toString());){
                        super.sendMessageAndWaitForReply(message, responseClass, responseHandler, msTimeout);
                    }
                }

                @Override
                protected void handleIOException(IOException e) {
                    CidrDebuggerLog.LOG.warn((Throwable)e);
                    if (!LLDBDriver.this.myConnectedClient.completeExceptionally(e)) {
                        LLDBDriver.this.storeAsyncFatalException(new DebuggerFatalException(e));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "request";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "message";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "responseClass";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "responseHandler";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "decomposeRequest";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "sendMessageAndWaitForReply";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        this.myLLDBCommandLine = this.myStarter.createDriverCommandLine(this, architectureType);
        Map environment = this.myLLDBCommandLine.getEnvironment();
        environment.put("GLOG_log_dir", this.myGLogOutputReaders.getLogDir().getPath());
        if (LOG.isTraceEnabled()) {
            environment.put("GLOG_minloglevel", "0");
            environment.put("GLOG_logbufsecs", "0");
            environment.put("GLOG_v", "1");
            this.myGLogOutputReaders.init();
        } else {
            environment.put("GLOG_minloglevel", "2");
        }
        this.myLLDBFrontendHandler = this.createDebugProcessHandler(this.myLLDBCommandLine, this.myStarter);
        this.myLLDBFrontendHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                LLDBDriver.this.myConnectedClient.completeExceptionally(new ExecutionFinishedException());
                OutputStream processInput = LLDBDriver.this.myProcessInput;
                if (processInput != null) {
                    try {
                        processInput.close();
                    }
                    catch (IOException e) {
                        CidrDebuggerLog.LOG.warn((Throwable)e);
                    }
                }
                LLDBDriver.this.myProcessInput = null;
                LLDBDriver.this.myGLogOutputReaders.close();
                if (LLDBDriver.this.myProtobufServer != null) {
                    LLDBDriver.this.myProtobufServer.tearDown();
                }
                LLDBDriver.this.handleExited(event.getExitCode());
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (outputType == null) {
                    5.$$$reportNull$$$0(2);
                }
                if ((text = event.getText()) == null) {
                    return;
                }
                if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                    CidrDebuggerLog.LOG.debug(PathUtil.getFileName((String)LLDBDriver.this.myLLDBCommandLine.getExePath()) + ": " + text);
                }
                if (ProcessOutputType.isStderr((Key)outputType) || ProcessOutputType.isStdout((Key)outputType)) {
                    LLDBDriver.this.handleDebuggerOutput(text, outputType);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
        if (this.myValuesFilteringEnabled == enabled) {
            return;
        }
        this.myValuesFilteringEnabled = enabled;
        this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.setValuesFilteringEnabled(enabled), ProtocolResponses.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid(LLDBBundle.message("error.cannot.set.values.filtering.policy", new Object[0])));
    }

    @NotNull
    private static String getLLDBArchitectureType(@Nullable String architectureType) {
        String lldbArchitecture = StringUtil.notNullize((String)architectureType);
        if (lldbArchitecture == ArchitectureType.UNKNOWN.getId()) {
            lldbArchitecture = "";
        }
        String string = lldbArchitecture;
        if (string == null) {
            LLDBDriver.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architecture) throws ExecutionException {
        if (installer == null) {
            LLDBDriver.$$$reportNull$$$0(23);
        }
        final GeneralCommandLine targetCommandLine = installer.install();
        String lldbArchitectureId = LLDBDriver.getLLDBArchitectureType(architecture);
        final Boolean useExternalConsole = targetCommandLine.getUserData(USE_EXTERNAL_CONSOLE_KEY) == Boolean.TRUE;
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget(installer.getExecutableFile().getPath(), lldbArchitectureId));
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                return LLDBDriver.this.doLaunch(targetCommandLine, (ThrowableComputable<Protocol.CompositeRequest, ExecutionException>)((ThrowableComputable)() -> {
                    String stdoutPath = null;
                    String stderrPath = null;
                    if (LLDBDriver.this.myToRedirect && !useExternalConsole.booleanValue()) {
                        ProcessOutputReaders readers = LLDBDriver.this.initReaders((HostMachine)LocalHost.INSTANCE, targetCommandLine, !SystemInfo.isWindows);
                        stdoutPath = readers.getOutFileAbsolutePath();
                        stderrPath = readers.getErrFileAbsolutePath();
                    }
                    File inputFile = targetCommandLine.getInputFile();
                    String stdinPath = null;
                    try {
                        if (inputFile != null) {
                            if (!inputFile.isFile() || !inputFile.canRead()) {
                                throw new FileNotFoundException(CidrDebuggerBundle.message("debug.driver.cannotReadInputFile", inputFile.getPath()));
                            }
                            stdinPath = inputFile.getPath();
                        } else if (!useExternalConsole.booleanValue()) {
                            if (SystemInfo.isWindows) {
                                WinPipe pipe = WinPipe.createOutboundPipe((String)"stdin");
                                LLDBDriver.this.myProcessInput = pipe.getOutputStream();
                                stdinPath = pipe.getName();
                            } else {
                                Pty pty = new Pty(true);
                                LLDBDriver.this.myProcessInput = pty.getOutputStream();
                                stdinPath = pty.getSlaveName();
                            }
                        }
                    }
                    catch (IOException e) {
                        CidrDebuggerLog.LOG.error((Throwable)e);
                        throw new LLDBDriverException(CidrDebuggerBundle.message("debug.driver.cannotCreatePipe", e.getMessage()));
                    }
                    return ProtobufMessageFactory.launch(targetCommandLine, useExternalConsole, stdinPath, stdoutPath, stderrPath);
                }), false);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final int pid) throws ExecutionException {
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget("", ""));
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                LLDBDriver.this.myAsyncAttachingTo = pid;
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.attach", new Object[0]));
                LLDBDriver.this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.attach(pid), ProtocolResponses.Attach_Res.class, responseHandler);
                return pid;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemoteAttach(@NotNull String bundleOrExecutablePath, @Nullable String architectureId, final @NotNull GeneralCommandLine installedCommandLine, final int pid, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings, @Nullable String execSearchPaths) throws ExecutionException {
        if (bundleOrExecutablePath == null) {
            LLDBDriver.$$$reportNull$$$0(24);
        }
        if (installedCommandLine == null) {
            LLDBDriver.$$$reportNull$$$0(25);
        }
        if (pathMappings == null) {
            LLDBDriver.$$$reportNull$$$0(26);
        }
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(bundleOrExecutablePath, StringUtil.notNullize((String)architectureId), "", sysroot != null ? sysroot.getAbsolutePath() : "", ""));
        if (execSearchPaths != null) {
            this.lldbSet("target.exec-search-paths", execSearchPaths);
        }
        this.addPathMapping(pathMappings);
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                LLDBDriver.this.myAsyncAttachingTo = pid;
                String debugserverSocket = (String)installedCommandLine.getUserData(DebuggerDriver.DEBUGSERVER_SOCKET);
                CidrDebuggerLog.LOG.assertTrue(debugserverSocket != null);
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.attach", new Object[0]));
                LLDBDriver.this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.remoteAttach(pid, debugserverSocket), ProtocolResponses.Attach_Res.class, responseHandler);
                return pid;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final @NotNull String name, final boolean wait) throws ExecutionException {
        if (name == null) {
            LLDBDriver.$$$reportNull$$$0(27);
        }
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget("", ""));
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.attach", new Object[0]));
                LLDBDriver.this.sendMessageAndWaitForReply(ProtobufMessageFactory.attachByName(name, wait), ProtocolResponses.AttachByName_Res.class, responseHandler);
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    private static String getLocalPlatform() throws ExecutionException {
        if (SystemInfo.isWindows) {
            return "remote-windows";
        }
        if (SystemInfo.isMac) {
            return "remote-macosx";
        }
        if (SystemInfo.isLinux) {
            return "remote-linux";
        }
        if (SystemInfo.isFreeBSD) {
            return "remote-freebsd";
        }
        throw new ExecutionException(LLDBBundle.message("error.unsupported.os", new Object[0]));
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadCoreDump(@NotNull File coreFile, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> sourcePathMappings) throws ExecutionException {
        if (coreFile == null) {
            LLDBDriver.$$$reportNull$$$0(28);
        }
        if (sourcePathMappings == null) {
            LLDBDriver.$$$reportNull$$$0(29);
        }
        DebuggerDriver.Inferior inferior = this.loadCoreDump(coreFile, symbolFile, sysroot, sourcePathMappings, Collections.emptyList());
        if (inferior == null) {
            LLDBDriver.$$$reportNull$$$0(30);
        }
        return inferior;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadCoreDump(@NotNull File coreFile, @Nullable File symbolFile, @Nullable File sysroot, final @NotNull List<DebuggerDriver.PathMapping> sourcePathMappings, @NotNull List<String> execSearchPaths) throws ExecutionException {
        if (coreFile == null) {
            LLDBDriver.$$$reportNull$$$0(31);
        }
        if (sourcePathMappings == null) {
            LLDBDriver.$$$reportNull$$$0(32);
        }
        if (execSearchPaths == null) {
            LLDBDriver.$$$reportNull$$$0(33);
        }
        if (symbolFile != null) {
            String sysrootPath = sysroot != null ? sysroot.getAbsolutePath() : "";
            String platform = sysroot != null ? LLDBDriver.getLocalPlatform() : "";
            this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(symbolFile.getPath(), "", platform, sysrootPath, ""));
        }
        if (!execSearchPaths.isEmpty()) {
            StringBuilder execSearchPathsArgs = new StringBuilder();
            for (String path : execSearchPaths) {
                execSearchPathsArgs.append("\"").append(path.replace("\\", "\\\\")).append("\" ");
            }
            this.lldbSet("target.exec-search-paths", execSearchPathsArgs.toString());
        }
        this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.loadCoreDump(coreFile.getPath()), ProtocolResponses.LoadCore_Res.class);
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                LLDBDriver.this.addPathMapping(sourcePathMappings, true);
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemoteLaunch(final @NotNull Installer installer, @Nullable String architectureId, @Nullable File symbolsDir, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        if (installer == null) {
            LLDBDriver.$$$reportNull$$$0(34);
        }
        if (pathMappings == null) {
            LLDBDriver.$$$reportNull$$$0(35);
        }
        final GeneralCommandLine targetCommandLine = installer.install();
        String exePath = installer.getExecutableFile().getPath();
        String remoteExePath = targetCommandLine.getExePath();
        String symbolsDirPath = symbolsDir != null ? symbolsDir.getAbsolutePath() : null;
        architectureId = StringUtil.notNullize((String)architectureId);
        CidrDebuggerLog.LOG.debug(StringUtil.join((String[])new String[]{"creating remote target: exepath: ", exePath, " remotePath: ", remoteExePath, " symbols dir path: ", symbolsDirPath, " arch: ", architectureId}));
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(exePath, architectureId, "remote-ios", symbolsDirPath, remoteExePath));
        this.addPathMapping(pathMappings);
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                return LLDBDriver.this.doLaunch(targetCommandLine, (ThrowableComputable<Protocol.CompositeRequest, ExecutionException>)((ThrowableComputable)() -> {
                    String debugserverSocket = (String)targetCommandLine.getUserData(DebuggerDriver.DEBUGSERVER_SOCKET);
                    CidrDebuggerLog.LOG.assertTrue(debugserverSocket != null);
                    LLDBDriver.this.myProcessInput = new ProcessInputDispatcher();
                    return ProtobufMessageFactory.remoteLaunch(installer.getExecutableFile().getAbsolutePath(), targetCommandLine, debugserverSocket);
                }), true);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForRemote(final @NotNull String connectionString, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        String sysrootPath;
        if (connectionString == null) {
            LLDBDriver.$$$reportNull$$$0(36);
        }
        if (pathMappings == null) {
            LLDBDriver.$$$reportNull$$$0(37);
        }
        String exePath = symbolFile != null ? symbolFile.getPath() : "";
        String string = sysrootPath = sysroot != null ? sysroot.getAbsolutePath() : "";
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug(StringUtil.join((String[])new String[]{"attaching remote process started under debug server: url: ", connectionString, " exePath: ", exePath, " sysroot: ", sysrootPath}));
        }
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(exePath, "", "", sysrootPath, ""));
        this.addPathMapping(pathMappings);
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.attach.remote.debug.server", new Object[0]));
                LLDBDriver.this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.connectProcess(connectionString, null), ProtocolResponses.ConnectProcess_Res.class, responseHandler);
                LLDBDriver.this.resume();
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @NotNull
    public DebuggerDriver.Inferior loadForAttachDebugServer(@NotNull String connectionUrl, @Nullable File executable, @Nullable String architectureId, @NotNull List<DebuggerDriver.PathMapping> pathMappings, @Nullable String plugin) throws ExecutionException {
        if (connectionUrl == null) {
            LLDBDriver.$$$reportNull$$$0(38);
        }
        if (pathMappings == null) {
            LLDBDriver.$$$reportNull$$$0(39);
        }
        DebuggerDriver.Inferior inferior = this.loadForRemote(connectionUrl, executable, null, pathMappings);
        if (inferior == null) {
            LLDBDriver.$$$reportNull$$$0(40);
        }
        return inferior;
    }

    private void addPathMapping(@NotNull List<DebuggerDriver.PathMapping> mappings) throws ExecutionException {
        if (mappings == null) {
            LLDBDriver.$$$reportNull$$$0(41);
        }
        this.addPathMapping(mappings, false);
    }

    private void addPathMapping(@NotNull List<DebuggerDriver.PathMapping> mappings, boolean useTargetSourceMap) throws ExecutionException {
        if (mappings == null) {
            LLDBDriver.$$$reportNull$$$0(42);
        }
        this.addPathMapping(-1, mappings, useTargetSourceMap);
    }

    private void addPathMapping(int index, @NotNull List<DebuggerDriver.PathMapping> mappings, boolean useTargetSourceMap) throws ExecutionException {
        if (mappings == null) {
            LLDBDriver.$$$reportNull$$$0(43);
        }
        if (mappings.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (index >= 0) {
            builder.append(index).append(' ');
        }
        for (DebuggerDriver.PathMapping each : mappings) {
            builder.append("\"").append(each.from).append("\" ");
            builder.append("\"").append(each.to).append("\" ");
        }
        String command = useTargetSourceMap ? (index >= 0 ? "settings insert-before target.source-map " : "settings append target.source-map ") : (index >= 0 ? "target modules search-paths insert " : "target modules search-paths add ");
        this.myProtobufServer.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, command + builder), ProtocolResponses.HandleConsoleCommand_Res.class, new ThrowIfNotValid(CidrDebuggerBundle.message("debug.command.error.cannotAddModulesSearchPaths", new Object[0])), Integer.MAX_VALUE);
    }

    protected void sendCreateTargetRequest(@NotNull Protocol.CompositeRequest createTargetRequest) throws ExecutionException {
        if (createTargetRequest == null) {
            LLDBDriver.$$$reportNull$$$0(44);
        }
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.target.create", new Object[0]));
        this.sendMessageAndWaitForReply((Message)createTargetRequest, ProtocolResponses.CreateTarget_Res.class, responseHandler);
    }

    private long doLaunch(@NotNull GeneralCommandLine targetCommandLine, @NotNull ThrowableComputable<Protocol.CompositeRequest, ExecutionException> launchRequestSupplier, boolean isRemoteTarget) throws ExecutionException {
        if (targetCommandLine == null) {
            LLDBDriver.$$$reportNull$$$0(45);
        }
        if (launchRequestSupplier == null) {
            LLDBDriver.$$$reportNull$$$0(46);
        }
        final Ref launchedPid = new Ref();
        ThrowIfNotValid<ProtocolResponses.Launch_Res> responseHandler = new ThrowIfNotValid<ProtocolResponses.Launch_Res>(LLDBBundle.message("error.cannot.launch.process", new Object[0])){

            @Override
            public void consume(ProtocolResponses.Launch_Res message) {
                super.consume(message);
                if (this.isValid()) {
                    launchedPid.set((Object)message.getPid());
                }
            }
        };
        this.printTargetCommandLine(targetCommandLine);
        Protocol.CompositeRequest launchReq = (Protocol.CompositeRequest)launchRequestSupplier.compute();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)launchReq, ProtocolResponses.Launch_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)responseHandler);
        if (isRemoteTarget && !responseHandler.isValid() && LOCKED_DEVICE_RESPONSE.equals(responseHandler.getMessage())) {
            throw new LLDBDriverException(CidrDebuggerBundle.message("debug.lldb.lockedDeviceUserMessage", ApplicationNamesInfo.getInstance().getProductName()));
        }
        responseHandler.throwIfNeeded();
        return (Long)launchedPid.get();
    }

    private void detach() throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.detach.process", new Object[0]));
        this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.detach(), ProtocolResponses.Detach_Res.class, responseHandler);
        if (!responseHandler.isValid() && !LLDBDriver.isDetachErrorShouldBeSuppressed(responseHandler.getMessage())) {
            responseHandler.throwIfNeeded();
        }
        this.handleDetached();
    }

    private static boolean isDetachErrorShouldBeSuppressed(@Nullable String message) {
        if (message == null) {
            return false;
        }
        if ("Sending disconnect packet failed.".equals(message)) {
            return true;
        }
        String errorWinPattern = "error: process \\d* in state = exited, but cannot detach it in this state.";
        return message.matches(errorWinPattern);
    }

    @Override
    public boolean interrupt() throws ExecutionException {
        Ref result2 = new Ref();
        Protocol.CompositeRequest req = ProtobufMessageFactory.suspend();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)req, ProtocolResponses.Suspend_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)suspend_res -> result2.set((Object)suspend_res.getCommonResponse().getIsValid())));
        return !result2.isNull() && (Boolean)result2.get() != false;
    }

    @Override
    public boolean resume() throws ExecutionException {
        boolean[] res = new boolean[1];
        Protocol.CompositeRequest resume = ProtobufMessageFactory.resume();
        long timeout = ApplicationManager.getApplication().isUnitTestMode() ? 30000L : 0L;
        this.getProtobufClient().sendMessageAndWaitForReply((Message)resume, ProtocolResponses.Continue_Res.class, continue_res -> {
            res[0] = continue_res.getCommonResponse().getIsValid();
        }, timeout);
        return res[0];
    }

    @Override
    public void stepOver(@Nullable Boolean stepByInstruction) throws ExecutionException {
        if (this.myStepOverClassName == null) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.step.over", new Object[0]));
            Protocol.CompositeRequest request = ProtobufMessageFactory.stepOver(this.myStoppedThreadID);
            this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.StepOver_Res.class, responseHandler);
        } else {
            this.stepScripted(this.myStepOverClassName, LLDBBundle.message("error.cannot.step.over", new Object[0]), 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, @Nullable Boolean stepByInstruction) throws ExecutionException {
        if (forceStepIntoFramesWithNoDebugInfo) {
            this.lldbSetStepIntoNoDebug(true);
        }
        try {
            if (this.myStepIntoClassName == null) {
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.step.into", new Object[0]));
                Protocol.CompositeRequest request = ProtobufMessageFactory.stepInto(this.myStoppedThreadID);
                this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.StepInto_Res.class, responseHandler);
            } else {
                this.stepScripted(this.myStepIntoClassName, LLDBBundle.message("error.cannot.step.into", new Object[0]), 0L);
            }
        }
        finally {
            if (forceStepIntoFramesWithNoDebugInfo) {
                this.lldbSetStepIntoNoDebug(false);
            }
        }
    }

    @Override
    public void stepOut() throws ExecutionException {
        long timeout;
        long l = timeout = ApplicationManager.getApplication().isUnitTestMode() ? 30000L : 0L;
        if (this.myStepOutClassName == null) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.step.out", new Object[0]));
            Protocol.CompositeRequest request = ProtobufMessageFactory.stepOut(this.myStoppedThreadID);
            this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.StepOut_Res.class, responseHandler, timeout);
        } else {
            this.stepScripted(this.myStepOutClassName, LLDBBundle.message("error.cannot.step.out", new Object[0]), timeout);
        }
    }

    private void stepScripted(@NotNull String className, @NlsContexts.DialogMessage @NotNull String exceptionMsg, long timeout) throws ExecutionException {
        if (className == null) {
            LLDBDriver.$$$reportNull$$$0(47);
        }
        if (exceptionMsg == null) {
            LLDBDriver.$$$reportNull$$$0(48);
        }
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(exceptionMsg);
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepScripted(this.myStoppedThreadID, className);
        this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.StepScripted_Res.class, responseHandler, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTo(@NotNull String path, int line) throws ExecutionException {
        if (path == null) {
            LLDBDriver.$$$reportNull$$$0(49);
        }
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            try {
                LLBreakpoint breakpoint = this.addBreakpoint(path, line);
                this.myTemporaryBreakpoints.add(breakpoint.getId());
            }
            catch (DebuggerCommandException e) {
                throw new ExecutionException(LLDBBundle.message("error.cannot.set.breakpoint", new Object[0]), (Throwable)e);
            }
            if (!this.resume()) {
                throw new ExecutionException(LLDBBundle.message("error.cannot.resume.program", new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTo(@NotNull Address address) throws ExecutionException {
        if (address == null) {
            LLDBDriver.$$$reportNull$$$0(50);
        }
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            LLBreakpoint breakpoint = this.addBreakpoint(address);
            this.myTemporaryBreakpoints.add(breakpoint.getId());
            if (!this.resume()) {
                throw new ExecutionException(LLDBBundle.message("error.cannot.resume.program", new Object[0]));
            }
        }
    }

    @Override
    @NotNull
    public DebuggerDriver.StopPlace jumpToLine(@NotNull LLThread thread, @NotNull String path, int line, boolean canLeaveFunction) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            LLDBDriver.$$$reportNull$$$0(51);
        }
        if (path == null) {
            LLDBDriver.$$$reportNull$$$0(52);
        }
        @NotNull String convertedPath = this.myStarter.convertToProjectModelPath(path);
        Protocol.CompositeRequest req = ProtobufMessageFactory.jumpToLine(thread.getId(), convertedPath, line + 1, canLeaveFunction);
        return this.sendAndHandleJumpRequest(thread, (Message)req, ProtocolResponses.JumpToLine_Res.class, res -> res.getFrame());
    }

    @Override
    @NotNull
    public DebuggerDriver.StopPlace jumpToAddress(@NotNull LLThread thread, @NotNull Address address, boolean canLeaveFunction) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            LLDBDriver.$$$reportNull$$$0(53);
        }
        if (address == null) {
            LLDBDriver.$$$reportNull$$$0(54);
        }
        Protocol.CompositeRequest req = ProtobufMessageFactory.jumpToAddress(thread.getId(), address.getUnsignedLongValue(), canLeaveFunction);
        return this.sendAndHandleJumpRequest(thread, (Message)req, ProtocolResponses.JumpToAddress_Res.class, res -> res.getFrame());
    }

    @Override
    public void addPathMapping(int index, @NotNull String from, @NotNull String to) throws ExecutionException {
        if (from == null) {
            LLDBDriver.$$$reportNull$$$0(55);
        }
        if (to == null) {
            LLDBDriver.$$$reportNull$$$0(56);
        }
        String convertedFrom = this.myStarter.convertToProjectModelPath(from);
        String convertedTo = this.myStarter.convertToProjectModelPath(to);
        DebuggerDriver.PathMapping pathMapping = new DebuggerDriver.PathMapping(convertedFrom, convertedTo);
        List<DebuggerDriver.PathMapping> list = Collections.singletonList(pathMapping);
        this.addPathMapping(index, list, true);
    }

    @Override
    public void addForcedFileMapping(int index, @NotNull String from, @Nullable DebuggerSourceFileHash hash, @NotNull String to) throws ExecutionException {
        if (from == null) {
            LLDBDriver.$$$reportNull$$$0(57);
        }
        if (to == null) {
            LLDBDriver.$$$reportNull$$$0(58);
        }
        if ((this.myCapabilities & 1L) != 0L && hash != null) {
            this.addPathMapping(index, LLDBDriver.getSourceFileHashSchema(hash) + hash.getHash(), to);
        } else {
            this.addPathMapping(index, from, to);
        }
    }

    @NotNull
    private static String getSourceFileHashSchema(@NotNull DebuggerSourceFileHash hash) {
        if (hash == null) {
            LLDBDriver.$$$reportNull$$$0(59);
        }
        switch (hash.getType()) {
            case MD5: {
                return "md5://";
            }
            case SHA1: {
                return "sha1://";
            }
            case SHA256: {
                return "sha256://";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTemporaryBreakpoints() throws ExecutionException {
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            for (int num : this.myTemporaryBreakpoints) {
                Protocol.CompositeRequest request = LLDBDriver.createRemoveBreakpointRequest(num);
                this.getProtobufClient().sendMessage((Message)request, ProtocolResponses.RemoveBreakpoint_Res.class, res -> {
                    if (!res.getCommonResponse().getIsValid()) {
                        CidrDebuggerLog.LOG.error("Couldn't remove breakpoint. error: " + res.getCommonResponse().getErrorMessage());
                    }
                });
            }
            this.myTemporaryBreakpoints.clear();
        }
    }

    private boolean abort() throws ExecutionException {
        Ref toThrow = Ref.create();
        Ref abort = Ref.create((Object)false);
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.kill(), ProtocolResponses.Kill_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (commonResponse.getIsValid()) {
                abort.set((Object)true);
            } else {
                @NlsSafe String errorMessage = commonResponse.getErrorMessage();
                if ("process not exist".equals(errorMessage)) {
                    abort.set((Object)false);
                } else {
                    if (StringUtil.isEmptyOrSpaces((String)errorMessage)) {
                        errorMessage = LLDBBundle.message("error.cannot.abort.process", new Object[0]);
                    }
                    toThrow.set((Object)new LLDBDriverException(errorMessage));
                }
            }
        }));
        if (!toThrow.isNull()) {
            throw (ExecutionException)((Object)toThrow.get());
        }
        return (Boolean)abort.get();
    }

    @Override
    protected boolean doExit() throws ExecutionException {
        boolean sendExit = this.myConnectedClient.isDone();
        if (sendExit) {
            ExecutionResult.get(this.myConnectedClient).sendMessage((Message)ProtobufMessageFactory.exit(), null, null);
        }
        return sendExit;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameIndex, @NotNull LLValue value, @NotNull String expr, @Nullable LLWatchpoint.Lifetime lifetime, @NotNull LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        void accessType2;
        if (value == null) {
            LLDBDriver.$$$reportNull$$$0(60);
        }
        if (expr == null) {
            LLDBDriver.$$$reportNull$$$0(61);
        }
        if (accessType == null) {
            LLDBDriver.$$$reportNull$$$0(62);
        }
        String expression = value.getReferenceExpression();
        Protocol.CompositeRequest request = ProtobufMessageFactory.addWatchpoint(LLDBDriver.valId(value), null, accessType2 == LLWatchpoint.AccessType.ANY || accessType2 == LLWatchpoint.AccessType.READ, accessType2 == LLWatchpoint.AccessType.ANY || accessType2 == LLWatchpoint.AccessType.WRITE, true);
        Ref result2 = Ref.create(null);
        Ref toThrow = Ref.create(null);
        this.getProtobufClient().sendMessageAndWaitForReply((Message)request, ProtocolResponses.AddWatchpoint_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                toThrow.set((Object)new DebuggerCommandException(res.getCommonResponse().getErrorMessage()));
            } else {
                result2.set((Object)new LLWatchpoint(res.getWatchpointId(), expression));
            }
        }));
        if (result2.isNull()) {
            throw (DebuggerCommandException)toThrow.get();
        }
        LLWatchpoint lLWatchpoint = (LLWatchpoint)result2.get();
        if (lLWatchpoint == null) {
            LLDBDriver.$$$reportNull$$$0(63);
        }
        return lLWatchpoint;
    }

    @Override
    @NotNull
    public LLBreakpoint addBreakpoint(@NotNull String path, int line, @Nullable String condition, boolean ignoreSourceHash) throws ExecutionException {
        if (path == null) {
            LLDBDriver.$$$reportNull$$$0(64);
        }
        String convertedPath = this.myStarter.convertToProjectModelPath(path);
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(convertedPath, line + 1, ignoreSourceHash, condition);
        ProtocolResponses.AddBreakpoint_Res res = this.sendMessageAndWaitForReply((Message)req, ProtocolResponses.AddBreakpoint_Res.class);
        Model.LLDBBreakpoint breakpoint = res.getBreakpoint();
        return LLDBDriver.makeBreakpoint(breakpoint);
    }

    @Override
    @NotNull
    public LLBreakpoint addAddressBreakpoint(@NotNull Address address, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        if (address == null) {
            LLDBDriver.$$$reportNull$$$0(65);
        }
        LLBreakpoint lLBreakpoint = this.addBreakpoint(address, condition);
        if (lLBreakpoint == null) {
            LLDBDriver.$$$reportNull$$$0(66);
        }
        return lLBreakpoint;
    }

    protected LLBreakpoint addBreakpoint(@NotNull Address address) throws ExecutionException {
        if (address == null) {
            LLDBDriver.$$$reportNull$$$0(67);
        }
        return this.addBreakpoint(address, null);
    }

    protected LLBreakpoint addBreakpoint(@NotNull Address address, @Nullable String condition) throws ExecutionException {
        if (address == null) {
            LLDBDriver.$$$reportNull$$$0(68);
        }
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(address.getUnsignedLongValue(), condition);
        ProtocolResponses.AddBreakpoint_Res res = this.sendMessageAndWaitForReply((Message)req, ProtocolResponses.AddBreakpoint_Res.class);
        Model.LLDBBreakpoint breakpoint = res.getBreakpoint();
        return LLDBDriver.makeBreakpoint(breakpoint);
    }

    private static String makeBreakpointLocationCanonicalName(@NotNull Model.LLDBBreakpoint breakpoint, @NotNull Model.LLDBBreakpointLocation location) {
        if (breakpoint == null) {
            LLDBDriver.$$$reportNull$$$0(69);
        }
        if (location == null) {
            LLDBDriver.$$$reportNull$$$0(70);
        }
        return breakpoint.getId() + "." + location.getId();
    }

    @Nullable
    private static LLBreakpointLocation makeLocation(@NotNull Model.LLDBBreakpoint breakpoint, @NotNull Model.LLDBBreakpointLocation loc) {
        if (breakpoint == null) {
            LLDBDriver.$$$reportNull$$$0(71);
        }
        if (loc == null) {
            LLDBDriver.$$$reportNull$$$0(72);
        }
        if (!loc.getIsResolved()) {
            return null;
        }
        String id = LLDBDriver.makeBreakpointLocationCanonicalName(breakpoint, loc);
        Address address = Address.fromUnsignedLong(loc.getAddr());
        return new LLBreakpointLocation(id, loc.getFilePath(), loc.getLine() - 1, address);
    }

    @NotNull
    private static LLBreakpoint makeBreakpoint(@NotNull Model.LLDBBreakpoint breakpoint) {
        if (breakpoint == null) {
            LLDBDriver.$$$reportNull$$$0(73);
        }
        List locationList = ContainerUtil.mapNotNull(breakpoint.getLocationList(), loc -> LLDBDriver.makeLocation(breakpoint, loc));
        String orig_file_path = breakpoint.hasOrigFilePath() ? breakpoint.getOrigFilePath() : null;
        int orig_line = breakpoint.hasOrigLine() ? breakpoint.getOrigLine() : 0;
        String condition = breakpoint.hasCondition() ? breakpoint.getCondition() : null;
        return new LLBreakpoint(breakpoint.getId(), orig_file_path != null ? orig_file_path : "<address>", orig_line - 1, locationList, condition);
    }

    @Override
    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException {
        if (symBreakpoint == null) {
            LLDBDriver.$$$reportNull$$$0(74);
        }
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(symBreakpoint.getPattern(), symBreakpoint.isRegexpPattern(), symBreakpoint.getModule(), symBreakpoint.getCondition(), symBreakpoint.getThreadId());
        Ref result2 = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)req, ProtocolResponses.AddBreakpoint_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> result2.set((Object)new LLSymbolicBreakpoint(res.getBreakpoint().getId()))));
        return (LLSymbolicBreakpoint)result2.get();
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws ExecutionException {
        if (ids == null) {
            LLDBDriver.$$$reportNull$$$0(75);
        }
        for (Integer each : ids) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.remove.breakpoint", new Object[0]));
            Protocol.CompositeRequest req = LLDBDriver.createRemoveBreakpointRequest(each);
            this.sendMessageAndWaitForReply((Message)req, ProtocolResponses.RemoveBreakpoint_Res.class, responseHandler);
        }
    }

    private static Protocol.CompositeRequest createRemoveBreakpointRequest(int num) {
        return ProtobufMessageFactory.removeBreakpoint(num);
    }

    @NotNull
    private LLThread newLLThread(@NotNull Model.LLDBThread lldbThread) {
        Model.ThreadStopReasonInfo stopReasonInfo;
        if (lldbThread == null) {
            LLDBDriver.$$$reportNull$$$0(76);
        }
        boolean isStopped = (stopReasonInfo = lldbThread.getStopReasonInfo()).getStopReason() != Model.ThreadStopReason.ThreadStopReasonInvalid;
        return new LLThread(lldbThread.getId(), isStopped ? "STOPPED" : null, lldbThread.getQueue(), lldbThread.getName());
    }

    @NotNull
    private LLFrame newLLFrame(@NotNull Model.LLDBFrame frame) {
        if (frame == null) {
            LLDBDriver.$$$reportNull$$$0(77);
        }
        return new LLFrame(frame.getNumber(), frame.hasFunction() ? frame.getFunction() : null, frame.hasFile() ? this.myStarter.convertToLocalPath(frame.getFile()) : null, LLDBDriver.createSourceFileHash(frame.hasHashType() ? frame.getHashType() : null, frame.hasHash() ? frame.getHash() : null), frame.hasLine() ? frame.getLine() - 1 : -1, frame.hasPc() ? frame.getPc() : 0L, frame.hasLanguage() ? LLDBDriver.convertLanguage(frame.getLanguage()) : null, frame.hasOptimized() && frame.getOptimized());
    }

    @Nullable
    private static DebuggerSourceFileHash createSourceFileHash(@Nullable Model.HashType type, @Nullable String hash) {
        DebuggerSourceFileHash.Type t;
        if (type == null || hash == null) {
            return null;
        }
        switch (type) {
            case HashTypeMD5: {
                t = DebuggerSourceFileHash.Type.MD5;
                break;
            }
            case HashTypeSHA1: {
                t = DebuggerSourceFileHash.Type.SHA1;
                break;
            }
            case HashTypeSHA256: {
                t = DebuggerSourceFileHash.Type.SHA256;
                break;
            }
            default: {
                return null;
            }
        }
        return new DebuggerSourceFileHash(t, hash);
    }

    @Nullable
    private static DebuggerDriver.DebuggerLanguage convertLanguage(@Nullable Model.Language language) {
        if (language != null) {
            switch (language) {
                case LanguageC: 
                case LanguageC89: 
                case LanguageC99: 
                case LanguageC11: {
                    return DebuggerDriver.StandardDebuggerLanguage.C;
                }
                case LanguageC_plus_plus: 
                case LanguageC_plus_plus_03: 
                case LanguageC_plus_plus_11: 
                case LanguageC_plus_plus_14: {
                    return DebuggerDriver.StandardDebuggerLanguage.C_PLUS_PLUS;
                }
                case LanguageObjC: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC;
                }
                case LanguageObjC_plus_plus: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
                }
                case LanguageSwift: {
                    return DebuggerDriver.StandardDebuggerLanguage.SWIFT;
                }
                case LanguageRust: {
                    return DebuggerDriver.StandardDebuggerLanguage.RUST;
                }
                case LanguageFortran77: 
                case LanguageFortran90: 
                case LanguageFortran95: 
                case LanguageFortran03: 
                case LanguageFortran08: {
                    return DebuggerDriver.StandardDebuggerLanguage.FORTRAN;
                }
                case LanguageAda83: 
                case LanguageAda95: {
                    return DebuggerDriver.StandardDebuggerLanguage.ADA;
                }
                case LanguageCobol74: 
                case LanguageCobol85: {
                    return DebuggerDriver.StandardDebuggerLanguage.COBOL;
                }
                case LanguagePascal83: {
                    return DebuggerDriver.StandardDebuggerLanguage.PASCAL;
                }
                case LanguageModula2: 
                case LanguageModula3: {
                    return DebuggerDriver.StandardDebuggerLanguage.MODULA;
                }
                case LanguageD: {
                    return DebuggerDriver.StandardDebuggerLanguage.D;
                }
                case LanguageOpenCL: {
                    return DebuggerDriver.StandardDebuggerLanguage.OPENCL;
                }
                case LanguageGo: {
                    return DebuggerDriver.StandardDebuggerLanguage.GO;
                }
                case LanguageHaskell: {
                    return DebuggerDriver.StandardDebuggerLanguage.HASKELL;
                }
                case LanguageOCaml: {
                    return DebuggerDriver.StandardDebuggerLanguage.OCAML;
                }
                case UnsupportedLanguage: {
                    CidrDebuggerLog.LOG.warn("Unknown language reported by LLDB. Protocol needs to be updated");
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static Model.Language convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DebuggerCommandException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case C: {
                    return Model.Language.LanguageC;
                }
                case C_PLUS_PLUS: {
                    return Model.Language.LanguageC_plus_plus;
                }
                case OBJC: {
                    return Model.Language.LanguageObjC;
                }
                case OBJC_PLUS_PLUS: {
                    return Model.Language.LanguageObjC_plus_plus;
                }
                case SWIFT: {
                    return Model.Language.LanguageSwift;
                }
                case FORTRAN: {
                    return Model.Language.LanguageFortran08;
                }
                case RUST: {
                    return Model.Language.LanguageRust;
                }
                case ADA: {
                    return Model.Language.LanguageAda95;
                }
                case COBOL: {
                    return Model.Language.LanguageCobol85;
                }
                case PASCAL: {
                    return Model.Language.LanguagePascal83;
                }
                case MODULA: {
                    return Model.Language.LanguageModula3;
                }
                case D: {
                    return Model.Language.LanguageD;
                }
                case OPENCL: {
                    return Model.Language.LanguageOpenCL;
                }
                case GO: {
                    return Model.Language.LanguageGo;
                }
                case HASKELL: {
                    return Model.Language.LanguageHaskell;
                }
                case OCAML: {
                    return Model.Language.LanguageOCaml;
                }
            }
        }
        throw new DebuggerCommandException(language.toString() + " is not supported by LLDB");
    }

    @Override
    @NotNull
    public List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getThreads();
        ProtocolResponses.GetThreads_Res res = this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetThreads_Res.class);
        List list = ContainerUtil.map(res.getThreadList(), thread -> this.newLLThread((Model.LLDBThread)thread));
        if (list == null) {
            LLDBDriver.$$$reportNull$$$0(78);
        }
        return list;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        ProtocolResponses.GetFrames_Res res;
        Protocol.CompositeRequest request = ProtobufMessageFactory.getFrames(threadId, from, count, untilFirstLineWithCode);
        try {
            res = this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetFrames_Res.class);
        }
        catch (ExecutionException ex) {
            if (this.getState() != DebuggerDriver.TargetState.SUSPENDED) {
                throw new DebuggerCommandException(ex);
            }
            throw ex;
        }
        List frames = ContainerUtil.map(res.getFrameList(), frame -> this.newLLFrame((Model.LLDBFrame)frame));
        DebuggerDriver.ResultList<LLFrame> resultList = DebuggerDriver.ResultList.create(frames, res.getHasMore());
        if (resultList == null) {
            LLDBDriver.$$$reportNull$$$0(79);
        }
        return resultList;
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        boolean staticsAndGlobals = this.myStarter.isStaticVarsLoadingEnabled();
        List<LLValue> list = this.getVariables(threadId, frameIndex, staticsAndGlobals, staticsAndGlobals);
        if (list == null) {
            LLDBDriver.$$$reportNull$$$0(80);
        }
        return list;
    }

    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex, boolean statics, boolean globals) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getVars(threadId, frameIndex, statics, globals);
        ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        Ref errorMessage = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetVars_Res.class, res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                String message = commonResponse.getErrorMessage();
                errorMessage.set((Object)message);
            } else {
                for (Model.LLDBValue lldbValue : res.getValueList()) {
                    result2.add(this.createLLValue(lldbValue, null));
                }
            }
        }, 0L);
        if (!errorMessage.isNull() && !StringUtil.isEmpty((String)((String)errorMessage.get()))) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        ArrayList<LLValue> arrayList = result2;
        if (arrayList == null) {
            LLDBDriver.$$$reportNull$$$0(81);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public LLValueData getData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            LLDBDriver.$$$reportNull$$$0(82);
        }
        return LLDBDriver.getLLValueData(value);
    }

    @Override
    @Nullable
    public String getDescription(@NotNull LLValue value, int maxLength) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            LLDBDriver.$$$reportNull$$$0(83);
        }
        Protocol.CompositeRequest req = ProtobufMessageFactory.getValueDescription(LLDBDriver.valId(value), maxLength);
        Ref description = Ref.create();
        Ref exception = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)req, ProtocolResponses.GetValueDescription_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                exception.set((Object)new DebuggerCommandException(commonResponse.getErrorMessage()));
                return;
            }
            if (res.hasDescription()) {
                description.set((Object)res.getDescription());
            }
        }));
        if (!exception.isNull()) {
            throw (DebuggerCommandException)exception.get();
        }
        return (String)description.get();
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            LLDBDriver.$$$reportNull$$$0(84);
        }
        Integer childrenCount = this.getChildrenCount(value);
        if (count == 0) {
            DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.empty();
            if (resultList == null) {
                LLDBDriver.$$$reportNull$$$0(85);
            }
            return resultList;
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueChildren(LLDBDriver.valId(value), from, count);
        Ref errorMessage = new Ref();
        ArrayList result2 = new ArrayList();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetValueChildren_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                this.convertList(res.getValueList(), result2);
            }
        }, 0L);
        String message = (String)errorMessage.get();
        if (message != null) {
            throw new DebuggerCommandException(message);
        }
        boolean hasMore = from + count < childrenCount;
        DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(result2, hasMore);
        if (resultList == null) {
            LLDBDriver.$$$reportNull$$$0(86);
        }
        return resultList;
    }

    @Override
    public void addSymbolsFile(@NotNull File symbols, @NotNull File module) throws ExecutionException {
        if (symbols == null) {
            LLDBDriver.$$$reportNull$$$0(87);
        }
        if (module == null) {
            LLDBDriver.$$$reportNull$$$0(88);
        }
        this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "target module add \"" + module.getAbsolutePath() + "\" -s \"" + symbols.getAbsolutePath() + "\""), ProtocolResponses.HandleConsoleCommand_Res.class, new ThrowIfNotValid(LLDBBundle.message("error.cannot.add.symbols", symbols.getAbsolutePath(), module.getAbsolutePath())));
    }

    private void convertList(List<Model.LLDBValue> valuesList, List<LLValue> result2) {
        for (Model.LLDBValue val : valuesList) {
            LLValue value = this.createLLValue(val, null);
            result2.add(value);
        }
    }

    private static int valId(@NotNull LLValue var) throws ExecutionException {
        if (var == null) {
            LLDBDriver.$$$reportNull$$$0(89);
        }
        return (Integer)var.getUserData(LLVALUE_ID);
    }

    public List<LLValue> arraySlice(LLValue var, int offset, int count) throws ExecutionException, DebuggerCommandException {
        Ref errorMessage = Ref.create((Object)"unknown error");
        ArrayList<LLValue> vals = new ArrayList<LLValue>();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.arraySlice(LLDBDriver.valId(var), offset, count), ProtocolResponses.GetArraySlice_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                String message = res.getCommonResponse().getErrorMessage();
                if (StringUtil.isNotEmpty((String)message)) {
                    errorMessage.set((Object)message);
                }
                return;
            }
            errorMessage.set(null);
            this.convertList(res.getValueList(), vals);
        }));
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return vals;
    }

    @NotNull
    private LLValue createLLValue(@NotNull Model.LLDBValue lldbValue, @Nullable String expression) {
        LLValue.TypeClass typeClass;
        if (lldbValue == null) {
            LLDBDriver.$$$reportNull$$$0(90);
        }
        switch (lldbValue.getTypeClass()) {
            case TypeClassFunction: {
                typeClass = LLValue.TypeClass.FUNCTION;
                break;
            }
            case TypeClassBuiltin: {
                typeClass = LLValue.TypeClass.BUILTIN;
                break;
            }
            case TypeClassClass: 
            case TypeClassStruct: {
                typeClass = LLValue.TypeClass.CLASS_STRUCT;
                break;
            }
            case TypeClassObjCObjectPointer: {
                typeClass = LLValue.TypeClass.OBJC_POINTER;
                break;
            }
            case TypeClassPointer: {
                typeClass = LLValue.TypeClass.POINTER;
                break;
            }
            default: {
                typeClass = null;
            }
        }
        String referenceExpression = lldbValue.getName();
        LLValue result2 = new LLValue(expression == null ? lldbValue.getName() : expression, lldbValue.getType(), lldbValue.hasAddress() ? Long.valueOf(lldbValue.getAddress()) : null, typeClass, referenceExpression);
        result2.putUserData(LLVALUE_ID, lldbValue.getId());
        result2.putUserData(LLVALUE_DATA_LOADER, new LLValueDataLoader());
        LLValue lLValue = result2;
        if (lLValue == null) {
            LLDBDriver.$$$reportNull$$$0(91);
        }
        return lLValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static LLValueData getLLValueData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            LLDBDriver.$$$reportNull$$$0(92);
        }
        LLValue lLValue = value;
        // MONITORENTER : lLValue
        LLValueDataLoader loader = (LLValueDataLoader)value.getUserData(LLVALUE_DATA_LOADER);
        if (loader != null) {
            LLValueData data = loader.loadData(value);
            value.putUserData(LLVALUE_DATA_LOADER, null);
            value.putUserData(LLVALUE_DATA, data);
            LLValueData lLValueData = data;
            // MONITOREXIT : lLValue
            if (lLValueData != null) return lLValueData;
            LLDBDriver.$$$reportNull$$$0(93);
            return lLValueData;
        }
        LLValueData data = (LLValueData)value.getUserData(LLVALUE_DATA);
        if (data == null) {
            throw new ExecutionException(LLDBBundle.message("error.variable.not.initialized", new Object[]{value}));
        }
        LLValueData lLValueData = data;
        // MONITOREXIT : lLValue
        if (lLValueData != null) return lLValueData;
        LLDBDriver.$$$reportNull$$$0(94);
        return lLValueData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LLValue evaluate(long threadId, int frameIndex, @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage debuggerLanguage) throws ExecutionException, DebuggerCommandException {
        void language;
        if (expression == null) {
            LLDBDriver.$$$reportNull$$$0(95);
        }
        Protocol.CompositeRequest req = ProtobufMessageFactory.evaluateExpression(threadId, frameIndex, expression, LLDBDriver.convertLanguage((DebuggerDriver.DebuggerLanguage)language));
        Ref result2 = new Ref();
        Ref errorMessage = new Ref();
        try (CidrEventSpan ignored = new CidrEventSpan("debug", "evaluate", (Object)expression);){
            this.getProtobufClient().sendMessageAndWaitForReply((Message)req, ProtocolResponses.EvaluateExpression_Res.class, res -> {
                if (res.getCommonResponse().getIsValid()) {
                    if (res.hasResult()) {
                        Model.LLDBValue lldbValue = res.getResult();
                        LLValue value = this.createLLValue(lldbValue, expression);
                        result2.set((Object)value);
                    } else {
                        errorMessage.set((Object)NO_RESULT);
                    }
                } else {
                    String error = res.getCommonResponse().getErrorMessage();
                    errorMessage.set((Object)error);
                }
            }, 0L);
        }
        catch (ProtobufTimedOutException e) {
            throw new DebuggerEvaluationTimedOutException(expression);
        }
        if (!errorMessage.isNull()) {
            String message = (String)errorMessage.get();
            if (NO_RESULT.equals(message)) {
                LLValue resultValue = new LLValue("result", "void", null, null, "");
                resultValue.putUserData(LLVALUE_ID, 0);
                resultValue.putUserData(LLVALUE_DATA, new LLValueData("", null, false, false, false));
                resultValue.putUserData(CHILDREN_COUNT_CACHE, 0);
                LLValue lLValue = resultValue;
                if (lLValue == null) {
                    LLDBDriver.$$$reportNull$$$0(96);
                }
                return lLValue;
            }
            Pattern p = Pattern.compile("error: (.*)\nerror: \\d+ error[s]? parsing expression\n");
            Matcher matcher = p.matcher(message);
            if (matcher.find()) {
                message = matcher.group(1);
            }
            throw new DebuggerCommandException(message);
        }
        if (result2.isNull()) {
            throw new ExecutionException(LLDBBundle.message("error.unknown.evaluation.error", new Object[0]));
        }
        LLValue lLValue = (LLValue)((Object)result2.get());
        if (lLValue == null) {
            LLDBDriver.$$$reportNull$$$0(97);
        }
        return lLValue;
    }

    @Override
    @NotNull
    public List<LLInstruction> disassembleFunction(@NotNull Address address, @NotNull AddressRange fallbackRange) throws ExecutionException, DebuggerCommandException {
        Address endAddr;
        Model.LLDBContextInfo contextInfo;
        if (address == null) {
            LLDBDriver.$$$reportNull$$$0(98);
        }
        if (fallbackRange == null) {
            LLDBDriver.$$$reportNull$$$0(99);
        }
        assert (fallbackRange.contains(address));
        try {
            ProtocolResponses.ContextInfo_Res res = this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.contextInfo(address.getUnsignedLongValue()), ProtocolResponses.ContextInfo_Res.class);
            contextInfo = res.hasContextInfo() ? res.getContextInfo() : null;
        }
        catch (LLDBDriverException ex) {
            List<LLInstruction> list = this.disassembleRange(fallbackRange, null);
            if (list == null) {
                LLDBDriver.$$$reportNull$$$0(100);
            }
            return list;
        }
        if (contextInfo == null) {
            List<LLInstruction> list = this.disassembleRange(fallbackRange, null);
            if (list == null) {
                LLDBDriver.$$$reportNull$$$0(101);
            }
            return list;
        }
        Address startAddr = Address.fromUnsignedLong(contextInfo.getStartAddr());
        AddressRange range = AddressUtil.addressRangeExclusive(startAddr, endAddr = Address.fromUnsignedLong(contextInfo.getEndAddr()));
        if (!range.contains(address)) {
            List<LLInstruction> list = this.disassembleRange(fallbackRange, null);
            if (list == null) {
                LLDBDriver.$$$reportNull$$$0(102);
            }
            return list;
        }
        String functionName = contextInfo.getName();
        AddressRange saneRange = range.getSize() > 65536L ? range.intersectWith(fallbackRange) : range;
        List<LLInstruction> list = this.disassembleRange(saneRange, functionName);
        if (list == null) {
            LLDBDriver.$$$reportNull$$$0(103);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws ExecutionException {
        if (range == null) {
            LLDBDriver.$$$reportNull$$$0(104);
        }
        List<LLInstruction> list = this.disassembleRange(range, null);
        if (list == null) {
            LLDBDriver.$$$reportNull$$$0(105);
        }
        return list;
    }

    protected List<LLInstruction> disassembleRange(@NotNull AddressRange range, @Nullable String functionName) throws ExecutionException {
        if (range == null) {
            LLDBDriver.$$$reportNull$$$0(106);
        }
        long start = range.getStart().unsignedLongValue();
        long end = AddressUtil.getEndCoerced(range).unsignedLongValue();
        ProtocolResponses.Disassemble_Res disassembleRes = this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.disassemble(start, end), ProtocolResponses.Disassemble_Res.class);
        ArrayList<LLInstruction> instructions = new ArrayList<LLInstruction>(disassembleRes.getInstructionsCount());
        for (Model.LLDBInstruction instruction : disassembleRes.getInstructionsList()) {
            long addr = instruction.getAddr();
            LLSymbolOffset functionOffset = functionName == null ? null : new LLSymbolOffset(functionName, addr - start);
            LLInstruction llInstruction = LLInstruction.create(Address.fromUnsignedLong(addr), (Iterable<Byte>)instruction.getOpcodes(), instruction.getMnemonic(), instruction.getOperands(), instruction.getComment(), functionOffset);
            instructions.add(llInstruction);
        }
        return instructions;
    }

    @Override
    @NotNull
    public List<LLModule> getLoadedModules() throws ExecutionException {
        Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
        List list = ContainerUtil.map(sectionsMap.keySet(), LLModule::new);
        if (list == null) {
            LLDBDriver.$$$reportNull$$$0(107);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LLSection> getModuleSections(@NotNull LLModule module) throws ExecutionException, DebuggerCommandException {
        Map<String, List<LLSection>> sectionsMap;
        if (module == null) {
            LLDBDriver.$$$reportNull$$$0(108);
        }
        if (!(sectionsMap = this.doGetSectionsMap()).containsKey(module.getName())) {
            throw new DebuggerCommandException("Can't find module " + module);
        }
        List<LLSection> list = sectionsMap.get(module.getName());
        if (list == null) {
            LLDBDriver.$$$reportNull$$$0(109);
        }
        return list;
    }

    @NotNull
    protected Map<String, List<LLSection>> doGetSectionsMap() throws ExecutionException {
        if (this.mySectionsMap == null) {
            this.mySectionsMap = new HashMap<String, List<LLSection>>();
            this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.dumpSections(), ProtocolResponses.DumpSections_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
                for (Model.LLDBModule module : res.getModulesList()) {
                    List llSections = ContainerUtil.map(module.getSectionsList(), m -> new LLSection(m.getName(), (List<String>)m.getFlagsList(), AddressUtil.addressRangeExclusive(Address.fromUnsignedLong(m.getStart()), Address.fromUnsignedLong(m.getEnd()))));
                    this.mySectionsMap.put(module.getName(), llSections);
                }
            }));
        }
        Map<String, List<LLSection>> map = this.mySectionsMap;
        if (map == null) {
            LLDBDriver.$$$reportNull$$$0(110);
        }
        return map;
    }

    @Override
    @NotNull
    public List<LLMemoryHunk> dumpMemory(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        if (range == null) {
            LLDBDriver.$$$reportNull$$$0(111);
        }
        Ref result2 = Ref.create();
        Ref exception = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.dumpMemory(range.getStart().unsignedLongValue(), range.getEndInclusive().getUnsignedLongValue() + 1L), ProtocolResponses.DumpMemory_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                exception.set((Object)new DebuggerCommandException(res.getCommonResponse().getErrorMessage()));
            } else if ((long)res.getData().size() != range.getSize()) {
                exception.set((Object)new DebuggerCommandException("Unable to read memory " + range));
            } else {
                result2.set((Object)res.getData());
            }
        }));
        if (!exception.isNull()) {
            throw (DebuggerCommandException)exception.get();
        }
        LLMemoryHunk hunk = new LLMemoryHunk(range, ((ByteString)result2.get()).toByteArray());
        LinkedList<LLMemoryHunk> list = new LinkedList<LLMemoryHunk>();
        list.add(hunk);
        LinkedList<LLMemoryHunk> linkedList = list;
        if (linkedList == null) {
            LLDBDriver.$$$reportNull$$$0(112);
        }
        return linkedList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws ExecutionException {
        if (executable == null) {
            LLDBDriver.$$$reportNull$$$0(113);
        }
        Ref result2 = new Ref();
        @NlsContexts.DialogMessage Ref errorMessage = new Ref();
        LinkedList<String> args = new LinkedList<String>();
        args.add(executable);
        if (params != null) {
            args.addAll(params);
        }
        String command = StringUtil.join(args, s -> StringUtil.escapeCharCharacters((String)s), (String)" ");
        this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.executeShellCommand(command, workingDir, timeoutSecs), ProtocolResponses.ExecuteShellCommand_Res.class, res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                @NlsSafe String message = commonResponse.getErrorMessage();
                errorMessage.set((Object)(!StringUtil.isEmpty((String)message) ? message : LLDBBundle.message("error.invalid.shell.command.response", new Object[0])));
            } else {
                result2.set((Object)new DebuggerDriver.ShellCommandResult(res.getOutput(), res.getStatus(), res.getSignal()));
            }
        }, (long)(timeoutSecs + 10) * 1000L);
        if (!errorMessage.isNull()) {
            throw new ExecutionException((String)errorMessage.get());
        }
        DebuggerDriver.ShellCommandResult shellCommandResult = (DebuggerDriver.ShellCommandResult)result2.get();
        if (shellCommandResult == null) {
            LLDBDriver.$$$reportNull$$$0(114);
        }
        return shellCommandResult;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void executeConsoleCommand(@NotNull String command) throws ExecutionException {
        if (command == null) {
            LLDBDriver.$$$reportNull$$$0(115);
        }
        this.executeInterpreterCommand(-1L, -1, command);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void executeConsoleCommand(long threadId, int frameIndex, @NotNull String string) throws ExecutionException {
        void command;
        if (string == null) {
            LLDBDriver.$$$reportNull$$$0(116);
        }
        this.executeInterpreterCommand(threadId, frameIndex, (String)command);
    }

    @Override
    @NotNull
    public String executeInterpreterCommand(@NotNull String command) throws ExecutionException {
        if (command == null) {
            LLDBDriver.$$$reportNull$$$0(117);
        }
        String string = this.executeInterpreterCommand(-1L, -1, command);
        if (string == null) {
            LLDBDriver.$$$reportNull$$$0(118);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String executeInterpreterCommand(long threadId, int frameIndex, @NotNull String string) throws ExecutionException {
        void command;
        Protocol.CompositeRequest request;
        ProtocolResponses.HandleConsoleCommand_Res reply;
        if (string == null) {
            LLDBDriver.$$$reportNull$$$0(119);
        }
        if ((reply = this.sendMessageAndWaitForReply((Message)(request = ProtobufMessageFactory.handleConsoleCommand(threadId, frameIndex, (String)command)), ProtocolResponses.HandleConsoleCommand_Res.class)).hasErr()) {
            this.handleDebuggerOutput(LLDBDriver.asNlsSafe(reply.getErr()), ProcessOutputTypes.STDERR);
        }
        if (reply.hasOut()) {
            this.handleDebuggerOutput(LLDBDriver.asNlsSafe(reply.getOut()), ProcessOutputTypes.STDOUT);
            String string2 = reply.getOut();
            if (string2 == null) {
                LLDBDriver.$$$reportNull$$$0(120);
            }
            return string2;
        }
        return "";
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<String> completeConsoleCommand(@NotNull String command, int pos) throws ExecutionException {
        if (command == null) {
            LLDBDriver.$$$reportNull$$$0(121);
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleCompletion(command, pos);
        ProtocolResponses.HandleCompletion_Res reply = this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.HandleCompletion_Res.class);
        DebuggerDriver.ResultList<String> resultList = DebuggerDriver.ResultList.create(reply.getCompletionList(), false);
        if (resultList == null) {
            LLDBDriver.$$$reportNull$$$0(122);
        }
        return resultList;
    }

    @Override
    public void handleSignal(@NotNull String signalName, boolean stop, boolean pass, boolean notify) throws ExecutionException {
        if (signalName == null) {
            LLDBDriver.$$$reportNull$$$0(123);
        }
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.handle.signal", new Object[0]));
        Protocol.CompositeRequest handleSignalReq = ProtobufMessageFactory.handleSignal(signalName, stop, pass, notify);
        this.sendMessageAndWaitForReply((Message)handleSignalReq, ProtocolResponses.HandleSignal_Res.class, responseHandler);
    }

    @Override
    protected String getPromptText() {
        return "lldb";
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcessInputProxy;
    }

    @TestOnly
    public OutputStream getProcessInputInternalStream() {
        return this.myProcessInput;
    }

    @Override
    public void removeWatchpoint(@NotNull List<Integer> ids) throws ExecutionException {
        if (ids == null) {
            LLDBDriver.$$$reportNull$$$0(124);
        }
        int num = ids.get(0);
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.remove.watchpoint", new Object[0]));
        Protocol.CompositeRequest req = ProtobufMessageFactory.removeWatchpoint(num);
        this.sendMessageAndWaitForReply((Message)req, ProtocolResponses.RemoveWatchpoint_Res.class, responseHandler);
    }

    @Override
    @NotNull
    public Integer getChildrenCount(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        Integer cached;
        if (var == null) {
            LLDBDriver.$$$reportNull$$$0(125);
        }
        if ((cached = (Integer)var.getUserData(CHILDREN_COUNT_CACHE)) != null) {
            Integer n = cached;
            if (n == null) {
                LLDBDriver.$$$reportNull$$$0(126);
            }
            return n;
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getChildrenCount(LLDBDriver.valId(var));
        Ref errorMessage = new Ref();
        Ref result2 = Ref.create((Object)0);
        this.getProtobufClient().sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetChildrenCount_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                result2.set((Object)res.getCount());
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        var.putUserData(CHILDREN_COUNT_CACHE, (Integer)result2.get());
        Integer n = (Integer)result2.get();
        if (n == null) {
            LLDBDriver.$$$reportNull$$$0(127);
        }
        return n;
    }

    public long getValueAddress(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            LLDBDriver.$$$reportNull$$$0(128);
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueAddress(LLDBDriver.valId(var));
        Ref errorMessage = new Ref();
        Ref result2 = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetValueAddress_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                result2.set((Object)res.getAddress());
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return (Long)result2.get();
    }

    protected void lldbSet(@NotNull String setting, boolean enabled) throws ExecutionException {
        if (setting == null) {
            LLDBDriver.$$$reportNull$$$0(129);
        }
        this.lldbSet(setting, enabled ? "true" : "false");
    }

    protected void lldbSet(@NotNull String setting, @Nullable String value) throws ExecutionException {
        if (setting == null) {
            LLDBDriver.$$$reportNull$$$0(130);
        }
        String settingCommand = value != null ? "set " + setting + " " + value : "remove " + setting;
        this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "settings " + settingCommand), ProtocolResponses.HandleConsoleCommand_Res.class, new ThrowIfNotValid(LLDBBundle.message("error.cannot.set.setting.to", setting, value)));
    }

    @Contract(pure=true)
    @NotNull
    protected String createTypeSummaryConsoleCommand(@NotNull String summaryString, @Nullable String category, String ... typeNames) {
        if (summaryString == null) {
            LLDBDriver.$$$reportNull$$$0(131);
        }
        if (typeNames == null) {
            LLDBDriver.$$$reportNull$$$0(132);
        }
        String string = String.format("type summary add --skip-pointers --summary-string %s --category %s %s", LLDBDriver.stringify(summaryString), category != null ? category : "default", Arrays.stream(typeNames).map(s -> DebuggerDriver.stringify(s)).collect(Collectors.joining(" ")));
        if (string == null) {
            LLDBDriver.$$$reportNull$$$0(133);
        }
        return string;
    }

    private void lldbSetStepIntoNoDebug(boolean value) throws ExecutionException {
        this.lldbSet("target.process.thread.step-in-avoid-nodebug", !value);
    }

    private void haveConnection(@NotNull String version, long capabilities) {
        if (version == null) {
            LLDBDriver.$$$reportNull$$$0(134);
        }
        this.handlePrompt();
        try {
            String[] typeSummaryConsoleCommands;
            this.myLLDBVersion = LLDBDriverConfiguration.parseVersion(version);
            this.myCapabilities = capabilities;
            this.lldbSetStepIntoNoDebug(false);
            this.lldbSet("target.process.thread.step-out-avoid-nodebug", true);
            if (CidrDebuggerLog.LOG.isTraceEnabled()) {
                String logPath = LLDBDriver.getLogDir() + "/lldb.log";
                this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "log enable -f " + logPath + " lldb default"), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {}));
            }
            if (this.myAutorunScriptName != null) {
                this.executeConsoleCommandAndHandleOutput(String.format("command script import \"%s\"", this.myAutorunScriptName));
            }
            for (String typeSummaryConsoleCommand : typeSummaryConsoleCommands = new String[]{this.createTypeSummaryConsoleCommand("${var%d} ${var}", "cplusplus", "char", "signed char"), this.createTypeSummaryConsoleCommand("${var%u} ${var}", "cplusplus", "unsigned char")}) {
                this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, typeSummaryConsoleCommand), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {}));
            }
            this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "type category enable objc"), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {}));
            this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "settings set target.max-string-summary-length 250"), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {}));
            this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED), ProtocolResponses.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid(LLDBBundle.message("error.cannot.set.values.filtering.policy", new Object[0])));
            if (this.myLLDBCommandLine.getUserData(ENABLE_STL_RENDERERS) == Boolean.TRUE) {
                this.executeConsoleCommandAndHandleOutput("script import lldb_formatters.jetbrains_stl_formatters");
            }
            this.myConnectedClient.complete(this.myProtobufServer);
        }
        catch (Exception e) {
            this.myConnectedClient.completeExceptionally(e);
        }
    }

    private void executeConsoleCommandAndHandleOutput(@NonNls @NotNull String command) throws ProtobufTimedOutException {
        if (command == null) {
            LLDBDriver.$$$reportNull$$$0(135);
        }
        this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, command), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (res.hasOut() || res.hasErr()) {
                String message = LLDBBundle.message("error.during.data.formatters.setup.0.1", res.hasOut() ? "\n" + res.getOut() : "", res.hasErr() ? "\n" + res.getErr() : "");
                this.handleTargetOutput(message, ProcessOutputTypes.SYSTEM);
            }
        }));
    }

    public void consume(@NotNull Message generatedMessage) {
        if (generatedMessage == null) {
            LLDBDriver.$$$reportNull$$$0(136);
        }
        try (CidrEventSpan ignored = new CidrEventSpan("debug", () -> "consume (" + generatedMessage.getClass().getSimpleName() + ")", () -> generatedMessage.toString());){
            this.handleMessage(generatedMessage);
        }
    }

    private void handleMessage(@NotNull Message generatedMessage) {
        if (generatedMessage == null) {
            LLDBDriver.$$$reportNull$$$0(137);
        }
        if (generatedMessage instanceof Broadcasts.Initialized_Message) {
            Broadcasts.Initialized_Message init = (Broadcasts.Initialized_Message)generatedMessage;
            this.haveConnection(init.getVersionString(), init.getCapabilities());
        } else if (generatedMessage instanceof Broadcasts.ProcessExited_Broadcast) {
            int signal;
            String exitDescription;
            Broadcasts.ProcessExited_Broadcast exit = (Broadcasts.ProcessExited_Broadcast)generatedMessage;
            int exitCode = exit.getExitCode();
            String string = exitDescription = exit.hasExitDescription() ? exit.getExitDescription() : null;
            if (SystemInfo.isMac && exitCode == 0 && exitDescription != null && exitDescription.startsWith(TERMINATED_DUE_TO_SIGNAL) && (signal = StringUtil.parseInt((String)exitDescription.substring(TERMINATED_DUE_TO_SIGNAL.length()).trim(), (int)-1)) > 0) {
                exitCode = 128 + signal;
                exitDescription = null;
            }
            this.handleTargetFinished(exitCode, exitDescription);
        } else if (generatedMessage instanceof Broadcasts.ProcessRunning_Broadcast) {
            Integer attachedTo = this.myAsyncAttachingTo;
            this.myAsyncAttachingTo = null;
            if (attachedTo != null) {
                this.handleAttached(attachedTo);
            }
            this.handleRunning();
        } else if (generatedMessage instanceof Broadcasts.ProcessInterrupted_Broadcast) {
            Model.ThreadStopReason stopReason;
            try {
                this.removeTemporaryBreakpoints();
            }
            catch (ExecutionException attachedTo) {
                // empty catch block
            }
            Broadcasts.ProcessInterrupted_Broadcast interrupted_broadcast = (Broadcasts.ProcessInterrupted_Broadcast)generatedMessage;
            Model.LLDBThread lldbThread = interrupted_broadcast.getThread();
            LLThread thread = this.newLLThread(lldbThread);
            LLFrame frame = this.newLLFrame(interrupted_broadcast.getFrame());
            DebuggerDriver.StopPlace stopPlace = new DebuggerDriver.StopPlace(thread, frame);
            this.myStoppedThreadID = stopPlace.thread.getId();
            Model.ThreadStopReasonInfo stopReasonInfo = lldbThread.hasStopReasonInfo() ? lldbThread.getStopReasonInfo() : null;
            Model.ThreadStopReason threadStopReason = stopReason = stopReasonInfo == null ? null : stopReasonInfo.getStopReason();
            if (stopReason == Model.ThreadStopReason.ThreadStopReasonBreakpoint && stopReasonInfo.hasCodepointId()) {
                this.handleBreakpoint(stopPlace, stopReasonInfo.getCodepointId());
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonWatchpoint && stopReasonInfo.hasCodepointId()) {
                this.handleWatchpoint(stopPlace, stopReasonInfo.getCodepointId());
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonSignal) {
                int signal = stopReasonInfo.getSignal();
                String signalName = stopReasonInfo.getSignalName();
                if (LLDBDriver.isTargetTerminationSignal(signal)) {
                    this.handleTargetTerminated();
                } else {
                    this.handleSignal(stopPlace, !signalName.isEmpty() ? signalName : String.valueOf(signal), stopReasonInfo.getStopDescription());
                }
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonException) {
                this.handleException(stopPlace, Address.fromUnsignedLong(stopReasonInfo.getAddress()), stopReasonInfo.hasFile() ? stopReasonInfo.getFile() : null, LLDBDriver.createSourceFileHash(stopReasonInfo.hasHashType() ? stopReasonInfo.getHashType() : null, stopReasonInfo.hasHash() ? stopReasonInfo.getHash() : null), stopReasonInfo.hasLine() ? stopReasonInfo.getLine() - 1 : -1, stopReasonInfo.getStopDescription());
            } else {
                this.handleInterrupted(stopPlace);
            }
        } else if (generatedMessage instanceof Broadcasts.ChangePrompt_Broadcast) {
            this.handlePrompt(((Broadcasts.ChangePrompt_Broadcast)generatedMessage).getPrompt());
        } else if (generatedMessage instanceof Broadcasts.ReadyForCommands_Broadcast) {
            this.handlePrompt(((Broadcasts.ReadyForCommands_Broadcast)generatedMessage).getReady() == 0);
        } else if (generatedMessage instanceof Broadcasts.CommandsInterpreter_Broadcast) {
            this.handleDebuggerOutput(LLDBDriver.asNlsSafe(((Broadcasts.CommandsInterpreter_Broadcast)generatedMessage).getMessage()), ProcessOutputTypes.STDOUT);
        } else if (generatedMessage instanceof Broadcasts.TargetProcessOutput_Broadcast) {
            Broadcasts.TargetProcessOutput_Broadcast outputBroadcast = (Broadcasts.TargetProcessOutput_Broadcast)generatedMessage;
            this.handleTargetOutput(LLDBDriver.asNlsSafe(outputBroadcast.getText()), LLDBDriver.outputType2ProcessOutputKey(outputBroadcast.getOutputType()));
        } else if (generatedMessage instanceof Broadcasts.LogMessage_Broadcast) {
            String message = ((Broadcasts.LogMessage_Broadcast)generatedMessage).getMessage();
            CidrDebuggerLog.LOG.info(message);
        } else if (generatedMessage instanceof Broadcasts.ModulesLoaded_Broadcast) {
            Broadcasts.ModulesLoaded_Broadcast msg = (Broadcasts.ModulesLoaded_Broadcast)generatedMessage;
            List lst = ContainerUtil.map((Collection)msg.getModulesList(), module -> new LLModule(module.trim()));
            this.handleModulesLoaded(lst);
        } else if (generatedMessage instanceof Broadcasts.BreakpointChanged_Broadcast) {
            Broadcasts.BreakpointChanged_Broadcast msg = (Broadcasts.BreakpointChanged_Broadcast)generatedMessage;
            Model.LLDBBreakpoint brk = msg.getBreakpoint();
            switch (msg.getEventType()) {
                case Added: {
                    this.handleBreakpointAdded(LLDBDriver.makeBreakpoint(brk));
                    break;
                }
                case Removed: {
                    this.handleBreakpointRemoved(LLDBDriver.makeBreakpoint(brk));
                    break;
                }
                case LocationsAdded: 
                case LocationsRemoved: 
                case LocationsResolved: {
                    this.handleBreakpointUpdated(LLDBDriver.makeBreakpoint(brk));
                    break;
                }
            }
        }
    }

    private static Key outputType2ProcessOutputKey(Model.OutputType outputType) {
        return outputType == Model.OutputType.OutputTypeStdout ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 30: 
            case 40: 
            case 63: 
            case 66: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 114: 
            case 118: 
            case 120: 
            case 122: 
            case 126: 
            case 127: 
            case 133: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 30: 
            case 40: 
            case 63: 
            case 66: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 114: 
            case 118: 
            case 120: 
            case 122: 
            case 126: 
            case 127: 
            case 133: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getNewFrame";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 30: 
            case 40: 
            case 63: 
            case 66: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 114: 
            case 118: 
            case 120: 
            case 122: 
            case 126: 
            case 127: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starter";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "architectureType";
                break;
            }
            case 23: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installer";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleOrExecutablePath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedCommandLine";
                break;
            }
            case 26: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreFile";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePathMappings";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execSearchPaths";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionUrl";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createTargetRequest";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCommandLine";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchRequestSupplier";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionMsg";
                break;
            }
            case 49: 
            case 52: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 50: 
            case 54: 
            case 65: 
            case 67: 
            case 68: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 60: 
            case 82: 
            case 83: 
            case 84: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 69: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loc";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symBreakpoint";
                break;
            }
            case 75: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lldbThread";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 88: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 89: 
            case 125: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lldbValue";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackRange";
                break;
            }
            case 104: 
            case 106: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 121: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 129: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setting";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summaryString";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeNames";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 136: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sendMessageAndWaitForReply";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleLanguage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostMachine";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBArchitectureType";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCoreDump";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "loadForAttachDebugServer";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "addWatchpoint";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "addAddressBreakpoint";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableChildren";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "createLLValue";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLValueData";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "disassembleFunction";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "disassemble";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedModules";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSections";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetSectionsMap";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpMemory";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "executeShellCommand";
                break;
            }
            case 118: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "executeInterpreterCommand";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "completeConsoleCommand";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenCount";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeSummaryConsoleCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sendAndHandleJumpRequest";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sendMessageAndWaitForReply";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 30: 
            case 40: 
            case 63: 
            case 66: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 114: 
            case 118: 
            case 120: 
            case 122: 
            case 126: 
            case 127: 
            case 133: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "startDriver";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadForLaunch";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadForRemoteAttach";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadForAttach";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "loadCoreDump";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadForRemoteLaunch";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "loadForRemote";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "loadForAttachDebugServer";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addPathMapping";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "sendCreateTargetRequest";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doLaunch";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "stepScripted";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "runTo";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "jumpToLine";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "jumpToAddress";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "addForcedFileMapping";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFileHashSchema";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addWatchpoint";
                break;
            }
            case 64: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addAddressBreakpoint";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "makeBreakpointLocationCanonicalName";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "makeLocation";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "makeBreakpoint";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolicBreakpoint";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "removeCodepoints";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "newLLThread";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "newLLFrame";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getVariableChildren";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolsFile";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "valId";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "createLLValue";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getLLValueData";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "disassembleFunction";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "disassemble";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "disassembleRange";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSections";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "dumpMemory";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "executeShellCommand";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "executeConsoleCommand";
                break;
            }
            case 117: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "executeInterpreterCommand";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "completeConsoleCommand";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "handleSignal";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchpoint";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenCount";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "getValueAddress";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "lldbSet";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "createTypeSummaryConsoleCommand";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "haveConnection";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "executeConsoleCommandAndHandleOutput";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "handleMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 30: 
            case 40: 
            case 63: 
            case 66: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 114: 
            case 118: 
            case 120: 
            case 122: 
            case 126: 
            case 127: 
            case 133: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProcessInputDispatcher
    extends OutputStream {
        private ProcessInputDispatcher() {
        }

        @Override
        public void write(int i) throws IOException {
            LOG.error("Shouldn't be here");
        }

        @Override
        public void write(byte @NotNull [] bytes, int i, int i1) throws IOException {
            if (bytes == null) {
                ProcessInputDispatcher.$$$reportNull$$$0(0);
            }
            try {
                String input = new String(bytes, i, i1, LLDBDriver.this.myLLDBCommandLine.getCharset());
                LLDBDriver.this.dispatchInput(input, Model.DispatchTarget.DispatchTargetProcess);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$ProcessInputDispatcher", "write"));
        }
    }

    private class LLValueDataLoader {
        private LLValueDataLoader() {
        }

        @NotNull
        public LLValueData loadData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            if (value == null) {
                LLValueDataLoader.$$$reportNull$$$0(0);
            }
            Protocol.CompositeRequest req = ProtobufMessageFactory.getValueData(LLDBDriver.valId(value), 250);
            Ref lldbDataRef = Ref.create();
            Ref exception = Ref.create();
            LLDBDriver.this.getProtobufClient().sendMessageAndWaitForReply((Message)req, ProtocolResponses.GetValueData_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
                ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
                if (!commonResponse.getIsValid()) {
                    exception.set((Object)new DebuggerCommandException(commonResponse.getErrorMessage()));
                    return;
                }
                lldbDataRef.set((Object)res.getValue());
            }));
            if (!exception.isNull()) {
                throw (DebuggerCommandException)exception.get();
            }
            Model.LLDBValueData lldbData = (Model.LLDBValueData)lldbDataRef.get();
            return new LLValueData(lldbData.getValue(), lldbData.hasDescription() ? lldbData.getDescription() : null, lldbData.getHasLongerDescription(), lldbData.getMayHaveChildren(), lldbData.getIsSynthetic());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$LLValueDataLoader", "loadData"));
        }
    }

    protected static class ThrowDebuggerCommandExceptionIfNotValid<T extends Message>
    extends ResponseMessageConsumer<T, DebuggerCommandException> {
        public ThrowDebuggerCommandExceptionIfNotValid(@NlsContexts.DialogMessage String message) {
            super(message);
        }

        @Override
        public void throwError() throws DebuggerCommandException {
            throw new DebuggerCommandException(this.getMessage());
        }
    }

    protected static class ThrowIfNotValid<T extends Message>
    extends ResponseMessageConsumer<T, LLDBDriverException> {
        public ThrowIfNotValid(@NlsContexts.DialogMessage String message) {
            super(message);
        }

        @Override
        public void consume(T message) {
            super.consume(message);
        }

        @Override
        public void throwIfNeeded() throws LLDBDriverException {
            super.throwIfNeeded();
        }

        @Override
        public void throwError() throws LLDBDriverException {
            throw new LLDBDriverException(this.getMessage());
        }
    }

    protected static abstract class ResponseMessageConsumer<T extends Message, E extends Exception>
    implements Consumer<T> {
        private @NlsContexts.DialogMessage String myMessage;
        private boolean myIsValid = false;

        public ResponseMessageConsumer(@NlsContexts.DialogMessage String message) {
            this.myMessage = message;
        }

        public void consume(T message) {
            Map allFields = message.getAllFields();
            for (Object val : allFields.values()) {
                String errorMessage;
                if (!(val instanceof ProtocolResponses.CommonResponse)) continue;
                ProtocolResponses.CommonResponse commonResponse = (ProtocolResponses.CommonResponse)val;
                this.myIsValid = commonResponse.getIsValid();
                if (this.myIsValid || !commonResponse.hasErrorMessage() || StringUtil.isEmptyOrSpaces((String)(errorMessage = commonResponse.getErrorMessage()))) continue;
                this.myMessage = errorMessage;
            }
        }

        public void throwIfNeeded() throws E {
            if (!this.myIsValid) {
                this.throwError();
            }
        }

        @NlsContexts.DialogMessage
        public String getMessage() {
            return this.myMessage;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        abstract void throwError() throws E;
    }
}

