/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.execution.CidrExecUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBEvaluationContext;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriverConfiguration
extends DebuggerDriverConfiguration {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+\\.[\\d]+(?:\\.[\\d]+)*).*");
    private static boolean ourIsDebugModeEnabled = false;

    public static void setDebugMode(boolean isEnabled) {
        ourIsDebugModeEnabled = isEnabled;
    }

    public static boolean isDebugModeEnabled() {
        return ourIsDebugModeEnabled;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getDriverName() {
        return "LLDB";
    }

    @NotNull
    public static ArchitectureType getDefaultTargetArchitecture() {
        ArchitectureType architectureType = ArchitectureType.X86_64;
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(0);
        }
        return architectureType;
    }

    @Nullable
    public String readVersion() {
        ToolVersion version = this.readToolVersion();
        return version == null ? null : version.toCompactString();
    }

    @Nullable
    public ToolVersion readToolVersion() {
        String displayVersion;
        try {
            GeneralCommandLine commandLine = this.createLLDBFrontendCommandLine(LLDBDriverConfiguration.getDefaultTargetArchitecture());
            commandLine.addParameter("--version");
            displayVersion = CidrToolsUtil.readOneLineWithProgress((GeneralCommandLine)commandLine, (int)10000);
        }
        catch (ExecutionException e) {
            CidrDebuggerLog.LOG.info("Cannot read LLDB version", (Throwable)e);
            return null;
        }
        if (displayVersion == null) {
            return null;
        }
        return LLDBDriverConfiguration.parseVersion(displayVersion);
    }

    @NotNull
    public static ToolVersion parseVersion(@NotNull String displayVersion) {
        if (displayVersion == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(1);
        }
        ToolVersion toolVersion = ToolVersion.parse((String)displayVersion, (Pattern[])new Pattern[]{VERSION_PATTERN});
        if (toolVersion == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(2);
        }
        return toolVersion;
    }

    @Override
    public boolean isAttachSupported() {
        return true;
    }

    @Override
    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) throws ExecutionException {
        if (handler == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(3);
        }
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(4);
        }
        return new LLDBDriver(handler, this, architectureType);
    }

    @NotNull
    private static String getWinBinDir(@NotNull ArchitectureType architectureType) {
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(5);
        }
        String string = (architectureType == ArchitectureType.I386 ? "x86" : "x64") + "/bin/";
        if (string == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected File getLLDBFrameworkFile(@NotNull ArchitectureType architectureType) {
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(7);
        }
        File file = this.getBundledLLDBFrameworkFile(architectureType);
        if (file == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    protected File getLLDBFrontendFile(@NotNull ArchitectureType architectureType) {
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(9);
        }
        File file = this.getLLDBBinFile((String)(SystemInfo.isWindows ? LLDBDriverConfiguration.getWinBinDir(architectureType) + "LLDBFrontend.exe" : (SystemInfo.isMac ? "LLDBFrontend" : "bin/LLDBFrontend")));
        if (file == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(10);
        }
        return file;
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(11);
        }
        File file = CidrDebuggerPathManager.getLLDBBinFile(relativePath, null);
        if (file == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(12);
        }
        return file;
    }

    @NotNull
    protected File getBundledLLDBFrameworkFile(ArchitectureType architectureType) {
        File file = CidrDebuggerPathManager.getLLDBBinFile((String)(SystemInfo.isWindows ? LLDBDriverConfiguration.getWinBinDir(architectureType) + "liblldb.dll" : (SystemInfo.isMac ? "LLDB.framework" : "lib/liblldb.so")), SystemInfo.isMac ? "LLDB.framework/Resources" : "bin");
        if (file == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(13);
        }
        return file;
    }

    public static boolean hasBundledLLDB() {
        return new LLDBDriverConfiguration().getBundledLLDBFrameworkFile(LLDBDriverConfiguration.getDefaultTargetArchitecture()).exists();
    }

    @Override
    @Deprecated
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (driver == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(14);
        }
        GeneralCommandLine generalCommandLine = this.createDriverCommandLine(driver, LLDBDriverConfiguration.getDefaultTargetArchitecture());
        if (generalCommandLine == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(15);
        }
        return generalCommandLine;
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull ArchitectureType architectureType) throws ExecutionException {
        if (driver == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(16);
        }
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(17);
        }
        GeneralCommandLine result2 = this.createLLDBFrontendCommandLine(architectureType);
        result2.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        this.configureDriverCommandLine(result2);
        GeneralCommandLine generalCommandLine = result2;
        if (generalCommandLine == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(18);
        }
        return generalCommandLine;
    }

    @NotNull
    private GeneralCommandLine createLLDBFrontendCommandLine(@NotNull ArchitectureType architectureType) throws ExecutionException {
        File lldbFrameworkFile;
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(19);
        }
        if (!(lldbFrameworkFile = this.getLLDBFrameworkFile(architectureType)).exists()) {
            throw new ExecutionException(LLDBBundle.message("error.lldb.library.not.found", lldbFrameworkFile));
        }
        File frontendExecutable = this.getLLDBFrontendFile(architectureType);
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(LLDBBundle.message("error.lldbfrontend.not.found", frontendExecutable.getAbsolutePath()));
        }
        GeneralCommandLine result2 = new GeneralCommandLine();
        result2.setExePath(frontendExecutable.getAbsolutePath());
        Map env = result2.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_PRELOAD", lldbFrameworkFile.getAbsolutePath());
        } else if (SystemInfo.isWindows) {
            File lldbFrameworkDir = lldbFrameworkFile.getParentFile();
            CidrExecUtil.appendSearchPath((Map)env, (String)"PATH", (String)lldbFrameworkDir.getPath());
            File lldbFrontendDir = frontendExecutable.getParentFile();
            if (!FileUtil.filesEqual((File)lldbFrontendDir, (File)lldbFrameworkDir)) {
                CidrExecUtil.appendSearchPath((Map)env, (String)"PATH", (String)lldbFrontendDir.getPath());
            }
            String parentPATH = (String)result2.getParentEnvironment().get("PATH");
            CidrExecUtil.appendSearchPath((Map)env, (String)"PATH", (String)parentPATH);
            if (this.useNativePDBPlugin()) {
                env.put("LLDB_USE_NATIVE_PDB_READER", "1");
            }
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
            env.put("NSUnbufferedIO", "YES");
            File pythonDir = CidrDebuggerPathManager.getOSXSystemPythonBinDir();
            if (pythonDir != null) {
                env.put("PATH", (String)result2.getParentEnvironment().get("PATH"));
                CidrExecUtil.appendSearchPath((Map)env, (String)"PATH", (String)pythonDir.getAbsolutePath());
            } else {
                CidrDebuggerLog.LOG.warn("Python bin dir not found");
            }
        }
        if (SystemInfo.isUnix && this.useSTLRenderers()) {
            result2.putUserData(LLDBDriver.ENABLE_STL_RENDERERS, (Object)true);
            env.put("PYTHONPATH", CidrDebuggerPathManager.getBundledLLDBSTLPrettyPrinters().getAbsolutePath());
        }
        if (this.disableASLR()) {
            env.put("LLDB_LAUNCH_FLAG_DISABLE_ASLR", "1");
        }
        LLDBDriverConfiguration.setupCommonParameters(result2);
        GeneralCommandLine generalCommandLine = result2;
        if (generalCommandLine == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(20);
        }
        return generalCommandLine;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result2) {
        if (result2 == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(21);
        }
        if (LLDBDriverConfiguration.isDebugModeEnabled()) {
            result2.addParameter("--debug");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, long threadId, int frameIndex, @NotNull UserDataHolderEx userDataHolderEx) {
        void cacheHolder;
        if (driver == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(22);
        }
        if (userDataHolderEx == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(23);
        }
        return new LLDBEvaluationContext(driver, expirable, threadId, frameIndex, (UserDataHolderEx)cacheHolder);
    }

    @Override
    public boolean supportsArrayEvaluation() {
        return true;
    }

    @Override
    public boolean isCodeFragmentEvaluationSupported() {
        return true;
    }

    public boolean isStaticVarsLoadingEnabled() {
        return Registry.is((String)"cidr.debugger.lldb.statics");
    }

    public boolean useNativePDBPlugin() {
        return Registry.is((String)"cidr.debugger.lldb.useNativePDBPlugin");
    }

    public boolean disableASLR() {
        return false;
    }

    public boolean useSTLRenderers() {
        return true;
    }

    @Contract(value="null -> null")
    public String convertToProjectModelPath(@Nullable String absolutePath) {
        return absolutePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayVersion";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "architectureType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 14: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTargetArchitecture";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWinBinDir";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBFrameworkFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBFrontendFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBBinFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledLLDBFrameworkFile";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriverCommandLine";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createLLDBFrontendCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDriver";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWinBinDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBFrameworkFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBFrontendFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBBinFile";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDriverCommandLine";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createLLDBFrontendCommandLine";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "configureDriverCommandLine";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluationContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

