/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCleanableBreakpointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrWatchpointHandler
extends CidrCleanableBreakpointHandlerBase<XBreakpoint<CidrWatchpointType.CidrWatchpointProperties>> {
    public CidrWatchpointHandler(CidrDebugProcess process) {
        super(process, CidrWatchpointType.class);
    }

    @Override
    protected Collection<LLCodepoint> addCodepointsInBackend(DebuggerDriver driver, XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        LLWatchpoint watchpoint;
        CidrWatchpointType.CidrWatchpointProperties properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties();
        if (properties == null || properties.getDebugProcess() != this.myProcess || !this.myProcess.supportsWatchpoints()) {
            return Collections.emptySet();
        }
        try {
            watchpoint = driver.addWatchpoint(threadId, frameIndex, properties.getLLValue(), properties.getExpr(), properties.getLifetime(), properties.getAccessType());
            properties.setError(null);
        }
        catch (DebuggerCommandException e) {
            properties.setError(e.getMessage());
            return Collections.emptyList();
        }
        return Collections.singleton(watchpoint);
    }

    @Override
    protected boolean shouldBreakpointBeRemoved(@NotNull XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint) {
        CidrWatchpointType.CidrWatchpointProperties properties;
        if (breakpoint == null) {
            CidrWatchpointHandler.$$$reportNull$$$0(0);
        }
        return (properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties()) != null && properties.getDebugProcess() == this.myProcess;
    }

    public void handleWatchpointScope(int id) {
        Object breakpoint = this.getCodepoint(id);
        if (breakpoint == null) {
            return;
        }
        this.unregisterCodepointsMapping(breakpoint);
        XDebuggerUtil.getInstance().removeBreakpoint(this.myProcess.getProject(), breakpoint);
    }

    @Override
    protected void removeCodepointsInBackend(DebuggerDriver driver, List<Integer> ids, XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint) throws ExecutionException, DebuggerCommandException {
        CidrWatchpointType.CidrWatchpointProperties properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties();
        if (properties != null) {
            CidrDebuggerLog.LOG.assertTrue(properties.getDebugProcess() == this.myProcess);
        }
        driver.removeWatchpoint(ids);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrWatchpointHandler", "shouldBreakpointBeRemoved"));
    }
}

