/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ContainerValueRenderer;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDictionaryEntryValue
extends CidrValue {
    @NotNull
    private final CidrPhysicalValue myContainer;
    @NotNull
    private final CidrPhysicalValue myKey;
    @NotNull
    private final CidrPhysicalValue myObject;
    protected final int myIndex;

    public CidrDictionaryEntryValue(@NotNull String displayName, @NotNull CidrPhysicalValue container, @NotNull LLValue key, @NotNull LLValue object, int index) {
        if (displayName == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(0);
        }
        if (container == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(1);
        }
        if (key == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(2);
        }
        if (object == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(3);
        }
        super(displayName, container.getProcess(), container.getSourcePosition(), container.getFrame());
        this.myContainer = container;
        this.myIndex = index;
        this.myKey = new CidrElementValue(key, "key", container, this.myIndex, false);
        this.myObject = new CidrElementValue(object, "object", container, this.myIndex, false);
    }

    @NotNull
    public CidrPhysicalValue getObject() {
        CidrPhysicalValue cidrPhysicalValue = this.myObject;
        if (cidrPhysicalValue == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(4);
        }
        return cidrPhysicalValue;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @Override
    @NotNull
    protected CompletableFuture<XSourcePosition> doComputePositionAsync(@NotNull XSourcePosition position, @NotNull ProgressIndicator indicator) {
        if (position == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(6);
        }
        CompletableFuture<XSourcePosition> completableFuture = this.myContainer.doComputePositionAsync(position, indicator);
        if (completableFuture == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        String string = ((ContainerValueRenderer)this.myContainer.getPreparedRenderer()).getDictionaryEntryEvaluationExpression(this, lvalue);
        if (string == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    protected boolean doComputeMayHaveChildren(@NotNull EvaluationContext context2) throws ExecutionException {
        if (context2 == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(9);
        }
        return true;
    }

    @Override
    @Nullable
    protected Icon doComputeIcon(@NotNull EvaluationContext context2, boolean hasChildren) throws ExecutionException {
        if (context2 == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(10);
        }
        return AllIcons.Debugger.Value;
    }

    @Override
    @Nullable
    protected String doComputeType(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(12);
        }
        Pair pair = Pair.create((Object)(CidrDictionaryEntryValue.shorten((String)this.myKey.doComputeValueAndEvaluator((EvaluationContext)context2).first) + " -> " + CidrDictionaryEntryValue.shorten((String)this.myObject.doComputeValueAndEvaluator((EvaluationContext)context2).first)), null);
        if (pair == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @Override
    @NotNull
    public String getConsoleDescription(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(14);
        }
        String string = CidrDictionaryEntryValue.shorten(this.myKey.getConsoleDescription(context2)) + " -> " + CidrDictionaryEntryValue.shorten(this.myObject.getConsoleDescription(context2));
        if (string == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String shorten(@NotNull String value) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(16);
        }
        String string = StringUtil.first((String)value, (int)100, (boolean)true);
        if (string == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    protected void computeValueChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            CidrDictionaryEntryValue.$$$reportNull$$$0(18);
        }
        if (node.isObsolete()) {
            return;
        }
        XValueChildrenList values = new XValueChildrenList(2);
        values.add((XNamedValue)this.myKey);
        values.add((XNamedValue)this.myObject);
        node.addChildren(values, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputePositionAsync";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeValueAndEvaluator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleDescription";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "shorten";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doComputePositionAsync";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doComputeMayHaveChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIcon";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doComputeType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doComputeValueAndEvaluator";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleDescription";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shorten";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeValueChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

