/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.Util;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;

class UniteSameType
implements DiffCorrection {
    private static final Logger LOG = Logger.getInstance(UniteSameType.class);
    public static final DiffCorrection INSTANCE = new UniteSameType();

    UniteSameType() {
    }

    @Override
    public DiffFragment[] correct(DiffFragment[] fragments) {
        return UniteSameType.unitSameTypes(UniteSameType.covertSequentialOneSideToChange(UniteSameType.unitSameTypes(fragments)));
    }

    private static DiffFragment @NotNull [] unitSameTypes(DiffFragment @NotNull [] fragments) {
        if (fragments == null) {
            UniteSameType.$$$reportNull$$$0(0);
        }
        if (fragments.length < 2) {
            if (fragments == null) {
                UniteSameType.$$$reportNull$$$0(1);
            }
            return fragments;
        }
        DiffCorrection.FragmentsCollector collector = new DiffCorrection.FragmentsCollector();
        DiffFragment previous = fragments[0];
        for (int i = 1; i < fragments.length; ++i) {
            DiffFragment fragment = fragments[i];
            if (!fragment.isOneSide() && fragment.getText1().isEmpty() && fragment.getText2().isEmpty()) continue;
            if (Util.isSameType(previous, fragment)) {
                previous = Util.unite(previous, fragment);
                continue;
            }
            collector.add(previous);
            previous = fragment;
        }
        collector.add(previous);
        DiffFragment[] diffFragmentArray = collector.toArray();
        if (diffFragmentArray == null) {
            UniteSameType.$$$reportNull$$$0(2);
        }
        return diffFragmentArray;
    }

    private static DiffFragment @NotNull [] covertSequentialOneSideToChange(DiffFragment @NotNull [] fragments) {
        if (fragments == null) {
            UniteSameType.$$$reportNull$$$0(3);
        }
        if (fragments.length < 2) {
            if (fragments == null) {
                UniteSameType.$$$reportNull$$$0(4);
            }
            return fragments;
        }
        DiffCorrection.FragmentsCollector collector = new DiffCorrection.FragmentsCollector();
        DiffFragment previous = null;
        for (DiffFragment fragment : fragments) {
            if (fragment.isOneSide()) {
                if (previous == null) {
                    previous = fragment;
                    continue;
                }
                FragmentSide side = FragmentSide.chooseSide(fragment);
                DiffString previousText = side.getText(previous);
                if (previousText == null) {
                    previousText = DiffString.EMPTY;
                }
                previous = side.createFragment(DiffString.concatenateNullable(previousText, side.getText(fragment)), side.getOtherText(previous), true);
                continue;
            }
            if (previous != null) {
                collector.add(previous);
            }
            previous = null;
            collector.add(fragment);
        }
        if (previous != null) {
            collector.add(previous);
        }
        DiffFragment[] diffFragmentArray = collector.toArray();
        if (diffFragmentArray == null) {
            UniteSameType.$$$reportNull$$$0(5);
        }
        return diffFragmentArray;
    }

    public static DiffFragment uniteAll(DiffFragment[] fragments) throws FilesTooBigForDiffException {
        LOG.assertTrue((fragments = INSTANCE.correct(fragments)).length == 1);
        return fragments[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/processing/UniteSameType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/processing/UniteSameType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "unitSameTypes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "covertSequentialOneSideToChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unitSameTypes";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "covertSequentialOneSideToChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

