/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.StartupUiUtil;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public final class FontInfo {
    private static final FontInfoComparator COMPARATOR = new FontInfoComparator();
    private static final FontRenderContext DEFAULT_CONTEXT = new FontRenderContext(null, false, false);
    private static final String[] WRONG_SUFFIX = new String[]{".plain", ".bold", ".italic", ".bolditalic"};
    private static final String[] DEFAULT = new String[]{"Dialog", "DialogInput", "Monospaced", "SansSerif", "Serif"};
    private static final int DEFAULT_SIZE = 12;
    private static final float SIZE_FOR_MONOSPACED_CHECK = 100.0f;
    private final String myName;
    private final int myDefaultSize;
    private final boolean myMonospaced;
    private volatile Font myFont;

    private FontInfo(String name, Font font, boolean monospaced) {
        this.myName = name;
        this.myFont = font;
        this.myDefaultSize = font.getSize();
        this.myMonospaced = monospaced;
    }

    public boolean isMonospaced() {
        return this.myMonospaced;
    }

    public Font getFont() {
        return this.getFont(this.myDefaultSize);
    }

    public Font getFont(int size) {
        Font font = this.myFont;
        if (size != font.getSize()) {
            this.myFont = font = font.deriveFont((float)size);
        }
        return font;
    }

    public String toString() {
        return this.myName != null ? this.myName : this.myFont.getFontName(Locale.ENGLISH);
    }

    public static FontInfo get(String name) {
        return name == null || GraphicsEnvironment.isHeadless() ? null : FontInfo.find(LazyListByName.LIST, name);
    }

    public static FontInfo get(Font font) {
        return font == null || GraphicsEnvironment.isHeadless() ? null : FontInfo.find(LazyListByFont.LIST, font.getFontName(Locale.ENGLISH));
    }

    public static List<FontInfo> getAll(boolean withAllStyles) {
        return GraphicsEnvironment.isHeadless() ? Collections.emptyList() : (withAllStyles ? LazyListByFont.LIST : LazyListByName.LIST);
    }

    private static FontInfo find(List<FontInfo> list, String name) {
        for (FontInfo info : list) {
            if (!FontInfo.matches(info, name)) continue;
            return info;
        }
        return null;
    }

    private static boolean matches(FontInfo info, String name) {
        return info.toString().equalsIgnoreCase(name);
    }

    private boolean isLogicalFont() {
        for (String logicalFontName : DEFAULT) {
            if (!FontInfo.matches(this, logicalFontName)) continue;
            return true;
        }
        return false;
    }

    private static FontInfo byName(String name) {
        return FontInfo.isWrongSuffix(name) ? null : FontInfo.create(name, null);
    }

    private static List<FontInfo> byName() {
        FontInfo info;
        String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.ENGLISH);
        ArrayList<FontInfo> list = new ArrayList<FontInfo>(names.length);
        for (String name : names) {
            info = FontInfo.byName(name);
            if (info == null) continue;
            list.add(info);
        }
        for (String name : DEFAULT) {
            if (FontInfo.find(list, name) != null || (info = FontInfo.byName(name)) == null) continue;
            list.add(info);
        }
        list.sort(COMPARATOR);
        return Collections.unmodifiableList(list);
    }

    private static FontInfo byFont(Font font) {
        return FontInfo.isWrongSuffix(font.getFontName(Locale.ENGLISH)) ? null : FontInfo.create(null, font);
    }

    private static List<FontInfo> byFont() {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        ArrayList<FontInfo> list = new ArrayList<FontInfo>(fonts.length);
        for (Font font : fonts) {
            FontInfo info = FontInfo.byFont(font);
            if (info == null || info.isLogicalFont()) continue;
            list.add(info);
        }
        list.sort(COMPARATOR);
        return Collections.unmodifiableList(list);
    }

    private static FontInfo create(String name, Font font) {
        boolean plainOnly = name == null;
        try {
            if (font == null) {
                font = new Font(name, 0, 12);
                if (!"Dialog".equals(name) && StartupUiUtil.isDialogFont(font)) {
                    throw new IllegalArgumentException("not supported " + font);
                }
            } else if (12 != font.getSize()) {
                font = font.deriveFont(12.0f);
                name = font.getFontName(Locale.ENGLISH);
            }
            boolean monospaced = plainOnly ? FontInfo.isMonospaced(font) : FontInfo.isMonospacedWithStyles(font);
            return new FontInfo(name, font, monospaced);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static boolean isWrongSuffix(String name) {
        for (String suffix : WRONG_SUFFIX) {
            if (!name.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static int getFontWidth(Font font, int mask) {
        int width;
        if (mask != 0) {
            font = font.deriveFont(mask ^ font.getStyle());
        }
        return (width = FontInfo.getCharWidth(font = font.deriveFont(100.0f), ' ')) == FontInfo.getCharWidth(font, 'l') && width == FontInfo.getCharWidth(font, 'W') ? width : 0;
    }

    public static boolean isMonospaced(Font font) {
        return FontInfo.getFontWidth(font, 0) > 0;
    }

    public static boolean isMonospacedWithStyles(Font font) {
        int width = FontInfo.getFontWidth(font, 0);
        if (width != 0 && width != FontInfo.getFontWidth(font, 1)) {
            width = 0;
        }
        if (width != 0 && width != FontInfo.getFontWidth(font, 2)) {
            width = 0;
        }
        if (width != 0 && width != FontInfo.getFontWidth(font, 3)) {
            width = 0;
        }
        return width > 0;
    }

    private static int getCharWidth(Font font, char ch) {
        Rectangle bounds;
        if (font.canDisplay(ch) && !(bounds = font.getStringBounds(new char[]{ch}, 0, 1, DEFAULT_CONTEXT).getBounds()).isEmpty()) {
            return bounds.width;
        }
        return 0;
    }

    private static final class FontInfoComparator
    implements Comparator<FontInfo> {
        private FontInfoComparator() {
        }

        @Override
        public int compare(FontInfo one, FontInfo two) {
            if (one.isMonospaced() && !two.isMonospaced()) {
                return -1;
            }
            if (!one.isMonospaced() && two.isMonospaced()) {
                return 1;
            }
            return one.toString().compareToIgnoreCase(two.toString());
        }
    }

    private static final class LazyListByFont {
        private static final List<FontInfo> LIST = FontInfo.byFont();

        private LazyListByFont() {
        }
    }

    private static final class LazyListByName {
        private static final List<FontInfo> LIST = FontInfo.byName();

        private LazyListByName() {
        }
    }
}

