/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.BigQueryExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.BigQueryIntermediateFacade;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigQueryJdbcHelper
extends JdbcHelperImpl {
    public BigQueryJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("BIGQUERY", version, connection);
    }

    public BigQueryJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return BigQueryJdbcHelper.extractVersion(version);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(0);
        }
        return new BigQueryIntermediateFacade(ds, BigQueryExceptionRecognizer.INSTANCE, this);
    }

    @Override
    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(1);
        }
        statement.setTimestamp(idx, timestamp);
    }

    @Override
    protected void setTime(@NotNull RemotePreparedStatement statement, int idx, Time time) throws RemoteException, SQLException {
        if (statement == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(2);
        }
        statement.setTime(idx, time);
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    public char getEscapeChar() {
        return '\\';
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "%_\\";
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "BigQuery")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return BigQueryJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static JdbcHelperImpl create(@Nullable Connection delegate, @Nullable String productVer) throws Exception {
        String versionStr = delegate == null ? productVer : delegate.getMetaData().getDriverVersion();
        JdbcNativeUtil.logInfo("release_version: " + versionStr);
        return new BigQueryJdbcHelper(BigQueryJdbcHelper.extractVersion(versionStr), delegate);
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, Level level, String logPath) {
        super.setDriverLogLevel(driver, properties, level, logPath);
        BigQueryJdbcHelper.configureSimbaLogging(properties, level, logPath);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(3);
        }
        return BigQueryJdbcHelper.classNameContains(driver, "googlebigquery");
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(4);
        }
        e.length = -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/BigQueryJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setTimestamp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setTime";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

