/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.execution.rmi.RemoteObject;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcRemoteObject
extends RemoteObject {
    protected Throwable wrapException(Throwable ex, int exDepth) {
        if (ex instanceof SQLException) {
            return this.wrapSqlException((SQLException)ex, exDepth);
        }
        return super.wrapException(ex, exDepth);
    }

    @Nullable
    private SQLException wrapSqlException(@Nullable SQLException target, int exDepth) {
        SQLException result = null;
        SQLException prev = null;
        for (SQLException ex = target; ex != null; ex = ex.getNextException()) {
            SQLException w = new SQLException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), this.wrapExceptionCause(ex, exDepth));
            w.setStackTrace(ex.getStackTrace());
            if (prev == null) {
                result = prev = w;
                continue;
            }
            prev.setNextException(w);
        }
        return result;
    }

    @Nullable
    public SQLWarning wrapSqlWarning(@Nullable SQLWarning target) {
        SQLWarning result = null;
        SQLWarning prev = null;
        for (SQLWarning ex = target; ex != null; ex = ex.getNextWarning()) {
            SQLWarning w = new SQLWarning(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), this.wrapExceptionCause(ex, 0));
            w.setStackTrace(ex.getStackTrace());
            if (prev == null) {
                result = prev = w;
                continue;
            }
            prev.setNextWarning(w);
        }
        return result;
    }

    @NotNull
    public List<SQLWarning> getAllWarnings(@Nullable SQLWarning target) {
        ArrayList<SQLWarning> warnings = new ArrayList<SQLWarning>();
        while (target != null) {
            SQLWarning warning = new SQLWarning(target.getMessage(), target.getSQLState(), target.getErrorCode(), this.wrapExceptionCause(target, 0));
            warning.setStackTrace(target.getStackTrace());
            warnings.add(warning);
            target = target.getNextWarning();
        }
        ArrayList<SQLWarning> arrayList = warnings;
        if (arrayList == null) {
            JdbcRemoteObject.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Contract(value="_ -> fail")
    public RuntimeException rethrowException(Throwable e) throws SQLException, RemoteException {
        Throwable wrap = this.wrapException(e);
        if (wrap instanceof SQLException) {
            throw (SQLException)wrap;
        }
        throw wrap instanceof RuntimeException ? (RuntimeException)wrap : new RuntimeException(wrap);
    }

    @Contract(value="_ -> fail")
    public RuntimeException rethrowRuntimeException(Throwable e) throws RemoteException {
        Throwable wrap = this.wrapException(e);
        throw wrap instanceof RuntimeException ? (RuntimeException)wrap : new RuntimeException(wrap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/impl/JdbcRemoteObject", "getAllWarnings"));
    }
}

