/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.GradleCommandLineProjectConfiguratorKt;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleImportHint;
import org.jetbrains.plugins.gradle.settings.GradleImportHintService;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator;", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator;", "()V", "configureEnvironment", "", "context", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;", "configureProject", "project", "Lcom/intellij/openapi/project/Project;", "getDescription", "", "getName", "importProjects", "linkGradleHintProjects", "", "basePath", "linkProjects", "linkRootProject", "LoggingNotificationListener", "StateNotificationListener", "intellij.gradle.common"})
public final class GradleCommandLineProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public String getName() {
        return "gradle";
    }

    @NotNull
    public String getDescription() {
        String string2 = GradleBundle.message("gradle.commandline.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GradleBundle.message(\"gr\u2026commandline.description\")");
        return string2;
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CommandLineInspectionProjectConfigurator.ConfiguratorContext configuratorContext = context;
        boolean bl = false;
        boolean bl2 = false;
        CommandLineInspectionProjectConfigurator.ConfiguratorContext $this$run = configuratorContext;
        boolean bl3 = false;
        Registry.get((String)"external.system.auto.import.disabled").setValue(true);
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)new LoggingNotificationListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureProject(@NotNull Project project, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = project.getBasePath();
        if (string2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.basePath ?: return");
        String basePath = string2;
        GradleImportHint state = (GradleImportHint)GradleImportHintService.Companion.getInstance(project).getState();
        if (state.getSkip()) {
            return;
        }
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        if (gradleSettings.getLinkedProjectsSettings().isEmpty()) {
            this.linkProjects(basePath, project);
        }
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        StateNotificationListener notificationListener2 = new StateNotificationListener();
        try {
            progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)notificationListener2);
            this.importProjects(project);
            notificationListener2.waitForImportEnd();
        }
        finally {
            progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)notificationListener2);
        }
    }

    private final void linkProjects(String basePath, Project project) {
        if (this.linkGradleHintProjects(basePath, project)) {
            return;
        }
        this.linkRootProject(basePath, project);
    }

    private final void importProjects(Project project) {
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        if (!gradleSettings.getLinkedProjectsSettings().isEmpty()) {
            Registry.get((String)"external.system.auto.import.disabled").setValue(false);
            AutoImportProjectTracker.Companion.getInstance(project).scheduleProjectRefresh();
            Registry.get((String)"external.system.auto.import.disabled").setValue(true);
        }
    }

    private final boolean linkRootProject(String basePath, Project project) {
        String gradleGroovyDslFile = basePath + "/" + "build.gradle";
        String kotlinDslGradleFile = basePath + "/" + "build.gradle.kts";
        if (FileUtil.findFirstThatExist((String[])new String[]{gradleGroovyDslFile, kotlinDslGradleFile}) == null) {
            return false;
        }
        GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Link gradle project from root directory");
        Path path = Paths.get(basePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(basePath)");
        GradleProjectSettings settings2 = GradleProjectImportUtil.createLinkSettings(path, project);
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)settings2);
        return true;
    }

    private final boolean linkGradleHintProjects(String basePath, Project project) {
        GradleImportHint state = (GradleImportHint)GradleImportHintService.Companion.getInstance(project).getState();
        Collection collection = state.getProjectsToImport();
        boolean bl = false;
        if (!collection.isEmpty()) {
            for (String projectPath : state.getProjectsToImport()) {
                Path buildFile = new File(basePath).toPath().resolve(projectPath);
                if (buildFile.toFile().exists()) {
                    GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Link gradle project from intellij.yaml: " + projectPath);
                    Path path = buildFile;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"buildFile");
                    Path path2 = path.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"buildFile.parent");
                    GradleProjectSettings settings2 = GradleProjectImportUtil.createLinkSettings(path2, project);
                    ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)settings2);
                    continue;
                }
                GradleCommandLineProjectConfiguratorKt.access$getLOG$p().error("File for linking gradle project doesn't exist: " + ((Object)buildFile.toAbsolutePath()).toString());
                return false;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u001c\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0006\u0010\u0011\u001a\u00020\bR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator$StateNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListenerAdapter;", "()V", "externalSystemState", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Ljava/util/concurrent/CompletableFuture;", "onCancel", "", "id", "onEnd", "onFailure", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onStart", "onSuccess", "waitForImportEnd", "intellij.gradle.common"})
    public static final class StateNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        private final ConcurrentHashMap<ExternalSystemTaskId, CompletableFuture<ExternalSystemTaskId>> externalSystemState = new ConcurrentHashMap();

        public void onSuccess(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle import success: " + id.getIdeProjectId());
            CompletableFuture<ExternalSystemTaskId> completableFuture = this.externalSystemState.get(id);
            if (completableFuture == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"externalSystemState[id] ?: return");
            CompletableFuture<ExternalSystemTaskId> future = completableFuture;
            future.complete(id);
        }

        public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().error("Gradle import failure " + id.getIdeProjectId(), (Throwable)e);
            CompletableFuture<ExternalSystemTaskId> completableFuture = this.externalSystemState.get(id);
            if (completableFuture == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"externalSystemState[id] ?: return");
            CompletableFuture<ExternalSystemTaskId> future = completableFuture;
            future.completeExceptionally(new IllegalStateException("Gradle project " + id.getIdeProjectId() + " import failed.", e));
        }

        public void onCancel(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().error("Gradle import canceled " + id.getIdeProjectId());
            CompletableFuture<ExternalSystemTaskId> completableFuture = this.externalSystemState.get(id);
            if (completableFuture == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"externalSystemState[id] ?: return");
            CompletableFuture<ExternalSystemTaskId> future = completableFuture;
            future.completeExceptionally(new IllegalStateException("Import of " + id.getIdeProjectId() + " was canceled"));
        }

        public void onStart(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            ((Map)this.externalSystemState).put(id, new CompletableFuture());
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle import started " + id.getIdeProjectId());
        }

        public final void waitForImportEnd() {
            Collection<CompletableFuture<ExternalSystemTaskId>> collection = this.externalSystemState.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"externalSystemState.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompletableFuture it = (CompletableFuture)element$iv;
                boolean bl = false;
                it.get();
            }
        }

        public void onEnd(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            CompletableFuture<ExternalSystemTaskId> completableFuture = this.externalSystemState.get(id);
            if (completableFuture == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"externalSystemState[id] ?: return");
            CompletableFuture<ExternalSystemTaskId> future = completableFuture;
            if (future.isDone()) {
                return;
            }
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().error("Gradle import finished " + id.getIdeProjectId() + " without success event");
            future.completeExceptionally(new IllegalStateException("Import of " + id.getIdeProjectId() + " was finished without success event"));
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator$LoggingNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListenerAdapter;", "()V", "onEnd", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "onTaskOutput", "text", "", "stdOut", "", "intellij.gradle.common"})
    public static final class LoggingNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            String gradleText = (stdOut ? "" : "STDERR: ") + text;
            GradleCommandLineProjectConfiguratorKt.access$getGradleLogWriter$p().write(gradleText);
            GradleCommandLineProjectConfiguratorKt.access$getGRADLE_OUTPUT_LOG$p().debug(gradleText);
        }

        public void onEnd(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GradleCommandLineProjectConfiguratorKt.access$getGradleLogWriter$p().flush();
        }
    }
}

