/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencyIssue;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencyIssueKt;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyBuildIssue;", "Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyIssue;", "dependencyName", "", "failureMessage", "isOfflineMode", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "description", "getDescription", "()Ljava/lang/String;", "quickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "getQuickFixes", "()Ljava/util/List;", "DisableOfflineAndRerun", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class UnresolvedDependencyBuildIssue
extends UnresolvedDependencyIssue {
    @NotNull
    private final List<BuildIssueQuickFix> quickFixes;
    @NotNull
    private final String description;

    @NotNull
    public List<BuildIssueQuickFix> getQuickFixes() {
        return this.quickFixes;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    public UnresolvedDependencyBuildIssue(@NotNull String dependencyName, @Nullable String failureMessage, boolean isOfflineMode) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        super(dependencyName);
        this.quickFixes = isOfflineMode ? CollectionsKt.listOf((Object)new DisableOfflineAndRerun()) : CollectionsKt.emptyList();
        this.description = this.buildDescription(failureMessage, isOfflineMode, "Disable offline mode and rerun the build");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyBuildIssue$DisableOfflineAndRerun;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "(Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyBuildIssue;)V", "id", "", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.gradle.common"})
    public final class DisableOfflineAndRerun
    implements BuildIssueQuickFix {
        @NotNull
        private final String id;

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            GradleSettings gradleSettings = GradleSettings.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
            gradleSettings.setOfflineWork(false);
            CompletableFuture<Object> completableFuture = UnresolvedDependencyIssueKt.access$tryRerun(dataContext);
            if (completableFuture == null) {
                CompletableFuture<Object> completableFuture2 = CompletableFuture.completedFuture(null);
                completableFuture = completableFuture2;
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"CompletableFuture.completedFuture(null)");
            }
            return completableFuture;
        }

        public DisableOfflineAndRerun() {
            this.id = "disable_offline_mode";
        }
    }
}

