/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;

public class WebResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final WarDirectory warDirectory;
    @NotNull
    private final String warRelativePath;
    @NotNull
    private final File file;

    @PropertyMapping(value={"warDirectory", "warRelativePath", "file"})
    public WebResource(@NotNull WarDirectory warDirectory, @NotNull String warRelativePath, @NotNull File file) {
        if (warDirectory == null) {
            WebResource.$$$reportNull$$$0(0);
        }
        if (warRelativePath == null) {
            WebResource.$$$reportNull$$$0(1);
        }
        if (file == null) {
            WebResource.$$$reportNull$$$0(2);
        }
        this.warDirectory = warDirectory;
        this.warRelativePath = WebResource.getAdjustedPath(warRelativePath);
        this.file = file;
    }

    @NotNull
    public WarDirectory getWarDirectory() {
        WarDirectory warDirectory = this.warDirectory;
        if (warDirectory == null) {
            WebResource.$$$reportNull$$$0(3);
        }
        return warDirectory;
    }

    @NotNull
    public String getWarRelativePath() {
        String string2 = this.warRelativePath;
        if (string2 == null) {
            WebResource.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public File getFile() {
        File file = this.file;
        if (file == null) {
            WebResource.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static String getAdjustedPath(@NotNull String path) {
        if (path == null) {
            WebResource.$$$reportNull$$$0(6);
        }
        return path.isEmpty() || path.charAt(0) != '/' ? "/" + path : path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebResource)) {
            return false;
        }
        WebResource resource = (WebResource)o;
        if (!this.file.getPath().equals(resource.file.getPath())) {
            return false;
        }
        if (this.warDirectory != resource.warDirectory) {
            return false;
        }
        return this.warRelativePath.equals(resource.warRelativePath);
    }

    public int hashCode() {
        int result = this.warDirectory.hashCode();
        result = 31 * result + this.warRelativePath.hashCode();
        result = 31 * result + this.file.getPath().hashCode();
        return result;
    }

    public String toString() {
        return "WebResource{myWarDirectory=" + this.warDirectory + ", warRelativePath='" + this.warRelativePath + "', file=" + this.file + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warRelativePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/data/WebResource";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/data/WebResource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarRelativePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

