/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemBeforeRunTask;
import com.intellij.openapi.externalSystem.service.execution.configuration.ExternalSystemReifiedRunConfigurationExtension;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemProjectPathField;
import com.intellij.openapi.externalSystem.service.ui.tasks.and.arguments.ExternalSystemTasksAndArguments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleBeforeRunTaskProvider;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfigurationExtension;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleTaskData;
import org.jetbrains.plugins.gradle.util.GradleTasksUtilKt;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0005H\u0002J\u0012\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0005H\u0002J\u0012\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0005H\u0002J$\u0010\b\u001a\u00020\t*\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u00050\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfigurationExtension;", "Lcom/intellij/openapi/externalSystem/service/execution/configuration/ExternalSystemReifiedRunConfigurationExtension;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration;", "()V", "createDebugAllEnabledTag", "Lcom/intellij/execution/ui/SettingsEditorFragment;", "createReattachDebugProcessTag", "createScriptDebugEnabledTag", "configureFragments", "", "", "configuration", "GradleTasksAndArguments", "intellij.gradle.common"})
public final class GradleRunConfigurationExtension
extends ExternalSystemReifiedRunConfigurationExtension<GradleRunConfiguration> {
    public void configureFragments(@NotNull List<SettingsEditorFragment<GradleRunConfiguration, ?>> $this$configureFragments, @NotNull GradleRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter($this$configureFragments, (String)"$this$configureFragments");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
        Project project2 = project;
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"GradleConstants.SYSTEM_ID");
        SettingsEditorFragment projectPathSettings = ExternalSystemReifiedRunConfigurationExtension.Companion.createProjectPath(project2, projectSystemId);
        JComponent jComponent = projectPathSettings.component();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"projectPathSettings.component()");
        JComponent jComponent2 = ((LabeledComponent)jComponent).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"projectPathSettings.component().component");
        GradleTasksAndArguments tasksAndArguments = new GradleTasksAndArguments(project2, (ExternalSystemProjectPathField)jComponent2);
        ProjectSystemId projectSystemId2 = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId2, (String)"GradleConstants.SYSTEM_ID");
        SettingsEditorFragment tasksAndArgumentsSettings = ExternalSystemReifiedRunConfigurationExtension.Companion.createTasksAndArguments(project2, projectSystemId2, (ExternalSystemTasksAndArguments)tasksAndArguments);
        Key<ExternalSystemBeforeRunTask> key = GradleBeforeRunTaskProvider.ID;
        Intrinsics.checkNotNullExpressionValue(key, (String)"GradleBeforeRunTaskProvider.ID");
        $this$configureFragments.add((SettingsEditorFragment<GradleRunConfiguration, ?>)ExternalSystemReifiedRunConfigurationExtension.Companion.createBeforeRun(key));
        $this$configureFragments.add(projectPathSettings);
        $this$configureFragments.add(tasksAndArgumentsSettings);
        $this$configureFragments.add(this.createScriptDebugEnabledTag());
        $this$configureFragments.add(this.createReattachDebugProcessTag());
        $this$configureFragments.add(this.createDebugAllEnabledTag());
    }

    private final SettingsEditorFragment<GradleRunConfiguration, ?> createScriptDebugEnabledTag() {
        String string2 = GradleBundle.message("gradle.tasks.script.debugging", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GradleBundle.message(\"gr\u2026.tasks.script.debugging\")");
        String string3 = GradleBundle.message("gradle.settings.title.debug", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GradleBundle.message(\"gr\u2026le.settings.title.debug\")");
        return ExternalSystemReifiedRunConfigurationExtension.Companion.createSettingsTag("gradle.tasks.script.debugging.fragment", string2, string3, null, (Function1)createScriptDebugEnabledTag.1.INSTANCE, (Function2)createScriptDebugEnabledTag.2.INSTANCE, 200);
    }

    private final SettingsEditorFragment<GradleRunConfiguration, ?> createReattachDebugProcessTag() {
        String string2 = GradleBundle.message("gradle.tasks.reattach.debug.process", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GradleBundle.message(\"gr\u2026.reattach.debug.process\")");
        String string3 = GradleBundle.message("gradle.settings.title.debug", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GradleBundle.message(\"gr\u2026le.settings.title.debug\")");
        return ExternalSystemReifiedRunConfigurationExtension.Companion.createSettingsTag("gradle.tasks.reattach.debug.process.fragment", string2, string3, GradleBundle.message("gradle.tasks.reattach.debug.process.comment", new Object[0]), (Function1)createReattachDebugProcessTag.1.INSTANCE, (Function2)createReattachDebugProcessTag.2.INSTANCE, 200);
    }

    private final SettingsEditorFragment<GradleRunConfiguration, ?> createDebugAllEnabledTag() {
        String string2 = GradleBundle.message("gradle.tasks.debugging.all", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GradleBundle.message(\"gradle.tasks.debugging.all\")");
        String string3 = GradleBundle.message("gradle.settings.title.debug", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GradleBundle.message(\"gr\u2026le.settings.title.debug\")");
        return ExternalSystemReifiedRunConfigurationExtension.Companion.createSettingsTag("gradle.tasks.debugging.all.fragment", string2, string3, GradleBundle.message("gradle.tasks.debugging.all.comment", new Object[0]), (Function1)createDebugAllEnabledTag.1.INSTANCE, (Function2)createDebugAllEnabledTag.2.INSTANCE, 200);
    }

    public GradleRunConfigurationExtension() {
        super(GradleRunConfiguration.class);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfigurationExtension$GradleTasksAndArguments;", "Lcom/intellij/openapi/externalSystem/service/ui/tasks/and/arguments/ExternalSystemTasksAndArguments;", "project", "Lcom/intellij/openapi/project/Project;", "projectPathField", "Lcom/intellij/openapi/externalSystem/service/ui/ExternalSystemProjectPathField;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/service/ui/ExternalSystemProjectPathField;)V", "arguments", "", "Lcom/intellij/openapi/externalSystem/service/ui/tasks/and/arguments/ExternalSystemTasksAndArguments$Argument;", "getArguments", "()Ljava/util/List;", "tasks", "Lcom/intellij/openapi/externalSystem/service/ui/tasks/and/arguments/ExternalSystemTasksAndArguments$Task;", "getTasks", "intellij.gradle.common"})
    private static final class GradleTasksAndArguments
    implements ExternalSystemTasksAndArguments {
        private final Project project;
        private final ExternalSystemProjectPathField projectPathField;

        @NotNull
        public List<ExternalSystemTasksAndArguments.Task> getTasks() {
            Map<String, MultiMap<String, GradleTaskData>> allTasks = GradleTasksUtilKt.getGradleTasks(this.project);
            String projectPath = this.projectPathField.getProjectPath();
            DataNode<ModuleData> dataNode = GradleUtil.findGradleModuleData(this.project, projectPath);
            if (dataNode == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue(dataNode, (String)"GradleUtil.findGradleMod\u2026th) ?: return emptyList()");
            DataNode<ModuleData> moduleNode = dataNode;
            String string2 = GradleProjectResolverUtil.getGradlePath((ModuleData)moduleNode.getData());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GradleProjectResolverUti\u2026adlePath(moduleNode.data)");
            String gradlePath = StringsKt.removeSuffix((String)string2, (CharSequence)":");
            MultiMap<String, GradleTaskData> multiMap = allTasks.get(projectPath);
            if (multiMap == null) {
                return CollectionsKt.emptyList();
            }
            MultiMap<String, GradleTaskData> tasks = multiMap;
            ArrayList<ExternalSystemTasksAndArguments.Task> wildcardTasksInfo = new ArrayList<ExternalSystemTasksAndArguments.Task>();
            ArrayList<ExternalSystemTasksAndArguments.Task> tasksInfo = new ArrayList<ExternalSystemTasksAndArguments.Task>();
            Iterator iterator = tasks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                boolean bl = false;
                Collection tasksData = (Collection)entry2.getValue();
                for (GradleTaskData taskData : tasksData) {
                    String taskFqn = StringsKt.removePrefix((String)taskData.getFqnTaskName(), (CharSequence)gradlePath);
                    String taskDescription = taskData.getDescription();
                    if (!taskData.isFromIncludedBuild()) {
                        wildcardTasksInfo.add(new ExternalSystemTasksAndArguments.Task(StringsKt.removePrefix((String)taskFqn, (CharSequence)":"), taskDescription));
                    }
                    if (taskData.isInherited()) continue;
                    tasksInfo.add(new ExternalSystemTasksAndArguments.Task(taskFqn, taskDescription));
                }
            }
            Iterable $this$sortedBy$iv = wildcardTasksInfo;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            Collection collection = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ExternalSystemTasksAndArguments.Task it = (ExternalSystemTasksAndArguments.Task)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (ExternalSystemTasksAndArguments.Task)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string2 = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                }
            });
            $this$sortedBy$iv = tasksInfo;
            $i$f$sortedBy = false;
            bl = false;
            return CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ExternalSystemTasksAndArguments.Task it = (ExternalSystemTasksAndArguments.Task)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (ExternalSystemTasksAndArguments.Task)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string2 = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<ExternalSystemTasksAndArguments.Argument> getArguments() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Options options = GradleCommandLineOptionsProvider.getSupportedOptions();
            Intrinsics.checkNotNullExpressionValue((Object)options, (String)"GradleCommandLineOptions\u2026der.getSupportedOptions()");
            Collection collection = options.getOptions();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"GradleCommandLineOptions\u2026upportedOptions().options");
            Iterable $this$filterIsInstance$iv = collection;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Option)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ExternalSystemTasksAndArguments.Argument argument2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Option it = (Option)element$iv$iv;
                boolean bl2 = false;
                String longOpt = it.getLongOpt();
                String shortOpt = it.getOpt();
                if ((longOpt != null && shortOpt != null ? new ExternalSystemTasksAndArguments.Argument("--" + longOpt, '-' + shortOpt, it.getDescription()) : (longOpt != null ? new ExternalSystemTasksAndArguments.Argument("--" + longOpt, null, it.getDescription()) : (shortOpt != null ? new ExternalSystemTasksAndArguments.Argument('-' + shortOpt, null, it.getDescription()) : null))) == null) continue;
                argument2 = argument2;
                boolean bl3 = false;
                boolean bl4 = false;
                ExternalSystemTasksAndArguments.Argument it$iv$iv = argument2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ExternalSystemTasksAndArguments.Argument it = (ExternalSystemTasksAndArguments.Argument)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (ExternalSystemTasksAndArguments.Argument)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string2 = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                }
            });
        }

        public GradleTasksAndArguments(@NotNull Project project, @NotNull ExternalSystemProjectPathField projectPathField) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectPathField, (String)"projectPathField");
            this.project = project;
            this.projectPathField = projectPathField;
        }
    }
}

