/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.application.Topics;
import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.cloudConfig.CloudConfigAppender;
import com.intellij.cloudConfig.CloudConfigBundle;
import com.intellij.cloudConfig.CloudConfigStreamProvider;
import com.intellij.cloudConfig.CloudConfigTaskExecutor;
import com.intellij.cloudConfig.CloudConfigUi;
import com.intellij.cloudConfig.ConfigInfo;
import com.intellij.cloudConfig.ConfigList;
import com.intellij.cloudConfig.ConfigState;
import com.intellij.cloudConfig.PluginState;
import com.intellij.cloudConfig.StatusBarInfoManager;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.idea.cloudConfig.ETagCloudConfigFileClient;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.StartupUiUtil;
import com.jetbrains.cloudconfig.exception.AccessDeniedException;
import com.jetbrains.cloudconfig.exception.UnauthorizedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.jvm.functions.Function2;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CloudConfigManager
implements ApplicationLoadListener {
    private static final Logger LOG = Logger.getInstance(CloudConfigManager.class);
    @NonNls
    private static final String CACHES_DIR = "caches";
    @NonNls
    private static final String OS_FILE = "os";
    @NonNls
    private static final String VERSION_FILE = "version";
    @NonNls
    private static final String STATUS_INFO_FILE = "status.info";
    @NonNls
    private static final String AUTO_UPDATE_PLUGINS_FILE = "auto_update_plugins";
    @NonNls
    private static final String LOCAL_CHANGES_FILE = "local.changes";
    @NonNls
    private static final String AUTO_CONNECT_FILE = ".auto_connect";
    @NonNls
    private static final String LOCAL_DISABLED_PLUGINS_FILENAME = "local_disabled_plugins.txt";
    @NonNls
    private static final String LAYOUT_CONFIG_FILENAME = "layout_config.txt";
    @NonNls
    private static final String LOCAL_LAYOUT_CONFIG_FILENAME = "local_layout_config.txt";
    private static final List<@NonNls String> TOP_LEVEL_SPECIAL_FILES = List.of("caches", "auto_update_plugins", "os", "version", "status.info", "disabled_plugins.txt", "installed_plugins.txt", "local_disabled_plugins.txt", "layout_config.txt", "local_layout_config.txt");
    private final NotNullLazyValue<List<Class<?>>> myAllClasses = NotNullLazyValue.atomicLazy(() -> new ArrayList(ConfigList.CLASSES));
    private final List<ConfigInfo> myAllConfigs = new ArrayList<ConfigInfo>();
    private final List<ConfigState> myAllConfigStates = new ArrayList<ConfigState>();
    private boolean myInitClasses = true;
    @NonNls
    private static final String API = "1";
    @NotNull
    private static final PluginId SELF_PLUGIN_ID = PluginId.getId((String)"com.intellij.CloudConfig");
    private static CloudConfigManager ourInstance;
    private File myIdeConfigPath;
    private File myIdeConfigOptionsDir;
    private File myConfigDir;
    private File myCachesDir;
    private File myFilesArchive;
    private File myUpdatesArchive;
    private File myApiFile;
    private File myStatusFile;
    private File myAutoUpdatePluginsFile;
    private StatusInfo myStatusInfo;
    private ETagCloudConfigFileClient myClient;
    private @NlsContexts.DialogMessage String myErrorMessage;
    private boolean myIOError;
    private boolean myIOOperation;
    private boolean myOfflineWithJBA;
    private LocalChanges myLocalChanges;
    private StatusBarInfoManager myStatusBarManager;
    private boolean myCanInitListeners = true;
    private Disposable myFrameListener;
    private Runnable myDisablePluginsListener;
    private PluginStateListener myStatePluginListener;
    private List<PluginState> myEnabledDisabledPlugins = Collections.emptyList();
    private List<PluginState> myInstalledUninstalledPlugins = Collections.emptyList();
    private boolean myUpdatePlugins;
    private boolean myUpdateApi;
    private boolean myUpdateApiNotification = true;
    private boolean myBeforeApplicationLoadedStart;
    private boolean mySavePluginsWithEditConfigs = true;
    private boolean mySaveSkipRulesFile;
    private boolean myAutoUpdatePlugins;
    private static final Function2<Class<?>, String, String> NAME_CONVERTER;
    private static Set<PluginId> myRepositoryPlugins;
    private static final int ENABLE_DISABLE = 0;
    private static final int INSTALL_UNINSTALL = 1;
    private static final int SHUTDOWN = 2;
    @NonNls
    private static final String[] OS_NAMES;

    @NotNull
    public static CloudConfigManager getInstance() {
        if (ourInstance == null) {
            ourInstance = (CloudConfigManager)ApplicationLoadListener.EP_NAME.findExtensionOrFail(CloudConfigManager.class);
        }
        CloudConfigManager cloudConfigManager = ourInstance;
        if (cloudConfigManager == null) {
            CloudConfigManager.$$$reportNull$$$0(0);
        }
        return cloudConfigManager;
    }

    @NotNull
    public StatusInfo getStatusInfo() {
        if (this.myIOOperation) {
            StatusInfo statusInfo = StatusInfo.JBA_IO_OPERATION;
            if (statusInfo == null) {
                CloudConfigManager.$$$reportNull$$$0(1);
            }
            return statusInfo;
        }
        if (this.myIOError) {
            StatusInfo statusInfo = StatusInfo.JBA_IO_ERROR;
            if (statusInfo == null) {
                CloudConfigManager.$$$reportNull$$$0(2);
            }
            return statusInfo;
        }
        if (this.myStatusInfo != StatusInfo.OFFLINE && this.myStatusInfo != StatusInfo.JBA_CONNECTED && CloudConfigManager.isExclusiveStreamProviderEnabled()) {
            this.myStatusInfo = StatusInfo.OFFLINE;
            this.updateStatusBar(false);
        }
        StatusInfo statusInfo = this.myStatusInfo;
        if (statusInfo == null) {
            CloudConfigManager.$$$reportNull$$$0(3);
        }
        return statusInfo;
    }

    public boolean isConnectedState() {
        return this.myStatusInfo == StatusInfo.JBA_CONNECTED;
    }

    @NlsContexts.DialogMessage
    @Nullable
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public boolean isAutoUpdatePlugins() {
        return this.myAutoUpdatePlugins;
    }

    public void setAutoUpdatePlugins(boolean value) {
        boolean update = this.myAutoUpdatePlugins != value;
        this.myAutoUpdatePlugins = value;
        if (update) {
            this.storeAutoUpdatePlugins();
            if (value) {
                this.executePlugins();
            }
        }
    }

    public boolean isLocalConnected() {
        return this.myFilesArchive.exists();
    }

    public boolean isOfflineWithJBA() {
        return this.myOfflineWithJBA || this.myClient != null;
    }

    @NotNull
    public List<ConfigState> getSelfSettings() {
        List<ConfigState> list = this.myAllConfigStates;
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<PluginState> getEnabledDisabledPlugins() {
        List<PluginState> list = this.myEnabledDisabledPlugins;
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<PluginState> getInstalledUninstalledPlugins() {
        List<PluginState> list = this.myInstalledUninstalledPlugins;
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    public boolean hasPluginsUpdate() {
        return this.myUpdatePlugins;
    }

    public boolean hasPluginsAnyUpdate() {
        return !this.myEnabledDisabledPlugins.isEmpty() || !this.myInstalledUninstalledPlugins.isEmpty();
    }

    public boolean hasUpdateApi() {
        return this.myUpdateApi;
    }

    public void beforeApplicationLoaded(@NotNull Application application, @NotNull Path configPath) {
        if (application == null) {
            CloudConfigManager.$$$reportNull$$$0(7);
        }
        if (configPath == null) {
            CloudConfigManager.$$$reportNull$$$0(8);
        }
        CloudConfigProvider.setProvider(null);
        if (application.isUnitTestMode()) {
            this.myStatusBarManager = StatusBarInfoManager.EMPTY;
        } else {
            this.myStatusBarManager = new StatusBarInfoManager();
            if (CloudConfigManager.isExclusiveStreamProviderEnabled()) {
                this.myStatusInfo = StatusInfo.OFFLINE;
                boolean bl = this.myOfflineWithJBA = CloudConfigClientUtil.createClient() != null;
                if (this.myOfflineWithJBA) {
                    this.updateStatusBarLater(true);
                }
                LOG.info("=== Offline: " + CloudConfigManager.isExclusiveStreamProviderEnabled() + " ===");
                return;
            }
        }
        this.myIdeConfigPath = configPath.toFile();
        this.myIdeConfigOptionsDir = configPath.resolve("options").toFile();
        this.myConfigDir = configPath.resolve("jba_config").toFile();
        this.myCachesDir = new File(this.myConfigDir, CACHES_DIR);
        this.myFilesArchive = new File(this.myCachesDir, "files.7z");
        this.myUpdatesArchive = new File(this.myCachesDir, "updates.7z");
        this.myApiFile = new File(this.myCachesDir, "api");
        this.myStatusFile = new File(this.myConfigDir, STATUS_INFO_FILE);
        this.myAutoUpdatePluginsFile = new File(this.myConfigDir, AUTO_UPDATE_PLUGINS_FILE);
        this.myLocalChanges = new LocalChanges();
        if (!this.initClient()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.afterApplicationLoaded(true, false);
        } else {
            this.setStreamProviderBeforeStart();
            final SimpleMessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().simpleConnect();
            connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                public void appFrameCreated(@NotNull List<String> commandLineArgs) {
                    if (commandLineArgs == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    connection.disconnect();
                    if (CloudConfigManager.this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
                        CloudConfigManager.this.initListeners();
                    }
                    CloudConfigManager.this.afterApplicationLoaded(false, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArgs", "com/intellij/cloudConfig/CloudConfigManager$1", "appFrameCreated"));
                }
            });
        }
    }

    private void setStreamProviderBeforeStart() {
        if (this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
            try {
                LOG.info("=== BeforeStart.StreamProvider ===");
                this.myCanInitListeners = false;
                FileUtil.copyContent((File)this.getIdeaDisabledPluginsFile(), (File)this.getLocalDisabledPluginsFile());
                this.loadStates();
                this.setStreamProvider(false, false, false);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.myCanInitListeners = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterApplicationLoaded(boolean init, boolean reload) {
        long time;
        block10: {
            time = System.currentTimeMillis();
            try {
                this.myBeforeApplicationLoadedStart = true;
                File autoConnect = new File(this.myConfigDir, AUTO_CONNECT_FILE);
                if (autoConnect.exists()) {
                    boolean remote = false;
                    try {
                        remote = "remote".equals(FileUtilRt.loadFile((File)autoConnect));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    FileUtilRt.delete((File)autoConnect);
                    if (remote) {
                        this.connectThisInstance(true, true, null);
                    } else {
                        this.connectFirstInstance(true, null);
                    }
                    break block10;
                }
                if (this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
                    this.myLocalChanges.load();
                    this.updateConnection(init, reload);
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> this.updateInitStatus());
                }
            }
            finally {
                this.myBeforeApplicationLoadedStart = false;
            }
        }
        LOG.info("=== Start: " + this.myStatusInfo + " (" + (System.currentTimeMillis() - time) + "ms) ===");
    }

    private boolean initClient() {
        try {
            this.myStatusInfo = StatusInfo.valueOf(FileUtilRt.loadFile((File)this.myStatusFile));
            if (this.myStatusInfo == StatusInfo.DISABLED) {
                LOG.info("=== Exit: " + this.myStatusInfo + " ===");
                return false;
            }
        }
        catch (IOException | IllegalArgumentException e) {
            this.myStatusInfo = StatusInfo.JBA_NOT_CONNECTED;
        }
        try {
            this.myAutoUpdatePlugins = API.equals(FileUtilRt.loadFile((File)this.myAutoUpdatePluginsFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.myClient = CloudConfigClientUtil.createClient();
        if (this.myClient == null) {
            this.myStatusInfo = StatusInfo.JBA_NOT_FOUND;
            if (this.isLocalConnected()) {
                this.updateStatusBarLater(true);
            }
            LOG.info("=== Exit: " + this.myStatusInfo + " ===");
            return false;
        }
        return true;
    }

    private void initClasses() {
        if (!this.myInitClasses) {
            return;
        }
        this.myInitClasses = false;
        List allClasses = (List)this.myAllClasses.getValue();
        for (Class aClass : allClasses) {
            this.myAllConfigs.add(new ConfigInfo(aClass.getName(), aClass, ConfigList.getConfigDescription(aClass)));
        }
        for (CloudConfigAppender provider : (CloudConfigAppender[])CloudConfigAppender.EP_NAME.getExtensions()) {
            List<Class<?>> classesToAppend = provider.appendClassesToStream();
            for (Class<?> aClass : classesToAppend) {
                @NlsSafe String description = provider.getConfigDescription(aClass);
                this.myAllConfigs.add(new ConfigInfo(aClass.getName(), aClass, description));
            }
            allClasses.addAll(classesToAppend);
        }
    }

    @NotNull
    public final List<Class<?>> getAllClasses() {
        assert (!this.myInitClasses);
        assert (!this.myAllConfigStates.isEmpty());
        List<Class<?>> list = this.myAllConfigStates.stream().filter(state -> state.type == ConfigState.Type.Enable).map(state -> state.info.configClass).collect(Collectors.toList());
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private List<Class<?>> getOSClasses() {
        List<Class<?>> classes = this.getAllClasses();
        List list = ContainerUtil.filter(ConfigList.OS_CLASSES, aClass -> classes.contains(aClass));
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private List<ConfigInfo> getConfigInfos() {
        this.initClasses();
        List<ConfigInfo> list = this.myAllConfigs;
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void createEnabledStates() {
        this.myAllConfigStates.clear();
        for (ConfigInfo info : this.getConfigInfos()) {
            ConfigState state = new ConfigState();
            state.info = info;
            state.type = ConfigState.Type.Enable;
            this.myAllConfigStates.add(state);
        }
    }

    private void loadStates() throws IOException {
        this.myAllConfigStates.clear();
        HashMap<String, ConfigState.Type> states = new HashMap<String, ConfigState.Type>();
        this.loadStates(LAYOUT_CONFIG_FILENAME, states);
        this.loadStates(LOCAL_LAYOUT_CONFIG_FILENAME, states);
        for (ConfigInfo info : this.getConfigInfos()) {
            ConfigState state = new ConfigState();
            state.info = info;
            state.type = states.getOrDefault(info.id, ConfigState.Type.Enable);
            this.myAllConfigStates.add(state);
        }
    }

    private void loadStates(@NotNull String name, Map<String, ConfigState.Type> states) throws IOException {
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(12);
        }
        CloudConfigManager.loadStates(this.loadLines(name), states);
    }

    private static void loadStates(@NotNull List<String> lines, Map<String, ConfigState.Type> states) {
        if (lines == null) {
            CloudConfigManager.$$$reportNull$$$0(13);
        }
        for (String line : lines) {
            String id = CloudConfigManager.getPluginId(line).getIdString();
            String type = CloudConfigManager.getRuleValue(line);
            states.put(id, ConfigState.Type.valueOf(type));
        }
    }

    private boolean prepareReloadStates(@NotNull File archiveFile) throws IOException {
        if (archiveFile == null) {
            CloudConfigManager.$$$reportNull$$$0(14);
        }
        LOG.info("=== ReloadStates ===");
        HashMap result = new HashMap();
        CloudConfigClientUtil.loadFiles((File)archiveFile, (List)ContainerUtil.newArrayList((Object[])new String[]{LAYOUT_CONFIG_FILENAME}), result);
        if (result.isEmpty()) {
            return false;
        }
        HashMap<String, ConfigState.Type> newStates = new HashMap<String, ConfigState.Type>();
        CloudConfigManager.loadStates(StringUtil.split((String)((String)ContainerUtil.getFirstItem(result.values())), (String)"\n"), newStates);
        HashMap<String, ConfigState> idToState = new HashMap<String, ConfigState>();
        for (ConfigState configState : this.myAllConfigStates) {
            idToState.put(configState.info.id, configState);
        }
        for (Map.Entry entry : newStates.entrySet()) {
            ConfigState oldState;
            LOG.info("=== ReloadStates.*" + entry.getValue() + "*: " + (String)entry.getKey() + " ===");
            if (entry.getValue() != ConfigState.Type.Disable || (oldState = (ConfigState)idToState.get(entry.getKey())) == null || oldState.type != ConfigState.Type.Enable) continue;
            this.copySettingsItemBack(Collections.emptyList(), "", true, false, oldState.info.configClass);
            LOG.info("=== ReloadStates.Disable: " + oldState.info.id + " ===");
        }
        return true;
    }

    public void editStates(@NotNull List<Pair<ConfigState, ConfigState.Type>> newStates) {
        if (newStates == null) {
            CloudConfigManager.$$$reportNull$$$0(15);
        }
        LOG.info("=== EditStates ===");
        try {
            ArrayList<String> files = new ArrayList<String>();
            this.editStates(newStates, files);
            CloudConfigManager.saveSettings();
            String prefix = this.myConfigDir.getAbsolutePath();
            List<Class<?>> newEnabled = newStates.stream().filter(state -> state.second == ConfigState.Type.Enable && ((ConfigState)state.first).type == ConfigState.Type.Disable).map(state -> ((ConfigState)state.first).info.configClass).collect(Collectors.toList());
            for (File file : this.copyConfigs(this.myConfigDir, newEnabled)) {
                files.add(StringUtil.substringAfter((String)file.getAbsolutePath(), (String)prefix));
            }
            for (Pair pair : newStates) {
                if (pair.second == ConfigState.Type.Enable) {
                    LOG.info("=== EditStates.Enable: " + ((ConfigState)pair.first).info.id + " ===");
                    continue;
                }
                this.copySettingsItemBack(files, prefix, ((ConfigState)pair.first).type == ConfigState.Type.Enable, pair.second == ConfigState.Type.Disable, ((ConfigState)pair.first).info.configClass);
                LOG.info("=== EditStates." + ((ConfigState.Type)((Object)pair.second)).name() + ": " + ((ConfigState)pair.first).info.id + " ===");
            }
            if (!files.isEmpty()) {
                this.editConfigFiles((String[])ContainerUtil.toArray(files, String[]::new));
            }
            this.loadStates();
            this.setStreamProvider(false, false, false);
            CloudConfigManager.reloadComponents(null, ContainerUtil.map(newStates, state -> ((ConfigState)state.first).info.configClass));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void copySettingsItemBack(@NotNull List<String> files, @NotNull String prefix, boolean copy, boolean delete, @NotNull Class<?> storageClass) throws IOException {
        String schemeDir;
        State spec;
        if (files == null) {
            CloudConfigManager.$$$reportNull$$$0(16);
        }
        if (prefix == null) {
            CloudConfigManager.$$$reportNull$$$0(17);
        }
        if (storageClass == null) {
            CloudConfigManager.$$$reportNull$$$0(18);
        }
        LOG.assertTrue((spec = StoreUtilKt.getStateSpec(storageClass)) != null);
        String inputName = StoreUtilKt.getDefaultStoragePathSpec((State)spec);
        String name = (String)NAME_CONVERTER.invoke(storageClass, (Object)inputName);
        File file = new File(this.myConfigDir, name);
        if (file.exists() && file.isFile()) {
            if (copy) {
                FileUtil.copyContent((File)file, (File)new File(this.myIdeConfigOptionsDir, inputName));
            }
            if (delete) {
                files.add(name);
                FileUtil.delete((File)file);
            }
        }
        if ((schemeDir = spec.additionalExportDirectory()).isEmpty()) {
            return;
        }
        String dirName = (String)NAME_CONVERTER.invoke(storageClass, (Object)schemeDir);
        File dir = new File(this.myConfigDir, dirName);
        if (dir.exists() && dir.isDirectory()) {
            File toDir = new File(this.myIdeConfigPath, schemeDir);
            if (copy) {
                FileUtil.delete((File)toDir);
                FileUtil.copyDir((File)dir, (File)toDir);
            }
            if (delete) {
                File[] childFiles = dir.listFiles();
                if (childFiles != null) {
                    for (File childFile : childFiles) {
                        files.add(StringUtil.substringAfter((String)childFile.getAbsolutePath(), (String)prefix));
                    }
                }
                FileUtil.delete((File)dir);
            }
        }
    }

    private void editStates(@NotNull List<Pair<ConfigState, ConfigState.Type>> newStates, @NotNull List<String> files) throws IOException {
        if (newStates == null) {
            CloudConfigManager.$$$reportNull$$$0(19);
        }
        if (files == null) {
            CloudConfigManager.$$$reportNull$$$0(20);
        }
        Map idToNewType = ContainerUtil.map2Map(newStates, state -> Pair.create((Object)((ConfigState)state.first).info.id, (Object)((Object)((ConfigState.Type)((Object)((Object)((Object)state.second)))))));
        LinkedHashMap<String, ConfigState.Type> oldStates = new LinkedHashMap<String, ConfigState.Type>();
        this.loadStates(LAYOUT_CONFIG_FILENAME, oldStates);
        ArrayList<String> globalStates = new ArrayList<String>();
        ArrayList<String> localStates = new ArrayList<String>();
        for (ConfigState configState : this.myAllConfigStates) {
            String id = configState.info.id;
            oldStates.remove(id);
            ConfigState.Type type = idToNewType.getOrDefault(id, configState.type);
            if (type == ConfigState.Type.Disable) {
                globalStates.add(id + ":" + type.name());
                continue;
            }
            if (type != ConfigState.Type.DisableLocally) continue;
            localStates.add(id + ":" + type.name());
        }
        for (Map.Entry entry : oldStates.entrySet()) {
            globalStates.add((String)entry.getKey() + ":" + ((ConfigState.Type)((Object)entry.getValue())).name());
        }
        this.saveStates(localStates, LOCAL_LAYOUT_CONFIG_FILENAME);
        if (this.saveStates(globalStates, LAYOUT_CONFIG_FILENAME)) {
            files.add(LAYOUT_CONFIG_FILENAME);
        }
    }

    private boolean saveStates(@NotNull List<String> states, @NotNull String filename) throws IOException {
        boolean result;
        if (states == null) {
            CloudConfigManager.$$$reportNull$$$0(21);
        }
        if (filename == null) {
            CloudConfigManager.$$$reportNull$$$0(22);
        }
        File file = new File(this.myConfigDir, filename);
        if (states.isEmpty()) {
            result = file.exists();
            FileUtil.delete((File)file);
        } else {
            boolean bl = result = !file.exists();
            if (result) {
                this.savePluginsToFile(states, filename);
            } else {
                String newContent = StringUtil.join(states, (String)"\n");
                if (!newContent.equals(FileUtilRt.loadFile((File)file))) {
                    FileUtil.writeToFile((File)file, (String)newContent);
                    result = true;
                }
            }
        }
        return result;
    }

    public void updateClient() {
        ETagCloudConfigFileClient newClient = CloudConfigClientUtil.createClient();
        if (newClient == null) {
            return;
        }
        if (this.myClient == null) {
            if (this.initClient()) {
                this.afterApplicationLoaded(true, true);
            }
        } else {
            this.myClient = newClient;
            this.updateIO(null);
        }
    }

    public void recalculateInitStatus(@Nullable Project project) {
        LOG.info("=== Start.recalculateInitStatus ===");
        if (this.myStatusInfo == StatusInfo.DISABLED && this.myClient == null) {
            this.myStatusInfo = null;
            FileUtil.delete((File)this.myStatusFile);
            this.myClient = CloudConfigClientUtil.createClient();
            LOG.assertTrue(this.myClient != null);
        }
        this.myIOOperation = true;
        this.updateStatusBar(true);
        CloudConfigManager.getTaskExecutor().runProcessWithProgressSynchronously(() -> {
            try {
                this.calculateInitStatus();
            }
            catch (Throwable e) {
                CloudConfigManager.logInfo(e);
            }
        }, CloudConfigBundle.message("io.operation.message", new Object[0]), false, project);
        this.myIOOperation = false;
        this.updateStatusBar(false);
        LOG.info("=== End.recalculateInitStatus ===");
    }

    private void calculateInitStatus() throws IOException {
        LOG.info("=== calculateInitStatus ===");
        try {
            this.myStatusInfo = this.listFiles("").contains("files.7z") ? StatusInfo.JBA_THIS_NOT_CONNECTED : StatusInfo.JBA_NOT_CONNECTED;
            File file403 = new File(this.myConfigDir, "403");
            if (file403.exists()) {
                FileUtil.delete((File)file403);
                ApplicationManager.getApplication().invokeLater(() -> StatusBarInfoManager.showStartNotification());
            }
        }
        catch (AccessDeniedException e) {
            this.myStatusInfo = StatusInfo.JBA_NOT_ACCEPTED;
            FileUtil.createIfDoesntExist((File)new File(this.myConfigDir, "403"));
            this.resetIO();
        }
        catch (FileNotFoundException e) {
            this.myStatusInfo = StatusInfo.JBA_NOT_CONNECTED;
            this.resetIO();
        }
        finally {
            LOG.info("=== calculateInitStatus.value: " + this.myStatusInfo + " ===");
        }
    }

    private void updateInitStatus() {
        LOG.info("=== Start.updateInitStatus ===");
        this.myIOOperation = true;
        this.updateStatusBar(true);
        CloudConfigManager.getTaskExecutor().executeOnPooledThread(() -> {
            try {
                this.calculateInitStatus();
            }
            catch (Throwable e) {
                CloudConfigManager.logInfo(e);
            }
            CloudConfigManager.getTaskExecutor().invokeLater(() -> {
                this.myIOOperation = false;
                this.updateStatusBar(false);
                LOG.info("=== End.updateInitStatus ===");
            });
        });
    }

    private void resetIO() {
        this.myIOError = false;
        this.myErrorMessage = null;
    }

    public void updateIO(@Nullable Runnable failedRun) {
        LOG.info("=== Start.updateIO ===");
        this.myIOOperation = true;
        this.updateStatusBar(true);
        CloudConfigManager.getTaskExecutor().executeOnPooledThread(() -> {
            try {
                LOG.info("=== updateIO ===");
                try {
                    this.listFiles("io");
                }
                catch (FileNotFoundException e) {
                    this.resetIO();
                }
                if (this.myStatusInfo == null) {
                    this.calculateInitStatus();
                } else if (this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
                    this.myIOError = true;
                    this.doConnection();
                    return;
                }
            }
            catch (Throwable e) {
                CloudConfigManager.logInfo(e);
            }
            CloudConfigManager.getTaskExecutor().invokeLater(() -> {
                this.myIOOperation = false;
                this.updateStatusBar(false);
                if (this.myIOError && failedRun != null) {
                    failedRun.run();
                }
                LOG.info("=== End.updateIO ===");
            });
        });
    }

    public void disable() {
        this.myLocalChanges.clean();
        this.myStatusInfo = StatusInfo.DISABLED;
        this.myIOError = false;
        this.myIOOperation = false;
        if (this.myClient != null) {
            this.myClient.clearTags();
            this.myClient = null;
        }
        this.storeState();
        this.updateStatusBar(false);
    }

    @TestOnly
    public void testDisconnect(boolean removeData) {
        this.removeListeners();
        this.doDisconnect(removeData, false, false);
        this.updateStatusBar(false);
    }

    @TestOnly
    public void testDisconnect(boolean removeData, boolean copySettingsBack) {
        this.removeListeners();
        this.doDisconnect(removeData, false, copySettingsBack);
        this.updateStatusBar(false);
    }

    public void disconnect(boolean removeData, boolean copySettingsBack) {
        LOG.info("=== Start.disconnect(" + removeData + ", " + copySettingsBack + ") ===");
        this.removeListeners();
        if (!removeData) {
            this.doDisconnect(false, true, copySettingsBack);
            this.updateStatusBar(false);
            LOG.info("=== End.disconnect ===");
            return;
        }
        this.myIOOperation = true;
        this.updateStatusBar(false);
        CloudConfigManager.getTaskExecutor().executeOnPooledThread(() -> {
            boolean[] success = new boolean[]{false};
            try {
                LOG.info("=== disconnect.delete_files ===");
                File delFile = new File(this.myConfigDir, ".del");
                FileUtil.createIfDoesntExist((File)delFile);
                this.writeFile(delFile);
                this.deleteFile("files.7z");
                this.deleteFile("updates.7z");
                this.deleteFile("api");
                success[0] = true;
            }
            catch (Throwable e) {
                CloudConfigManager.logInfo(e);
            }
            CloudConfigManager.getTaskExecutor().invokeLater(() -> {
                if (success[0]) {
                    this.doDisconnect(true, true, copySettingsBack);
                }
                this.myIOOperation = false;
                this.updateStatusBar(false);
                LOG.info("=== End.disconnect ===");
            });
        });
    }

    private void doDisconnect(boolean removeData, boolean reload, boolean copySettingsBack) {
        try {
            LOG.info("=== doDisconnect ===");
            if (copySettingsBack) {
                this.copySettingsBack();
            }
            this.myInstalledUninstalledPlugins = Collections.emptyList();
            this.myEnabledDisabledPlugins = this.myInstalledUninstalledPlugins;
            this.myUpdatePlugins = false;
            this.myUpdateApi = false;
            this.myUpdateApiNotification = true;
            this.myLocalChanges.clean();
            this.myStatusInfo = removeData ? StatusInfo.JBA_NOT_CONNECTED : StatusInfo.JBA_THIS_NOT_CONNECTED;
            this.myClient.clearTags();
            FileUtil.delete((File)this.myConfigDir);
            this.setStreamProvider(true, reload, false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void copySettingsBack() throws IOException {
        LOG.info("=== copySettingsBack ===");
        File[] files = this.myConfigDir.listFiles();
        assert (files != null);
        String osPrefix = CloudConfigClientUtil.getOS() + ".";
        String ideConfig = this.myIdeConfigPath.getName();
        for (File file : files) {
            String name = file.getName();
            if (TOP_LEVEL_SPECIAL_FILES.contains(name) || !CloudConfigManager.filterOsName(name)) continue;
            boolean isPerOsSetting = name.startsWith(osPrefix);
            if (isPerOsSetting) {
                name = StringUtil.trimStart((String)name, (String)osPrefix);
            }
            if (file.isDirectory()) {
                File toDir = new File(this.myIdeConfigPath, name);
                FileUtil.delete((File)toDir);
                FileUtil.copyDir((File)file, (File)toDir);
                LOG.info("=== copyDir: jba_config/" + file.getName() + " -> " + ideConfig + "/" + name + " ===");
                continue;
            }
            File parentDir = isPerOsSetting ? new File(this.myIdeConfigOptionsDir, CloudConfigClientUtil.getOS()) : this.myIdeConfigOptionsDir;
            FileUtil.copy((File)file, (File)new File(parentDir, name));
            LOG.info("=== copyFile: jba_config/" + file.getName() + " -> " + ideConfig + "/options/" + name + " ===");
        }
    }

    @NotNull
    private ConnectionState getConnectionState() {
        block12: {
            block11: {
                Boolean newVersion;
                block10: {
                    ConnectionState connectionState;
                    try {
                        LOG.info("=== getConnectionState ===");
                        this.getFile("api");
                        newVersion = this.getFile("files.7z");
                        if (newVersion != null) break block10;
                        connectionState = ConnectionState.DELETE;
                    }
                    catch (Throwable e) {
                        CloudConfigManager.logInfo(e);
                        ConnectionState connectionState2 = ConnectionState.IO_ERROR;
                        if (connectionState2 == null) {
                            CloudConfigManager.$$$reportNull$$$0(27);
                        }
                        return connectionState2;
                    }
                    if (connectionState == null) {
                        CloudConfigManager.$$$reportNull$$$0(23);
                    }
                    return connectionState;
                }
                if (!newVersion.booleanValue()) break block11;
                ConnectionState connectionState = ConnectionState.NEW;
                if (connectionState == null) {
                    CloudConfigManager.$$$reportNull$$$0(24);
                }
                return connectionState;
            }
            if (this.getFile("updates.7z") != Boolean.TRUE) break block12;
            ConnectionState connectionState = ConnectionState.UPDATE;
            if (connectionState == null) {
                CloudConfigManager.$$$reportNull$$$0(25);
            }
            return connectionState;
        }
        ConnectionState connectionState = ConnectionState.OLD;
        if (connectionState == null) {
            CloudConfigManager.$$$reportNull$$$0(26);
        }
        return connectionState;
    }

    private void updateConnection(boolean init, boolean reload) {
        try {
            LOG.info("=== Start.updateConnection ===");
            if (init) {
                FileUtil.copyContent((File)this.getIdeaDisabledPluginsFile(), (File)this.getLocalDisabledPluginsFile());
                this.loadStates();
                this.setStreamProvider(false, reload, false);
            }
            this.myIOOperation = true;
            this.updateStatusBar(init);
            Runnable connection = () -> CloudConfigManager.getTaskExecutor().executeOnPooledThread(() -> this.doConnection());
            if (init && !ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(connection);
            } else {
                connection.run();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void doConnection() {
        LOG.info("=== doConnect ===");
        ConnectionState state = this.getConnectionState();
        if (state != ConnectionState.DELETE && state != ConnectionState.IO_ERROR) {
            this.checkApi();
        }
        if (state == ConnectionState.NEW) {
            this.connectThisInstanceOperation(true, true, null);
            return;
        }
        CloudConfigManager.getTaskExecutor().invokeLater(() -> {
            if (state == ConnectionState.OLD) {
                this.safeUpdatePlugins();
                if (this.handleUpdates()) {
                    return;
                }
            } else if (state == ConnectionState.UPDATE) {
                try {
                    this.updateFiles();
                    if (this.handleUpdates()) {
                        return;
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            } else if (state == ConnectionState.DELETE) {
                this.removeListeners();
                this.doDisconnect(false, true, false);
                this.myStatusInfo = StatusInfo.JBA_NOT_CONNECTED;
            }
            this.myIOOperation = false;
            this.updateStatusBar(false);
            LOG.info("=== End.connect ===");
        });
    }

    private void checkApi() {
        int api;
        try {
            api = Integer.parseInt(FileUtil.loadFile((File)this.myApiFile));
        }
        catch (IOException ignore) {
            return;
        }
        boolean bl = this.myUpdateApi = api < Integer.parseInt(API);
        if (this.myUpdateApi && this.myUpdateApiNotification) {
            this.myUpdateApiNotification = false;
            ApplicationManager.getApplication().invokeLater(() -> CloudConfigUi.showUpdateApiNotification());
        }
    }

    public void doUpdateApi() {
        if (this.myStatusInfo != StatusInfo.JBA_CONNECTED || !this.myUpdateApi) {
            return;
        }
        LOG.info("=== Start.doUpdateApi ===");
        File temp = new File(this.myCachesDir, "temp_" + System.currentTimeMillis());
        try {
            FileUtil.delete((File)temp);
            FileUtil.createDirectory((File)temp);
            int prefix = temp.getAbsolutePath().length();
            for (File file : this.copyConfigs(temp, this.getAllClasses())) {
                File indexFile = new File(this.myConfigDir, file.getAbsolutePath().substring(prefix));
                if (indexFile.exists()) continue;
                FileUtil.copyContent((File)file, (File)indexFile);
            }
            FileUtil.delete((File)temp);
            LinkedHashSet<File> index = new LinkedHashSet<File>();
            for (File file : Objects.requireNonNull(this.myConfigDir.listFiles())) {
                String name = file.getName();
                if (file.isDirectory()) {
                    if (CACHES_DIR.equals(name)) continue;
                    ContainerUtil.addAll(index, (Object[])Objects.requireNonNull(file.listFiles((File child) -> child.isFile())));
                    continue;
                }
                if (ArrayUtil.contains((String)name, (String[])new String[]{STATUS_INFO_FILE, AUTO_UPDATE_PLUGINS_FILE, LOCAL_DISABLED_PLUGINS_FILENAME, LOCAL_CHANGES_FILE, AUTO_CONNECT_FILE})) continue;
                index.add(file);
            }
            this.myIOOperation = true;
            this.updateStatusBar(false);
            CloudConfigManager.getTaskExecutor().executeOnPooledThread(() -> {
                boolean[] success = new boolean[]{false};
                try {
                    LOG.info("=== doUpdateApi.write ===");
                    this.pushToServer(index, true);
                    FileUtil.delete((File)this.myUpdatesArchive);
                    success[0] = true;
                }
                catch (Throwable e) {
                    CloudConfigManager.logInfo(e);
                }
                CloudConfigManager.getTaskExecutor().invokeLater(() -> {
                    if (success[0]) {
                        CloudConfigManager.reloadComponents(null, this.getAllClasses());
                        this.myUpdateApi = false;
                        this.myUpdateApiNotification = true;
                    }
                    this.myIOOperation = false;
                    this.updateStatusBar(false);
                    LOG.info("=== End.doUpdateApi ===");
                });
            });
        }
        catch (Throwable e) {
            FileUtil.delete((File)temp);
            LOG.error(e);
        }
    }

    public void connectFirstInstance(boolean cleanup, @Nullable Runnable successRun) {
        try {
            LOG.info("=== Start.connectFirstInstance ===");
            FileUtil.delete((File)this.myConfigDir);
            FileUtil.createDirectory((File)this.myConfigDir);
            CloudConfigManager.saveSettings();
            this.myLocalChanges.clean();
            this.myClient.clearTags();
            this.createEnabledStates();
            Set<File> index = this.copyConfigs(this.myConfigDir, this.getAllClasses());
            this.addPlugins(index);
            this.addToFile(index, OS_FILE, CloudConfigClientUtil.getOS());
            this.addToFile(index, VERSION_FILE, "0");
            this.myIOOperation = true;
            this.updateStatusBar(true);
            CloudConfigManager.getTaskExecutor().executeOnPooledThread(() -> {
                boolean[] success = new boolean[]{false};
                try {
                    LOG.info("=== connectFirstInstance.pushToServer ===");
                    this.pushToServer(index, cleanup);
                    success[0] = true;
                }
                catch (Throwable e) {
                    CloudConfigManager.logInfo(e);
                }
                CloudConfigManager.getTaskExecutor().invokeLater(() -> {
                    if (success[0]) {
                        try {
                            this.setConnected();
                            this.setStreamProvider(false, false, true);
                        }
                        catch (IOException e) {
                            success[0] = false;
                            LOG.error((Throwable)e);
                        }
                    }
                    this.myIOOperation = false;
                    this.updateStatusBar(false);
                    this.finishConnectOperation(success[0], successRun);
                    LOG.info("=== End.connectFirstInstance ===");
                });
            });
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void addToFile(@NotNull Set<File> index, @NotNull String name, @NotNull String content) throws IOException {
        if (index == null) {
            CloudConfigManager.$$$reportNull$$$0(28);
        }
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(29);
        }
        if (content == null) {
            CloudConfigManager.$$$reportNull$$$0(30);
        }
        File file = new File(this.myConfigDir, name);
        FileUtil.writeToFile((File)file, (String)content);
        index.add(file);
    }

    private void initListeners() {
        if (!this.myCanInitListeners) {
            return;
        }
        if (this.myFrameListener == null) {
            this.myFrameListener = Disposer.newDisposable();
            Topics.subscribe((Topic)FrameStateListener.TOPIC, (Disposable)this.myFrameListener, (Object)new FrameStateListener(){
                long time;

                public void onFrameDeactivated() {
                    this.time = System.currentTimeMillis();
                }

                public void onFrameActivated() {
                    if (CloudConfigManager.this.myIOOperation || !CloudConfigManager.this.myStatusInfo.in(StatusInfo.JBA_NOT_CONNECTED, StatusInfo.JBA_CONNECTED)) {
                        return;
                    }
                    long timeOfInactivity = System.currentTimeMillis() - this.time;
                    if (timeOfInactivity < (long)Registry.intValue((String)"cloud.config.sync.delay.sec") * 1000L) {
                        return;
                    }
                    if (CloudConfigManager.this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
                        CloudConfigManager.this.updateConnection(false, false);
                    } else {
                        CloudConfigManager.this.updateInitStatus();
                    }
                }
            });
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this.myFrameListener);
        }
        if (this.myDisablePluginsListener == null) {
            this.myDisablePluginsListener = () -> this.handleDisablePlugins();
            DisabledPluginsState.addDisablePluginListener((Runnable)this.myDisablePluginsListener);
        }
        if (this.myStatePluginListener == null) {
            this.myStatePluginListener = new PluginStateListener(){

                public void install(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    CloudConfigManager.this.installPlugin(descriptor);
                }

                public void uninstall(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    CloudConfigManager.this.uninstallPlugin(descriptor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "descriptor";
                    objectArray2[1] = "com/intellij/cloudConfig/CloudConfigManager$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "install";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "uninstall";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            PluginStateManager.addStateListener((PluginStateListener)this.myStatePluginListener);
        }
    }

    private void handleDisablePlugins() {
        try {
            boolean result;
            LOG.info("=== Start.DisablePluginHandler ===");
            File localFile = this.getLocalDisabledPluginsFile();
            Set<PluginId> oldPlugins = CloudConfigManager.loadPlugins(localFile);
            File sourceFile = this.getIdeaDisabledPluginsFile();
            Set<PluginId> newPlugins = CloudConfigManager.loadPlugins(sourceFile);
            Iterator<PluginId> iterator = newPlugins.iterator();
            while (iterator.hasNext()) {
                if (!oldPlugins.remove(iterator.next())) continue;
                iterator.remove();
            }
            newPlugins.remove(SELF_PLUGIN_ID);
            if (oldPlugins.isEmpty() && newPlugins.isEmpty()) {
                return;
            }
            FileUtil.copyContent((File)sourceFile, (File)localFile);
            Set<PluginId> plugins = this.loadPlugins("disabled_plugins.txt");
            boolean update = false;
            for (PluginId deletedPluginId : oldPlugins) {
                result = this.removePlugin(plugins, deletedPluginId);
                update |= result;
                LOG.info("=== DisablePluginHandler.Remove: " + deletedPluginId + " (" + result + ") ===");
            }
            for (PluginId newPluginId : newPlugins) {
                result = this.addPlugin(plugins, newPluginId);
                update |= result;
                LOG.info("=== DisablePluginHandler.Add: " + newPluginId + " (" + result + ") ===");
            }
            if (update) {
                this.savePlugins(plugins, "disabled_plugins.txt");
            }
            LOG.info("=== End.DisablePluginHandler ===");
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void installPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            CloudConfigManager.$$$reportNull$$$0(31);
        }
        LOG.info("=== InstallPlugin: " + descriptor + " ===");
        if (descriptor.isBundled()) {
            return;
        }
        if (ContainerUtil.find(CloudConfigManager.getRepositoryPlugins(), arg_0 -> ((PluginId)descriptor.getPluginId()).equals(arg_0)) == null) {
            return;
        }
        this.addPlugin(descriptor, "installed_plugins.txt");
    }

    private void addPlugin(@NotNull IdeaPluginDescriptor descriptor, @NotNull String name) {
        if (descriptor == null) {
            CloudConfigManager.$$$reportNull$$$0(32);
        }
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(33);
        }
        try {
            Set<PluginId> plugins = this.loadPlugins(name);
            if (this.addPlugin(plugins, descriptor.getPluginId())) {
                LOG.info("=== " + name + ".Add: " + descriptor + " ===");
                this.savePlugins(plugins, name);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void uninstallPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            CloudConfigManager.$$$reportNull$$$0(34);
        }
        if (!SELF_PLUGIN_ID.equals((Object)descriptor.getPluginId())) {
            this.removePlugin(descriptor, "installed_plugins.txt");
        }
    }

    private void removePlugin(@NotNull IdeaPluginDescriptor descriptor, @NotNull String name) {
        if (descriptor == null) {
            CloudConfigManager.$$$reportNull$$$0(35);
        }
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(36);
        }
        try {
            LOG.info("=== " + name + ": " + descriptor + " ===");
            Set<PluginId> plugins = this.loadPlugins(name);
            if (this.removePlugin(plugins, descriptor.getPluginId())) {
                LOG.info("=== " + name + ".Remove: " + descriptor + " ===");
                this.savePlugins(plugins, name);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private List<String> loadLines(@NotNull String name) throws IOException {
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(37);
        }
        return CloudConfigManager.loadLines(new File(this.myConfigDir, name));
    }

    @NotNull
    private Set<PluginId> loadPlugins(@NotNull String name) throws IOException {
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(38);
        }
        return CloudConfigManager.loadPlugins(new File(this.myConfigDir, name));
    }

    @NotNull
    private static List<String> loadLines(@NotNull File file) throws IOException {
        List list;
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(39);
        }
        try {
            list = FileUtil.loadLines((File)file);
        }
        catch (FileNotFoundException e) {
            return new ArrayList<String>();
        }
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(40);
        }
        return list;
    }

    @NotNull
    private static Set<PluginId> loadPlugins(@NotNull File file) throws IOException {
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(41);
        }
        return new LinkedHashSet<PluginId>(ContainerUtil.map2LinkedSet(CloudConfigManager.loadLines(file), PluginId::getId));
    }

    private void savePlugins(@NotNull Collection<PluginId> plugins, @NotNull String name) throws IOException {
        if (plugins == null) {
            CloudConfigManager.$$$reportNull$$$0(42);
        }
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(43);
        }
        this.savePluginsToFile(ContainerUtil.map(plugins, PluginId::getIdString), name);
        if (this.mySavePluginsWithEditConfigs) {
            if (this.mySaveSkipRulesFile) {
                this.mySaveSkipRulesFile = false;
                this.editConfigFiles(name, "plugin_rules.txt");
            } else {
                this.editConfigFiles(name);
            }
        }
    }

    private void savePluginsToFile(@NotNull List<String> plugins, @NotNull String name) throws IOException {
        if (plugins == null) {
            CloudConfigManager.$$$reportNull$$$0(44);
        }
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(45);
        }
        FileUtil.writeToFile((File)new File(this.myConfigDir, name), (String)StringUtil.join(plugins, (String)"\n"));
    }

    private boolean addPlugin(@NotNull Collection<PluginId> plugins, @NotNull PluginId pluginId) throws IOException {
        if (plugins == null) {
            CloudConfigManager.$$$reportNull$$$0(46);
        }
        if (pluginId == null) {
            CloudConfigManager.$$$reportNull$$$0(47);
        }
        if (!plugins.contains(pluginId)) {
            plugins.add(pluginId);
            this.removeRules(pluginId);
            return true;
        }
        return false;
    }

    private boolean removePlugin(@NotNull Collection<PluginId> plugins, @NotNull PluginId pluginId) throws IOException {
        if (plugins == null) {
            CloudConfigManager.$$$reportNull$$$0(48);
        }
        if (pluginId == null) {
            CloudConfigManager.$$$reportNull$$$0(49);
        }
        if (plugins.contains(pluginId)) {
            plugins.remove(pluginId);
            this.removeRules(pluginId);
            return true;
        }
        return false;
    }

    private void removeListeners() {
        if (this.myFrameListener != null) {
            Disposer.dispose((Disposable)this.myFrameListener);
            this.myFrameListener = null;
        }
        if (this.myDisablePluginsListener != null) {
            DisabledPluginsState.removeDisablePluginListener((Runnable)this.myDisablePluginsListener);
            this.myDisablePluginsListener = null;
        }
        if (this.myStatePluginListener != null) {
            PluginStateManager.removeStateListener((PluginStateListener)this.myStatePluginListener);
            this.myStatePluginListener = null;
        }
    }

    public void connectThisInstance(boolean reload, boolean saveCaches, @Nullable Runnable successRun) {
        this.myIOOperation = true;
        this.updateStatusBar(true);
        CloudConfigManager.getTaskExecutor().executeOnPooledThread(() -> {
            try {
                this.getFile("api");
                this.checkApi();
            }
            catch (IOException | RuntimeException e) {
                this.resetIO();
            }
            this.connectThisInstanceOperation(reload, saveCaches, successRun);
        });
    }

    private void connectThisInstanceOperation(boolean reload, boolean saveCaches, @Nullable Runnable successRun) {
        LOG.info("=== connectThisInstanceOperation ===");
        boolean[] success = new boolean[]{false};
        try {
            CloudConfigManager.getTaskExecutor().invokeAndWait(() -> {
                if (saveCaches) {
                    File[] files = this.myConfigDir.listFiles();
                    LOG.assertTrue(files != null);
                    for (File file : files) {
                        if (CACHES_DIR.equals(file.getName())) continue;
                        FileUtil.delete((File)file);
                    }
                } else {
                    this.myClient.clearTags();
                    FileUtil.delete((File)this.myConfigDir);
                    FileUtil.createDirectory((File)this.myConfigDir);
                }
                this.myLocalChanges.clean();
            });
            LOG.assertTrue(this.getFile("files.7z") != null);
            CloudConfigManager.extractArchive(this.myFilesArchive, this.myConfigDir, false);
            if (this.getFile("updates.7z") != null) {
                CloudConfigManager.extractArchive(this.myUpdatesArchive, this.myConfigDir, true);
            }
            boolean[] write = new boolean[]{false};
            CloudConfigManager.getTaskExecutor().invokeAndWait(() -> {
                try {
                    List<String> osNames = this.loadLines(OS_FILE);
                    String os = CloudConfigClientUtil.getOS();
                    CloudConfigManager.saveSettings();
                    this.loadStates();
                    LinkedHashSet<File> index = new LinkedHashSet<File>();
                    if (!osNames.contains(os)) {
                        index.addAll(this.copyConfigs(this.myConfigDir, this.getOSClasses()));
                        if (!index.isEmpty()) {
                            osNames.add(os);
                            this.addToFile(index, OS_FILE, StringUtil.join(osNames, (String)"\n"));
                        }
                    }
                    FileUtil.copyContent((File)this.getIdeaDisabledPluginsFile(), (File)this.getLocalDisabledPluginsFile());
                    if (!index.isEmpty()) {
                        this.addVersion(index);
                        this.createUpdates(index, this.myConfigDir.getAbsolutePath());
                        write[0] = true;
                    }
                    success[0] = true;
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            });
            if (write[0]) {
                this.writeUpdates();
            }
        }
        catch (Throwable e) {
            success[0] = false;
            if (this.myIOError) {
                CloudConfigManager.logInfo(e);
            }
            LOG.error(e);
        }
        CloudConfigManager.getTaskExecutor().invokeLater(() -> {
            if (success[0]) {
                try {
                    this.setConnected();
                    this.setStreamProvider(false, reload, true);
                }
                catch (IOException e) {
                    success[0] = false;
                    LOG.error((Throwable)e);
                }
            }
            if (!success[0] || !this.handleUpdates()) {
                this.myIOOperation = false;
                this.updateStatusBar(false);
            }
            this.finishConnectOperation(success[0], successRun);
            LOG.info("=== End.connectThisInstanceOperation ===");
        });
    }

    private static void saveSettings() {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) {
            application.saveSettings();
        }
    }

    private void finishConnectOperation(boolean success, @Nullable Runnable successRun) {
        if (successRun == null) {
            return;
        }
        if (success) {
            successRun.run();
        } else if (this.myIOError) {
            CloudConfigUi.showErrorMessage(this.myErrorMessage);
        }
    }

    private boolean handleUpdates() {
        try {
            File toWrite;
            Set<File> index = this.myLocalChanges.getFiles();
            if (!index.isEmpty()) {
                LOG.info("=== End.Update: " + index + " ===");
                toWrite = this.copyUpdates(index);
                this.myLocalChanges.clean();
            } else {
                toWrite = null;
            }
            CloudConfigManager.getTaskExecutor().executeOnPooledThread(() -> {
                try {
                    File file = this.myUpdatesArchive;
                    synchronized (file) {
                        File newUpdates = new File(this.myConfigDir, "new.updates");
                        if (toWrite == null) {
                            if (!newUpdates.exists()) {
                                this.finishHandleUpdates();
                                return;
                            }
                        } else {
                            FileUtil.delete((File)newUpdates);
                            this.createUpdates(toWrite);
                            FileUtil.createIfDoesntExist((File)newUpdates);
                        }
                        this.writeUpdates();
                        FileUtil.delete((File)newUpdates);
                    }
                }
                catch (Throwable e) {
                    CloudConfigManager.logInfo(e);
                }
                this.finishHandleUpdates();
            });
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private void finishHandleUpdates() {
        CloudConfigManager.getTaskExecutor().invokeLater(() -> {
            this.myIOOperation = false;
            this.updateStatusBar(false);
            if (!this.myLocalChanges.myFiles.isEmpty()) {
                this.handleUpdates();
            }
        });
    }

    @NotNull
    private File copyUpdates(@NotNull Set<File> index) throws IOException {
        if (index == null) {
            CloudConfigManager.$$$reportNull$$$0(50);
        }
        this.addVersion(index);
        String configPrefix = this.myConfigDir.getAbsolutePath();
        int configPrefixLength = configPrefix.length();
        File toWrite = new File(this.myCachesDir, "toWrite_" + System.currentTimeMillis());
        for (File file : index) {
            String path = file.getAbsolutePath();
            assert (path.startsWith(configPrefix));
            File toFile = new File(toWrite, path.substring(configPrefixLength));
            FileUtil.createParentDirs((File)toFile);
            if (file.exists()) {
                FileUtil.copy((File)file, (File)toFile);
                continue;
            }
            FileUtil.createIfDoesntExist((File)toFile);
        }
        File file = toWrite;
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(51);
        }
        return file;
    }

    private void createUpdates(@NotNull File toWrite) throws IOException {
        if (toWrite == null) {
            CloudConfigManager.$$$reportNull$$$0(52);
        }
        try {
            HashSet<File> index = new HashSet<File>();
            CloudConfigManager.createIndex(toWrite, index);
            this.createUpdates(index, toWrite.getAbsolutePath());
        }
        catch (IOException e) {
            LOG.error("=== Error create updates.7z ===");
            FileUtil.delete((File)this.myUpdatesArchive);
            throw e;
        }
        finally {
            FileUtil.delete((File)toWrite);
        }
    }

    private static void createIndex(@NotNull File parent, @NotNull Set<File> index) {
        File[] files;
        if (parent == null) {
            CloudConfigManager.$$$reportNull$$$0(53);
        }
        if (index == null) {
            CloudConfigManager.$$$reportNull$$$0(54);
        }
        if ((files = parent.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    CloudConfigManager.createIndex(file, index);
                    continue;
                }
                index.add(file);
            }
        }
    }

    private void createUpdates(@NotNull Set<File> index, @NotNull String configPrefix) throws IOException {
        if (index == null) {
            CloudConfigManager.$$$reportNull$$$0(55);
        }
        if (configPrefix == null) {
            CloudConfigManager.$$$reportNull$$$0(56);
        }
        if (this.myUpdatesArchive.exists()) {
            File temp = new File(this.myCachesDir, "temp_" + System.currentTimeMillis());
            FileUtil.delete((File)temp);
            CloudConfigManager.extractArchive(this.myUpdatesArchive, temp, false);
            int configPrefixLength = configPrefix.length();
            Set newUpdate = ContainerUtil.map2Set(index, file -> {
                String path = file.getAbsolutePath();
                assert (path.startsWith(configPrefix));
                return path.substring(configPrefixLength);
            });
            LinkedHashSet<File> oldUpdate = new LinkedHashSet<File>();
            String oldUpdatePrefix = temp.getAbsolutePath();
            CloudConfigManager.collectFiles(temp, oldUpdatePrefix, oldUpdate, newUpdate);
            try (SevenZOutputFile archive = new SevenZOutputFile(this.myUpdatesArchive);){
                CloudConfigManager.addToArchive(archive, oldUpdate, oldUpdatePrefix);
                CloudConfigManager.addToArchive(archive, index, configPrefix);
            }
            FileUtil.delete((File)temp);
        } else {
            CloudConfigManager.createArchive(index, this.myUpdatesArchive, configPrefix);
        }
    }

    private void addVersion(@NotNull Set<File> index) throws IOException {
        if (index == null) {
            CloudConfigManager.$$$reportNull$$$0(57);
        }
        this.addToFile(index, VERSION_FILE, CloudConfigManager.plusOne(FileUtil.loadFile((File)new File(this.myConfigDir, VERSION_FILE))));
    }

    private void writeUpdates() throws IOException {
        if (this.myUpdatesArchive.exists() && this.myUpdatesArchive.length() > 0L) {
            this.writeFile(this.myUpdatesArchive);
        }
    }

    private static void collectFiles(@NotNull File dir, @NotNull String prefix, @NotNull Set<File> result, @NotNull Set<String> excludes) {
        File[] files;
        if (dir == null) {
            CloudConfigManager.$$$reportNull$$$0(58);
        }
        if (prefix == null) {
            CloudConfigManager.$$$reportNull$$$0(59);
        }
        if (result == null) {
            CloudConfigManager.$$$reportNull$$$0(60);
        }
        if (excludes == null) {
            CloudConfigManager.$$$reportNull$$$0(61);
        }
        if ((files = dir.listFiles()) == null) {
            return;
        }
        int prefixLength = prefix.length();
        for (File file : files) {
            if (file.isDirectory()) {
                CloudConfigManager.collectFiles(file, prefix, result, excludes);
                continue;
            }
            String path = file.getAbsolutePath();
            assert (path.startsWith(prefix));
            String name = path.substring(prefixLength);
            if (excludes.contains(name)) continue;
            result.add(file);
        }
    }

    @NotNull
    private Set<File> copyConfigs(@NotNull File configDir, @NotNull List<Class<?>> storageClasses) throws IOException {
        if (configDir == null) {
            CloudConfigManager.$$$reportNull$$$0(62);
        }
        if (storageClasses == null) {
            CloudConfigManager.$$$reportNull$$$0(63);
        }
        LinkedHashSet<File> index = new LinkedHashSet<File>();
        for (Class<?> storageClass : storageClasses) {
            File dir;
            String schemeDir;
            State spec = StoreUtilKt.getStateSpec(storageClass);
            LOG.assertTrue(spec != null);
            String inputName = StoreUtilKt.getDefaultStoragePathSpec((State)spec);
            File inputFile = new File(this.myIdeConfigOptionsDir, inputName);
            if (inputFile.exists() && inputFile.isFile()) {
                String outName = (String)NAME_CONVERTER.invoke(storageClass, (Object)inputName);
                File outFile = new File(configDir, outName);
                FileUtil.copyContent((File)inputFile, (File)outFile);
                index.add(outFile);
            }
            if ((schemeDir = spec.additionalExportDirectory()).isEmpty() || !(dir = new File(this.myIdeConfigPath, schemeDir)).exists() || !dir.isDirectory()) continue;
            if (!ConfigList.loadService(storageClass)) {
                LOG.info("=== CopyConfig: service '" + storageClass + "' not loaded ===");
            }
            SchemeManagerImpl<?, ?> scheme = CloudConfigManager.findScheme(schemeDir);
            String schemeOutDir = (String)NAME_CONVERTER.invoke(storageClass, (Object)schemeDir);
            FileUtil.copyDir((File)dir, (File)new File(configDir, schemeOutDir), childFile -> {
                boolean canRead;
                String childName = childFile.getName();
                boolean bl = canRead = scheme == null || scheme.canRead((CharSequence)childName);
                if (canRead) {
                    index.add(new File(configDir, schemeOutDir + File.separator + childName));
                }
                return canRead;
            });
        }
        LinkedHashSet<File> linkedHashSet = index;
        if (linkedHashSet == null) {
            CloudConfigManager.$$$reportNull$$$0(64);
        }
        return linkedHashSet;
    }

    private void addPlugins(@NotNull Set<File> index) throws IOException {
        if (index == null) {
            CloudConfigManager.$$$reportNull$$$0(65);
        }
        String content = FileUtil.loadFile((File)this.getIdeaDisabledPluginsFile());
        FileUtil.writeToFile((File)this.getLocalDisabledPluginsFile(), (String)content);
        File file = new File(this.myConfigDir, "disabled_plugins.txt");
        FileUtil.writeToFile((File)file, (String)content);
        index.add(file);
        this.addToFile(index, "installed_plugins.txt", StringUtil.join(CloudConfigManager.getInstalledPlugins(true, descriptor -> !descriptor.isBundled()), descriptor -> descriptor.getIdString(), (String)"\n"));
    }

    @NotNull
    private static Set<PluginId> getInstalledPlugins(boolean filterRepo, @NotNull Predicate<? super IdeaPluginDescriptor> predicate) {
        Set<PluginId> repositoryPlugins;
        if (predicate == null) {
            CloudConfigManager.$$$reportNull$$$0(66);
        }
        List plugins = new ArrayList();
        ContainerUtil.addAll(plugins, (Object[])PluginManagerCore.getPlugins());
        plugins.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
        plugins = ContainerUtil.filter(plugins, descriptor -> (!(descriptor instanceof IdeaPluginDescriptorImpl) || !((IdeaPluginDescriptorImpl)descriptor).isDeleted()) && predicate.test((IdeaPluginDescriptor)descriptor));
        List pluginIds = ContainerUtil.map(plugins, PluginDescriptor::getPluginId);
        if (filterRepo && !pluginIds.isEmpty() && !(repositoryPlugins = CloudConfigManager.getRepositoryPlugins()).isEmpty()) {
            pluginIds = ContainerUtil.filter((Collection)pluginIds, repositoryPlugins::contains);
        }
        return new LinkedHashSet<PluginId>(pluginIds);
    }

    @NotNull
    private static Set<PluginId> getRepositoryPlugins() {
        if (myRepositoryPlugins == null) {
            try {
                Future future = MarketplaceRequests.getInstance().loadPlugins();
                CloudConfigManager.waitDone(future);
                myRepositoryPlugins = (Set)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                CloudConfigManager.logInfo(e);
                myRepositoryPlugins = Collections.emptySet();
            }
        }
        Set<PluginId> set = myRepositoryPlugins;
        if (set == null) {
            CloudConfigManager.$$$reportNull$$$0(67);
        }
        return set;
    }

    @Nullable
    private static IdeaPluginDescriptor getRepositoryPlugin(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            CloudConfigManager.$$$reportNull$$$0(68);
        }
        try {
            Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> MarketplaceRequests.getInstance().getLastCompatiblePluginUpdate(pluginId));
            CloudConfigManager.waitDone(future);
            return (IdeaPluginDescriptor)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            CloudConfigManager.logInfo(e);
            return null;
        }
    }

    private static void waitDone(Future<?> future) throws InterruptedException {
        assert (SwingUtilities.isEventDispatchThread()) : Thread.currentThread();
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while (!future.isDone()) {
            while (eventQueue.peekEvent() != null) {
                eventQueue.dispatchEvent(eventQueue.getNextEvent());
            }
            Thread.sleep(0L);
        }
    }

    private void safeUpdatePlugins() {
        try {
            this.updatePlugins(null, false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void updatePlugins(@Nullable Set<String> changedFiles, boolean autoUpdatePlugins) throws IOException {
        boolean checkDisabled = true;
        boolean checkInstalled = true;
        if (changedFiles != null) {
            if (changedFiles.isEmpty()) {
                return;
            }
            boolean rules = changedFiles.contains("plugin_rules.txt");
            checkDisabled = rules || changedFiles.contains("disabled_plugins.txt");
            boolean bl = checkInstalled = rules || changedFiles.contains("installed_plugins.txt");
            if (!checkDisabled && !checkInstalled) {
                return;
            }
        }
        this.myUpdatePlugins = false;
        HashMap<PluginId, PluginState> enabledDisabledStates = new HashMap<PluginId, PluginState>();
        HashMap<PluginId, PluginState> installedUninstalledStates = new HashMap<PluginId, PluginState>();
        Map plugins = ContainerUtil.map2Map((Object[])PluginManagerCore.getPlugins(), descriptor -> Pair.create((Object)descriptor.getPluginId(), (Object)descriptor));
        if (checkDisabled) {
            this.myEnabledDisabledPlugins = new ArrayList<PluginState>();
            this.mergePlugins(this.myEnabledDisabledPlugins, enabledDisabledStates, plugins::get, CloudConfigManager.loadPlugins(this.getIdeaDisabledPluginsFile()), null, PluginState.Type.Enable, "disabled_plugins.txt", PluginState.Type.Disable);
        }
        if (checkInstalled) {
            this.myInstalledUninstalledPlugins = new ArrayList<PluginState>();
            LinkedHashSet<PluginId> bundled = new LinkedHashSet<PluginId>();
            Set<PluginId> oldPlugins = CloudConfigManager.getInstalledPlugins(false, descriptor -> {
                if (descriptor.isBundled()) {
                    bundled.add(descriptor.getPluginId());
                    return false;
                }
                return true;
            });
            this.mergePlugins(this.myInstalledUninstalledPlugins, installedUninstalledStates, pluginId -> plugins.containsKey(pluginId) ? (IdeaPluginDescriptor)plugins.get(pluginId) : (CloudConfigManager.getRepositoryPlugins().contains(pluginId) ? CloudConfigManager.getRepositoryPlugin(pluginId) : null), oldPlugins, bundled, PluginState.Type.Uninstall, "installed_plugins.txt", PluginState.Type.Install);
            Iterator<PluginState> I = this.myInstalledUninstalledPlugins.iterator();
            while (I.hasNext()) {
                PluginState state2 = I.next();
                if (state2.type != PluginState.Type.Install || !PluginManagerCore.isIncompatible((IdeaPluginDescriptor)state2.plugin)) continue;
                I.remove();
            }
        }
        if (!this.myEnabledDisabledPlugins.isEmpty() || !this.myInstalledUninstalledPlugins.isEmpty()) {
            this.applyRules(enabledDisabledStates, installedUninstalledStates, false);
            this.applyRules(enabledDisabledStates, installedUninstalledStates, true);
            if (this.myEnabledDisabledPlugins.stream().anyMatch(state -> !state.skip) || this.myInstalledUninstalledPlugins.stream().anyMatch(state -> !state.skip)) {
                this.myUpdatePlugins = true;
            }
        }
        this.updateStatusBar(false);
        if (autoUpdatePlugins && this.myAutoUpdatePlugins) {
            this.executePlugins();
        }
    }

    private void applyRules(@NotNull Map<PluginId, PluginState> enabledDisabledStates, @NotNull Map<PluginId, PluginState> installedUninstalledStates, boolean local) throws IOException {
        if (enabledDisabledStates == null) {
            CloudConfigManager.$$$reportNull$$$0(69);
        }
        if (installedUninstalledStates == null) {
            CloudConfigManager.$$$reportNull$$$0(70);
        }
        for (String ruleLine : this.loadLines(local ? "local_plugin_rules.txt" : "plugin_rules.txt")) {
            PluginId pluginId = CloudConfigManager.getPluginId(ruleLine);
            for (String rule : StringUtil.split((String)CloudConfigManager.getRuleValue(ruleLine), (String)",")) {
                if (CloudConfigManager.applyRule(enabledDisabledStates, pluginId, rule, "skip_disable", PluginState.Type.Disable, local) || CloudConfigManager.applyRule(enabledDisabledStates, pluginId, rule, "skip_enable", PluginState.Type.Enable, local) || CloudConfigManager.applyRule(installedUninstalledStates, pluginId, rule, "skip_install", PluginState.Type.Install, local)) continue;
                CloudConfigManager.applyRule(installedUninstalledStates, pluginId, rule, "skip_uninstall", PluginState.Type.Uninstall, local);
            }
        }
    }

    @NotNull
    private static PluginId getPluginId(@NotNull String text) {
        if (text == null) {
            CloudConfigManager.$$$reportNull$$$0(71);
        }
        String pluginId = StringUtil.substringBefore((String)text, (String)":");
        assert (pluginId != null);
        PluginId pluginId2 = PluginId.getId((String)pluginId);
        if (pluginId2 == null) {
            CloudConfigManager.$$$reportNull$$$0(72);
        }
        return pluginId2;
    }

    @NotNull
    private static String getRuleValue(@NotNull String text) {
        if (text == null) {
            CloudConfigManager.$$$reportNull$$$0(73);
        }
        String rule = StringUtil.substringAfter((String)text, (String)":");
        assert (rule != null);
        String string = rule;
        if (string == null) {
            CloudConfigManager.$$$reportNull$$$0(74);
        }
        return string;
    }

    private static boolean applyRule(@NotNull Map<PluginId, PluginState> states, @NotNull PluginId pluginId, @NotNull String rule, @NotNull String ruleExpected, @NotNull PluginState.Type type, boolean local) {
        PluginState state;
        if (states == null) {
            CloudConfigManager.$$$reportNull$$$0(75);
        }
        if (pluginId == null) {
            CloudConfigManager.$$$reportNull$$$0(76);
        }
        if (rule == null) {
            CloudConfigManager.$$$reportNull$$$0(77);
        }
        if (ruleExpected == null) {
            CloudConfigManager.$$$reportNull$$$0(78);
        }
        if (type == null) {
            CloudConfigManager.$$$reportNull$$$0(79);
        }
        if (ruleExpected.equals(rule) && (state = states.get(pluginId)) != null && state.type == type) {
            state.skip = true;
            state.local = local;
            return true;
        }
        return false;
    }

    private void addRule(@NotNull PluginState state) {
        if (state == null) {
            CloudConfigManager.$$$reportNull$$$0(80);
        }
        try {
            PluginId pluginId = state.plugin.getPluginId();
            String name = state.local ? "local_plugin_rules.txt" : "plugin_rules.txt";
            List<String> rules = this.loadLines(name);
            boolean found = false;
            String newRule = "skip_" + StringUtil.decapitalize((String)state.type.name());
            ListIterator<String> I = rules.listIterator();
            while (I.hasNext()) {
                String ruleLine = I.next();
                PluginId nextId = CloudConfigManager.getPluginId(ruleLine);
                if (!pluginId.equals((Object)nextId)) continue;
                List allRules = StringUtil.split((String)CloudConfigManager.getRuleValue(ruleLine), (String)",");
                if (allRules.contains(newRule)) {
                    return;
                }
                allRules.add(newRule);
                I.set(pluginId + ":" + StringUtil.join((Collection)allRules, (String)","));
                found = true;
            }
            if (!found) {
                rules.add(pluginId + ":" + newRule);
            }
            this.savePluginsToFile(rules, name);
            if (!state.local) {
                this.mySaveSkipRulesFile = true;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void removeRules(@NotNull PluginId pluginId) throws IOException {
        if (pluginId == null) {
            CloudConfigManager.$$$reportNull$$$0(81);
        }
        this.mySaveSkipRulesFile |= this.removeRules(pluginId, "plugin_rules.txt");
        this.removeRules(pluginId, "local_plugin_rules.txt");
    }

    private boolean removeRules(@NotNull PluginId pluginId, @NotNull String file) throws IOException {
        if (pluginId == null) {
            CloudConfigManager.$$$reportNull$$$0(82);
        }
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(83);
        }
        List<String> rules = this.loadLines(file);
        Iterator<String> iterator = rules.iterator();
        while (iterator.hasNext()) {
            PluginId nextPluginId = CloudConfigManager.getPluginId(iterator.next());
            if (!pluginId.equals((Object)nextPluginId)) continue;
            iterator.remove();
            this.savePluginsToFile(rules, file);
            return true;
        }
        return false;
    }

    private void mergePlugins(@NotNull List<PluginState> result, @NotNull Map<PluginId, PluginState> states, @NotNull @NotNull Function<@NotNull PluginId, @Nullable ? extends IdeaPluginDescriptor> descriptorById, @NotNull Set<PluginId> oldPlugins1, @Nullable Set<PluginId> oldPlugins2, @NotNull PluginState.Type oldState, @NotNull String newPluginsName, @NotNull PluginState.Type newState) throws IOException {
        if (result == null) {
            CloudConfigManager.$$$reportNull$$$0(84);
        }
        if (states == null) {
            CloudConfigManager.$$$reportNull$$$0(85);
        }
        if (descriptorById == null) {
            CloudConfigManager.$$$reportNull$$$0(86);
        }
        if (oldPlugins1 == null) {
            CloudConfigManager.$$$reportNull$$$0(87);
        }
        if (oldState == null) {
            CloudConfigManager.$$$reportNull$$$0(88);
        }
        if (newPluginsName == null) {
            CloudConfigManager.$$$reportNull$$$0(89);
        }
        if (newState == null) {
            CloudConfigManager.$$$reportNull$$$0(90);
        }
        Set<PluginId> newPlugins = this.loadPlugins(newPluginsName);
        Iterator<PluginId> iterator = newPlugins.iterator();
        while (iterator.hasNext()) {
            PluginId newPlugin = iterator.next();
            if (!oldPlugins1.remove(newPlugin) && (oldPlugins2 == null || !oldPlugins2.remove(newPlugin))) continue;
            iterator.remove();
        }
        result.addAll(CloudConfigManager.mergePlugins(states, descriptorById, oldPlugins1, oldState));
        result.addAll(CloudConfigManager.mergePlugins(states, descriptorById, newPlugins, newState));
    }

    @NotNull
    private static List<? extends PluginState> mergePlugins(@NotNull Map<PluginId, PluginState> states, @NotNull @NotNull Function<@NotNull PluginId, @Nullable ? extends IdeaPluginDescriptor> descriptorById, @NotNull Set<PluginId> pluginIds, @NotNull PluginState.Type type) {
        if (states == null) {
            CloudConfigManager.$$$reportNull$$$0(91);
        }
        if (descriptorById == null) {
            CloudConfigManager.$$$reportNull$$$0(92);
        }
        if (pluginIds == null) {
            CloudConfigManager.$$$reportNull$$$0(93);
        }
        if (type == null) {
            CloudConfigManager.$$$reportNull$$$0(94);
        }
        ArrayList<PluginState> result = new ArrayList<PluginState>();
        for (PluginId pluginId : pluginIds) {
            IdeaPluginDescriptor descriptor = descriptorById.apply(pluginId);
            if (descriptor == null || !PluginManagerCore.isCompatible((IdeaPluginDescriptor)descriptor)) continue;
            PluginState state = new PluginState(type, descriptor);
            result.add(state);
            states.put(pluginId, state);
        }
        ArrayList<PluginState> arrayList = result;
        if (arrayList == null) {
            CloudConfigManager.$$$reportNull$$$0(95);
        }
        return arrayList;
    }

    private void executePlugins() {
        ArrayList<PluginState> states = new ArrayList<PluginState>(this.myEnabledDisabledPlugins);
        states.addAll(this.myInstalledUninstalledPlugins);
        List<Pair<PluginState, PluginState.Operation>> executeList = states.stream().filter(state -> !state.skip).map(state -> Pair.create((Object)state, (Object)((Object)PluginState.Operation.Auto))).collect(Collectors.toList());
        this.executePlugins(executeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePlugins(@NotNull List<Pair<PluginState, PluginState.Operation>> executeList) {
        if (executeList == null) {
            CloudConfigManager.$$$reportNull$$$0(96);
        }
        if (executeList.isEmpty()) {
            return;
        }
        final ArrayList<IdeaPluginDescriptor> installList = new ArrayList<IdeaPluginDescriptor>();
        final boolean[] states = new boolean[]{false, false, false};
        try {
            this.mySavePluginsWithEditConfigs = false;
            for (Pair<PluginState, PluginState.Operation> info : executeList) {
                PluginState state = (PluginState)info.first;
                IdeaPluginDescriptor descriptor = state.plugin;
                PluginState.Operation operation = (PluginState.Operation)((Object)info.second);
                PluginState.Type type = state.type;
                if (operation == PluginState.Operation.Auto) {
                    if (type == PluginState.Type.Install) {
                        installList.add(descriptor);
                    } else if (type == PluginState.Type.Uninstall) {
                        try {
                            assert (descriptor instanceof IdeaPluginDescriptorImpl) : descriptor.getClass() + " : " + descriptor;
                            IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)descriptor;
                            pluginDescriptor.setDeleted(true);
                            if (!PluginInstaller.prepareToUninstall((IdeaPluginDescriptorImpl)pluginDescriptor)) {
                                PluginInstaller.uninstallDynamicPlugin(null, (IdeaPluginDescriptorImpl)pluginDescriptor, (boolean)false);
                            }
                            states[1] = true;
                            states[2] = true;
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    } else {
                        PluginId id = descriptor.getPluginId();
                        if (type == PluginState.Type.Disable) {
                            PluginManagerCore.disablePlugin((PluginId)id);
                        } else {
                            PluginManagerCore.enablePlugin((PluginId)id);
                        }
                        states[0] = true;
                        states[2] = true;
                    }
                    try {
                        this.removeRules(descriptor.getPluginId());
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                    continue;
                }
                if (operation == PluginState.Operation.Revert) {
                    if (type == PluginState.Type.Install) {
                        this.removePlugin(descriptor, "installed_plugins.txt");
                        states[1] = true;
                        continue;
                    }
                    if (type == PluginState.Type.Uninstall) {
                        this.addPlugin(descriptor, "installed_plugins.txt");
                        states[1] = true;
                        continue;
                    }
                    if (type == PluginState.Type.Disable) {
                        this.removePlugin(descriptor, "disabled_plugins.txt");
                    } else {
                        this.addPlugin(descriptor, "disabled_plugins.txt");
                    }
                    states[0] = true;
                    continue;
                }
                state.skip = true;
                state.local = operation == PluginState.Operation.SkipLocally;
                this.addRule(state);
            }
        }
        finally {
            this.mySavePluginsWithEditConfigs = true;
        }
        if (installList.isEmpty()) {
            this.doneExecutePlugins(states);
        } else {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, CloudConfigBundle.message("progress.title.download.jba.cloud.shared.plugins", new Object[0])){
                final List<PluginDownloader> myDownloaders;
                boolean mySuccess;
                {
                    super(arg0, arg1);
                    this.myDownloaders = new ArrayList<PluginDownloader>();
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    for (IdeaPluginDescriptor descriptor : installList) {
                        try {
                            PluginDownloader downloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor);
                            if (!downloader.prepareToInstall(indicator)) continue;
                            this.myDownloaders.add(downloader);
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }

                public void onSuccess() {
                    this.mySuccess = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFinished() {
                    if (this.mySuccess) {
                        try {
                            CloudConfigManager.this.mySavePluginsWithEditConfigs = false;
                            for (PluginDownloader downloader : this.myDownloaders) {
                                try {
                                    downloader.install();
                                    states[1] = true;
                                    states[2] = true;
                                }
                                catch (IOException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                        }
                        finally {
                            CloudConfigManager.this.mySavePluginsWithEditConfigs = true;
                        }
                    }
                    CloudConfigManager.this.doneExecutePlugins(states);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/cloudConfig/CloudConfigManager$4", "run"));
                }
            });
        }
    }

    private void doneExecutePlugins(boolean @NotNull [] states) {
        if (states == null) {
            CloudConfigManager.$$$reportNull$$$0(97);
        }
        ArrayList<String> files = new ArrayList<String>();
        if (states[0]) {
            files.add("disabled_plugins.txt");
        }
        if (states[1]) {
            files.add("installed_plugins.txt");
        }
        if (this.mySaveSkipRulesFile) {
            this.mySaveSkipRulesFile = false;
            if (files.isEmpty()) {
                this.editConfigFiles("plugin_rules.txt");
                this.safeUpdatePlugins();
                return;
            }
            files.add("plugin_rules.txt");
        }
        if (files.isEmpty()) {
            this.safeUpdatePlugins();
        } else {
            this.editConfigFiles(ArrayUtilRt.toStringArray(files));
            this.safeUpdatePlugins();
            if (states[2]) {
                PluginManagerConfigurable.shutdownOrRestartApp();
            }
        }
    }

    @Nullable
    private static SchemeManagerImpl<?, ?> findScheme(@NotNull String fileSpec) {
        if (fileSpec == null) {
            CloudConfigManager.$$$reportNull$$$0(98);
        }
        Ref result = new Ref();
        ((SchemeManagerFactoryBase)SchemeManagerFactory.getInstance()).process(manager -> {
            if (result.isNull() && fileSpec.equals(manager.getFileSpec())) {
                result.set(manager);
            }
            return null;
        });
        return (SchemeManagerImpl)result.get();
    }

    private void pushToServer(@NotNull Set<File> index, boolean cleanup) throws IOException {
        if (index == null) {
            CloudConfigManager.$$$reportNull$$$0(99);
        }
        if (cleanup) {
            this.deleteFile("updates.7z");
            this.deleteFile(".del");
        }
        CloudConfigManager.createArchive(index, this.myFilesArchive, this.myConfigDir.getAbsolutePath());
        this.writeFile(this.myFilesArchive);
        this.writeApi();
    }

    private void writeApi() throws IOException {
        FileUtil.writeToFile((File)this.myApiFile, (String)API);
        this.writeFile(this.myApiFile);
    }

    private void setConnected() throws IOException {
        this.myStatusInfo = StatusInfo.JBA_CONNECTED;
        this.storeStateIO();
        this.storeAutoUpdatePlugins();
    }

    private void updateStatusBar(boolean create) {
        if (this.myBeforeApplicationLoadedStart) {
            this.updateStatusBarLater(create);
        } else {
            this.myStatusBarManager.update(create);
        }
    }

    private void updateStatusBarLater(boolean create) {
        ApplicationManager.getApplication().invokeLater(() -> this.myStatusBarManager.update(create));
    }

    public void editConfigFiles(String ... fileNames) {
        if (fileNames == null) {
            CloudConfigManager.$$$reportNull$$$0(100);
        }
        try {
            LOG.info("=== Start.Edit: " + Arrays.toString(fileNames) + " |" + this.myIOOperation + "| ===");
            this.myLocalChanges.addFiles(fileNames);
            if (this.myIOOperation) {
                return;
            }
            this.myIOOperation = true;
            this.updateStatusBar(false);
            CloudConfigManager.getTaskExecutor().schedule(() -> this.doConnection(), 1L, TimeUnit.SECONDS);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private static String plusOne(@NotNull String value) {
        String string;
        if (value == null) {
            CloudConfigManager.$$$reportNull$$$0(101);
        }
        try {
            string = Integer.toString(Integer.parseInt(value) + 1);
        }
        catch (NumberFormatException e) {
            return "100";
        }
        if (string == null) {
            CloudConfigManager.$$$reportNull$$$0(102);
        }
        return string;
    }

    private void storeState() {
        try {
            this.storeStateIO();
        }
        catch (IOException e) {
            CloudConfigManager.logInfo(e);
        }
    }

    private void storeStateIO() throws IOException {
        FileUtil.writeToFile((File)this.myStatusFile, (String)this.myStatusInfo.name());
    }

    private void storeAutoUpdatePlugins() {
        try {
            FileUtil.writeToFile((File)this.myAutoUpdatePluginsFile, (String)(this.myAutoUpdatePlugins ? API : "0"));
        }
        catch (IOException e) {
            CloudConfigManager.logInfo(e);
        }
    }

    private void setStreamProvider(boolean noProvider, boolean reload, boolean plugins) throws IOException {
        StateStorageManagerImpl storageManager = CloudConfigManager.getStateStorageManager();
        storageManager.removeStreamProvider(CloudConfigStreamProvider.class);
        if (!noProvider) {
            storageManager.addStreamProvider((StreamProvider)new CloudConfigStreamProvider(this.myConfigDir.toPath(), this), true);
        }
        if (!noProvider) {
            this.initListeners();
        }
        if (reload) {
            CloudConfigManager.reloadComponents(null, this.getAllClasses());
        }
        if (noProvider) {
            this.myInstalledUninstalledPlugins = Collections.emptyList();
            this.myEnabledDisabledPlugins = this.myInstalledUninstalledPlugins;
            this.myUpdatePlugins = false;
        } else if (plugins) {
            this.updatePlugins(null, true);
        }
    }

    private void updateFiles() throws IOException {
        LOG.info("=== Update Files ===");
        boolean reload = this.prepareReloadStates(this.myUpdatesArchive);
        HashSet<String> changedFiles = new HashSet<String>();
        CloudConfigManager.extractArchive(this.myUpdatesArchive, this.myConfigDir, changedFiles);
        this.myLocalChanges.removeFiles(changedFiles);
        if (reload) {
            this.loadStates();
            this.setStreamProvider(false, false, false);
            CloudConfigManager.reloadComponents(null, (List)this.myAllClasses.getValue());
        } else if (!changedFiles.isEmpty()) {
            CloudConfigManager.reloadComponents(changedFiles, this.getAllClasses());
        }
        this.updatePlugins(changedFiles, true);
    }

    private static void reloadComponents(@Nullable Set<String> changedFiles, @NotNull List<Class<?>> storageClasses) {
        if (storageClasses == null) {
            CloudConfigManager.$$$reportNull$$$0(103);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LinkedHashSet<String> componentNames = new LinkedHashSet<String>();
        HashSet<StateStorage> changedStorages = new HashSet<StateStorage>();
        LinkedHashSet schemes = new LinkedHashSet();
        StateStorageManagerImpl storageManager = CloudConfigManager.getStateStorageManager();
        for (Class<?> clazz : storageClasses) {
            SchemeManagerImpl<?, ?> scheme;
            String name;
            StateStorage storage;
            State spec = StoreUtilKt.getStateSpec(clazz);
            LOG.assertTrue(spec != null);
            boolean addComponent = false;
            String schemeDir = spec.additionalExportDirectory();
            if (!schemeDir.isEmpty() && (changedFiles == null || changedFiles.contains(NAME_CONVERTER.invoke(clazz, (Object)schemeDir)))) {
                SchemeManagerImpl<?, ?> scheme2 = CloudConfigManager.findScheme(schemeDir);
                if (scheme2 != null) {
                    schemes.add(scheme2);
                    addComponent = true;
                } else {
                    LOG.info("=== Reload: lazy component scheme '" + schemeDir + "' ===");
                }
            }
            if ((storage = storageManager.findCachedFileStorage(name = StoreUtilKt.getDefaultStoragePathSpec((State)spec))) == null) {
                LOG.info("=== Reload: lazy component '" + name + "' ===");
                continue;
            }
            LOG.assertTrue(storage instanceof XmlElementStorage, (Object)(name + " : " + storage));
            changedStorages.add(storage);
            LOG.assertTrue(((XmlElementStorage)storage).getRoamingType() != RoamingType.DISABLED, (Object)(name + " : " + storage));
            ((XmlElementStorage)storage).updatedFrom(componentNames, false, true);
            if (!addComponent && changedFiles != null && !changedFiles.contains(NAME_CONVERTER.invoke(clazz, (Object)name))) continue;
            componentNames.add(spec.name());
            if (schemeDir.isEmpty() || (scheme = CloudConfigManager.findScheme(schemeDir)) == null) continue;
            schemes.add(scheme);
        }
        CustomActionsSchema.getInstance().clearFirstLoadState();
        for (SchemeManagerImpl schemeManagerImpl : schemes) {
            schemeManagerImpl.reload();
        }
        LOG.info("=== Reload schemes: " + schemes + " ===");
        Application application = ApplicationManager.getApplication();
        ComponentStoreImpl componentStoreImpl = (ComponentStoreImpl)ServiceKt.getStateStore((ComponentManager)application);
        Collection notReloadableComponents = componentStoreImpl.getNotReloadableComponents(componentNames);
        LOG.assertTrue(notReloadableComponents.isEmpty());
        componentStoreImpl.reinitComponents(componentNames, changedStorages, notReloadableComponents);
        CloudConfigManager.updateUI();
        LOG.info("=== Reload components: " + componentNames + " ===");
    }

    private static void updateUI() {
        LafManager lafManager = LafManager.getInstance();
        UIManager.LookAndFeelInfo lookAndFeel = lafManager.getCurrentLookAndFeel();
        if (lookAndFeel != null) {
            lafManager.setCurrentLookAndFeel(lookAndFeel, true);
        }
        boolean darcula = StartupUiUtil.isUnderDarcula();
        JBColor.setDark((boolean)darcula);
        IconLoader.setUseDarkIcons((boolean)darcula);
        ActionToolbarImpl.updateAllToolbarsImmediately();
        lafManager.updateUI();
        UISettings.getInstance().fireUISettingsChanged();
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
        EditorOptionsPanel.reinitAllEditors();
        EditorOptionsPanel.restartDaemons();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            ProjectView.getInstance((Project)project).refresh();
        }
    }

    static boolean isExclusiveStreamProviderEnabled() {
        return CloudConfigManager.getStateStorageManager().getCompoundStreamProvider().isExclusivelyEnabled();
    }

    @NotNull
    private static CloudConfigTaskExecutor getTaskExecutor() {
        CloudConfigTaskExecutor cloudConfigTaskExecutor = (CloudConfigTaskExecutor)ApplicationManager.getApplication().getService(CloudConfigTaskExecutor.class);
        if (cloudConfigTaskExecutor == null) {
            CloudConfigManager.$$$reportNull$$$0(104);
        }
        return cloudConfigTaskExecutor;
    }

    @NotNull
    public static StateStorageManagerImpl getStateStorageManager() {
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStorageManager();
        if (stateStorageManagerImpl == null) {
            CloudConfigManager.$$$reportNull$$$0(105);
        }
        return stateStorageManagerImpl;
    }

    private static boolean filterOsName(@NotNull String fileName) {
        if (fileName == null) {
            CloudConfigManager.$$$reportNull$$$0(106);
        }
        if (!fileName.startsWith(CloudConfigClientUtil.getOS() + ".")) {
            for (String name : OS_NAMES) {
                if (!fileName.startsWith(name + ".")) continue;
                return false;
            }
        }
        return true;
    }

    public static void createArchive(@NotNull Set<File> files, @NotNull File outFile, @NotNull String prefix) throws IOException {
        if (files == null) {
            CloudConfigManager.$$$reportNull$$$0(107);
        }
        if (outFile == null) {
            CloudConfigManager.$$$reportNull$$$0(108);
        }
        if (prefix == null) {
            CloudConfigManager.$$$reportNull$$$0(109);
        }
        FileUtil.createParentDirs((File)outFile);
        try (SevenZOutputFile archive = new SevenZOutputFile(outFile);){
            CloudConfigManager.addToArchive(archive, files, prefix);
        }
    }

    private static void addToArchive(SevenZOutputFile archive, @NotNull Set<File> files, @NotNull String prefix) throws IOException {
        if (files == null) {
            CloudConfigManager.$$$reportNull$$$0(110);
        }
        if (prefix == null) {
            CloudConfigManager.$$$reportNull$$$0(111);
        }
        prefix = (String)prefix + File.separator;
        int length = ((String)prefix).length();
        for (File file : files) {
            String path = file.getAbsolutePath();
            assert (path.startsWith((String)prefix));
            String name = path.substring(length);
            if (File.separatorChar != '/') {
                name = name.replace(File.separatorChar, '/');
            }
            archive.putArchiveEntry((ArchiveEntry)archive.createArchiveEntry(file, name));
            if (file.exists() && file.isFile()) {
                archive.write(FileUtil.loadFileBytes((File)file));
            }
            archive.closeArchiveEntry();
        }
    }

    private static void extractArchive(@NotNull File archiveFile, @NotNull File outDir, boolean delete) throws IOException {
        if (archiveFile == null) {
            CloudConfigManager.$$$reportNull$$$0(112);
        }
        if (outDir == null) {
            CloudConfigManager.$$$reportNull$$$0(113);
        }
        try (SevenZFile archive = new SevenZFile(archiveFile);){
            SevenZArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (entry.isDirectory() || !CloudConfigManager.filterOsName(entry.getName())) continue;
                File file = new File(outDir, entry.getName());
                int size = (int)entry.getSize();
                if (delete && size == 0) {
                    FileUtil.delete((File)file);
                    continue;
                }
                FileUtil.writeToFile((File)file, (byte[])CloudConfigClientUtil.loadBytes((SevenZFile)archive, (int)size));
            }
        }
    }

    private static void extractArchive(@NotNull File archiveFile, @NotNull File outDir, @NotNull Set<String> changedFiles) throws IOException {
        if (archiveFile == null) {
            CloudConfigManager.$$$reportNull$$$0(114);
        }
        if (outDir == null) {
            CloudConfigManager.$$$reportNull$$$0(115);
        }
        if (changedFiles == null) {
            CloudConfigManager.$$$reportNull$$$0(116);
        }
        try (SevenZFile archive = new SevenZFile(archiveFile);){
            SevenZArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String fileName = entry.getName();
                File file = new File(outDir, fileName);
                int size = (int)entry.getSize();
                boolean change = false;
                if (size == 0) {
                    if (file.exists()) {
                        FileUtil.delete((File)file);
                        change = true;
                        LOG.info("=== Update File(Delete): " + fileName + " ===");
                    }
                } else if (CloudConfigManager.filterOsName(fileName)) {
                    byte[] oldBytes = file.isFile() && file.exists() ? FileUtil.loadFileBytes((File)file) : null;
                    byte[] newBytes = CloudConfigClientUtil.loadBytes((SevenZFile)archive, (int)((int)entry.getSize()));
                    if (!Arrays.equals(newBytes, oldBytes)) {
                        FileUtil.writeToFile((File)file, (byte[])newBytes);
                        if (!VERSION_FILE.equals(fileName)) {
                            change = true;
                            LOG.info("=== Update File(Edit): " + fileName + " ===");
                        }
                    }
                }
                if (!change) continue;
                changedFiles.add(StringUtil.defaultIfEmpty((String)StringUtil.substringBefore((String)fileName, (String)"/"), (String)fileName));
            }
        }
    }

    @NotNull
    private List<String> listFiles(@NotNull String file) throws IOException {
        List list;
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(117);
        }
        try {
            List result = this.myClient.list(CloudConfigClientUtil.getName() + file);
            this.resetIO();
            list = result;
        }
        catch (IOException | RuntimeException e) {
            this.myIOError = true;
            this.setErrorMessage(e);
            throw e;
        }
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(118);
        }
        return list;
    }

    @Nullable
    private Boolean getFile(@NotNull String name) throws IOException {
        InputStream stream;
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(119);
        }
        File file = new File(this.myCachesDir, name);
        try {
            stream = this.myClient.read(CloudConfigClientUtil.getName() + name);
            this.resetIO();
        }
        catch (FileNotFoundException e) {
            FileUtil.delete((File)file);
            this.resetIO();
            return null;
        }
        catch (IOException | RuntimeException e) {
            this.myIOError = true;
            this.setErrorMessage(e);
            throw e;
        }
        if (stream != null) {
            FileUtil.createParentDirs((File)file);
            try (InputStream inputStream = stream;
                 FileOutputStream outputStream = new FileOutputStream(file);){
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                this.resetIO();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                this.myIOError = true;
                throw e;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void writeFile(@NotNull File file) throws IOException {
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(120);
        }
        try (FileInputStream stream = new FileInputStream(file);){
            this.myClient.write(CloudConfigClientUtil.getName() + file.getName(), (InputStream)stream);
            this.resetIO();
        }
        catch (IOException | RuntimeException e) {
            this.myIOError = true;
            this.setErrorMessage(e);
            throw e;
        }
    }

    private void deleteFile(@NotNull String file) throws IOException {
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(121);
        }
        try {
            this.myClient.delete(CloudConfigClientUtil.getName() + file);
            this.resetIO();
        }
        catch (IOException | RuntimeException e) {
            this.myIOError = true;
            this.setErrorMessage(e);
            throw e;
        }
    }

    @NotNull
    private File getIdeaDisabledPluginsFile() {
        File file = new File(this.myIdeConfigPath, "disabled_plugins.txt");
        FileUtil.createIfDoesntExist((File)file);
        File file2 = file;
        if (file2 == null) {
            CloudConfigManager.$$$reportNull$$$0(122);
        }
        return file2;
    }

    @NotNull
    private File getLocalDisabledPluginsFile() {
        return new File(this.myConfigDir, LOCAL_DISABLED_PLUGINS_FILENAME);
    }

    private void setErrorMessage(@NotNull Exception e) {
        if (e == null) {
            CloudConfigManager.$$$reportNull$$$0(123);
        }
        if (e instanceof UnauthorizedException) {
            this.myErrorMessage = "401";
        } else if (e instanceof RuntimeException) {
            this.myErrorMessage = e.getMessage();
            if (this.myErrorMessage != null && this.myErrorMessage.startsWith("Unexpected response (code: 413,")) {
                this.myErrorMessage = CloudConfigBundle.message("error.message.requested.entity.too.large", new Object[0]);
            }
        } else {
            this.myErrorMessage = null;
        }
    }

    private static void logInfo(@NotNull Throwable e) {
        if (e == null) {
            CloudConfigManager.$$$reportNull$$$0(124);
        }
        LOG.info(e);
    }

    static {
        NAME_CONVERTER = (storageClass, name) -> ConfigList.isOSConfig(storageClass) ? CloudConfigClientUtil.getOS() + "." + StringUtil.trimStart((String)name, (String)(CloudConfigClientUtil.getOS() + "/")) : name;
        OS_NAMES = new String[]{"mac", "win", "linux", "freebsd", "unix", "unknown"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 124: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 124: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cloudConfig/CloudConfigManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 12: 
            case 29: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 45: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 14: 
            case 112: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveFile";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStates";
                break;
            }
            case 16: 
            case 20: 
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 17: 
            case 59: 
            case 109: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageClass";
                break;
            }
            case 21: 
            case 75: 
            case 85: 
            case 91: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 28: 
            case 50: 
            case 54: 
            case 55: 
            case 57: 
            case 65: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 39: 
            case 41: 
            case 83: 
            case 117: 
            case 120: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 42: 
            case 44: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 47: 
            case 49: 
            case 68: 
            case 76: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toWrite";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPrefix";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 60: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 63: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageClasses";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledDisabledStates";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedUninstalledStates";
                break;
            }
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleExpected";
                break;
            }
            case 79: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 86: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorById";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPlugins1";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldState";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPluginsName";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executeList";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSpec";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFile";
                break;
            }
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDir";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFiles";
                break;
            }
            case 123: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledDisabledPlugins";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledUninstalledPlugins";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cloudConfig/CloudConfigManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSClasses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigInfos";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionState";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLines";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "copyUpdates";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "copyConfigs";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryPlugins";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuleValue";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "mergePlugins";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "plusOne";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskExecutor";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateStorageManager";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "listFiles";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeaDisabledPluginsFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "beforeApplicationLoaded";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadStates";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareReloadStates";
                break;
            }
            case 15: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "editStates";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copySettingsItemBack";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "saveStates";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addToFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "installPlugin";
                break;
            }
            case 32: 
            case 33: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addPlugin";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "uninstallPlugin";
                break;
            }
            case 35: 
            case 36: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removePlugin";
                break;
            }
            case 37: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "loadLines";
                break;
            }
            case 38: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "loadPlugins";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "savePlugins";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsToFile";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "copyUpdates";
                break;
            }
            case 52: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createUpdates";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addVersion";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "copyConfigs";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addPlugins";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledPlugins";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryPlugin";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "applyRules";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getPluginId";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getRuleValue";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "applyRule";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addRule";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "removeRules";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "mergePlugins";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "executePlugins";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "doneExecutePlugins";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "findScheme";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "pushToServer";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "editConfigFiles";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "plusOne";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "reloadComponents";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "filterOsName";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createArchive";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "addToArchive";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "extractArchive";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "listFiles";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "writeFile";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "setErrorMessage";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "logInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 124: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LocalChanges {
        private final Set<String> myFiles = new LinkedHashSet<String>();
        private final File myFile;

        private LocalChanges() {
            this.myFile = new File(CloudConfigManager.this.myConfigDir, CloudConfigManager.LOCAL_CHANGES_FILE);
        }

        public void load() {
            try {
                if (this.myFile.exists()) {
                    this.myFiles.clear();
                    this.myFiles.addAll(FileUtil.loadLines((File)this.myFile));
                    LOG.info("=== Local Changes: " + this.myFiles + " ===");
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        public void addFiles(String ... fileNames) throws IOException {
            if (fileNames == null) {
                LocalChanges.$$$reportNull$$$0(0);
            }
            if (Collections.addAll(this.myFiles, fileNames)) {
                this.save();
            }
        }

        @NotNull
        public Set<File> getFiles() {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (String file : this.myFiles) {
                files.add(new File(CloudConfigManager.this.myConfigDir, file));
            }
            LinkedHashSet<File> linkedHashSet = files;
            if (linkedHashSet == null) {
                LocalChanges.$$$reportNull$$$0(1);
            }
            return linkedHashSet;
        }

        public void removeFiles(@NotNull Set<String> files) throws IOException {
            if (files == null) {
                LocalChanges.$$$reportNull$$$0(2);
            }
            this.myFiles.removeAll(files);
            if (this.myFiles.isEmpty()) {
                FileUtil.delete((File)this.myFile);
            } else {
                this.save();
            }
        }

        private void save() throws IOException {
            FileUtil.writeToFile((File)this.myFile, (String)StringUtil.join(this.myFiles, (String)"\n"));
        }

        public void clean() {
            this.myFiles.clear();
            FileUtil.delete((File)this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/cloudConfig/CloudConfigManager$LocalChanges";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/cloudConfig/CloudConfigManager$LocalChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addFiles";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeFiles";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum ConnectionState {
        OLD,
        NEW,
        UPDATE,
        DELETE,
        IO_ERROR;

    }
}

