/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigBundle;
import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.ConfigState;
import com.intellij.cloudConfig.StatusBarInfoManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.TwoStepConfirmationDialog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConfigSyncSettingsAction
extends DumbAwareAction {
    public CloudConfigSyncSettingsAction() {
        super(CloudConfigBundle.messagePointer("self.settings.action", new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CloudConfigSyncSettingsAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CloudConfigSyncSettingsAction.$$$reportNull$$$0(1);
        }
        CloudConfigSyncSettingsAction.showSelfSettingsDialog();
    }

    public static void showSelfSettingsDialog() {
        final SelfConfigsModel model = new SelfConfigsModel();
        TwoStepConfirmationDialog dialog = new TwoStepConfirmationDialog(null, CloudConfigBundle.message("self.settings.dialog.title", new Object[0]), new String[]{CloudConfigBundle.message("plugins.dialog.button", new Object[0]), Messages.getCancelButton()}, null, false, 0, 0, null, (exitCode, checkBox) -> exitCode){
            JBTable myTable;

            protected String getDimensionServiceKey() {
                return "cloudConfig.SelfSettingsDialog";
            }

            protected JComponent createNorthPanel() {
                return null;
            }

            protected JComponent createCenterPanel() {
                JPanel messagePanel = this.createMessagePanel();
                messagePanel.add(this.createCheckComponent());
                return messagePanel;
            }

            @NotNull
            protected JComponent createCheckComponent() {
                this.myTable = new JBTable(model){

                    public TableCellRenderer getCellRenderer(int row, int column) {
                        return model.getRenderer(column);
                    }
                };
                this.myTable.setSelectionMode(0);
                this.myTable.setShowGrid(false);
                this.myTable.setTableHeader(null);
                TableColumnModel columnModel = this.myTable.getColumnModel();
                columnModel.setColumnMargin(0);
                JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
                int width = this.myTable.getPreferredScrollableViewportSize().width;
                pane.setPreferredSize(new Dimension(width, JBUIScale.scale((int)200)));
                int size = columnModel.getColumnCount();
                for (int i = 0; i < size; ++i) {
                    columnModel.getColumn(i).setCellEditor(model.getEditor(i));
                }
                TableColumn column1 = columnModel.getColumn(1);
                int columnWidth = JBUIScale.scale((int)150);
                column1.setMinWidth(columnWidth);
                column1.setMaxWidth(columnWidth);
                JScrollPane jScrollPane = pane;
                if (jScrollPane == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jScrollPane;
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myTable;
            }

            protected Action @NotNull [] createActions() {
                Action[] actions = super.createActions();
                model.setOkButton(actions[0]);
                if (actions == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actions;
            }

            protected String getHelpId() {
                return "cloud-config.self-settings-dialog";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/cloudConfig/CloudConfigSyncSettingsAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCheckComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActions";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        dialog.show();
        if (dialog.getExitCode() == 0) {
            ArrayList<Pair<ConfigState, ConfigState.Type>> newStates = new ArrayList<Pair<ConfigState, ConfigState.Type>>();
            for (EditConfigState state : model.myStates) {
                if (!state.isModified()) continue;
                state.getResult(newStates);
            }
            CloudConfigManager.getInstance().editStates(newStates);
        }
    }

    private static void customizeColor(@NotNull JComponent component, @NotNull ConfigState.Type value, boolean isSelected) {
        if (component == null) {
            CloudConfigSyncSettingsAction.$$$reportNull$$$0(2);
        }
        if (value == null) {
            CloudConfigSyncSettingsAction.$$$reportNull$$$0(3);
        }
        if (!isSelected && value != ConfigState.Type.Enable) {
            component.setForeground(SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cloudConfig/CloudConfigSyncSettingsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class EditConfigState {
        public ConfigState state;
        public ConfigState.Type type;
        private List<ConfigState> myChildStates;

        private EditConfigState(@NotNull ConfigState state) {
            if (state == null) {
                EditConfigState.$$$reportNull$$$0(0);
            }
            this.state = state;
            this.type = state.type;
        }

        public boolean isModified() {
            return this.type != this.state.type;
        }

        public void addChild(@NotNull ConfigState childState) {
            if (childState == null) {
                EditConfigState.$$$reportNull$$$0(1);
            }
            assert (this.type == childState.type);
            if (this.myChildStates == null) {
                this.myChildStates = new ArrayList<ConfigState>();
            }
            this.myChildStates.add(childState);
        }

        public void getResult(@NotNull List<Pair<ConfigState, ConfigState.Type>> newStates) {
            if (newStates == null) {
                EditConfigState.$$$reportNull$$$0(2);
            }
            newStates.add((Pair<ConfigState, ConfigState.Type>)Pair.create((Object)this.state, (Object)((Object)this.type)));
            if (this.myChildStates != null) {
                for (ConfigState childState : this.myChildStates) {
                    newStates.add((Pair<ConfigState, ConfigState.Type>)Pair.create((Object)childState, (Object)((Object)this.type)));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newStates";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cloudConfig/CloudConfigSyncSettingsAction$EditConfigState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChild";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getResult";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SelfConfigsModel
    extends AbstractTableModel {
        final List<EditConfigState> myStates = new ArrayList<EditConfigState>();
        Runnable myOkHandler;

        private SelfConfigsModel() {
            HashMap<String, EditConfigState> idToState = new HashMap<String, EditConfigState>();
            for (ConfigState setting : CloudConfigManager.getInstance().getSelfSettings()) {
                String id = setting.info.id;
                EditConfigState state = (EditConfigState)idToState.get(id);
                if (state == null) {
                    EditConfigState newState = new EditConfigState(setting);
                    this.myStates.add(newState);
                    idToState.put(id, newState);
                    continue;
                }
                state.addChild(setting);
            }
        }

        @Override
        public int getRowCount() {
            return this.myStates.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @NotNull
        public TableCellRenderer getRenderer(int column) {
            return column == 0 ? new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    CloudConfigSyncSettingsAction.customizeColor(this, myStates.get((int)row).type, isSelected);
                    return this;
                }
            } : new ComboBoxTableRenderer<ConfigState.Type>(null){

                protected void customizeComponent(ConfigState.Type value, JTable table, boolean isSelected) {
                    super.customizeComponent((Object)value, table, isSelected);
                    CloudConfigSyncSettingsAction.customizeColor((JComponent)((Object)this), value, isSelected);
                }

                @NlsContexts.Label
                protected String getTextFor(@NotNull ConfigState.Type value) {
                    if (value == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return value.getText();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/CloudConfigSyncSettingsAction$SelfConfigsModel$2", "getTextFor"));
                }
            };
        }

        @Nullable
        public TableCellEditor getEditor(int column) {
            return column == 0 ? null : new ComboBoxTableRenderer<ConfigState.Type>(ConfigState.Type.values()){

                public boolean isCellEditable(EventObject event) {
                    if (event instanceof MouseEvent) {
                        return ((MouseEvent)event).getClickCount() >= 1;
                    }
                    return false;
                }

                protected boolean isApplicable(ConfigState.Type value, int row) {
                    if (value == ConfigState.Type.DisableLocally) {
                        return myStates.get((int)row).state.type != ConfigState.Type.Disable;
                    }
                    return true;
                }

                @NlsContexts.Label
                protected String getTextFor(@NotNull ConfigState.Type value) {
                    if (value == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return value.getText();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/CloudConfigSyncSettingsAction$SelfConfigsModel$3", "getTextFor"));
                }
            };
        }

        @Override
        public Object getValueAt(int row, int column) {
            EditConfigState state = this.myStates.get(row);
            return column == 0 ? state.state.info.description : state.type;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            this.myStates.get((int)row).type = (ConfigState.Type)((Object)value);
            this.myOkHandler.run();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        public void setOkButton(@NotNull Action okButton) {
            if (okButton == null) {
                SelfConfigsModel.$$$reportNull$$$0(0);
            }
            this.myOkHandler = () -> {
                boolean modified = false;
                boolean enabled = false;
                for (EditConfigState state : this.myStates) {
                    if (state.isModified()) {
                        modified = true;
                    }
                    if (state.type == ConfigState.Type.Enable) {
                        enabled = true;
                    }
                    if (!modified || !enabled) continue;
                    break;
                }
                okButton.setEnabled(modified && enabled);
            };
            this.myOkHandler.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okButton", "com/intellij/cloudConfig/CloudConfigSyncSettingsAction$SelfConfigsModel", "setOkButton"));
        }
    }
}

