/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigBundle;
import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.icons.AllIcons;
import com.intellij.idea.cloudConfig.CloudConfigLoginDialog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.TwoStepConfirmationDialog;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CloudConfigUi {
    CloudConfigUi() {
    }

    @NotNull
    static DialogWithCheckboxResult showDialog(@NotNull String messageKey, @NotNull String okButtonKey, @NotNull String checkBoxKey, @Nullable Computable<? extends JCheckBox> secondCheckbox) {
        int result;
        if (messageKey == null) {
            CloudConfigUi.$$$reportNull$$$0(0);
        }
        if (okButtonKey == null) {
            CloudConfigUi.$$$reportNull$$$0(1);
        }
        if (checkBoxKey == null) {
            CloudConfigUi.$$$reportNull$$$0(2);
        }
        DialogWithCheckboxResult dialogWithCheckboxResult = (result = CloudConfigUi.showCheckboxDialog(CloudConfigBundle.message(messageKey, new Object[0]), new String[]{CloudConfigBundle.message(okButtonKey, new Object[0]), Messages.getCancelButton()}, CloudConfigBundle.message(checkBoxKey, new Object[0]), (PairFunction<? super Integer, ? super JCheckBox, Integer>)((PairFunction)(exitCode, checkBox) -> exitCode == 0 ? (checkBox.isSelected() ? 0 : 1) : 2), secondCheckbox)) == 2 ? DialogWithCheckboxResult.NO : (result == 0 ? DialogWithCheckboxResult.YES_WITH_EXTRA_OPTION : DialogWithCheckboxResult.YES_WITHOUT_EXTRA_OPTION);
        if (dialogWithCheckboxResult == null) {
            CloudConfigUi.$$$reportNull$$$0(3);
        }
        return dialogWithCheckboxResult;
    }

    static int showCheckboxDialog(@NlsContexts.DialogMessage String message, String @NotNull [] options, @NlsContexts.Checkbox String checkboxText, @Nullable PairFunction<? super Integer, ? super JCheckBox, Integer> exitFunc, final @Nullable Computable<? extends JCheckBox> secondCheckboxProvider) {
        if (options == null) {
            CloudConfigUi.$$$reportNull$$$0(4);
        }
        TwoStepConfirmationDialog dialog = new TwoStepConfirmationDialog(message, CloudConfigBundle.message("dialog.title.general", new Object[0]), options, checkboxText, false, 0, 0, Messages.getInformationIcon(), exitFunc){

            @NotNull
            protected JPanel createButtonsPanel(@NotNull List<? extends JButton> buttons) {
                if (buttons == null) {
                    1.$$$reportNull$$$0(0);
                }
                NonOpaquePanel panel = new NonOpaquePanel();
                for (JButton jButton : buttons) {
                    panel.add(jButton);
                }
                panel.setLayout(new LayoutManager(){
                    final int hgap = SystemInfoRt.isMac ? (UIUtil.isUnderIntelliJLaF() ? 8 : 0) : 5;

                    @Override
                    public void addLayoutComponent(String name, Component comp) {
                    }

                    @Override
                    public void removeLayoutComponent(Component comp) {
                    }

                    @Override
                    public Dimension minimumLayoutSize(Container parent) {
                        return this.preferredLayoutSize(parent);
                    }

                    @Override
                    public Dimension preferredLayoutSize(Container parent) {
                        Insets insets = parent.getInsets();
                        int components = parent.getComponentCount() - 1;
                        Dimension size = this.calculateSize(parent);
                        int lastWidth = parent.getComponent((int)components).getPreferredSize().width + JBUIScale.scale((int)50);
                        return new Dimension(insets.left + insets.right + components * size.width + lastWidth + components * this.hgap, insets.top + insets.bottom + size.height);
                    }

                    @NotNull
                    private Dimension calculateSize(@NotNull Container parent) {
                        if (parent == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        int components = parent.getComponentCount();
                        Dimension size = new Dimension();
                        for (int i = 0; i < components; ++i) {
                            Component component = parent.getComponent(i);
                            Dimension d = component.getPreferredSize();
                            if (size.width < d.width) {
                                size.width = d.width;
                            }
                            if (size.height >= d.height) continue;
                            size.height = d.height;
                        }
                        Dimension dimension = size;
                        if (dimension == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return dimension;
                    }

                    @Override
                    public void layoutContainer(Container parent) {
                        Insets insets = parent.getInsets();
                        Dimension size = this.calculateSize(parent);
                        int index = parent.getComponentCount() - 1;
                        Component lastButton = parent.getComponent(index--);
                        int lastWidth = lastButton.getPreferredSize().width;
                        int x = parent.getWidth() - insets.right - lastWidth;
                        int y = insets.top;
                        lastButton.setBounds(x, y, lastWidth, size.height);
                        while (index >= 0) {
                            parent.getComponent(index--).setBounds(x -= this.hgap + size.width, y, size.width, size.height);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "parent";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/cloudConfig/CloudConfigUi$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/cloudConfig/CloudConfigUi$1$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "calculateSize";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "calculateSize";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
                NonOpaquePanel nonOpaquePanel = panel;
                if (nonOpaquePanel == null) {
                    1.$$$reportNull$$$0(1);
                }
                return nonOpaquePanel;
            }

            protected JComponent createNorthPanel() {
                if (SystemInfo.isMac && !this.myMessage.contains("\n")) {
                    JPanel panel = this.createIconPanel();
                    JPanel messagePanel = new JPanel((LayoutManager)new VerticalLayout(12));
                    messagePanel.add(new JLabel(this.myMessage));
                    messagePanel.add(this.createCheckComponent());
                    panel.add((Component)messagePanel, "Center");
                    return panel;
                }
                return super.createNorthPanel();
            }

            @NotNull
            protected JComponent createCheckComponent() {
                JComponent component = super.createCheckComponent();
                this.applyCheckboxBorder(component);
                if (secondCheckboxProvider != null) {
                    JPanel panel = new JPanel((LayoutManager)new VerticalLayout(SystemInfo.isWindows ? 0 : 12));
                    panel.add(component);
                    JCheckBox checkBox = (JCheckBox)secondCheckboxProvider.compute();
                    this.applyCheckboxBorder(checkBox);
                    panel.add(checkBox);
                    JPanel jPanel = panel;
                    if (jPanel == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return jPanel;
                }
                JComponent jComponent = component;
                if (jComponent == null) {
                    1.$$$reportNull$$$0(3);
                }
                return jComponent;
            }

            private void applyCheckboxBorder(@NotNull JComponent component) {
                if (component == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (SystemInfo.isWindows) {
                    int top = JBUIScale.scale((int)7);
                    int bottom = StartupUiUtil.isUnderDarcula() ? 0 : top;
                    component.setBorder(BorderFactory.createEmptyBorder(top, 0, bottom, 0));
                } else if (SystemInfo.isMac && this.myMessage.contains("\n")) {
                    int offset = JBUIScale.scale((int)(StartupUiUtil.isUnderDarcula() ? 6 : 7));
                    component.setBorder(BorderFactory.createEmptyBorder(offset, 0, offset, 0));
                } else if (SystemInfo.isLinux) {
                    component.setBorder(BorderFactory.createEmptyBorder(JBUIScale.scale((int)7), 0, 0, 0));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "buttons";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/cloudConfig/CloudConfigUi$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/cloudConfig/CloudConfigUi$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createButtonsPanel";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCheckComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createButtonsPanel";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "applyCheckboxBorder";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        dialog.show();
        return dialog.getExitCode();
    }

    static void showLoginDialog() {
        CloudConfigLoginDialog dialog = new CloudConfigLoginDialog(CloudConfigManager.getInstance().isLocalConnected());
        if (dialog.showAndGet()) {
            CloudConfigManager.getInstance().updateClient();
        }
    }

    static void showOfflineMessage() {
        Messages.showInfoMessage((String)CloudConfigBundle.message("offline.dialog.message", new Object[0]), (String)CloudConfigBundle.message("offline.dialog.title", new Object[0]));
    }

    static void showErrorMessage(@NlsContexts.DialogMessage @Nullable String message) {
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            message = CloudConfigBundle.message("default.error.message", new Object[0]);
        }
        CloudConfigUi.showErrorMessage(message, CloudConfigBundle.message("error.message.title", new Object[0]));
    }

    private static void showErrorMessage(@NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title) {
        if (message == null) {
            CloudConfigUi.$$$reportNull$$$0(5);
        }
        if (title == null) {
            CloudConfigUi.$$$reportNull$$$0(6);
        }
        Messages.showErrorDialog((String)message, (String)title);
    }

    static void showUpdateApiDialog() {
        int exitCode = Messages.showOkCancelDialog((String)CloudConfigBundle.message("update.api.dialog.message", new Object[0]), (String)CloudConfigBundle.message("dialog.title.general", new Object[0]), (String)CloudConfigBundle.message("update.api.dialog.button", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getInformationIcon());
        if (exitCode == 0) {
            CloudConfigManager.getInstance().doUpdateApi();
        }
    }

    static void showUpdateApiNotification() {
        Notification notification = new Notification(NotificationGroupHolder.GROUP.getDisplayId(), CloudConfigBundle.message("notification.title.general", new Object[0]), CloudConfigBundle.message("update.api.notification.message", new Object[0]), NotificationType.INFORMATION);
        notification.setIcon(AllIcons.General.Settings);
        notification.addAction((AnAction)new NotificationAction(CloudConfigBundle.message("update.api.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                notification.expire();
                CloudConfigUi.showUpdateApiDialog();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/cloudConfig/CloudConfigUi$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.notify(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okButtonKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBoxKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cloudConfig/CloudConfigUi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cloudConfig/CloudConfigUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "showDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showCheckboxDialog";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class NotificationGroupHolder {
        static final NotificationGroup GROUP = new NotificationGroup("JBA Cloud Config", NotificationDisplayType.STICKY_BALLOON, true);

        NotificationGroupHolder() {
        }
    }

    static enum DialogWithCheckboxResult {
        YES_WITH_EXTRA_OPTION,
        YES_WITHOUT_EXTRA_OPTION,
        NO;

    }
}

