/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.performance;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.performancePlugin.commands.Waiter;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class OCWaitForSymbolsCommand
extends AbstractCommand {
    public static final String PREFIX = "%waitForSymbols";
    private static final Logger LOG = Logger.getInstance(OCWaitForSymbolsCommand.class);

    public OCWaitForSymbolsCommand(String text, int line) {
        super(text, line);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        AsyncPromise result = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean success;
            try {
                success = Waiter.checkCondition(() -> OCWaitForSymbolsCommand.areSymbolsReady(context.getProject())).await(10L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                result.setError((Throwable)e);
                LOG.debug((Throwable)e);
                return;
            }
            result.setResult((Object)success);
        });
        return result;
    }

    private static boolean areSymbolsReady(@NotNull Project project) {
        if (project == null) {
            OCWaitForSymbolsCommand.$$$reportNull$$$0(0);
        }
        return FileSymbolTablesCache.areSymbolsLoaded((Project)project) && CidrWorkspaceManager.getInstance((Project)project).getModelsLoaded() && !DumbService.isDumb((Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/performance/OCWaitForSymbolsCommand", "areSymbolsReady"));
    }
}

