/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.visiting;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class ClosingBracesFilter
extends MethodVisitingFilter {
    private boolean myHasInstructions;
    private boolean myHasLines;
    private boolean mySeenLineBefore;
    private int myCurrentLine;

    public void initFilter(MethodVisitor methodVisitor, Instrumenter context, String desc) {
        super.initFilter(methodVisitor, context, desc);
        this.myHasInstructions = false;
        this.myHasLines = false;
        this.mySeenLineBefore = false;
        this.myCurrentLine = -1;
    }

    private void removeEmptyLine() {
        if (this.myHasLines && !this.myHasInstructions && !this.mySeenLineBefore) {
            this.myContext.removeLine(this.myCurrentLine);
        }
    }

    public void visitLineNumber(int line, Label start) {
        this.removeEmptyLine();
        this.mySeenLineBefore = this.myContext.getLineData(line) != null;
        super.visitLineNumber(line, start);
        this.myHasLines = true;
        this.myHasInstructions = false;
        this.myCurrentLine = line;
    }

    public void visitEnd() {
        this.removeEmptyLine();
        super.visitEnd();
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (!this.myHasLines) {
            return;
        }
        if (opcode != 177) {
            this.myHasInstructions = true;
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.setHasInstructions();
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.setHasInstructions();
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        this.setHasInstructions();
    }

    public void visitLdcInsn(Object value) {
        super.visitLdcInsn(value);
        this.setHasInstructions();
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.setHasInstructions();
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.setHasInstructions();
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
        this.setHasInstructions();
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        this.setHasInstructions();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        super.visitFieldInsn(opcode, owner, name, descriptor);
        this.setHasInstructions();
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.setHasInstructions();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        this.setHasInstructions();
    }

    private void setHasInstructions() {
        if (this.myHasLines) {
            this.myHasInstructions = true;
        }
    }

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return true;
    }
}

