/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.testTracking;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.ExtraFieldInstrumenter;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.LineEnumerator;
import com.intellij.rt.coverage.instrumentation.LocalVariableInserter;
import com.intellij.rt.coverage.instrumentation.NewTracingInstrumenter;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

class TestTrackingClassDataInstrumenter
extends NewTracingInstrumenter {
    protected static final String CLASS_DATA_FIELD_NAME = "__$classData$__";
    protected static final String CLASS_DATA_FIELD_TYPE = "Ljava/lang/Object;";
    private static final String CLASS_DATA_FIELD_INIT_NAME = "__$classDataInit$__";
    private static final String CLASS_DATA_LOCAL_VARIABLE_NAME = "__$classDataLocal$__";
    private static final String CLASS_INIT = "<clinit>";
    protected final ExtraFieldInstrumenter myExtraClassDataFieldInstrumenter;

    public TestTrackingClassDataInstrumenter(ProjectData projectData, ClassVisitor classVisitor, ClassReader cr, String className, boolean shouldCalculateSource) {
        super(projectData, classVisitor, cr, className, shouldCalculateSource);
        this.myExtraClassDataFieldInstrumenter = new ExtraClassDataFieldTestTrackingInstrumenter(cr, className);
    }

    public MethodVisitor createTouchCounter(MethodVisitor mv, BranchDataContainer branchData, LineEnumerator enumerator, int access, String name, String desc, String className) {
        mv = super.createTouchCounter(mv, branchData, enumerator, access, name, desc, className);
        return this.createMethodTransformer(mv, enumerator, access, name, desc);
    }

    protected MethodVisitor createMethodTransformer(MethodVisitor mv, LineEnumerator enumerator, int access, String name, String desc) {
        if (!enumerator.hasExecutableLines()) {
            if (this.myExtraClassDataFieldInstrumenter.isInterface() && CLASS_INIT.equals(name)) {
                return this.myExtraClassDataFieldInstrumenter.createMethodVisitor(this, mv, mv, name);
            }
            return mv;
        }
        LocalVariableInserter visitor = new LocalVariableInserter(mv, access, desc, CLASS_DATA_LOCAL_VARIABLE_NAME, CLASS_DATA_FIELD_TYPE){

            public void visitLineNumber(int line, Label start) {
                LineData lineData = TestTrackingClassDataInstrumenter.this.getLineData(line);
                if (lineData != null) {
                    this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
                    InstrumentationUtils.pushInt(this.mv, line);
                    this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "traceLine", "(Ljava/lang/Object;I)V", false);
                }
                super.visitLineNumber(line, start);
            }

            public void visitCode() {
                this.mv.visitFieldInsn(178, TestTrackingClassDataInstrumenter.this.myExtraClassDataFieldInstrumenter.getInternalClassName(), TestTrackingClassDataInstrumenter.CLASS_DATA_FIELD_NAME, TestTrackingClassDataInstrumenter.CLASS_DATA_FIELD_TYPE);
                this.mv.visitVarInsn(58, this.getOrCreateLocalVariableIndex());
                super.visitCode();
            }
        };
        return this.myExtraClassDataFieldInstrumenter.createMethodVisitor(this, mv, visitor, name);
    }

    public void visitEnd() {
        this.myExtraClassDataFieldInstrumenter.generateMembers(this);
        super.visitEnd();
    }

    private class ExtraClassDataFieldTestTrackingInstrumenter
    extends ExtraFieldInstrumenter {
        public ExtraClassDataFieldTestTrackingInstrumenter(ClassReader cr, String className) {
            super(cr, null, className, TestTrackingClassDataInstrumenter.CLASS_DATA_FIELD_NAME, TestTrackingClassDataInstrumenter.CLASS_DATA_FIELD_TYPE, TestTrackingClassDataInstrumenter.CLASS_DATA_FIELD_INIT_NAME, true);
        }

        public void initField(MethodVisitor mv) {
            mv.visitLdcInsn(TestTrackingClassDataInstrumenter.this.getClassName());
            mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "loadClassData", "(Ljava/lang/String;)Ljava/lang/Object;", false);
            mv.visitFieldInsn(179, TestTrackingClassDataInstrumenter.this.myExtraClassDataFieldInstrumenter.getInternalClassName(), TestTrackingClassDataInstrumenter.CLASS_DATA_FIELD_NAME, TestTrackingClassDataInstrumenter.CLASS_DATA_FIELD_TYPE);
        }
    }
}

