/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramFileType;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.diagram.actions.DiagramCreateNewNodeElementAction;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.messages.MessageBusListener;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import javax.swing.Icon;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramProvider<T> {
    @NotNull
    public static final ExtensionPointName<DiagramProvider<?>> DIAGRAM_PROVIDER = new ExtensionPointName("com.intellij.diagram.Provider");
    @NotNull
    public static final Key<Object> ORIGINAL_ELEMENT = Key.create((String)"diagram.original.element");
    @NotNull
    private static final DiagramColorManager DEFAULT_COLOR_MANAGER = new DiagramColorManagerBase();

    @NotNull
    @Pattern(value="[a-zA-Z0-9_-]*")
    public abstract String getID();

    @Nullable
    public static <T> DiagramProvider<T> findByID(@Nullable String id) {
        return (DiagramProvider)DIAGRAM_PROVIDER.findFirstSafe(it -> it.getID().equals(id));
    }

    @NotNull
    @NlsContexts.Label
    public abstract String getPresentableName();

    @NotNull
    @NlsContexts.Label
    public String getRefinedPresentableName(@Nullable T element, @NotNull Collection<T> additionalElements) {
        if (additionalElements == null) {
            DiagramProvider.$$$reportNull$$$0(0);
        }
        String string = this.getPresentableName();
        if (string == null) {
            DiagramProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getActionName(boolean isPopup) {
        String string = DiagramBundle.message("uml.action.name", new Object[0]);
        if (string == null) {
            DiagramProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Icon getActionIcon(boolean isPopup) {
        Icon icon = AllIcons.FileTypes.Diagram;
        if (icon == null) {
            DiagramProvider.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public abstract DiagramDataModel<T> createDataModel(@NotNull Project var1, @Nullable T var2, @Nullable VirtualFile var3, @NotNull DiagramPresentationModel var4);

    @NotNull
    public abstract DiagramVisibilityManager createVisibilityManager();

    @Nullable
    public DiagramScopeManager<T> createScopeManager(@NotNull Project project) {
        if (project == null) {
            DiagramProvider.$$$reportNull$$$0(4);
        }
        return null;
    }

    @NotNull
    public DiagramNodeContentManager createNodeContentManager() {
        Logger.getInstance(DiagramProvider.class).warn("createNodeContentManager should be overriden to return new instance each time");
        DiagramNodeContentManager diagramNodeContentManager = this.getNodeContentManager();
        if (diagramNodeContentManager == null) {
            DiagramProvider.$$$reportNull$$$0(5);
        }
        return diagramNodeContentManager;
    }

    @Nullable
    public DiagramPresentationModel createPresentationModel(@NotNull Project project, @NotNull Graph2D graph) {
        if (project == null) {
            DiagramProvider.$$$reportNull$$$0(6);
        }
        if (graph == null) {
            DiagramProvider.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @NotNull
    public DiagramNodeContentManager getNodeContentManager() {
        DiagramNodeContentManager diagramNodeContentManager = this.createNodeContentManager();
        if (diagramNodeContentManager == null) {
            DiagramProvider.$$$reportNull$$$0(8);
        }
        return diagramNodeContentManager;
    }

    public DiagramCategory @NotNull [] getAllContentCategories() {
        DiagramNodeContentManager deprecatedGlobalContentManager = this.getNodeContentManager();
        DiagramCategory[] diagramCategoryArray = deprecatedGlobalContentManager.getContentCategories();
        if (diagramCategoryArray == null) {
            DiagramProvider.$$$reportNull$$$0(9);
        }
        return diagramCategoryArray;
    }

    @NotNull
    public abstract DiagramElementManager<T> getElementManager();

    @NotNull
    public abstract DiagramVfsResolver<T> getVfsResolver();

    @NotNull
    public DiagramColorManager getColorManager() {
        DiagramColorManager diagramColorManager = DEFAULT_COLOR_MANAGER;
        if (diagramColorManager == null) {
            DiagramProvider.$$$reportNull$$$0(10);
        }
        return diagramColorManager;
    }

    @NotNull
    public DiagramExtras<T> getExtras() {
        return new DiagramExtras();
    }

    @NotNull
    public abstract DiagramRelationshipManager<T> getRelationshipManager();

    @Nullable
    public DiagramEdgeCreationPolicy<T> getEdgeCreationPolicy() {
        return null;
    }

    public AnAction @NotNull [] getCreateNewActions() {
        if (DiagramCreateNewElementAction.EMPTY == null) {
            DiagramProvider.$$$reportNull$$$0(11);
        }
        return DiagramCreateNewElementAction.EMPTY;
    }

    public AnAction @NotNull [] getCreateNewNodeElementActions() {
        if (DiagramCreateNewNodeElementAction.EMPTY == null) {
            DiagramProvider.$$$reportNull$$$0(12);
        }
        return DiagramCreateNewNodeElementAction.EMPTY;
    }

    public DiagramNodeIntentionAction<T> @NotNull [] getNodeIntentionActions() {
        if (DiagramNodeIntentionAction.EMPTY == null) {
            DiagramProvider.$$$reportNull$$$0(13);
        }
        return DiagramNodeIntentionAction.EMPTY;
    }

    @Nullable
    public MessageBusListener<?> getMessageBusListener(final @NotNull Project project, final @NotNull Graph2D graph) {
        if (project == null) {
            DiagramProvider.$$$reportNull$$$0(14);
        }
        if (graph == null) {
            DiagramProvider.$$$reportNull$$$0(15);
        }
        return new MessageBusListener<PsiDocumentTransactionListener>(){

            @NotNull
            public Topic<PsiDocumentTransactionListener> getTopic() {
                Topic topic = PsiDocumentTransactionListener.TOPIC;
                if (topic == null) {
                    1.$$$reportNull$$$0(0);
                }
                return topic;
            }

            @NotNull
            public PsiDocumentTransactionListener getListener() {
                return new PsiDocumentTransactionListener(){

                    public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file) {
                        if (doc == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (file == null) {
                            1.$$$reportNull$$$0(1);
                        }
                    }

                    public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile file) {
                        if (doc == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (file == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        for (VirtualFile vf : FileEditorManager.getInstance((Project)project).getSelectedFiles()) {
                            if (!FileTypeRegistry.getInstance().isFileOfType(vf, (FileType)DiagramFileType.INSTANCE)) continue;
                            graph.updateViews();
                            return;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "doc";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/diagram/DiagramProvider$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "transactionStarted";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "transactionCompleted";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramProvider$1", "getTopic"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramProvider";
                break;
            }
            case 4: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefinedPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeContentManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeContentManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContentCategories";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateNewActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateNewNodeElementActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeIntentionActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRefinedPresentableName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createScopeManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPresentationModel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMessageBusListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

