/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class DiagramIntentionAction
extends DiagramAction {
    private static final Logger LOG = Logger.getInstance(DiagramIntentionAction.class);

    protected DiagramIntentionAction() {
        super(DiagramBundle.message("show.intentions.for.node", new Object[0]), null, null);
    }

    @Override
    public void perform(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramIntentionAction.$$$reportNull$$$0(0);
        }
        if ((builder = DiagramIntentionAction.getBuilder(e)) == null) {
            return;
        }
        DiagramNode node = DiagramIntentionAction.getSelectedNodes(e).get(0);
        ArrayList actions = new ArrayList();
        for (DiagramNodeIntentionAction<?> action : builder.getProvider().getNodeIntentionActions()) {
            if (!action.isEnabled(e, builder)) continue;
            actions.add(action);
        }
        JBList list = new JBList(actions);
        list.installCellRenderer(obj -> {
            Presentation presentation = obj.getTemplatePresentation();
            String actionText = presentation.getText();
            LOG.assertTrue(actionText != null, (Object)obj);
            String text = StringUtil.capitalize((String)StringUtil.wordsToBeginFromLowerCase((String)actionText));
            Icon icon = presentation.getIcon();
            JLabel label = new JLabel(text, icon == null ? AllIcons.Actions.IntentionBulb : icon, 2);
            label.setBorder((Border)JBUI.Borders.empty((int)4, (int)4, (int)4, (int)10));
            return label;
        });
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setAutoselectOnMouseMove(true).setItemChoosenCallback(() -> {
            DiagramNodeIntentionAction value = (DiagramNodeIntentionAction)((Object)((Object)list.getSelectedValue()));
            if (value != null) {
                value.perform(node, builder);
            }
        }).createPopup();
        GraphCanvasLocationService.getInstance().showPopupBeneathNode(popup, builder.getGraphBuilder(), Objects.requireNonNull(builder.getNode(node)));
    }

    @Override
    public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            DiagramIntentionAction.$$$reportNull$$$0(1);
        }
        for (DiagramNodeIntentionAction<?> action : b.getProvider().getNodeIntentionActions()) {
            if (!action.isEnabled(e, b)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramIntentionAction.$$$reportNull$$$0(2);
        }
        return false;
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("show.intentions.for.node", new Object[0]);
        if (string == null) {
            DiagramIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/actions/DiagramIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/actions/DiagramIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

