/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.components.DiagramNodeItemComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.RepaintManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramNodeBodyComponent
extends JBList<Object>
implements ListCellRenderer<Object> {
    @NotNull
    private static final String ourRepaintManagerClassName;
    @NotNull
    private static final JComponent ourSeparatorComponent;
    @NotNull
    private final DiagramNodeItemComponent myItemComponent;
    @NotNull
    private final DiagramBuilder myBuilder;
    @NotNull
    private final Point myBasePoint;
    @NotNull
    private final DiagramNode myNode;

    public DiagramNodeBodyComponent(@NotNull DiagramNode node, @NotNull DiagramBuilder builder, @NotNull Point point) {
        if (node == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(1);
        }
        if (point == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(2);
        }
        super(DiagramNodeBodyComponent.getNodeItems(node.getIdentifyingElement(), builder));
        this.myItemComponent = new DiagramNodeItemComponent();
        this.myNode = node;
        this.myBuilder = builder;
        this.myBasePoint = point;
        this.disableEmptyText();
        this.setCellRenderer(this);
        this.setOpaque(true);
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                int index;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DiagramNodeBodyComponent.this.getSelectedValue() == null && (index = DiagramNodeBodyComponent.this.getSelectedIndex()) != -1) {
                    DiagramNodeBodyComponent.this.setSelectedIndex(index + (e.getLastIndex() == index ? 1 : -1));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagram/components/DiagramNodeBodyComponent$1", "valueChanged"));
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (this.myIsEngaged && !DiagramNodeBodyComponent.this.getComponentPopupMenu().isVisible()) {
                    Point point = e.getPoint();
                    int index = DiagramNodeBodyComponent.this.locationToIndex(point);
                    DiagramNodeBodyComponent.this.setSelectedIndex(index);
                } else {
                    this.myIsEngaged = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagram/components/DiagramNodeBodyComponent$2", "mouseMoved"));
            }
        });
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Uml.NodeCellEditorPopup");
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("StructureViewPopup", group);
        this.setComponentPopupMenu(menu.getComponent());
        this.setExpandableItemsEnabled(false);
    }

    public Dimension getPreferredSize() {
        return this.super_getPreferredSize();
    }

    @Override
    public Component getListCellRendererComponent(JList list, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            ourSeparatorComponent.setBackground(this.getSeparatorColor());
            return ourSeparatorComponent;
        }
        this.myItemComponent.setUp(this.myBuilder, this.myNode, value, isSelected);
        this.myItemComponent.setSelected(isSelected);
        return this.myItemComponent;
    }

    @NotNull
    public Point getPopupLocation(@NotNull MouseEvent event) {
        if (event == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(3);
        }
        Point p = this.myBuilder.getView().getCanvasComponent().getLocationOnScreen();
        return new Point(this.myBasePoint.x - p.x + event.getX(), this.myBasePoint.y - p.y + event.getY());
    }

    @NotNull
    private Color getSeparatorColor() {
        boolean isSelectedByUser = this.myBuilder.getGraph().isSelected(this.myBuilder.getNode(this.myNode));
        Color color = this.myBuilder.getProvider().getColorManager().getNodeBorderColor(this.myBuilder, this.myNode, isSelectedByUser);
        if (color == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(4);
        }
        return color;
    }

    /*
     * Could not resolve type clashes
     */
    public static Object @NotNull [] getNodeItems(Object element, @NotNull DiagramBuilder builder) {
        DiagramNodeContentManager localNodeContentManager;
        if (builder == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(5);
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        DiagramProvider<?> umlProvider = builder.getProvider();
        DiagramDataModel<?> dataModel = builder.getDataModel();
        DiagramVisibilityManager visibilityManager = dataModel.getVisibilityManager();
        VisibilityLevel visibility = visibilityManager.getCurrentVisibilityLevel();
        Comparator<VisibilityLevel> visibilityComparator = visibilityManager.getComparator();
        DiagramNodeContentManager nodeContentManager = localNodeContentManager = dataModel.getNodeContentManager();
        DiagramCategory[] allCategories = localNodeContentManager.getContentCategories();
        List<DiagramCategory> enabledCategories = Arrays.asList(nodeContentManager.getEnabledCategories());
        Object[] items = umlProvider.getElementManager().getNodeItems(element);
        if (allCategories.length != 0) {
            for (DiagramCategory category : allCategories) {
                if (!enabledCategories.contains(category)) continue;
                ArrayList<Object> nodeElements = new ArrayList<Object>();
                for (Object elem : items) {
                    if (!nodeContentManager.isInCategory(elem, category)) continue;
                    nodeElements.add(elem);
                }
                if (nodeElements.isEmpty()) continue;
                boolean added = false;
                for (Object nodeElement : nodeElements) {
                    VisibilityLevel level = visibilityManager.getVisibilityLevel(nodeElement);
                    if (visibilityComparator.compare(level, visibility) > 0) continue;
                    elements.add(nodeElement);
                    added = true;
                }
                if (!added) continue;
                elements.add(null);
            }
        } else {
            elements.addAll(Arrays.asList(items));
        }
        if (!elements.isEmpty() && elements.get(elements.size() - 1) == null) {
            elements.remove(elements.size() - 1);
        }
        Object[] objectArray = ArrayUtil.toObjectArray(elements);
        if (objectArray == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    public void revalidate() {
        block5: {
            RepaintManager manager = RepaintManager.currentManager((JComponent)((Object)this));
            if (manager != null && !ourRepaintManagerClassName.equals(manager.getClass().getName())) {
                try {
                    RepaintManager originalManager = (RepaintManager)ReflectionUtil.getField(manager.getClass(), (Object)manager, RepaintManager.class, (String)"b");
                    if (originalManager == null) {
                        super.revalidate();
                        break block5;
                    }
                    originalManager.addInvalidComponent((JComponent)((Object)this));
                    this.invalidate();
                }
                catch (Throwable ignored) {
                    super.revalidate();
                }
            } else {
                super.revalidate();
            }
        }
    }

    static {
        ourSeparatorComponent = new JPanel();
        ourSeparatorComponent.setBackground((Color)JBColor.GRAY);
        ourSeparatorComponent.setPreferredSize(new Dimension(-1, 1));
        ourSeparatorComponent.putClientProperty("IgnoreListRowHeight", Boolean.TRUE);
        ourRepaintManagerClassName = RepaintManager.currentManager(ourSeparatorComponent).getClass().getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/DiagramNodeBodyComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/DiagramNodeBodyComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorColor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPopupLocation";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNodeItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

