/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.components.UmlGraphZoomableViewport;
import com.intellij.uml.core.actions.ShowDiagramBase;
import com.intellij.uml.utils.DiagramBundle;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiagramPopup
extends ShowDiagramBase
implements PopupAction {
    private static final @NonNls String @NotNull [] ACTIONS = new String[]{"Uml.ShowSubtypes", "Uml.ShowSupers", "Uml.ShowUsed", "EditSource"};

    @Override
    protected boolean isPopup() {
        return true;
    }

    @Override
    @NotNull
    @NonNls
    public String getFeatureId() {
        return "diagram.show.popup";
    }

    @NotNull
    @Nls
    protected String getTitle(@NotNull Project project, @Nullable Object element, @NotNull DiagramProvider<Object> provider, @NotNull DiagramState presentation, @NotNull Collection<Object> additionalElements) {
        if (project == null) {
            ShowDiagramPopup.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            ShowDiagramPopup.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            ShowDiagramPopup.$$$reportNull$$$0(2);
        }
        if (additionalElements == null) {
            ShowDiagramPopup.$$$reportNull$$$0(3);
        }
        String string = DiagramBundle.message("show.diagram.popup.title", provider.getActionName(this.isPopup()), provider.getElementManager().getEditorTitle(element, additionalElements));
        if (string == null) {
            ShowDiagramPopup.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private JBPopup getPopup(@Nullable Object element, @NotNull Collection<Object> elements, @NotNull DiagramBuilder builder) {
        if (elements == null) {
            ShowDiagramPopup.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            ShowDiagramPopup.$$$reportNull$$$0(6);
        }
        Ref popupRef = Ref.create();
        Project project = builder.getProject();
        Graph2DView view = builder.getView();
        JComponent focusTarget = view.getJComponent();
        PopupUpdateProcessor updateProcessor = this.createUpdateProcessor(builder, project, (Ref<JBPopup>)popupRef);
        UmlGraphZoomableViewport viewport = new UmlGraphZoomableViewport(builder);
        String title = this.getTitle(project, element, builder.getProvider(), builder.getPresentation(), elements);
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)viewport), focusTarget).setResizable(true).setFocusable(true).setMovable(true).setMayBeParent(true).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setTitle(title).setTitleIcon(new ActiveIcon(AllIcons.FileTypes.Diagram, AllIcons.FileTypes.Diagram)).setCancelOnOtherWindowOpen(false).setCancelOnWindowDeactivation(false).setRequestFocus(!this.isCalledFromJList()).createPopup();
        popupRef.set((Object)popup);
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            ShowDiagramPopup.$$$reportNull$$$0(7);
        }
        return jBPopup;
    }

    @Override
    @Nullable
    protected Runnable showReadyDiagramCallback(@Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull DiagramBuilder builder, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @NotNull RelativePoint popupLocation) {
        if (additionalElements == null) {
            ShowDiagramPopup.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            ShowDiagramPopup.$$$reportNull$$$0(9);
        }
        if (file == null) {
            ShowDiagramPopup.$$$reportNull$$$0(10);
        }
        if (popupLocation == null) {
            ShowDiagramPopup.$$$reportNull$$$0(11);
        }
        return () -> {
            JBPopup popup = this.getPopup(element, additionalElements, builder);
            Disposer.register((Disposable)popup, (Disposable)builder);
            DiagramUtils.setBestPopupSizeForGraph(popup, builder);
            builder.setPopup(popup);
            popup.show(popupLocation);
            if (this.isCalledFromJList()) {
                PopupPositionManager.positionPopupInBestPosition((JBPopup)popup, null, null);
            }
        };
    }

    @Override
    @Nullable
    protected Runnable afterDiagramIsShownCallback(@Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull DiagramBuilder builder, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @NotNull RelativePoint popupLocation) {
        if (additionalElements == null) {
            ShowDiagramPopup.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            ShowDiagramPopup.$$$reportNull$$$0(13);
        }
        if (file == null) {
            ShowDiagramPopup.$$$reportNull$$$0(14);
        }
        if (popupLocation == null) {
            ShowDiagramPopup.$$$reportNull$$$0(15);
        }
        return () -> {
            builder.update(false, true);
            builder.getGraphBuilder().fitContent(false);
            builder.getDataModel().getNodes().stream().filter(it -> it.getIdentifyingElement().equals(element)).findFirst().ifPresent(it -> builder.setSelected((DiagramNode<?>)it, true));
            Graph2DView view = builder.getView();
            this.registerUmlActionsOnComponent(view.getJComponent());
            GraphViewUtil.addDataProvider((Graph2DView)view, dataId -> UmlFileEditorImpl.getData(dataId, builder));
            ShowDiagramPopup.run(super.afterDiagramIsShownCallback(element, additionalElements, builder, file, popupLocation));
        };
    }

    @NotNull
    private PopupUpdateProcessor createUpdateProcessor(final @NotNull DiagramBuilder builder, final @NotNull Project project, final @NotNull Ref<JBPopup> popupRef) {
        if (builder == null) {
            ShowDiagramPopup.$$$reportNull$$$0(16);
        }
        if (project == null) {
            ShowDiagramPopup.$$$reportNull$$$0(17);
        }
        if (popupRef == null) {
            ShowDiagramPopup.$$$reportNull$$$0(18);
        }
        return new PopupUpdateProcessor(project){

            public void updatePopup(@Nullable Object o) {
                PsiElement element = o instanceof PsiElement ? (PsiElement)o : null;
                Module module = o instanceof Module ? (Module)o : null;
                DataContext context = dataId -> {
                    if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                        return element;
                    }
                    if (LangDataKeys.MODULE.is(dataId) || LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                        return module;
                    }
                    return null;
                };
                Object newObj = builder.getProvider().getElementManager().findInDataContext(context);
                JBPopup popup = (JBPopup)popupRef.get();
                if (newObj != null) {
                    builder.getDataModel().rebuild(newObj);
                    builder.update(true, true);
                    builder.relayout();
                    builder.getGraphBuilder().fitContent(false);
                    if (popup instanceof AbstractPopup) {
                        popup.setCaption(ShowDiagramPopup.this.getTitle(project, newObj, builder.getProvider(), builder.getPresentation(), Collections.emptyList()));
                    }
                    Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    DiagramUtils.setBestPopupSizeForGraph(popup, builder);
                    if (focusOwner instanceof JComponent) {
                        PopupPositionManager.positionPopupInBestPosition((JBPopup)popup, null, null);
                    }
                }
            }
        };
    }

    protected void registerUmlActionsOnComponent(@Nullable JComponent component) {
        ActionManager manager = ActionManager.getInstance();
        for (String actionId : ACTIONS) {
            AnAction action = manager.getAction(actionId);
            if (action == null) continue;
            action.registerCustomShortcutSet(action.getShortcutSet(), component);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/ShowDiagramPopup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupLocation";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/ShowDiagramPopup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPopup";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showReadyDiagramCallback";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "afterDiagramIsShownCallback";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateProcessor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

