/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.diff;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uml.diff.UmlDiffElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DiffUmlElementManager
extends AbstractDiagramElementManager<UmlDiffElement> {
    DiffUmlElementManager() {
    }

    @Override
    @Nullable
    public UmlDiffElement findInDataContext(@NotNull DataContext context) {
        if (context == null) {
            DiffUmlElementManager.$$$reportNull$$$0(0);
        }
        VcsFileRevision revision = (VcsFileRevision)VcsDataKeys.VCS_FILE_REVISION.getData(context);
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (revision == null || project == null || virtualFile == null) {
            return null;
        }
        VirtualFile dir = virtualFile.getParent();
        if (dir == null) {
            return null;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(dir);
        if (vcs == null) {
            return null;
        }
        return new UmlDiffElement(vcs, revision, virtualFile);
    }

    @Override
    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof UmlDiffElement;
    }

    @Override
    public Object @NotNull [] getNodeItems(UmlDiffElement parent) {
        Object[] objectArray = parent.getChanges();
        if (objectArray == null) {
            DiffUmlElementManager.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @Override
    public String getElementTitle(UmlDiffElement element) {
        return element.getNodeName();
    }

    @Override
    public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            DiffUmlElementManager.$$$reportNull$$$0(2);
        }
        if (element instanceof UmlDiffElement) {
            UmlDiffElement diffElement = (UmlDiffElement)element;
            return new SimpleColoredText(diffElement.getNodeName(), new SimpleTextAttributes(1, diffElement.getNodeStatus().getColor()));
        }
        if (element instanceof UmlDiffElement.NodeElementHolder) {
            return ((UmlDiffElement.NodeElementHolder)element).getName();
        }
        return null;
    }

    @Override
    @Nullable
    public SimpleColoredText getItemType(@Nullable Object element) {
        if (element instanceof UmlDiffElement.NodeElementHolder) {
            return ((UmlDiffElement.NodeElementHolder)element).getType();
        }
        return null;
    }

    @Override
    @Nullable
    @Nls
    public String getNodeTooltip(UmlDiffElement element) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/diff/DiffUmlElementManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/diff/DiffUmlElementManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

