/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.diff;

import com.intellij.CommonBundle;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramChangesProvider;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PaintingParent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.components.UmlGraphZoomableViewport;
import com.intellij.uml.core.actions.ShowDiagramPopup;
import com.intellij.uml.diff.DiffUmlDataModel;
import com.intellij.uml.diff.DiffUmlProvider;
import com.intellij.uml.diff.UmlDiffElement;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.uml.utils.UmlUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShowDiffOnUmlAction
extends ShowDiagramPopup {
    public static final int MAX_CHANGES = 50;
    private static final Map<String, Boolean> SUPPORTED = new HashMap<String, Boolean>();

    ShowDiffOnUmlAction() {
    }

    @Override
    public DiagramProvider<?> getForcedProvider(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(0);
        }
        return DiffUmlProvider.INSTANCE;
    }

    @Override
    @NotNull
    @NonNls
    public String getFeatureId() {
        return "diagrams.show.diff";
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull Project project, @Nullable Object element, @NotNull DiagramProvider<Object> provider, @NotNull DiagramState presentation, @NotNull Collection<Object> additionalElements) {
        if (project == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(2);
        }
        if (presentation == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(3);
        }
        if (additionalElements == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(4);
        }
        VcsRevisionNumber number = ((UmlDiffElement)Objects.requireNonNull(element)).getRevision().getRevisionNumber();
        String string = DiagramBundle.message("changes.for.revision.0", number.asString());
        if (string == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        AbstractVcs vcs;
        if (e == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(6);
        }
        VcsFileRevision[] revisions = (VcsFileRevision[])e.getData(VcsDataKeys.VCS_FILE_REVISIONS);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile dir = virtualFile != null ? virtualFile.getParent() : null;
        Project project = e.getProject();
        if (project != null && dir != null && revisions != null && revisions.length == 1 && revisions[0] != null && !DumbService.isDumb((Project)project) && (vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(dir)) != null) {
            String name = vcs.getName();
            if (!SUPPORTED.containsKey(name)) {
                try {
                    SUPPORTED.put(name, vcs.getCommittedChangesProvider() != null);
                }
                catch (Exception exc) {
                    SUPPORTED.put(name, false);
                }
            }
            e.getPresentation().setEnabled(SUPPORTED.get(name).booleanValue());
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    @Override
    protected Runnable show(@NotNull Project project, @NotNull DiagramProvider<Object> provider, @Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull RelativePoint popupLocation) {
        UmlDiffElement diffElement;
        CommittedChangeList changeList;
        if (project == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(7);
        }
        if (provider == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(8);
        }
        if (additionalElements == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(9);
        }
        if (popupLocation == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(10);
        }
        if (element instanceof UmlDiffElement && (changeList = (diffElement = (UmlDiffElement)element).getVcs().loadRevisions(diffElement.getInitialVirtualFile(), diffElement.getRevision().getRevisionNumber())) != null) {
            Collection changes = changeList.getChanges();
            if (changes != null && changes.size() <= 50) {
                return super.show(project, provider, element, additionalElements, popupLocation);
            }
            return () -> Messages.showErrorDialog((String)DiagramBundle.message("dialog.message.can.t.show.more.than.0.changes.at.one.diagram", 50), (String)CommonBundle.getErrorTitle());
        }
        return super.show(project, provider, element, additionalElements, popupLocation);
    }

    @Override
    @NotNull
    protected Runnable showReadyDiagramCallback(@Nullable Object element, @NotNull Collection<Object> additionalElements, final @NotNull DiagramBuilder builder, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @NotNull RelativePoint popupLocation) {
        if (additionalElements == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(12);
        }
        if (file == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(13);
        }
        if (popupLocation == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(14);
        }
        final UmlGraphZoomableViewport viewport = new UmlGraphZoomableViewport(builder);
        final String title = this.getTitle(builder.getProject(), element, builder.getProvider(), builder.getPresentation(), additionalElements);
        Runnable runnable = () -> {
            UmlUtils.updateAfterCategoryChange(builder);
            builder.getGraphBuilder().fitContent(true);
            builder.getGraphBuilder().setZoom(1.0);
            Dimension size = DiagramUtils.calcGraphSize(builder);
            DialogWrapper dialog = new DialogWrapper(builder.getProject()){
                {
                    super(arg0);
                    this.init();
                    this.setTitle(title);
                    this.setModal(false);
                    Disposer.register((Disposable)this.getDisposable(), (Disposable)builder);
                }

                protected JComponent createCenterPanel() {
                    return new PaintingParent.Wrapper((Component)((Object)viewport)){

                        public void paint(Graphics g) {
                            if (StartupUiUtil.isUnderDarcula()) {
                                // empty if block
                            }
                            super.paint(g);
                        }
                    };
                }

                protected Border createContentPaneBorder() {
                    return JBUI.Borders.empty();
                }

                public JComponent getPreferredFocusedComponent() {
                    return builder.getView().getCanvasComponent();
                }

                protected JComponent createSouthPanel() {
                    return null;
                }

                protected void dispose() {
                    if (!Disposer.isDisposed((Disposable)builder)) {
                        Disposer.dispose((Disposable)builder);
                    }
                    this.close(1);
                    super.dispose();
                }
            };
            DiagramChangesProvider.EP.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DiagramChangesProvider>(dialog){
                final /* synthetic */ 1 val$dialog;
                {
                    this.val$dialog = var3_3;
                }

                public void extensionRemoved(@NotNull DiagramChangesProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                    DiffUmlDataModel dataModel;
                    if (extension == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (pluginDescriptor == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ((dataModel = (DiffUmlDataModel)builder.getDataModel()).containsChangeProvider(extension)) {
                        this.val$dialog.doCancelAction();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "extension";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/uml/diff/ShowDiffOnUmlAction$2";
                    objectArray[2] = "extensionRemoved";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)builder);
            dialog.show();
            dialog.setSize(size.width + 20, size.height + 40);
            dialog.validate();
            builder.getGraphBuilder().setZoom(1.0);
        };
        if (runnable == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(15);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/diff/ShowDiffOnUmlAction";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupLocation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/diff/ShowDiffOnUmlAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "showReadyDiagramCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getForcedProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 5: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showReadyDiagramCallback";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

