/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.project;

import com.intellij.ProjectTopics;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.java.project.DependencyPath;
import com.intellij.uml.java.project.ModuleItem;
import com.intellij.uml.java.project.ModulesUmlCategoryManager;
import com.intellij.uml.java.project.ModulesUmlEdge;
import com.intellij.uml.java.project.ModulesUmlNode;
import com.intellij.uml.java.project.ModulesUmlProvider;
import com.intellij.uml.java.project.UmlModulesRelationshipHelper;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModulesUmlDataModel
extends DiagramDataModel<ModuleItem> {
    @Nullable
    private final ModuleItem myInitialElement;
    private final VirtualFile myEditorFile;
    private final Set<ModuleItem> addedByUser = new HashSet<ModuleItem>();
    private final Set<ModuleItem> removedByUser = new HashSet<ModuleItem>();
    private final HashSet<ModulesUmlNode> myNodes = new HashSet();
    private final HashSet<ModulesUmlEdge> myEdges = new HashSet();
    private final ModificationTracker myModificationTracker;
    private final MessageBusConnection myConnection;
    private final StructureConfigurableContext myContext;
    private long myModificationCount;

    public ModulesUmlDataModel(Project project, @Nullable ModuleItem moduleItem, VirtualFile file, DiagramPresentationModel model) {
        super(project, DiagramProvider.findByID("MODULES"));
        this.myEditorFile = file;
        this.myInitialElement = moduleItem;
        this.myConnection = this.getProject().getMessageBus().connect();
        this.myConnection.setDefaultHandler(() -> ++this.myModificationCount);
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        this.myConnection.subscribe(ProjectTopics.MODULES);
        this.myModificationTracker = () -> this.myModificationCount + ProjectRootManager.getInstance((Project)this.getProject()).getModificationCount();
        ModulesConfigurator configurator = new ModulesConfigurator(this.getProject());
        this.myContext = new StructureConfigurableContext(this.getProject(), configurator);
        this.myContext.resetLibraries();
        this.myContext.getDaemonAnalyzer().reset();
        Disposer.register((Disposable)this, (Disposable)this.myContext);
        Disposer.register((Disposable)this.myContext, () -> ((ModulesConfigurator)configurator).disposeUIResources());
        LibraryTable projectTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
        projectTable.addListener(new LibraryTable.Listener(){

            public void afterLibraryRenamed(@NotNull Library library, @Nullable String oldName) {
                if (library == null) {
                    1.$$$reportNull$$$0(0);
                }
                ModulesUmlDataModel.this.updateDataModel();
                ModulesUmlDataModel.this.getBuilder().update(true, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/uml/java/project/ModulesUmlDataModel$1", "afterLibraryRenamed"));
            }
        }, (Disposable)this);
    }

    private Collection<ModuleItem> getDependentModulesAndLibs() {
        ArrayList<ModuleItem> items = new ArrayList<ModuleItem>();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myInitialElement != null) {
            Module mainModule = this.myInitialElement.getModule();
            modules.add(mainModule);
            OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)mainModule).withoutSdk().withoutModuleSourceEntries();
            this.includeTestsIfNeeded(enumerator).forEachModule(module -> {
                items.add(new ModuleItem((Module)module));
                modules.add((Module)module);
                return true;
            });
        }
        for (Module module2 : modules) {
            OrderEnumerator librariesEnumerator = OrderEnumerator.orderEntries((Module)module2).librariesOnly();
            this.includeTestsIfNeeded(librariesEnumerator).forEachLibrary(library -> {
                items.add(new ModuleItem(module2, (Library)library, this.getProject()));
                return true;
            });
        }
        return items;
    }

    private OrderEnumerator includeTestsIfNeeded(OrderEnumerator enumerator) {
        if (!this.isTestDependenciesEnabled()) {
            enumerator = enumerator.productionOnly();
        }
        return enumerator;
    }

    @Override
    @NotNull
    public Collection<ModulesUmlNode> getNodes() {
        HashSet<ModulesUmlNode> hashSet = this.myNodes;
        if (hashSet == null) {
            ModulesUmlDataModel.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Collection<ModulesUmlEdge> getEdges() {
        HashSet<ModulesUmlEdge> hashSet = this.myEdges;
        if (hashSet == null) {
            ModulesUmlDataModel.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Override
    @NotNull
    @NonNls
    public String getNodeName(@NotNull DiagramNode<ModuleItem> node) {
        if (node == null) {
            ModulesUmlDataModel.$$$reportNull$$$0(2);
        }
        String string = node.getIdentifyingElement().getName();
        if (string == null) {
            ModulesUmlDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void removeEdge(@NotNull DiagramEdge<ModuleItem> edge) {
        if (edge == null) {
            ModulesUmlDataModel.$$$reportNull$$$0(4);
        }
        if (edge instanceof ModulesUmlEdge) {
            int answer;
            ModulesUmlEdge modulesEdge = (ModulesUmlEdge)edge;
            ModuleItem source = (ModuleItem)modulesEdge.getSource().getIdentifyingElement();
            ModuleItem target = (ModuleItem)modulesEdge.getTarget().getIdentifyingElement();
            ExportableOrderEntry orderEntry = modulesEdge.findOrderEntry();
            if (source.isModule() && orderEntry != null && (answer = Messages.showYesNoDialog((Project)this.getProject(), (String)DiagramJavaBundle.message("dialog.message.do.you.want.to.remove.dependency.from.0.to.1", StringUtil.decapitalize((String)source.getPresentableName()), StringUtil.decapitalize((String)target.getPresentableName())), (String)DiagramJavaBundle.message("dialog.title.remove.dependency", new Object[0]), null)) == 0) {
                WriteAction.run(() -> {
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)source.getModule()).getModifiableModel();
                    model.removeOrderEntry((OrderEntry)modulesEdge.findOrderEntry((ModuleRootModel)model));
                    model.commit();
                });
                this.getBuilder().update(false, false);
            }
        }
    }

    @Override
    public DiagramEdge<ModuleItem> createEdge(@NotNull DiagramNode<ModuleItem> from, @NotNull DiagramNode<ModuleItem> to) {
        if (from == null) {
            ModulesUmlDataModel.$$$reportNull$$$0(5);
        }
        if (to == null) {
            ModulesUmlDataModel.$$$reportNull$$$0(6);
        }
        if (from instanceof ModulesUmlNode && to instanceof ModulesUmlNode && from.getIdentifyingElement().isModule()) {
            ModuleItem target = to.getIdentifyingElement();
            Module fromModule = from.getIdentifyingElement().getModule();
            if (target.isModule()) {
                ModuleRootModificationUtil.addDependency((Module)fromModule, (Module)target.getModule());
            } else {
                ModuleRootModificationUtil.addDependency((Module)fromModule, (Library)target.getLibrary());
            }
        }
        return null;
    }

    @Override
    public void removeNode(@NotNull DiagramNode<ModuleItem> node) {
        if (node == null) {
            ModulesUmlDataModel.$$$reportNull$$$0(7);
        }
        this.removeElement(node.getIdentifyingElement());
        this.refreshDataModel();
    }

    @Override
    public boolean hasElement(@Nullable ModuleItem element) {
        return this.findNode(element) != null;
    }

    @Override
    public void refreshDataModel() {
        this.updateDataModel();
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = this.myModificationTracker;
        if (modificationTracker == null) {
            ModulesUmlDataModel.$$$reportNull$$$0(8);
        }
        return modificationTracker;
    }

    public synchronized void updateDataModel() {
        Module[] modules;
        this.myNodes.clear();
        this.myEdges.clear();
        ModulesUmlProvider umlProvider = (ModulesUmlProvider)this.getBuilder().getProvider();
        Set<ModuleItem> moduleItems = this.getItemsToShow();
        HashMap<ModuleItem, ModulesUmlNode> nodes = new HashMap<ModuleItem, ModulesUmlNode>();
        for (ModuleItem item : moduleItems) {
            ModulesUmlNode umlNode = new ModulesUmlNode(item, umlProvider);
            this.myNodes.add(umlNode);
            nodes.put(item, umlNode);
        }
        List<ModulesUmlEdge> edges = UmlModulesRelationshipHelper.generateEdges(nodes, this.getProject(), this.isTestDependenciesEnabled());
        this.myEdges.addAll(edges);
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            this.myContext.getDaemonAnalyzer().queueUpdate((ProjectStructureElement)new ModuleProjectStructureElement(this.myContext, module));
        }
        if (Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(CommonDiagramExtras.PATH_TO_ROOT)) {
            this.showPathsFromRoot();
        }
        if (DiagramUtils.isSelectionMode(this.getBuilder())) {
            DiagramUtils.removeNonSelectedDependencies(this);
        }
    }

    private void showPathsFromRoot() {
        ArrayList<DiagramNode> selectedNodes = DiagramUtils.getSelectedNodes(this.getBuilder());
        if (selectedNodes.size() > 0) {
            ModulesUmlNode root = null;
            for (ModulesUmlNode umlNode : this.myNodes) {
                if (umlNode.getIdentifyingElement() != this.myInitialElement) continue;
                root = umlNode;
                break;
            }
            if (root != null) {
                Set pathEdges = DiagramUtils.getPathsFromRoot(root, selectedNodes, this);
                Set pathNodes = DiagramUtils.collectNodes(pathEdges);
                for (DiagramNode node : this.myNodes.toArray(new DiagramNode[0])) {
                    if (pathNodes.contains(node) || node == root) continue;
                    this.myNodes.remove(node);
                }
                for (DiagramEdge edge : this.myEdges.toArray(new DiagramEdge[0])) {
                    if (pathEdges.contains(edge)) continue;
                    this.myEdges.remove(edge);
                }
            }
        }
    }

    private boolean isTestDependenciesEnabled() {
        return Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(ModulesUmlCategoryManager.TEST);
    }

    public void refreshDataModel(List<DependencyPath> dependencyPaths) {
        this.removeAll();
        this.myNodes.clear();
        this.myEdges.clear();
        this.addedByUser.clear();
        block0: for (DependencyPath path : dependencyPaths) {
            Module[] modules = path.getPaths();
            int i = 0;
            for (Module module : modules) {
                this.addedByUser.add(new ModuleItem(module));
                if (++i == 10) continue block0;
            }
        }
        this.refreshDataModel();
        this.getBuilder().update(true, true);
        if (dependencyPaths.size() > 10) {
            DiagramAction.showNotification(DiagramJavaBundle.message("notification.message.only.few.paths.have.been.shown", new Object[0]), this.getBuilder());
        }
    }

    private Set<ModuleItem> getItemsToShow() {
        HashSet<ModuleItem> result = new HashSet<ModuleItem>();
        boolean libsEnabled = Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(ModulesUmlCategoryManager.LIBRARIES);
        HashSet<ModuleItem> allItems = new HashSet<ModuleItem>();
        if (this.myInitialElement != null) {
            allItems.add(this.myInitialElement);
            if (this.myInitialElement.isModule()) {
                allItems.addAll(this.getDependentModulesAndLibs());
            }
        }
        allItems.addAll(this.addedByUser);
        for (ModuleItem item : allItems) {
            if (this.removedByUser.contains(item) || !libsEnabled && item.isLibrary()) continue;
            if (item.isDisposed()) {
                this.addedByUser.remove(item);
                continue;
            }
            result.add(item);
        }
        return result;
    }

    @Nullable
    public DiagramNode<ModuleItem> findNode(ModuleItem item) {
        for (DiagramNode diagramNode : this.myNodes) {
            ModuleItem element = (ModuleItem)diagramNode.getIdentifyingElement();
            if (!element.equals(item)) continue;
            return diagramNode;
        }
        return null;
    }

    public boolean contains(ModuleItem item) {
        return this.findNode(item) != null;
    }

    public void dispose() {
        this.myConnection.disconnect();
    }

    public void removeElement(ModuleItem item) {
        DiagramNode<ModuleItem> node = this.findNode(item);
        this.addedByUser.remove(item);
        this.removedByUser.add(item);
        this.myNodes.remove(node);
        if (node == null) {
            return;
        }
        ArrayList<DiagramEdge> edges = new ArrayList<DiagramEdge>();
        for (DiagramEdge diagramEdge : this.myEdges) {
            if (diagramEdge.getTarget() != node && diagramEdge.getSource() != node) continue;
            edges.add(diagramEdge);
        }
        this.myEdges.removeAll(edges);
    }

    @Override
    @Nullable
    public DiagramNode<ModuleItem> addElement(@Nullable ModuleItem element) {
        if (element == null || this.findNode(element) != null) {
            return null;
        }
        this.addedByUser.add(element);
        this.removedByUser.remove(element);
        DiagramNodeContentManager nodeContentManager = Objects.requireNonNull(this.getBuilder().getDataModel().getNodeContentManager());
        if (element.isLibrary() && nodeContentManager.getEnabledCategories().length == 0) {
            nodeContentManager.setCategoryEnabled(ModulesUmlCategoryManager.LIBRARIES, true);
        }
        return new ModulesUmlNode(element, this.getProvider());
    }

    public VirtualFile getFile() {
        return this.myEditorFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/project/ModulesUmlDataModel";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/project/ModulesUmlDataModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeEdge";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

