/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.diagnostics;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.io.Compressor;
import com.jetbrains.cidr.cpp.diagnostics.CdCidrWorkspaceKt;
import com.jetbrains.cidr.cpp.diagnostics.CdDateUtilKt;
import com.jetbrains.cidr.cpp.diagnostics.CdOCWorkspaceKt;
import com.jetbrains.cidr.cpp.diagnostics.CdToolchainsKt;
import com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsAction;
import com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsBundle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/cpp/diagnostics/CppDiagnosticsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.clion.diagnostics"})
public final class CppDiagnosticsAction
extends DumbAwareAction {
    private static final NotificationGroup NOTIFICATION_GROUP;
    @NotNull
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(DumbAwareAction.getEventProject((AnActionEvent)e) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = DumbAwareAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getEventProject(e) ?: return");
        Project project2 = project;
        Task.Modal task2 = new Task.Modal(project2, project2, CppDiagnosticsBundle.message("cpp.diagnostics.progress.title", new Object[0]), true){
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                String toolchains2 = (String)com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsAction$Companion.access$readActionWithText(CppDiagnosticsAction.Companion, indicator, CppDiagnosticsBundle.message("cpp.diagnostics.progress.toolchains", new Object[0]), (Function0)new Function0<String>(this){
                    final /* synthetic */ actionPerformed.task.1 this$0;

                    @NotNull
                    public final String invoke() {
                        return CdToolchainsKt.collectToolchains(this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                String cidrWorkspaces2 = (String)com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsAction$Companion.access$readActionWithText(CppDiagnosticsAction.Companion, indicator, CppDiagnosticsBundle.message("cpp.diagnostics.progress.workspace", new Object[0]), (Function0)new Function0<String>(this){
                    final /* synthetic */ actionPerformed.task.1 this$0;

                    @NotNull
                    public final String invoke() {
                        return CdCidrWorkspaceKt.collectCidrWorkspaces(this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                String ocWorkspace2 = (String)com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsAction$Companion.access$readActionWithText(CppDiagnosticsAction.Companion, indicator, CppDiagnosticsBundle.message("cpp.diagnostics.progress.ocWorkspace", new Object[0]), (Function0)new Function0<String>(this){
                    final /* synthetic */ actionPerformed.task.1 this$0;

                    @NotNull
                    public final String invoke() {
                        return CdOCWorkspaceKt.collectOCWorkspace(this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                String ocWorkspaceEvents2 = (String)com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsAction$Companion.access$readActionWithText(CppDiagnosticsAction.Companion, indicator, CppDiagnosticsBundle.message("cpp.diagnostics.progress.ocWorkspaceEvents", new Object[0]), (Function0)new Function0<String>(this){
                    final /* synthetic */ actionPerformed.task.1 this$0;

                    @NotNull
                    public final String invoke() {
                        return CdCidrWorkspaceKt.collectOCWorkspaceEvents(this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                List files = CollectionsKt.listOf((Object[])new Companion.FileWithContents[]{new Companion.FileWithContents("Toolchains.txt", toolchains2), new Companion.FileWithContents("CidrWorkspaces.txt", cidrWorkspaces2), new Companion.FileWithContents("OCWorkspaceEvents.txt", ocWorkspaceEvents2), new Companion.FileWithContents("OCWorkspace.txt", ocWorkspace2)});
                com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsAction$Companion.access$zipAndReveal(CppDiagnosticsAction.Companion, files);
                if (Registry.is((String)"cpp.diagnostics.also.open.in.editor")) {
                    ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.$project)).submit(new Runnable(this, files){
                        final /* synthetic */ actionPerformed.task.1 this$0;
                        final /* synthetic */ List $files;

                        public final void run() {
                            for (Companion.FileWithContents file : this.$files) {
                                LightVirtualFile virtualFile = new LightVirtualFile(file.getFilename(), (CharSequence)file.getContents());
                                FileEditorManager.getInstance((Project)this.this$0.$project).openFile((VirtualFile)virtualFile, true);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$files = list;
                        }
                    });
                }
            }
            {
                this.$project = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    static {
        Companion = new Companion(null);
        NOTIFICATION_GROUP = new NotificationGroup("C/C++ Diagnostics", NotificationDisplayType.BALLOON, true, null, null, 24, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J3\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/cpp/diagnostics/CppDiagnosticsAction$Companion;", "", "()V", "NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "createZip", "Ljava/io/File;", "files", "", "Lcom/jetbrains/cidr/cpp/diagnostics/CppDiagnosticsAction$Companion$FileWithContents;", "readActionWithText", "R", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "text", "", "block", "Lkotlin/Function0;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "zipAndReveal", "", "FileWithContents", "intellij.clion.diagnostics"})
    public static final class Companion {
        private final File createZip(Iterable<FileWithContents> files) throws IOException {
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            String productName = StringUtil.toLowerCase((String)applicationNamesInfo.getLowercaseProductName());
            File file = FileUtil.createTempFile((String)(productName + "-cpp-diag-" + CdDateUtilKt.formatCurrentTime()), (String)".zip");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\u2026matCurrentTime(), \".zip\")");
            File zippedLogsFile = file;
            try {
                Compressor.Zip zip = new Compressor.Zip(zippedLogsFile);
                for (FileWithContents file2 : files) {
                    String string = file2.getFilename();
                    String string2 = file2.getContents();
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    String string3 = string2;
                    boolean bl2 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string4.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    zip.addFile(string, (InputStream)new ByteArrayInputStream(byArray));
                }
                zip.close();
            }
            catch (IOException exception) {
                FileUtil.delete((File)zippedLogsFile);
                throw (Throwable)exception;
            }
            return zippedLogsFile;
        }

        private final void zipAndReveal(Iterable<FileWithContents> files) {
            try {
                File zippedDiagnostics = this.createZip(files);
                if (RevealFileAction.isSupported()) {
                    RevealFileAction.openFile((File)zippedDiagnostics);
                } else {
                    String string = NOTIFICATION_GROUP.getDisplayId();
                    Object[] objectArray = new Object[1];
                    String string2 = zippedDiagnostics.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"zippedDiagnostics.absolutePath");
                    objectArray[0] = string2;
                    Notification logNotification = new Notification(string, "", CppDiagnosticsBundle.message("cpp.diagnostics.are.collected.0", objectArray), NotificationType.INFORMATION);
                    Notifications.Bus.notify((Notification)logNotification);
                }
            }
            catch (IOException e) {
                String string = NOTIFICATION_GROUP.getDisplayId();
                Object[] objectArray = new Object[1];
                String string3 = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"e.localizedMessage");
                objectArray[0] = string3;
                Notification errorNotification = new Notification(string, "", CppDiagnosticsBundle.message("cpp.diagnostics.cant.write.0", objectArray), NotificationType.ERROR);
                Notifications.Bus.notify((Notification)errorNotification);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <R> R readActionWithText(ProgressIndicator indicator, @NlsContexts.ProgressText String text, Function0<? extends R> block) {
            String oldText = indicator.getText();
            indicator.setText(text);
            try {
                boolean $i$f$runReadAction = false;
                Object object = ApplicationManager.getApplication().runReadAction(new Computable(block){
                    final /* synthetic */ Function0 $runnable;
                    {
                        this.$runnable = function0;
                    }

                    public final T compute() {
                        return (T)this.$runnable.invoke();
                    }
                });
                return (R)object;
            }
            finally {
                indicator.setText(oldText);
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ Object access$readActionWithText(Companion $this, ProgressIndicator indicator, String text, Function0 block) {
            return $this.readActionWithText(indicator, text, block);
        }

        public static final /* synthetic */ void access$zipAndReveal(Companion $this, Iterable files) {
            $this.zipAndReveal(files);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/diagnostics/CppDiagnosticsAction$Companion$FileWithContents;", "", "filename", "", "contents", "(Ljava/lang/String;Ljava/lang/String;)V", "getContents", "()Ljava/lang/String;", "getFilename", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clion.diagnostics"})
        private static final class FileWithContents {
            @NotNull
            private final String filename;
            @NotNull
            private final String contents;

            @NotNull
            public final String getFilename() {
                return this.filename;
            }

            @NotNull
            public final String getContents() {
                return this.contents;
            }

            public FileWithContents(@NotNull String filename, @NotNull String contents) {
                Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
                Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
                this.filename = filename;
                this.contents = contents;
            }

            @NotNull
            public final String component1() {
                return this.filename;
            }

            @NotNull
            public final String component2() {
                return this.contents;
            }

            @NotNull
            public final FileWithContents copy(@NotNull String filename, @NotNull String contents) {
                Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
                Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
                return new FileWithContents(filename, contents);
            }

            public static /* synthetic */ FileWithContents copy$default(FileWithContents fileWithContents, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = fileWithContents.filename;
                }
                if ((n & 2) != 0) {
                    string2 = fileWithContents.contents;
                }
                return fileWithContents.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "FileWithContents(filename=" + this.filename + ", contents=" + this.contents + ")";
            }

            public int hashCode() {
                String string = this.filename;
                String string2 = this.contents;
                return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof FileWithContents)) break block3;
                        FileWithContents fileWithContents = (FileWithContents)object;
                        if (!Intrinsics.areEqual((Object)this.filename, (Object)fileWithContents.filename) || !Intrinsics.areEqual((Object)this.contents, (Object)fileWithContents.contents)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

