/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class EmbeddedUsagesCollector {
    private static final Pair<String, String>[] KNOWN_GDBSERVERS_BY_NAME = (Pair[])ContainerUtil.ar((Object[])new Pair[]{new Pair((Object)"gdbserver", (Object)"gdbserver")});
    private static final Pair<String, String>[] KNOWN_GDBSERVERS_BY_NAME_FRAGMENT = (Pair[])ContainerUtil.ar((Object[])new Pair[]{Pair.pair((Object)"openocd", (Object)"OpenOCD"), Pair.pair((Object)"st-util", (Object)"st-util"), Pair.pair((Object)"jlinkgdbserver", (Object)"JLink"), Pair.pair((Object)"st-link_gdbserver", (Object)"ST-LINK Gdbserver"), Pair.pair((Object)"qemu", (Object)"qemu"), Pair.pair((Object)"pyocd", (Object)"pyocd"), Pair.pair((Object)"xmd", (Object)"Xilinx XMD")});
    private static final String[] KNOWN_MCU_FAMILIES = new String[]{"STM32F0", "STM32F1", "STM32F2", "STM32F3", "STM32F4", "STM32F7", "STM32G0", "STM32G4", "STM32H7", "STM32L0", "STM32L1", "STM32L4A", "STM32L4P", "STM32L4Q", "STM32L4R", "STM32L4S", "STM32L4", "STM32L5", "STM32MP1", "STM32U5", "STM32WB1", "STM32WL", "UPDATE_FAILED"};
    private static final String GROUP_ID = "cidr.embedded";

    public static void triggerStm32CubeMXParse(@NotNull Project project, @NotNull String mcuName, boolean automatic) {
        if (project == null) {
            EmbeddedUsagesCollector.$$$reportNull$$$0(0);
        }
        if (mcuName == null) {
            EmbeddedUsagesCollector.$$$reportNull$$$0(1);
        }
        mcuName = mcuName.toUpperCase(Locale.ROOT);
        String mcuFamily = "UNKNOWN";
        for (String tryFamily : KNOWN_MCU_FAMILIES) {
            if (!mcuName.startsWith(tryFamily)) continue;
            mcuFamily = tryFamily;
            break;
        }
        FeatureUsageData data = new FeatureUsageData().addProject(project).addData("MCU_NAME", mcuFamily).addData("AUTOMATIC", automatic);
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP_ID, "STM32CUBEMX_PROJECT_UPDATE", data);
    }

    public static void triggerGdbServerRun(@NotNull Project project, @NotNull String gdbServer) {
        if (project == null) {
            EmbeddedUsagesCollector.$$$reportNull$$$0(2);
        }
        if (gdbServer == null) {
            EmbeddedUsagesCollector.$$$reportNull$$$0(3);
        }
        int anySlashIndex = Math.max(0, gdbServer.lastIndexOf(47));
        anySlashIndex = Math.max(anySlashIndex, gdbServer.lastIndexOf(92));
        String pureName = FileUtil.getNameWithoutExtension((String)gdbServer.substring(anySlashIndex)).toLowerCase(Locale.ROOT);
        String serverType = null;
        for (Pair<String, String> pair : KNOWN_GDBSERVERS_BY_NAME) {
            if (!((String)pair.first).equalsIgnoreCase(pureName)) continue;
            serverType = (String)pair.second;
            break;
        }
        if (serverType == null) {
            for (Pair<String, String> pair : KNOWN_GDBSERVERS_BY_NAME_FRAGMENT) {
                if (!pureName.contains((CharSequence)pair.first)) continue;
                serverType = (String)pair.second;
                break;
            }
        }
        if (serverType == null) {
            serverType = "Other";
        }
        FeatureUsageData data = new FeatureUsageData().addProject(project).addData("SERVER_TYPE", serverType);
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP_ID, "CUSTOM_GDB_SERVER_STARTED", data);
    }

    public static void triggerPeripheralViewOpen(@NotNull Project project, int activeNodesCounter) {
        if (project == null) {
            EmbeddedUsagesCollector.$$$reportNull$$$0(4);
        }
        FeatureUsageData data = new FeatureUsageData().addProject(project).addData("ACTIVE_PERIPHERAL_NODES", activeNodesCounter);
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP_ID, "PERIPHERAL_VIEW_SHOWN", data);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mcuName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gdbServer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/embedded/EmbeddedUsagesCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerStm32CubeMXParse";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerGdbServerRun";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerPeripheralViewOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

