/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectData {
    @Nullable
    private String projectName;
    @Nullable
    private String cmakeRequiredVersion;
    @Nullable
    private String linkerScript;
    @Nullable
    private String mcuFamily;
    @Nullable
    private String genericConfigName;
    @Nullable
    private String linkerFlags;
    @Nullable
    private String defines;
    @Nullable
    private String includes;
    @Nullable
    private String sources;
    @Nullable
    private String mcpu;
    @Nullable
    private String board;

    public void setProjectName(@NotNull String projectName) {
        if (projectName == null) {
            ProjectData.$$$reportNull$$$0(0);
        }
        this.projectName = projectName;
    }

    public void setLinkerFlags(@NotNull String linkerFlags) {
        if (linkerFlags == null) {
            ProjectData.$$$reportNull$$$0(1);
        }
        this.linkerFlags = linkerFlags;
    }

    public void setLinkerScript(@NotNull String linkerScript) {
        if (linkerScript == null) {
            ProjectData.$$$reportNull$$$0(2);
        }
        this.linkerScript = linkerScript;
        this.genericConfigName = linkerScript.replace(".ld", "");
    }

    public void setMcuFamily(@NotNull String mcuFamily) {
        if (mcuFamily == null) {
            ProjectData.$$$reportNull$$$0(3);
        }
        this.mcuFamily = mcuFamily;
        String mcuFamilyPrefix = mcuFamily.length() < 7 ? "" : mcuFamily.substring(0, 7);
        switch (StringUtil.toUpperCase((String)mcuFamilyPrefix)) {
            case "STM32F0": 
            case "STM32L0": 
            case "STM32G0": {
                this.mcpu = "cortex-m0";
                break;
            }
            case "STM32F1": 
            case "STM32F2": 
            case "STM32L1": {
                this.mcpu = "cortex-m3";
                break;
            }
            case "STM32F7": 
            case "STM32H7": {
                this.mcpu = "cortex-m7";
                break;
            }
            case "STM32L5": 
            case "STM32U5": {
                this.mcpu = "cortex-m33";
                break;
            }
            default: {
                this.mcpu = "cortex-m4";
            }
        }
    }

    @Nullable
    public String getProjectName() {
        return this.projectName;
    }

    @Nullable
    public String getLinkerScript() {
        return this.linkerScript;
    }

    @Nullable
    public String getMcuFamily() {
        return this.mcuFamily;
    }

    @Nullable
    public String getGenericConfigName() {
        return this.genericConfigName;
    }

    @Nullable
    public String getLinkerFlags() {
        return this.linkerFlags;
    }

    @Nullable
    public String getDefines() {
        return this.defines;
    }

    @Nullable
    public String getIncludes() {
        return this.includes;
    }

    @Nullable
    public String getSources() {
        return this.sources;
    }

    @Nullable
    public String getMcpu() {
        return this.mcpu;
    }

    @Nullable
    public String getBoard() {
        return this.board;
    }

    @Nullable
    public String getCmakeRequiredVersion() {
        return this.cmakeRequiredVersion;
    }

    public void setDefines(@NotNull String defines) {
        if (defines == null) {
            ProjectData.$$$reportNull$$$0(4);
        }
        this.defines = defines;
    }

    public void setIncludes(@NotNull String includes) {
        if (includes == null) {
            ProjectData.$$$reportNull$$$0(5);
        }
        this.includes = includes;
    }

    public void setSources(@NotNull String sources) {
        if (sources == null) {
            ProjectData.$$$reportNull$$$0(6);
        }
        this.sources = sources;
    }

    public void setBoard(@NotNull String board) {
        if (board == null) {
            ProjectData.$$$reportNull$$$0(7);
        }
        this.board = board;
    }

    public void setCmakeRequiredVersion(@Nullable String cmakeRequiredVersion) {
        this.cmakeRequiredVersion = cmakeRequiredVersion;
    }

    @NotNull
    public String toString() {
        String string = "projectName='" + this.projectName + "'\n cmakeRequiredVersion='" + this.cmakeRequiredVersion + "'\n linkerScript='" + this.linkerScript + "'\n mcuFamily='" + this.mcuFamily + "'\n genericConfigName='" + this.genericConfigName + "'\n linkerFlags='" + this.linkerFlags + "'\n defines='" + this.defines + "'\n includes='" + this.includes + "'\n sources='" + this.sources + "'\n mcpu='" + this.mcpu + "'";
        if (string == null) {
            ProjectData.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public Map<String, String> getAsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("projectName", this.projectName);
        map.put("cmakeRequiredVersion", this.cmakeRequiredVersion);
        map.put("linkerScript", this.linkerScript);
        map.put("mcuFamily", this.mcuFamily);
        map.put("genericConfigName", this.genericConfigName);
        map.put("linkerFlags", this.linkerFlags);
        map.put("defines", this.defines);
        map.put("includes", this.includes);
        map.put("sources", this.sources);
        map.put("mcpu", this.mcpu);
        map.put("templateWarning", EmbeddedBundle.message("template.do.not.change", new Object[0]));
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            ProjectData.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkerFlags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkerScript";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mcuFamily";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defines";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "board";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/embedded/ProjectData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/embedded/ProjectData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setProjectName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setLinkerFlags";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLinkerScript";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setMcuFamily";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDefines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setIncludes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSources";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setBoard";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

