/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.stm32cubemx;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.CustomStepProjectGenerator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.util.io.IOUtil;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.CLionProjectGenerator;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import com.jetbrains.cidr.cpp.embedded.stm32cubemx.CMakeSTM32CubeMXProjectSettingsStep;
import com.jetbrains.cidr.cpp.embedded.stm32cubemx.ConvertProjectAction;
import com.jetbrains.cidr.cpp.embedded.stm32cubemx.CubeMXManager;
import com.jetbrains.cidr.cpp.embedded.stm32cubemx.RunStm32CubeMXAction;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.EmbeddedSettingsState;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.ui.EmbeddedMessages;
import icons.CLionEmbeddedIcons;
import java.io.File;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeSTM32CubeMXProjectGenerator<T>
extends CLionProjectGenerator<T>
implements CustomStepProjectGenerator<T> {
    private static final Logger LOG = Logger.getInstance(CMakeSTM32CubeMXProjectGenerator.class);
    @NonNls
    public static final String EMBEDDED_PROJECTS_GROUP_NAME = "Embedded";
    public static final Supplier<@Nls String> EMBEDDED_PROJECTS_GROUP_DISPLAY_NAME = EmbeddedBundle.messagePointer("embedded.display.name", new Object[0]);

    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        ValidationResult stm32CubeMxValidation;
        if (baseDirPath == null) {
            CMakeSTM32CubeMXProjectGenerator.$$$reportNull$$$0(0);
        }
        if (!(stm32CubeMxValidation = CMakeSTM32CubeMXProjectGenerator.validateStm32CubeMx()).isOk()) {
            ValidationResult validationResult = stm32CubeMxValidation;
            if (validationResult == null) {
                CMakeSTM32CubeMXProjectGenerator.$$$reportNull$$$0(1);
            }
            return validationResult;
        }
        if (!IOUtil.isAscii((String)baseDirPath) || StringUtil.containsWhitespaces((CharSequence)baseDirPath)) {
            return new ValidationResult(EmbeddedBundle.message("validation.intl.characters", new Object[0]));
        }
        ValidationResult validationResult = super.validate(baseDirPath);
        if (validationResult == null) {
            CMakeSTM32CubeMXProjectGenerator.$$$reportNull$$$0(2);
        }
        return validationResult;
    }

    @NotNull
    static ValidationResult validateStm32CubeMx() {
        EmbeddedSettingsState state = (EmbeddedSettingsState)ApplicationManager.getApplication().getComponent(EmbeddedSettingsState.class);
        if (new File(state.stm32CubeMXLocation).exists()) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                CMakeSTM32CubeMXProjectGenerator.$$$reportNull$$$0(3);
            }
            return validationResult;
        }
        return new ValidationResult(EmbeddedBundle.message("stm32cubemx.is.not.found", new Object[0]));
    }

    @NotNull
    public String getGroupName() {
        return EMBEDDED_PROJECTS_GROUP_NAME;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = EMBEDDED_PROJECTS_GROUP_DISPLAY_NAME.get();
        if (string == null) {
            CMakeSTM32CubeMXProjectGenerator.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void generateProject(final @NotNull Project project, @NotNull VirtualFile baseDir, @NotNull T settings, @NotNull Module module) {
        VirtualFile contentRoot;
        if (project == null) {
            CMakeSTM32CubeMXProjectGenerator.$$$reportNull$$$0(5);
        }
        if (baseDir == null) {
            CMakeSTM32CubeMXProjectGenerator.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            CMakeSTM32CubeMXProjectGenerator.$$$reportNull$$$0(7);
        }
        if (module == null) {
            CMakeSTM32CubeMXProjectGenerator.$$$reportNull$$$0(8);
        }
        if (CubeMXManager.findIocFile(contentRoot = Objects.requireNonNull(ConvertProjectAction.getRootDir(Stream.of(module))), true) == null) {
            new Task.Modal(null, EmbeddedBundle.message("stm32.cube.mx.project.generation", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    VirtualFile iocFile;
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((iocFile = CMakeSTM32CubeMXProjectGenerator.generateIocFile(indicator, contentRoot, project)) != null) {
                        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, iocFile);
                        ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)project).openEditor(descriptor, true));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/cpp/embedded/stm32cubemx/CMakeSTM32CubeMXProjectGenerator$1", "run"));
                }
            }.queue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static VirtualFile generateIocFile(@NotNull ProgressIndicator indicator, VirtualFile contentRoot, @NotNull Project project) {
        if (indicator == null) {
            CMakeSTM32CubeMXProjectGenerator.$$$reportNull$$$0(9);
        }
        if (project == null) {
            CMakeSTM32CubeMXProjectGenerator.$$$reportNull$$$0(10);
        }
        indicator.setText(EmbeddedBundle.message("stm32.cube.mx.project.generation.writing.temp.script", new Object[0]));
        File tempScript = null;
        try {
            tempScript = FileUtil.createTempFile((String)"stm32cube-init", (String)".txt", (boolean)true);
            String name = contentRoot.getName();
            String scriptContent = String.format("load STM32F030F4Px%nproject toolchain SW4STM32%nproject generateunderroot 1%nproject name %s%nproject path %s%nproject save project settings%nexit%n", name, contentRoot.getParent().getPath());
            FileUtil.writeToFile((File)tempScript, (String)scriptContent);
            indicator.setText(EmbeddedBundle.message("stm32.cube.mx.project.generation.running", new Object[0]));
            GeneralCommandLine commandLine = RunStm32CubeMXAction.createJavaCommandLine(null);
            if (commandLine == null) {
                VirtualFile virtualFile = null;
                return virtualFile;
            }
            commandLine.withParameters(new String[]{"-q", tempScript.getAbsolutePath()});
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = handler.runProcessWithProgressIndicator(indicator);
            if (output.getExitCode() != 0 && !output.isCancelled()) {
                LOG.error("STM32CubeMX failed with code: " + output.getExitCode(), new Attachment[]{new Attachment("stdout", output.getStdout()), new Attachment("stderr", output.getStderr())});
            }
            CubeMXManager.getInstance(project).notifyPossibleCubeMXChanges();
            VirtualFile virtualFile = VfsUtil.refreshAndFindChild((VirtualFile)contentRoot, (String)(name + ".ioc"));
            return virtualFile;
        }
        catch (Throwable e) {
            String message = EmbeddedBundle.message("stm32.cube.mx.project.cant.generate", e.getLocalizedMessage());
            EmbeddedMessages.showErrorMessage(project, EmbeddedBundle.message("stm32cubemx1", new Object[0]), message);
        }
        finally {
            if (tempScript != null) {
                tempScript.delete();
            }
        }
        return null;
    }

    @NotNull
    public String getName() {
        return "STM32CubeMX";
    }

    @Nullable
    public Icon getLogo() {
        return CLionEmbeddedIcons.STM32CubeMX;
    }

    public AbstractActionWithPanel createStep(DirectoryProjectGenerator<T> projectGenerator, AbstractNewProjectStep.AbstractCallback<T> callback) {
        return new CMakeSTM32CubeMXProjectSettingsStep<T>(projectGenerator, callback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/embedded/stm32cubemx/CMakeSTM32CubeMXProjectGenerator";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/embedded/stm32cubemx/CMakeSTM32CubeMXProjectGenerator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "validateStm32CubeMx";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateIocFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

