/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.embedded.svd;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import com.jetbrains.cidr.cpp.embedded.EmbeddedUsagesCollector;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdRegister;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdRoot;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdShowHideDialog;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdTreeTable;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdWindowState;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import icons.CLionEmbeddedIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SvdPanel
extends JPanel {
    public static final String HELP_ID = "toolwindows.peripheralview";
    private final JComponent myInnerPanel;
    private final SvdTreeTable myTreeTable;
    private final CidrDebugProcess myProcess;
    private final SvdWindowState.ProjectState myWindowProfileState;
    private boolean autoUpdate;
    private boolean myPendingUpdateValue;
    private VirtualFile mySvdDefaultLocation;

    private SvdPanel(@NotNull JComponent innerPanel, @NotNull DefaultActionGroup group, @NotNull SvdTreeTable treeTable, @NotNull CidrDebugProcess process, SvdWindowState.ProjectState profileState) {
        if (innerPanel == null) {
            SvdPanel.$$$reportNull$$$0(0);
        }
        if (group == null) {
            SvdPanel.$$$reportNull$$$0(1);
        }
        if (treeTable == null) {
            SvdPanel.$$$reportNull$$$0(2);
        }
        if (process == null) {
            SvdPanel.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.autoUpdate = true;
        this.mySvdDefaultLocation = null;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("DebuggerToolbar", (ActionGroup)group, false);
        actionToolbar.setTargetComponent((JComponent)((Object)treeTable));
        JComponent component = actionToolbar.getComponent();
        this.add((Component)component, "West");
        this.add((Component)innerPanel, "Center");
        this.myInnerPanel = innerPanel;
        this.myTreeTable = treeTable;
        this.myProcess = process;
        this.setupActions(group);
        StatusText emptyText = treeTable.getEmptyText();
        emptyText.setText(EmbeddedBundle.message("svd.no.registers.loaded", new Object[0]));
        emptyText.appendSecondaryText(EmbeddedBundle.message("svd.load.file", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.configureSvd());
        this.myWindowProfileState = profileState;
        this.myTreeTable.setAutoUpdate(this.autoUpdate);
        this.myTreeTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                SvdPanel.this.myWindowProfileState.notifyColumnsChange(SvdPanel.this.myTreeTable);
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                SvdPanel.this.myWindowProfileState.notifyColumnsChange(SvdPanel.this.myTreeTable);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.myTreeTable.restoreState();
        this.addHierarchyListener(e -> {
            if (this.isDisplayable() && this.myPendingUpdateValue) {
                this.doUpdateValues();
                EmbeddedUsagesCollector.triggerPeripheralViewOpen(process.getProject(), this.myTreeTable.getRoot().getActiveNodes().size());
            }
        });
    }

    public void setSvdDefaultLocation(@Nullable VirtualFile svdDefaultLocation) {
        this.mySvdDefaultLocation = svdDefaultLocation;
    }

    @NotNull
    public JComponent getDefaultFocusComponent() {
        JComponent jComponent = this.myInnerPanel;
        if (jComponent == null) {
            SvdPanel.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    private void setupActions(DefaultActionGroup group) {
        group.add((AnAction)new ToggleAction(EmbeddedBundle.message("disable.refresh.on.step", new Object[0]), null, AllIcons.Actions.StopRefresh){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !SvdPanel.this.autoUpdate;
            }

            public boolean isDumbAware() {
                return true;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                SvdPanel.this.autoUpdate = !state;
                e.getPresentation().setText(SvdPanel.this.autoUpdate ? EmbeddedBundle.message("disable.refresh.on.step", new Object[0]) : EmbeddedBundle.message("enable.refresh.on.step", new Object[0]));
                SvdPanel.this.myTreeTable.setAutoUpdate(SvdPanel.this.autoUpdate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        group.add((AnAction)new DumbAwareAction(EmbeddedBundle.message("svd.panel.refresh", new Object[0]), null, AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                SvdPanel.this.updateValues(true);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(SvdPanel.this.myProcess.getSession().isSuspended());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdPanel$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction(EmbeddedBundle.message("svd.panel.export.csv.to.clipboard", new Object[0]), null, AllIcons.Actions.Copy){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                try (StringWriter writer = new StringWriter();
                     PrintWriter printWriter = new PrintWriter(writer);){
                    SvdPanel.this.myTreeTable.getRoot().export(printWriter);
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(writer.toString()));
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdPanel$4", "actionPerformed"));
            }
        });
        group.add((AnAction)new DumbAwareAction(EmbeddedBundle.message("svd.panel.open.csv.editor", new Object[0]), null, AllIcons.ToolbarDecorator.Export){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                RunProfile profile = SvdPanel.this.myProcess.getSession().getRunProfile();
                Object filename = String.format("Peripheral-%s%tF-%2$tT", profile != null ? profile.getName() + "-" : "", new Date());
                filename = FileUtil.sanitizeFileName((String)filename, (boolean)false) + ".csv";
                Project project = SvdPanel.this.myProcess.getProject();
                try (StringWriter writer = new StringWriter();
                     PrintWriter printWriter = new PrintWriter(writer);){
                    SvdPanel.this.myTreeTable.getRoot().export(printWriter);
                    VirtualFile scratchFile = ScratchRootType.getInstance().createScratchFile(project, (String)filename, (Language)PlainTextLanguage.INSTANCE, ((Object)writer).toString());
                    if (scratchFile != null) {
                        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, scratchFile);
                        descriptor.navigate(true);
                    }
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdPanel$5", "actionPerformed"));
            }
        });
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction(EmbeddedBundle.message("svd.panel.configure.action", new Object[0]), null, AllIcons.General.Filter){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                SvdPanel.this.configureSvd();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdPanel$6", "actionPerformed"));
            }
        });
        group.add((AnAction)new ContextHelpAction(HELP_ID));
    }

    private void configureSvd() {
        SvdRoot root = this.myTreeTable.getRoot();
        TreeTableTree tree = this.myTreeTable.getTree();
        SvdShowHideDialog dialog = new SvdShowHideDialog(root, this.myProcess.getProject());
        dialog.setSvdDefaultLocation(this.mySvdDefaultLocation);
        dialog.showHideNodes();
        root.getTreeTableModel().notifyTreeUpdated();
        ((JBTreeTraverser)TreeUtil.treePathTraverser((JTree)tree).filter(path -> !(path.getLastPathComponent() instanceof SvdRegister))).forEach(arg_0 -> tree.expandPath(arg_0));
        this.myWindowProfileState.notifyTreeChange(this.myTreeTable);
        this.updateValues(true);
    }

    public void updateValues(boolean forced) {
        if ((forced || this.autoUpdate) && this.myProcess.getSession().isSuspended()) {
            if (this.isDisplayable()) {
                this.doUpdateValues();
            } else {
                this.myPendingUpdateValue = true;
            }
        }
    }

    private void doUpdateValues() {
        try {
            this.myTreeTable.getRoot().getTreeTableModel().updateValues(this.myProcess, () -> {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    this.myTreeTable.repaint();
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> this.myTreeTable.repaint());
                }
            });
        }
        finally {
            this.myPendingUpdateValue = false;
        }
    }

    @NotNull
    public static SvdPanel create(@NotNull CidrDebugProcess process) {
        if (process == null) {
            SvdPanel.$$$reportNull$$$0(5);
        }
        SvdWindowState.ProjectState svdWindowProfileState = SvdWindowState.get((XDebugProcess)process);
        SvdTreeTable treeTable = SvdTreeTable.create(svdWindowProfileState);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)treeTable), (int)22, (int)30);
        return new SvdPanel(scrollPane, new DefaultActionGroup(), treeTable, process, svdWindowProfileState);
    }

    @NotNull
    public static SvdPanel registerPeripheralTab(@NotNull CidrDebugProcess process, @NotNull RunnerLayoutUi ui) {
        if (process == null) {
            SvdPanel.$$$reportNull$$$0(6);
        }
        if (ui == null) {
            SvdPanel.$$$reportNull$$$0(7);
        }
        final SvdPanel svdPanel = SvdPanel.create(process);
        Content content = ui.createContent("svdView", (JComponent)svdPanel, EmbeddedBundle.message("svd.panel.peripherals", new Object[0]), CLionEmbeddedIcons.CustomGdbRunConfiguration, svdPanel.getDefaultFocusComponent());
        content.setCloseable(false);
        content.setHelpId(HELP_ID);
        ui.addContent(content);
        process.getSession().addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                svdPanel.updateValues(false);
            }
        });
        SvdPanel svdPanel2 = svdPanel;
        if (svdPanel2 == null) {
            SvdPanel.$$$reportNull$$$0(8);
        }
        return svdPanel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeTable";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFocusComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "registerPeripheralTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerPeripheralTab";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

