/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.embedded.svd;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.RegisterAccess;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.RegisterReadAction;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdField;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdFile;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdNode;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdNodeBase;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdPeripheral;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdRegister;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdRegisterBigEndian;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdTreeTableModel;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.text.StringsKt;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvdRoot
implements SvdNode<SvdFile> {
    private final SvdTreeTableModel myTreeTableModel = new SvdTreeTableModel(this);
    private final List<SvdFile> files = new ArrayList<SvdFile>();
    private Set<SvdNode<?>> activeNodes = new HashSet();

    @Override
    @NotNull
    public List<SvdFile> getChildren() {
        List<SvdFile> list = this.files;
        if (list == null) {
            SvdRoot.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public String getId() {
        return "";
    }

    @Nullable
    public SvdFile addFile(InputStream stream, String shortName, @NlsSafe String fileName) {
        Document document;
        try {
            document = new SAXBuilder().build(stream);
        }
        catch (Exception e) {
            Messages.showErrorDialog((String)(fileName + ": " + e.getMessage()), (String)EmbeddedBundle.message("svd.root.load.error", new Object[0]));
            return null;
        }
        SvdFile svdFile = new SvdFile(shortName, fileName);
        ArrayList flatList = new ArrayList();
        List<Element> endian = SvdRoot.selectDomSubNodes(document.getRootElement(), "cpu", "endian");
        boolean bigEndian = !endian.isEmpty() && "big".equals(endian.get(0).getTextTrim());
        TreeMap elements = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        SvdRoot.selectDomSubNodes(document.getRootElement(), "peripherals", "peripheral").forEach(element -> elements.put(element.getChildText("name"), element));
        TreeMap<String, SvdNodeBase> grouped = new TreeMap<String, SvdNodeBase>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry entry : elements.entrySet()) {
            Element element2 = (Element)entry.getValue();
            String name = (String)entry.getKey();
            try {
                SvdPeripheral peripheral;
                String derivedFromName = element2.getAttributeValue("derivedFrom");
                Element derivedFrom = derivedFromName == null ? null : (Element)elements.get(derivedFromName);
                String description = SvdRoot.loadDescription(element2, derivedFrom);
                String groupName = SvdRoot.getDomSubTagText(element2, derivedFrom, "groupName");
                long baseAddress = SvdRoot.getDomSubTagValue(element2, derivedFrom, "baseAddress", Long::decode, 0L);
                int registerSize = SvdRoot.getDomSubTagValue(element2, derivedFrom, "size", Integer::decode, 32);
                RegisterAccess registerAccess = SvdRoot.getDomSubTagValue(element2, derivedFrom, "access", RegisterAccess::parse, RegisterAccess.READ_WRITE);
                if (groupName.isEmpty()) {
                    peripheral = new SvdPeripheral(shortName, name, description, registerAccess, baseAddress, registerSize);
                    flatList.add(peripheral);
                } else {
                    SvdNodeBase group = grouped.computeIfAbsent(groupName, s -> {
                        SvdNodeBase node = new SvdNodeBase(shortName + "|g:" + s, (String)s, "");
                        node.setChildren(new ArrayList());
                        return node;
                    });
                    peripheral = new SvdPeripheral(shortName, name, description, registerAccess, baseAddress, registerSize);
                    group.getChildren().add(peripheral);
                }
                SvdRoot.loadContent(peripheral, element2, derivedFrom, bigEndian);
            }
            catch (RuntimeException e) {
                Logger.getInstance(SvdFile.class).warn(MessageFormat.format("Svd parser error at {0}/{1}", element2.getName(), element2.getChildText("name")), (Throwable)e);
            }
        }
        block9: for (SvdNodeBase node : grouped.values()) {
            List children = node.getChildren();
            switch (children.size()) {
                case 0: {
                    continue block9;
                }
                case 1: {
                    flatList.add((SvdNodeBase)children.get(0));
                    continue block9;
                }
            }
            flatList.add(node);
        }
        flatList.sort(NAME_COMPARATOR);
        svdFile.setChildren(flatList);
        Objects.requireNonNull(this.getChildren()).add(svdFile);
        this.getTreeTableModel().notifyFileInserted(svdFile);
        return svdFile;
    }

    @NotNull
    public SvdTreeTableModel getTreeTableModel() {
        SvdTreeTableModel svdTreeTableModel = this.myTreeTableModel;
        if (svdTreeTableModel == null) {
            SvdRoot.$$$reportNull$$$0(1);
        }
        return svdTreeTableModel;
    }

    public boolean isActive(@NotNull SvdNode<?> child) {
        if (child == null) {
            SvdRoot.$$$reportNull$$$0(2);
        }
        return this.activeNodes.contains(child);
    }

    public void setActive(@NotNull Set<SvdNode<?>> nodes) {
        if (nodes == null) {
            SvdRoot.$$$reportNull$$$0(3);
        }
        this.activeNodes = nodes;
    }

    public void unloadFile(@NotNull SvdFile deleted) {
        int index;
        if (deleted == null) {
            SvdRoot.$$$reportNull$$$0(4);
        }
        if ((index = this.getChildren().indexOf(deleted)) >= 0) {
            this.getChildren().remove(index);
            this.getTreeTableModel().notifyFileDeleted(deleted, index);
        }
    }

    public Set<SvdNode<?>> getActiveNodes() {
        return this.activeNodes;
    }

    public void export(PrintWriter writer) {
        writer.write("Peripheral, Register, Value, Fields" + System.lineSeparator());
        boolean fileNamePrefix = this.getChildren().size() > 1;
        for (SvdFile file : this.files) {
            if (file.getChildren().stream().noneMatch(this::isActive)) continue;
            String prefix = fileNamePrefix ? file.getName() + ": " : "";
            file.exportCsv(writer, prefix, this::isActive);
        }
    }

    private static void loadContent(@NotNull SvdPeripheral peripheral, @NotNull Element peripheralElement, @Nullable Element peripheralDerivedFrom, boolean bigEndian) {
        if (peripheral == null) {
            SvdRoot.$$$reportNull$$$0(5);
        }
        if (peripheralElement == null) {
            SvdRoot.$$$reportNull$$$0(6);
        }
        TreeMap elements = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Stream.concat(SvdRoot.selectDomSubNodes(peripheralElement, "registers", "register").stream(), SvdRoot.selectDomSubNodes(peripheralDerivedFrom, "registers", "register").stream()).forEach(element -> elements.put(element.getChildText("name"), element));
        ArrayList<SvdRegister> registers = new ArrayList<SvdRegister>();
        for (Map.Entry entry : elements.entrySet()) {
            Element element2 = (Element)entry.getValue();
            String name = (String)entry.getKey();
            String derivedFromName = element2.getAttributeValue("derivedFrom");
            Element derivedFrom = derivedFromName == null ? null : (Element)elements.get(derivedFromName);
            Address address = Address.fromUnsignedLong((long)(peripheral.getBaseAddress() + SvdRoot.getDomSubTagValue(element2, derivedFrom, "addressOffset", Long::decode, 0L)));
            String description = SvdRoot.loadDescription(element2, derivedFrom) + " (" + SvdRoot.addressToString(address) + ")";
            int registerSize = SvdRoot.getDomSubTagValue(element2, derivedFrom, "size", Integer::decode, peripheral.getRegisterBitSize());
            RegisterAccess registerAccess = SvdRoot.getDomSubTagValue(element2, derivedFrom, "access", RegisterAccess::parse, peripheral.getRegisterAccess());
            RegisterReadAction registerReadAction = SvdRoot.getDomSubTagValue(element2, derivedFrom, "access", RegisterReadAction::parse, null);
            SvdRegister register = bigEndian ? new SvdRegisterBigEndian(peripheral.getId(), name, description, address, registerSize, registerAccess, registerReadAction) : new SvdRegister(peripheral.getId(), name, description, address, registerSize, registerAccess, registerReadAction);
            SvdRoot.loadContent(register, element2, derivedFrom);
            registers.add(register);
        }
        registers.sort(Comparator.comparing(SvdRegister::getAddress));
        peripheral.setChildren(registers);
    }

    @NotNull
    public static String addressToString(Address address) {
        long value = address.getUnsignedLongValue();
        if ((value & 0xFFFFFFFF00000000L) == 0L) {
            String string = "0x" + StringsKt.padStart((String)Integer.toHexString((int)value), (int)8, (char)'0');
            if (string == null) {
                SvdRoot.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = address.toString();
        if (string == null) {
            SvdRoot.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static String loadDescription(@NotNull Element element, @Nullable Element derivedFrom) {
        if (element == null) {
            SvdRoot.$$$reportNull$$$0(9);
        }
        return Text.normalizeString((String)SvdRoot.getDomSubTagText(element, derivedFrom, "description"));
    }

    @NotNull
    private static String getDomSubTagText(@NotNull Element element, @Nullable Element derivedFrom, @NotNull String tagName) {
        if (element == null) {
            SvdRoot.$$$reportNull$$$0(10);
        }
        if (tagName == null) {
            SvdRoot.$$$reportNull$$$0(11);
        }
        String string = SvdRoot.getDomSubTagValue(element, derivedFrom, tagName, String::valueOf, "");
        if (string == null) {
            SvdRoot.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    @Contract(value="_,_,_,_,!null->!null")
    private static <T> T getDomSubTagValue(@NotNull Element element, @Nullable Element derivedFrom, @NotNull String tagName, Function<String, T> convert, @Nullable T defaultValue) {
        String text;
        if (element == null) {
            SvdRoot.$$$reportNull$$$0(13);
        }
        if (tagName == null) {
            SvdRoot.$$$reportNull$$$0(14);
        }
        if ((text = element.getChildText(tagName)) != null) {
            return convert.apply(text);
        }
        if (derivedFrom != null) {
            text = derivedFrom.getChildText(tagName);
        }
        return text == null ? defaultValue : convert.apply(text);
    }

    @NotNull
    private static List<Element> selectDomSubNodes(@Nullable Element parent, String ... selectors) {
        if (parent == null) {
            List<Element> list = Collections.emptyList();
            if (list == null) {
                SvdRoot.$$$reportNull$$$0(15);
            }
            return list;
        }
        for (int i = 0; i < selectors.length - 1; ++i) {
            if ((parent = parent.getChild(selectors[i])) != null) continue;
            List<Element> list = Collections.emptyList();
            if (list == null) {
                SvdRoot.$$$reportNull$$$0(16);
            }
            return list;
        }
        List list = parent.getChildren(selectors[selectors.length - 1]);
        if (list == null) {
            SvdRoot.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static void loadContent(@NotNull SvdRegister register, @NotNull Element peripheralElement, @Nullable Element peripheralDerivedFrom) {
        if (register == null) {
            SvdRoot.$$$reportNull$$$0(18);
        }
        if (peripheralElement == null) {
            SvdRoot.$$$reportNull$$$0(19);
        }
        TreeMap elements = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Stream.concat(SvdRoot.selectDomSubNodes(peripheralElement, "fields", "field").stream(), SvdRoot.selectDomSubNodes(peripheralDerivedFrom, "fields", "field").stream()).forEach(element -> elements.put(element.getChildText("name"), element));
        ArrayList<SvdField> fields = new ArrayList<SvdField>();
        for (Map.Entry entry : elements.entrySet()) {
            int bitSize;
            Element element2 = (Element)entry.getValue();
            String name = (String)entry.getKey();
            String derivedFromName = element2.getAttributeValue("derivedFrom");
            Element derivedFrom = derivedFromName == null ? null : (Element)elements.get(derivedFromName);
            RegisterAccess registerAccess = SvdRoot.getDomSubTagValue(element2, derivedFrom, "access", RegisterAccess::parse, register.getAccess());
            RegisterReadAction registerReadAction = SvdRoot.getDomSubTagValue(element2, derivedFrom, "access", RegisterReadAction::parse, null);
            int bitOffset = SvdRoot.getDomSubTagValue(element2, derivedFrom, "bitOffset", Integer::parseInt, -1);
            if (bitOffset >= 0) {
                bitSize = SvdRoot.getDomSubTagValue(element2, derivedFrom, "bitWidth", Integer::parseInt, register.getBitSize() - bitOffset);
            } else {
                bitOffset = SvdRoot.getDomSubTagValue(element2, derivedFrom, "lsb", Integer::parseInt, -1);
                if (bitOffset >= 0) {
                    bitSize = SvdRoot.getDomSubTagValue(element2, derivedFrom, "msb", Integer::parseInt, register.getBitSize()) - bitOffset + 1;
                } else {
                    String bitRange = SvdRoot.getDomSubTagText(element2, derivedFrom, "bitRange");
                    int columnIndex = (bitRange = bitRange.replaceAll("\\s|\\[|]", "")).indexOf(58);
                    if (columnIndex < 1) {
                        bitOffset = 0;
                        bitSize = register.getBitSize();
                    } else {
                        int bitEnd = Integer.parseUnsignedInt(bitRange.substring(0, columnIndex), 10);
                        int bitStart = Integer.parseUnsignedInt(bitRange.substring(columnIndex + 1), 10);
                        bitOffset = Math.min(bitEnd, bitStart);
                        bitSize = Math.abs(bitEnd - bitStart) + 1;
                    }
                }
            }
            Object description = SvdRoot.loadDescription(element2, derivedFrom);
            description = bitSize == 1 ? (String)description + " [" + bitOffset + "]" : (String)description + " [" + bitOffset + ":" + (bitOffset + bitSize - 1) + "]";
            fields.add(new SvdField(register, name, (String)description, registerAccess, registerReadAction, bitOffset, bitSize));
        }
        fields.sort(Comparator.comparingInt(SvdField::getBitOffset));
        register.setChildren(fields);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "peripheral";
                break;
            }
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "peripheralElement";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "register";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeTableModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdRoot";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addressToString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomSubTagText";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "selectDomSubNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setActive";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unloadFile";
                break;
            }
            case 5: 
            case 6: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadDescription";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDomSubTagText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDomSubTagValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

