/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.embedded.svd;

import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdAddressCoalescer;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdFile;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdNode;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdRegister;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdRoot;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvdTreeTableModel
implements TreeTableModel {
    private final SvdRoot myRoot;
    private final Map<SvdNode<?>, List<SvdNode<?>>> myActiveCache;
    private final SmartList<TreeModelListener> myListeners;
    private SvdAddressCoalescer myCoalescer;

    SvdTreeTableModel(@NotNull SvdRoot root) {
        if (root == null) {
            SvdTreeTableModel.$$$reportNull$$$0(0);
        }
        this.myActiveCache = new HashMap();
        this.myListeners = new SmartList();
        this.myRoot = root;
    }

    public int getColumnCount() {
        return 3;
    }

    @NotNull
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                String string = EmbeddedBundle.message("svd.table.name.column", new Object[0]);
                if (string == null) {
                    SvdTreeTableModel.$$$reportNull$$$0(1);
                }
                return string;
            }
            case 1: {
                String string = EmbeddedBundle.message("svd.table.value.column", new Object[0]);
                if (string == null) {
                    SvdTreeTableModel.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        String string = EmbeddedBundle.message("svd.table.description.column", new Object[0]);
        if (string == null) {
            SvdTreeTableModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Class<?> getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    @NotNull
    public Object getValueAt(@NotNull Object node, int column) {
        if (node == null) {
            SvdTreeTableModel.$$$reportNull$$$0(4);
        }
        switch (column) {
            case 0: {
                String string = node.toString();
                if (string == null) {
                    SvdTreeTableModel.$$$reportNull$$$0(5);
                }
                return string;
            }
            case 1: {
                String string = ((SvdNode)node).getDisplayValue();
                if (string == null) {
                    SvdTreeTableModel.$$$reportNull$$$0(6);
                }
                return string;
            }
        }
        String string = ((SvdNode)node).getDescription();
        if (string == null) {
            SvdTreeTableModel.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isCellEditable(@NotNull Object node, int column) {
        if (node == null) {
            SvdTreeTableModel.$$$reportNull$$$0(8);
        }
        return false;
    }

    public void setValueAt(@Nullable Object aValue, @NotNull Object node, int column) {
        if (node == null) {
            SvdTreeTableModel.$$$reportNull$$$0(9);
        }
    }

    public void setTree(JTree tree) {
    }

    @NotNull
    public SvdRoot getRoot() {
        SvdRoot svdRoot = this.myRoot;
        if (svdRoot == null) {
            SvdTreeTableModel.$$$reportNull$$$0(10);
        }
        return svdRoot;
    }

    @NotNull
    public Object getChild(@NotNull Object parent, int index) {
        if (parent == null) {
            SvdTreeTableModel.$$$reportNull$$$0(11);
        }
        List<SvdNode<?>> activeChildren = this.getActiveChildren(parent);
        SvdNode<?> svdNode = activeChildren.get(index);
        if (svdNode == null) {
            SvdTreeTableModel.$$$reportNull$$$0(12);
        }
        return svdNode;
    }

    @NotNull
    private List<SvdNode<?>> getActiveChildren(@NotNull Object parentObject) {
        if (parentObject == null) {
            SvdTreeTableModel.$$$reportNull$$$0(13);
        }
        if (parentObject == this.myRoot || parentObject instanceof SvdRegister) {
            List<SvdNode<?>> list = ((SvdNode)parentObject).getChildren();
            if (list == null) {
                SvdTreeTableModel.$$$reportNull$$$0(14);
            }
            return list;
        }
        SvdNode parent = (SvdNode)parentObject;
        List<SvdNode<?>> nodes = this.myActiveCache.get(parent);
        if (nodes == null) {
            nodes = new ArrayList();
            for (SvdNode child : parent.getChildren()) {
                if (!this.myRoot.isActive(child)) continue;
                nodes.add(child);
            }
            this.myActiveCache.put(parent, nodes);
        }
        List<SvdNode<?>> list = nodes;
        if (list == null) {
            SvdTreeTableModel.$$$reportNull$$$0(15);
        }
        return list;
    }

    public int getChildCount(@NotNull Object parent) {
        if (parent == null) {
            SvdTreeTableModel.$$$reportNull$$$0(16);
        }
        List<SvdNode<?>> activeChildren = this.getActiveChildren(parent);
        return activeChildren.size();
    }

    public boolean isLeaf(@NotNull Object node) {
        if (node == null) {
            SvdTreeTableModel.$$$reportNull$$$0(17);
        }
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(@NotNull TreePath path, @Nullable Object newValue) {
        if (path == null) {
            SvdTreeTableModel.$$$reportNull$$$0(18);
        }
    }

    public int getIndexOfChild(@NotNull Object parent, Object child) {
        if (parent == null) {
            SvdTreeTableModel.$$$reportNull$$$0(19);
        }
        List<SvdNode<?>> activeChildren = this.getActiveChildren(parent);
        return activeChildren.indexOf(child);
    }

    public void addTreeModelListener(@NotNull TreeModelListener l) {
        if (l == null) {
            SvdTreeTableModel.$$$reportNull$$$0(20);
        }
        this.myListeners.add((Object)l);
    }

    public void removeTreeModelListener(@NotNull TreeModelListener l) {
        if (l == null) {
            SvdTreeTableModel.$$$reportNull$$$0(21);
        }
        this.myListeners.remove((Object)l);
    }

    public void notifyFileInserted(@NotNull SvdFile newSvdFile) {
        if (newSvdFile == null) {
            SvdTreeTableModel.$$$reportNull$$$0(22);
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(this.myRoot), new int[]{this.getIndexOfChild(this.getRoot(), newSvdFile)}, new Object[]{newSvdFile});
        for (TreeModelListener listener : this.myListeners) {
            listener.treeStructureChanged(event);
        }
    }

    public void notifyTreeUpdated() {
        this.resetActiveCache();
        TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(this.myRoot), ArrayUtil.EMPTY_INT_ARRAY, ArrayUtil.EMPTY_OBJECT_ARRAY);
        for (TreeModelListener listener : this.myListeners) {
            listener.treeStructureChanged(event);
        }
    }

    public void notifyFileDeleted(@NotNull SvdFile deleted, int index) {
        if (deleted == null) {
            SvdTreeTableModel.$$$reportNull$$$0(23);
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(this.myRoot), new int[]{index}, new Object[]{deleted});
        for (TreeModelListener listener : this.myListeners) {
            listener.treeNodesRemoved(event);
        }
    }

    public void resetActiveCache() {
        this.myActiveCache.clear();
        this.myCoalescer = SvdAddressCoalescer.create(this.myRoot.getActiveNodes());
    }

    public void updateValues(@NotNull CidrDebugProcess process, @NotNull Runnable updateListener) {
        if (process == null) {
            SvdTreeTableModel.$$$reportNull$$$0(24);
        }
        if (updateListener == null) {
            SvdTreeTableModel.$$$reportNull$$$0(25);
        }
        this.myCoalescer.updateValues(process, updateListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdTreeTableModel";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentObject";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSvdFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdTreeTableModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAt";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChild";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValueAt";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCellEditable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getActiveChildren";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildCount";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isLeaf";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "valueForPathChanged";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOfChild";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addTreeModelListener";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeTreeModelListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "notifyFileInserted";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "notifyFileDeleted";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

