/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogListenersManager;
import com.intellij.internal.statistic.eventLog.FilteredEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.StatisticsSystemEventIdProvider;
import com.intellij.internal.statistic.eventLog.validator.IntellijSensitiveDataValidator;
import com.intellij.internal.statistic.eventLog.validator.SensitiveDataValidator;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u00019BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020(H\u0016J4\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u00042\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002000/H\u0002J:\u00101\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00042\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002000/2\u0006\u00106\u001a\u00020\u0007H\u0016J\b\u00107\u001a\u00020\"H\u0002J\b\u00108\u001a\u00020\"H\u0016R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsFileEventLogger;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "Lcom/intellij/openapi/Disposable;", "recorderId", "", "sessionId", "headless", "", "build", "bucket", "recorderVersion", "writer", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "systemEventIdProvider", "Lcom/intellij/internal/statistic/eventLog/StatisticsSystemEventIdProvider;", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;Lcom/intellij/internal/statistic/eventLog/StatisticsSystemEventIdProvider;)V", "eventMergeTimeoutMs", "", "lastEvent", "Lcom/intellij/internal/statistic/eventLog/StatisticsFileEventLogger$FusEvent;", "lastEventCreatedTime", "lastEventFlushFuture", "Ljava/util/concurrent/ScheduledFuture;", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "lastEventTime", "logExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "getLogExecutor", "()Ljava/util/concurrent/ExecutorService;", "mergeStrategy", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventMergeStrategy;", "cleanup", "", "dispose", "flush", "getActiveLogFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "log", "event", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "createdTime", "rawEventId", "rawData", "", "", "logAsync", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "data", "isState", "logLastEvent", "rollOver", "FusEvent", "intellij.platform.statistics"})
public class StatisticsFileEventLogger
implements StatisticsEventLogger,
Disposable {
    @NotNull
    private final ExecutorService logExecutor;
    private FusEvent lastEvent;
    private long lastEventTime;
    private long lastEventCreatedTime;
    private long eventMergeTimeoutMs;
    private final StatisticsEventMergeStrategy mergeStrategy;
    private ScheduledFuture<CompletableFuture<Void>> lastEventFlushFuture;
    private final String recorderId;
    private final String sessionId;
    private final boolean headless;
    private final String build;
    private final String bucket;
    private final String recorderVersion;
    private final StatisticsEventLogWriter writer;
    private final StatisticsSystemEventIdProvider systemEventIdProvider;

    @NotNull
    protected final ExecutorService getLogExecutor() {
        return this.logExecutor;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> logAsync(@NotNull EventLogGroup group, @NotNull String eventId, @NotNull Map<String, ? extends Object> data, boolean isState) {
        CompletableFuture<Object> completableFuture;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        long eventTime = System.currentTimeMillis();
        group.validateEventId$intellij_platform_statistics(eventId);
        try {
            CompletableFuture<Void> completableFuture2 = CompletableFuture.runAsync(new Runnable(this, group, eventTime, eventId, data, isState){
                final /* synthetic */ StatisticsFileEventLogger this$0;
                final /* synthetic */ EventLogGroup $group;
                final /* synthetic */ long $eventTime;
                final /* synthetic */ String $eventId;
                final /* synthetic */ Map $data;
                final /* synthetic */ boolean $isState;

                public final void run() {
                    IntellijSensitiveDataValidator intellijSensitiveDataValidator = IntellijSensitiveDataValidator.getInstance(StatisticsFileEventLogger.access$getRecorderId$p(this.this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)intellijSensitiveDataValidator), (String)"IntellijSensitiveDataVal\u2026r.getInstance(recorderId)");
                    IntellijSensitiveDataValidator validator = intellijSensitiveDataValidator;
                    if (!validator.isGroupAllowed(this.$group)) {
                        return;
                    }
                    LogEvent event = SensitiveDataValidator.validate$default((SensitiveDataValidator)validator, (String)this.$group.getId(), (String)String.valueOf(this.$group.getVersion()), (String)StatisticsFileEventLogger.access$getBuild$p(this.this$0), (String)StatisticsFileEventLogger.access$getSessionId$p(this.this$0), (String)StatisticsFileEventLogger.access$getBucket$p(this.this$0), (long)this.$eventTime, (String)StatisticsFileEventLogger.access$getRecorderVersion$p(this.this$0), (String)this.$eventId, (Map)this.$data, (boolean)this.$isState, (int)0, (int)1024, null);
                    if (event != null) {
                        StatisticsFileEventLogger.access$log(this.this$0, event, System.currentTimeMillis(), this.$eventId, this.$data);
                    }
                }
                {
                    this.this$0 = statisticsFileEventLogger;
                    this.$group = eventLogGroup;
                    this.$eventTime = l;
                    this.$eventId = string;
                    this.$data = map;
                    this.$isState = bl;
                }
            }, this.logExecutor);
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"CompletableFuture.runAsy\u2026  }\n      }, logExecutor)");
            completableFuture = completableFuture2;
        }
        catch (RejectedExecutionException e) {
            CompletableFuture<Object> completableFuture3 = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"CompletableFuture.completedFuture(null)");
            completableFuture = completableFuture3;
        }
        return completableFuture;
    }

    /*
     * Unable to fully structure code
     */
    private final void log(LogEvent event, long createdTime, String rawEventId, Map<String, ? extends Object> rawData) {
        if (this.lastEvent == null || event.getTime() - this.lastEventTime > this.eventMergeTimeoutMs) ** GOTO lbl-1000
        v0 = this.lastEvent;
        Intrinsics.checkNotNull((Object)v0);
        if (this.mergeStrategy.shouldMerge(v0.getValidatedEvent(), event)) {
            this.lastEventTime = event.getTime();
            v1 = this.lastEvent;
            Intrinsics.checkNotNull((Object)v1);
            v1.getValidatedEvent().getEvent().increment();
        } else lbl-1000:
        // 2 sources

        {
            this.logLastEvent();
            this.lastEvent = StatisticsRecorderUtil.isTestModeEnabled(this.recorderId) != false ? new FusEvent(event, rawEventId, rawData) : new FusEvent(event, null, null);
            this.lastEventTime = event.getTime();
            this.lastEventCreatedTime = createdTime;
        }
        if (StatisticsRecorderUtil.isTestModeEnabled(this.recorderId)) {
            v2 = this.lastEventFlushFuture;
            if (v2 != null) {
                v2.cancel(false);
            }
            var6_5 = (Function0)new Function0<CompletableFuture<Void>>(this){

                @NotNull
                public final CompletableFuture<Void> invoke() {
                    return ((StatisticsFileEventLogger)this.receiver).flush();
                }
            };
            this.lastEventFlushFuture = AppExecutorUtil.getAppScheduledExecutorService().schedule(new Callable(var6_5){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ Object call() {
                    return this.function.invoke();
                }
            }, this.eventMergeTimeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    private final void logLastEvent() {
        FusEvent fusEvent = this.lastEvent;
        if (fusEvent != null) {
            FusEvent fusEvent2 = fusEvent;
            boolean bl = false;
            boolean bl2 = false;
            FusEvent it = fusEvent2;
            boolean bl3 = false;
            LogEventAction event = it.getValidatedEvent().getEvent();
            if (event.isEventGroup()) {
                event.addData("last", (Object)this.lastEventTime);
            }
            event.addData("created", (Object)this.lastEventCreatedTime);
            long systemEventId = this.systemEventIdProvider.getSystemEventId(this.recorderId);
            event.addData("system_event_id", (Object)systemEventId);
            this.systemEventIdProvider.setSystemEventId(this.recorderId, ++systemEventId);
            if (this.headless) {
                event.addData("system_headless", (Object)true);
            }
            this.writer.log(it.getValidatedEvent());
            ((EventLogListenersManager)ApplicationManager.getApplication().getService(EventLogListenersManager.class)).notifySubscribers(this.recorderId, it.getValidatedEvent(), it.getRawEventId(), it.getRawData());
        }
        this.lastEvent = null;
    }

    @Override
    @Nullable
    public EventLogFile getActiveLogFile() {
        return this.writer.getActiveFile();
    }

    @Override
    @NotNull
    public EventLogFilesProvider getLogFilesProvider() {
        return this.writer.getLogFilesProvider();
    }

    @Override
    public void cleanup() {
        this.writer.cleanup();
    }

    @Override
    public void rollOver() {
        this.writer.rollOver();
    }

    public void dispose() {
        this.flush();
        this.logExecutor.shutdown();
        Disposer.dispose((Disposable)this.writer);
    }

    @NotNull
    public final CompletableFuture<Void> flush() {
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(new Runnable(this){
            final /* synthetic */ StatisticsFileEventLogger this$0;

            public final void run() {
                StatisticsFileEventLogger.access$logLastEvent(this.this$0);
            }
            {
                this.this$0 = statisticsFileEventLogger;
            }
        }, this.logExecutor);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.runAsy\u2026ent()\n    }, logExecutor)");
        return completableFuture;
    }

    public StatisticsFileEventLogger(@NotNull String recorderId, @NotNull String sessionId, boolean headless, @NotNull String build2, @NotNull String bucket, @NotNull String recorderVersion, @NotNull StatisticsEventLogWriter writer, @NotNull StatisticsSystemEventIdProvider systemEventIdProvider) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)recorderVersion, (String)"recorderVersion");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)systemEventIdProvider, (String)"systemEventIdProvider");
        this.recorderId = recorderId;
        this.sessionId = sessionId;
        this.headless = headless;
        this.build = build2;
        this.bucket = bucket;
        this.recorderVersion = recorderVersion;
        this.writer = writer;
        this.systemEventIdProvider = systemEventIdProvider;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)("StatisticsFileEventLogger: " + this.sessionId), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026ntLogger: $sessionId\", 1)");
        this.logExecutor = executorService;
        this.mergeStrategy = new FilteredEventMergeStrategy(SetsKt.hashSetOf((Object[])new String[]{"start_time"}));
        this.eventMergeTimeoutMs = StatisticsRecorderUtil.isTestModeEnabled(this.recorderId) ? 500L : 10000L;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> logAsync(@NotNull EventLogGroup group, @NotNull String eventId, boolean isState) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        return StatisticsEventLogger.DefaultImpls.logAsync(this, group, eventId, isState);
    }

    @Override
    @Deprecated(message="Use StatisticsEventLogger.logAsync()", replaceWith=@ReplaceWith(imports={}, expression="logAsync(group, eventId, isState)"))
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void log(@NotNull EventLogGroup group, @NotNull String eventId, boolean isState) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        StatisticsEventLogger.DefaultImpls.log(this, group, eventId, isState);
    }

    @Override
    @Deprecated(message="Use StatisticsEventLogger.logAsync", replaceWith=@ReplaceWith(imports={}, expression="logAsync(group, eventId, data, isState)"))
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void log(@NotNull EventLogGroup group, @NotNull String eventId, @NotNull Map<String, ? extends Object> data, boolean isState) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        StatisticsEventLogger.DefaultImpls.log(this, group, eventId, data, isState);
    }

    public static final /* synthetic */ String access$getRecorderId$p(StatisticsFileEventLogger $this) {
        return $this.recorderId;
    }

    public static final /* synthetic */ String access$getBuild$p(StatisticsFileEventLogger $this) {
        return $this.build;
    }

    public static final /* synthetic */ String access$getSessionId$p(StatisticsFileEventLogger $this) {
        return $this.sessionId;
    }

    public static final /* synthetic */ String access$getBucket$p(StatisticsFileEventLogger $this) {
        return $this.bucket;
    }

    public static final /* synthetic */ String access$getRecorderVersion$p(StatisticsFileEventLogger $this) {
        return $this.recorderVersion;
    }

    public static final /* synthetic */ void access$log(StatisticsFileEventLogger $this, LogEvent event, long createdTime, String rawEventId, Map rawData) {
        $this.log(event, createdTime, rawEventId, rawData);
    }

    public static final /* synthetic */ void access$logLastEvent(StatisticsFileEventLogger $this) {
        $this.logLastEvent();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0017\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007H\u00c6\u0003J7\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsFileEventLogger$FusEvent;", "", "validatedEvent", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "rawEventId", "", "rawData", "", "(Lcom/intellij/internal/statistic/eventLog/LogEvent;Ljava/lang/String;Ljava/util/Map;)V", "getRawData", "()Ljava/util/Map;", "getRawEventId", "()Ljava/lang/String;", "getValidatedEvent", "()Lcom/intellij/internal/statistic/eventLog/LogEvent;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    private static final class FusEvent {
        @NotNull
        private final LogEvent validatedEvent;
        @Nullable
        private final String rawEventId;
        @Nullable
        private final Map<String, Object> rawData;

        @NotNull
        public final LogEvent getValidatedEvent() {
            return this.validatedEvent;
        }

        @Nullable
        public final String getRawEventId() {
            return this.rawEventId;
        }

        @Nullable
        public final Map<String, Object> getRawData() {
            return this.rawData;
        }

        public FusEvent(@NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
            Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
            this.validatedEvent = validatedEvent;
            this.rawEventId = rawEventId;
            this.rawData = rawData;
        }

        @NotNull
        public final LogEvent component1() {
            return this.validatedEvent;
        }

        @Nullable
        public final String component2() {
            return this.rawEventId;
        }

        @Nullable
        public final Map<String, Object> component3() {
            return this.rawData;
        }

        @NotNull
        public final FusEvent copy(@NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
            Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
            return new FusEvent(validatedEvent, rawEventId, rawData);
        }

        public static /* synthetic */ FusEvent copy$default(FusEvent fusEvent, LogEvent logEvent, String string, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                logEvent = fusEvent.validatedEvent;
            }
            if ((n & 2) != 0) {
                string = fusEvent.rawEventId;
            }
            if ((n & 4) != 0) {
                map = fusEvent.rawData;
            }
            return fusEvent.copy(logEvent, string, map);
        }

        @NotNull
        public String toString() {
            return "FusEvent(validatedEvent=" + this.validatedEvent + ", rawEventId=" + this.rawEventId + ", rawData=" + this.rawData + ")";
        }

        public int hashCode() {
            LogEvent logEvent = this.validatedEvent;
            String string = this.rawEventId;
            Map<String, Object> map = this.rawData;
            return ((logEvent != null ? logEvent.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FusEvent)) break block3;
                    FusEvent fusEvent = (FusEvent)object;
                    if (!Intrinsics.areEqual((Object)this.validatedEvent, (Object)fusEvent.validatedEvent) || !Intrinsics.areEqual((Object)this.rawEventId, (Object)fusEvent.rawEventId) || !Intrinsics.areEqual(this.rawData, fusEvent.rawData)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

