/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.utils;

import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.TestModeValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.UtilValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.UtilRuleProducer;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomRuleProducer
extends UtilRuleProducer {
    private final boolean myTestMode;

    public CustomRuleProducer(@NotNull String recorderId) {
        if (recorderId == null) {
            CustomRuleProducer.$$$reportNull$$$0(0);
        }
        this.myTestMode = StatisticsRecorderUtil.isTestModeEnabled(recorderId);
    }

    @Nullable
    public UtilValidationRule createValidationRule(@NotNull String value, @NotNull EventGroupContextData contextData) {
        if (value == null) {
            CustomRuleProducer.$$$reportNull$$$0(1);
        }
        if (contextData == null) {
            CustomRuleProducer.$$$reportNull$$$0(2);
        }
        for (CustomValidationRule customValidationRule : (CustomValidationRule[])CustomValidationRule.EP_NAME.getExtensions()) {
            if (!this.isAcceptedRule(customValidationRule) || !customValidationRule.acceptRuleId(value)) continue;
            return customValidationRule;
        }
        for (PerformanceCareRule performanceCareRule : (CustomWhiteListRule[])CustomWhiteListRule.EP_NAME.getExtensions()) {
            if (!this.isAcceptedRule((FUSRule)performanceCareRule) || !performanceCareRule.acceptRuleId(value)) continue;
            return performanceCareRule;
        }
        return null;
    }

    private boolean isAcceptedRule(FUSRule extension) {
        if (extension instanceof TestModeValidationRule && !this.myTestMode) {
            return false;
        }
        return CustomRuleProducer.isDevelopedByJetBrains(extension);
    }

    private static boolean isDevelopedByJetBrains(FUSRule extension) {
        return ApplicationManager.getApplication().isUnitTestMode() || PluginInfoDetectorKt.getPluginInfo(extension.getClass()).isDevelopedByJetBrains();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/utils/CustomRuleProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createValidationRule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

