/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.util;

import com.intellij.ide.DataManager;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.BaseGraphStructureViewBuilder;
import com.intellij.openapi.graph.builder.util.CompositeDataProvider;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeCellRendererPainter;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphViewUtil {
    @NotNull
    private static final Key<NodeCellRenderer> NODE_CELL_RENDERER_KEY = Key.create((String)"com.intellij.openapi.graph.builder.util.GraphViewUtil.NODE_CELL_RENDERER_KEY");

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static boolean isPrintMode() {
        return GraphExportService.getInstance().isPrintMode();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static void setPrintMode(boolean printMode) {
        GraphExportService.getInstance().setPrintMode(printMode);
    }

    @Nullable
    public static Object getData(Graph2DView view, String data) {
        DataProvider dataProvider = DataManager.getDataProvider((JComponent)view.getJComponent());
        if (dataProvider == null) {
            return null;
        }
        return dataProvider.getData(data);
    }

    public static void addDataProvider(Graph2DView graph2DView, @NotNull DataProvider dataProvider) {
        CompositeDataProvider compositeDataProvider;
        DataProvider oldDataProvider;
        if (dataProvider == null) {
            GraphViewUtil.$$$reportNull$$$0(0);
        }
        if ((oldDataProvider = DataManager.getDataProvider((JComponent)graph2DView.getJComponent())) == null) {
            compositeDataProvider = new CompositeDataProvider();
            compositeDataProvider.add(GraphViewUtil.createDefaultGraphDataProvider(graph2DView));
        } else if (oldDataProvider instanceof CompositeDataProvider) {
            compositeDataProvider = (CompositeDataProvider)oldDataProvider;
        } else {
            compositeDataProvider = new CompositeDataProvider();
            compositeDataProvider.add(oldDataProvider);
        }
        compositeDataProvider.add(dataProvider);
        DataManager.registerDataProvider((JComponent)graph2DView.getJComponent(), (DataProvider)compositeDataProvider);
    }

    private static DataProvider createDefaultGraphDataProvider(Graph2DView graph2DView) {
        return dataId -> GraphDataKeys.GRAPH.is(dataId) ? graph2DView.getGraph2D() : null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @NotNull
    public static List<Node> getSelectedNodes(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphViewUtil.$$$reportNull$$$0(1);
        }
        List<Node> list = GraphSelectionService.getInstance().getSelectedNodes(graph);
        if (list == null) {
            GraphViewUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static NodeRealizer createNodeRealizer(@NotNull @NonNls String configuration, @NotNull NodeCellRenderer nodeCellRenderer) {
        if (configuration == null) {
            GraphViewUtil.$$$reportNull$$$0(3);
        }
        if (nodeCellRenderer == null) {
            GraphViewUtil.$$$reportNull$$$0(4);
        }
        GenericNodeRealizer.Factory factory = GenericNodeRealizer.Statics.getFactory();
        Map map = factory.createDefaultConfigurationMap();
        map.put(GenericNodeRealizer.Painter.class, GraphManager.getGraphManager().createFastNodeCellRendererPainter(nodeCellRenderer, NodeCellRendererPainter.USER_DATA_MAP));
        map.put(GenericNodeRealizer.HotSpotPainter.class, GraphManager.getGraphManager().createHotSpotPainter());
        factory.addConfiguration(configuration, map);
        GenericNodeRealizer nodeRealizer = GraphManager.getGraphManager().createGenericNodeRealizer(configuration);
        UserDataHolderBase nodeRealizerUserData = new UserDataHolderBase();
        nodeRealizer.setUserData(nodeRealizerUserData);
        nodeRealizerUserData.putUserData(NODE_CELL_RENDERER_KEY, (Object)nodeCellRenderer);
        GenericNodeRealizer genericNodeRealizer = nodeRealizer;
        if (genericNodeRealizer == null) {
            GraphViewUtil.$$$reportNull$$$0(5);
        }
        return genericNodeRealizer;
    }

    public static void setRenderedNodeSizes(@NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull Node node) {
        NodeLabel nodeLabel;
        GroupNodeRealizer groupNodeRealizer;
        NodeCellRenderer nodeCellRenderer;
        Object realizerUserData;
        NodeRealizer nodeRealizer;
        if (graph == null) {
            GraphViewUtil.$$$reportNull$$$0(6);
        }
        if (view == null) {
            GraphViewUtil.$$$reportNull$$$0(7);
        }
        if (node == null) {
            GraphViewUtil.$$$reportNull$$$0(8);
        }
        if ((nodeRealizer = graph.getRealizer(node)) instanceof GenericNodeRealizer && (realizerUserData = ((GenericNodeRealizer)nodeRealizer).getUserData()) instanceof UserDataHolder && (nodeCellRenderer = (NodeCellRenderer)((UserDataHolder)realizerUserData).getUserData(NODE_CELL_RENDERER_KEY)) != null) {
            Dimension size = nodeCellRenderer.getNodeCellRendererComponent(view, nodeRealizer, null, false).getPreferredSize();
            graph.setSize(nodeRealizer.getNode(), GraphManager.getGraphManager().createYDimension(size.width, size.height));
        }
        if (nodeRealizer instanceof GroupNodeRealizer && (groupNodeRealizer = (GroupNodeRealizer)nodeRealizer).isGroupClosed() && (nodeLabel = groupNodeRealizer.getLabel()) != null) {
            graph.setSize(node, nodeLabel.getWidth(), 2.0 * nodeLabel.getHeight());
        }
    }

    @Deprecated
    public static DefaultActionGroup getBasicToolbar(GraphBuilder builder) {
        return GraphViewUtil.getCommonToolbarActions();
    }

    public static DefaultActionGroup getCommonToolbarActions() {
        return (DefaultActionGroup)ActionManager.getInstance().getAction("Graph.DefaultGraphToolbar");
    }

    public static AnAction getCommonPopupActions() {
        return ActionManager.getInstance().getAction("Graph.DefaultGraphPopup");
    }

    public static void updateWorldRect(@NotNull Graph2DView view) {
        if (view == null) {
            GraphViewUtil.$$$reportNull$$$0(9);
        }
        Rectangle graphBoundingBox = view.getGraph2D().getBoundingBox();
        int x = (int)graphBoundingBox.getX() - 20;
        int y = (int)graphBoundingBox.getY() - 20;
        int width = (int)graphBoundingBox.getWidth() + 40;
        int height = (int)graphBoundingBox.getHeight() + 40;
        view.setWorldRect(x, y, width, height);
    }

    @Deprecated
    public static StructureViewBuilder createStructureViewBuilder(final Overview overview) {
        DefaultBackgroundRenderer renderer = GraphManager.getGraphManager().createDefaultBackgroundRenderer(overview);
        renderer.setColor(UIUtil.getListBackground());
        overview.setBackgroundRenderer(renderer);
        overview.getJComponent().putClientProperty("Overview.FogColor", new JBColor(new Color(0.0f, 0.0f, 0.0f, 0.15f), new Color(1.0f, 1.0f, 1.0f, 0.1f)));
        return new StructureViewBuilder(){

            @NotNull
            public StructureView createStructureView(final FileEditor fileEditor, @NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new StructureView(){

                    public FileEditor getFileEditor() {
                        return fileEditor;
                    }

                    public boolean navigateToSelectedElement(boolean requestFocus) {
                        return false;
                    }

                    public JComponent getComponent() {
                        return overview.getJComponent();
                    }

                    public void dispose() {
                    }

                    public void centerSelectedRow() {
                    }

                    public void restoreState() {
                    }

                    public void storeState() {
                    }

                    @NotNull
                    public StructureViewModel getTreeModel() {
                        StructureViewModel structureViewModel = BaseGraphStructureViewBuilder.OUR_DUMMY_MODEL;
                        if (structureViewModel == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return structureViewModel;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1$1", "getTreeModel"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1", "createStructureView"));
            }
        };
    }

    public static <T> void copyClientProperty(@NotNull JComponent source, @NotNull JComponent target, @NotNull Key<T> key) {
        if (source == null) {
            GraphViewUtil.$$$reportNull$$$0(10);
        }
        if (target == null) {
            GraphViewUtil.$$$reportNull$$$0(11);
        }
        if (key == null) {
            GraphViewUtil.$$$reportNull$$$0(12);
        }
        UIUtil.putClientProperty((JComponent)target, key, (Object)UIUtil.getClientProperty((Object)source, key));
    }

    public static void copyClientProperty(@NotNull JComponent source, @NotNull JComponent target, @NotNull String key) {
        if (source == null) {
            GraphViewUtil.$$$reportNull$$$0(13);
        }
        if (target == null) {
            GraphViewUtil.$$$reportNull$$$0(14);
        }
        if (key == null) {
            GraphViewUtil.$$$reportNull$$$0(15);
        }
        target.putClientProperty(key, source.getClientProperty(source));
    }

    public static void navigateTo(Object node, GraphBuilder builder) {
        for (Object o : builder.getGraphDataModel().getNodes()) {
            if (!o.equals(node)) continue;
            Node n = builder.getNode(node);
            if (n == null) {
                return;
            }
            for (Node nn : builder.getGraph().getNodeArray()) {
                builder.getGraph().setSelected(nn, nn.equals(n));
            }
            builder.getView().setCenter(builder.getGraph().getCenterX(n), builder.getGraph().getCenterY(n));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/util/GraphViewUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeCellRenderer";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/util/GraphViewUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeRealizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDataProvider";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodes";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNodeRealizer";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setRenderedNodeSizes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateWorldRect";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyClientProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

