/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class BaseGraphMouseWheelListener
implements MouseWheelListener {
    private static final int PROCESSING_DELAY = 200;
    @NotNull
    private final GraphBuilder<?, ?> myBuilder;
    private boolean myIsExecutionScheduled;
    private double myCurrentZoomDelta;
    @NotNull
    private Point myLastZoomPoint;

    protected BaseGraphMouseWheelListener(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            BaseGraphMouseWheelListener.$$$reportNull$$$0(0);
        }
        this.myLastZoomPoint = new Point(0, 0);
        this.myBuilder = builder;
    }

    @Override
    public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
        int sign;
        if (e == null) {
            BaseGraphMouseWheelListener.$$$reportNull$$$0(1);
        }
        if ((sign = e.getWheelRotation()) == 0) {
            return;
        }
        if (e.isControlDown()) {
            if (!this.myIsExecutionScheduled) {
                AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> ApplicationManager.getApplication().invokeLater(() -> {
                    this.doZoomChange();
                    this.myIsExecutionScheduled = false;
                    this.myCurrentZoomDelta = 0.0;
                }), 200L, TimeUnit.MILLISECONDS);
                this.myIsExecutionScheduled = true;
            }
            this.myCurrentZoomDelta -= (double)sign * 0.15;
            this.myLastZoomPoint = e.getPoint();
        }
    }

    protected void doZoomChange() {
        Magnificator magnificator = (Magnificator)ComponentUtil.getParentOfType(Magnificator.class, (Component)this.myBuilder.getView().getCanvasComponent());
        if (magnificator != null) {
            double newZoom = this.myBuilder.getZoom() + this.myCurrentZoomDelta;
            magnificator.magnify(newZoom / this.myBuilder.getZoom(), this.myLastZoomPoint);
        }
    }

    @NotNull
    protected GraphBuilder<?, ?> getBuilder() {
        GraphBuilder<?, ?> graphBuilder = this.myBuilder;
        if (graphBuilder == null) {
            BaseGraphMouseWheelListener.$$$reportNull$$$0(2);
        }
        return graphBuilder;
    }

    protected double getCurrentZoomDelta() {
        return this.myCurrentZoomDelta;
    }

    @NotNull
    protected Point getLastZoomPoint() {
        Point point = this.myLastZoomPoint;
        if (point == null) {
            BaseGraphMouseWheelListener.$$$reportNull$$$0(3);
        }
        return point;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/view/BaseGraphMouseWheelListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/view/BaseGraphMouseWheelListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastZoomPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mouseWheelMoved";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

