/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsOptions;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lgit4idea/config/GitSetupProjectConfig;", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "setupConfigIfNeeded", "ConfigVariables", "intellij.vcs.git"})
public final class GitSetupProjectConfig
implements StartupActivity.Background {
    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectLevelVcsManager.getInstance((Project)project).runAfterInitialization(new Runnable(this, project){
            final /* synthetic */ GitSetupProjectConfig this$0;
            final /* synthetic */ Project $project;

            public final void run() {
                GitSetupProjectConfig.access$setupConfigIfNeeded(this.this$0, this.$project);
            }
            {
                this.this$0 = gitSetupProjectConfig;
                this.$project = project;
            }
        });
    }

    private final void setupConfigIfNeeded(Project project) {
        GitVcsSettings gitVcsSettings = GitVcsSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcsSettings), (String)"GitVcsSettings.getInstance(project)");
        GitVcsOptions settings = (GitVcsOptions)gitVcsSettings.getState();
        for (ConfigVariables configVar : ConfigVariables.values()) {
            Function1<GitVcsOptions, String> function1 = configVar.getSettingsGetter();
            GitVcsOptions gitVcsOptions = settings;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcsOptions), (String)"settings");
            String settingsValue = (String)function1.invoke((Object)gitVcsOptions);
            if (settingsValue == null) continue;
            boolean bl = false;
            List rootsToUpdate = new ArrayList();
            GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
            Iterator<GitRepository> iterator = gitRepositoryManager.getRepositories().iterator();
            while (iterator.hasNext()) {
                GitRepository repo;
                GitRepository gitRepository = repo = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
                String value = GitConfigUtil.getValue(project, gitRepository.getRoot(), configVar.getGitName());
                if (value != null) continue;
                rootsToUpdate.add(repo);
            }
            for (GitRepository repo : rootsToUpdate) {
                GitConfigUtil.setValue(project, repo.getRoot(), configVar.getGitName(), settingsValue, "--local");
            }
        }
    }

    public static final /* synthetic */ void access$setupConfigIfNeeded(GitSetupProjectConfig $this, Project project) {
        $this.setupConfigIfNeeded(project);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lgit4idea/config/GitSetupProjectConfig$ConfigVariables;", "", "gitName", "", "settingsGetter", "Lkotlin/Function1;", "Lgit4idea/config/GitVcsOptions;", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getGitName", "()Ljava/lang/String;", "getSettingsGetter", "()Lkotlin/jvm/functions/Function1;", "GC_AUTO", "CORE_LONGPATHS", "intellij.vcs.git"})
    private static final class ConfigVariables
    extends Enum<ConfigVariables> {
        public static final /* enum */ ConfigVariables GC_AUTO;
        public static final /* enum */ ConfigVariables CORE_LONGPATHS;
        private static final /* synthetic */ ConfigVariables[] $VALUES;
        @NotNull
        private final String gitName;
        @NotNull
        private final Function1<GitVcsOptions, String> settingsGetter;

        static {
            ConfigVariables[] configVariablesArray = new ConfigVariables[2];
            ConfigVariables[] configVariablesArray2 = configVariablesArray;
            configVariablesArray[0] = GC_AUTO = new ConfigVariables("gc.auto", (Function1<? super GitVcsOptions, String>)((Function1)1.INSTANCE));
            configVariablesArray[1] = CORE_LONGPATHS = new ConfigVariables("core.longpaths", (Function1<? super GitVcsOptions, String>)((Function1)2.INSTANCE));
            $VALUES = configVariablesArray;
        }

        @NotNull
        public final String getGitName() {
            return this.gitName;
        }

        @NotNull
        public final Function1<GitVcsOptions, String> getSettingsGetter() {
            return this.settingsGetter;
        }

        private ConfigVariables(String gitName, Function1<? super GitVcsOptions, String> settingsGetter) {
            this.gitName = gitName;
            this.settingsGetter = settingsGetter;
        }

        public static ConfigVariables[] values() {
            return (ConfigVariables[])$VALUES.clone();
        }

        public static ConfigVariables valueOf(String string) {
            return Enum.valueOf(ConfigVariables.class, string);
        }
    }
}

