/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import git4idea.stash.GitStashOperations;
import git4idea.ui.StashInfo;
import java.util.EventListener;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002Rf\u0010\u0005\u001aZ\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t \b*,\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \b*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lgit4idea/stash/GitStashCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/vcs/log/CommitId;", "kotlin.jvm.PlatformType", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lgit4idea/stash/GitStashCache$StashData;", "executor", "Lcom/google/common/util/concurrent/ListeningExecutorService;", "getProject", "()Lcom/intellij/openapi/project/Project;", "dispose", "", "getCachedStashData", "stashInfo", "Lgit4idea/ui/StashInfo;", "loadStashData", "scheduleLoading", "commitId", "Companion", "StashData", "StashLoadedListener", "intellij.vcs.git"})
public final class GitStashCache
implements Disposable {
    private final ListeningExecutorService executor;
    private final LoadingCache<CommitId, ListenableFuture<StashData>> cache;
    @NotNull
    private final Project project;
    private static final Logger LOG;
    @NotNull
    private static final Topic<StashLoadedListener> GIT_STASH_LOADED;
    @NotNull
    public static final Companion Companion;

    private final ListenableFuture<StashData> scheduleLoading(CommitId commitId) {
        ListenableFuture future2 = this.executor.submit(new Callable(this, commitId){
            final /* synthetic */ GitStashCache this$0;
            final /* synthetic */ CommitId $commitId;

            public final StashData call() {
                try {
                    GitStashCache.access$getLOG$cp().debug("Loading stash at '" + this.$commitId.getHash() + "' in '" + this.$commitId.getRoot() + '\'');
                    Project project = this.this$0.getProject();
                    VirtualFile virtualFile = this.$commitId.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commitId.root");
                    Hash hash = this.$commitId.getHash();
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commitId.hash");
                    return new StashData.ChangeList((CommittedChangeList)GitStashOperations.INSTANCE.loadStashedChanges(project, virtualFile, hash, false));
                }
                catch (VcsException e) {
                    GitStashCache.access$getLOG$cp().warn("Could not load stash at '" + this.$commitId.getHash() + "' in '" + this.$commitId.getRoot() + '\'', (Throwable)e);
                    return new StashData.Error(e);
                }
            }
            {
                this.this$0 = gitStashCache;
                this.$commitId = commitId;
            }
        });
        future2.addListener(new Runnable(this, commitId){
            final /* synthetic */ GitStashCache this$0;
            final /* synthetic */ CommitId $commitId;

            public final void run() {
                StashLoadedListener stashLoadedListener = (StashLoadedListener)this.this$0.getProject().getMessageBus().syncPublisher(GitStashCache.Companion.getGIT_STASH_LOADED());
                VirtualFile virtualFile = this.$commitId.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commitId.root");
                Hash hash = this.$commitId.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commitId.hash");
                stashLoadedListener.stashLoaded(virtualFile, hash);
            }
            {
                this.this$0 = gitStashCache;
                this.$commitId = commitId;
            }
        }, (Executor)EdtExecutorService.getInstance());
        return future2;
    }

    @Nullable
    public final StashData getCachedStashData(@NotNull StashInfo stashInfo) {
        Intrinsics.checkNotNullParameter((Object)stashInfo, (String)"stashInfo");
        ListenableFuture listenableFuture = (ListenableFuture)this.cache.getIfPresent((Object)new CommitId(stashInfo.getHash(), stashInfo.getRoot()));
        if (listenableFuture == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"cache.getIfPresent(Commi\u2026nfo.root)) ?: return null");
        ListenableFuture future2 = listenableFuture;
        return !future2.isDone() ? null : (StashData)future2.get();
    }

    public final void loadStashData(@NotNull StashInfo stashInfo) {
        Intrinsics.checkNotNullParameter((Object)stashInfo, (String)"stashInfo");
        if (!Disposer.isDisposed((Disposable)this)) {
            this.cache.get((Object)new CommitId(stashInfo.getHash(), stashInfo.getRoot()));
        }
    }

    public void dispose() {
        this.executor.shutdown();
        this.cache.invalidateAll();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public GitStashCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Git Stash Loader", (int)1));
        this.cache = Caffeine.newBuilder().maximumSize(100L).build(new CacheLoader(this){
            final /* synthetic */ GitStashCache this$0;

            @Nullable
            public final ListenableFuture<StashData> load(CommitId it) {
                CommitId commitId = it;
                Intrinsics.checkNotNullExpressionValue((Object)commitId, (String)"it");
                return GitStashCache.access$scheduleLoading(this.this$0, commitId);
            }
            {
                this.this$0 = gitStashCache;
            }
        });
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public final void run() {
                cache.invalidateAll();
            }
        }, (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GitStashCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(GitStashCache::class.java)");
        LOG = logger;
        Topic topic = Topic.create((String)"Git Stash Loaded", StashLoadedListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"Topic.create(\"Git Stash \u2026adedListener::class.java)");
        GIT_STASH_LOADED = topic;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ ListenableFuture access$scheduleLoading(GitStashCache $this, CommitId commitId) {
        return $this.scheduleLoading(commitId);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/GitStashCache$StashData;", "", "()V", "ChangeList", "Error", "Lgit4idea/stash/GitStashCache$StashData$ChangeList;", "Lgit4idea/stash/GitStashCache$StashData$Error;", "intellij.vcs.git"})
    public static abstract class StashData {
        private StashData() {
        }

        public /* synthetic */ StashData(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/GitStashCache$StashData$ChangeList;", "Lgit4idea/stash/GitStashCache$StashData;", "changeList", "Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "(Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;)V", "getChangeList", "()Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "intellij.vcs.git"})
        public static final class ChangeList
        extends StashData {
            @NotNull
            private final CommittedChangeList changeList;

            @NotNull
            public final CommittedChangeList getChangeList() {
                return this.changeList;
            }

            public ChangeList(@NotNull CommittedChangeList changeList) {
                Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
                super(null);
                this.changeList = changeList;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/GitStashCache$StashData$Error;", "Lgit4idea/stash/GitStashCache$StashData;", "error", "Lcom/intellij/openapi/vcs/VcsException;", "(Lcom/intellij/openapi/vcs/VcsException;)V", "getError", "()Lcom/intellij/openapi/vcs/VcsException;", "intellij.vcs.git"})
        public static final class Error
        extends StashData {
            @NotNull
            private final VcsException error;

            @NotNull
            public final VcsException getError() {
                return this.error;
            }

            public Error(@NotNull VcsException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                super(null);
                this.error = error;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lgit4idea/stash/GitStashCache$StashLoadedListener;", "Ljava/util/EventListener;", "stashLoaded", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "intellij.vcs.git"})
    public static interface StashLoadedListener
    extends EventListener {
        public void stashLoaded(@NotNull VirtualFile var1, @NotNull Hash var2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/stash/GitStashCache$Companion;", "", "()V", "GIT_STASH_LOADED", "Lcom/intellij/util/messages/Topic;", "Lgit4idea/stash/GitStashCache$StashLoadedListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getGIT_STASH_LOADED", "()Lcom/intellij/util/messages/Topic;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        @NotNull
        public final Topic<StashLoadedListener> getGIT_STASH_LOADED() {
            return GIT_STASH_LOADED;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

