/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import git4idea.GitVcs;
import git4idea.stash.GitStashTracker;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u00a8\u0006\n"}, d2={"isStashToolWindowAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "isStashToolWindowEnabled", "stashToolWindowRegistryOption", "Lcom/intellij/openapi/util/registry/RegistryValue;", "Lorg/jetbrains/annotations/NotNull;", "isNotEmpty", "Lgit4idea/stash/GitStashTracker;", "intellij.vcs.git"})
public final class GitStashTrackerKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotEmpty(@NotNull GitStashTracker $this$isNotEmpty) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"$this$isNotEmpty");
        Iterable $this$any$iv = $this$isNotEmpty.getStashes().values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            GitStashTracker.Stashes it = (GitStashTracker.Stashes)element$iv;
            boolean bl2 = false;
            if (it instanceof GitStashTracker.Stashes.Error) return true;
            if (it instanceof GitStashTracker.Stashes.Loaded) {
                Collection collection = ((GitStashTracker.Stashes.Loaded)it).getStashes();
                boolean bl3 = false;
                if (!collection.isEmpty()) {
                    return true;
                }
                boolean bl4 = false;
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final RegistryValue stashToolWindowRegistryOption() {
        RegistryValue registryValue = Registry.get((String)"git.enable.stash.toolwindow");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"Registry.get(\"git.enable.stash.toolwindow\")");
        return registryValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStashToolWindowEnabled(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!GitStashTrackerKt.stashToolWindowRegistryOption().asBoolean()) return false;
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(project)");
        AbstractVcs[] abstractVcsArray = projectLevelVcsManager.getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"ProjectLevelVcsManager.g\u2026ce(project).allActiveVcss");
        AbstractVcs[] $this$any$iv = abstractVcsArray;
        boolean $i$f$any = false;
        AbstractVcs[] abstractVcsArray2 = $this$any$iv;
        int n = abstractVcsArray2.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractVcs element$iv;
            AbstractVcs it = element$iv = abstractVcsArray2[n2];
            boolean bl = false;
            AbstractVcs abstractVcs = it;
            Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"it");
            if (Intrinsics.areEqual((Object)abstractVcs.getKeyInstanceMethod(), (Object)GitVcs.getKey())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStashToolWindowAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!GitStashTrackerKt.isStashToolWindowEnabled(project)) return false;
        Project $this$serviceIfCreated$iv = project;
        boolean $i$f$serviceIfCreated = false;
        GitStashTracker gitStashTracker = (GitStashTracker)$this$serviceIfCreated$iv.getServiceIfCreated(GitStashTracker.class);
        if (gitStashTracker == null) return false;
        if (!GitStashTrackerKt.isNotEmpty(gitStashTracker)) return false;
        return true;
    }
}

