/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.DvcsBranchSettingsKt;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.hover.TreeHoverListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.PlatformIcons;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.branch.LinkedBranchDataImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcsUtil.VcsImplUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchTreeNode;
import git4idea.ui.branch.dashboard.BranchesTreeComponent;
import git4idea.ui.branch.dashboard.BranchesTreeComponent$getSelectedRepositories$3;
import git4idea.ui.branch.dashboard.BranchesTreeKt;
import git4idea.ui.branch.dashboard.IncomingOutgoing;
import git4idea.ui.branch.dashboard.NodeType;
import git4idea.ui.branch.dashboard.RemoteInfo;
import icons.DvcsImplIcons;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00180\u0006H\u0002J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001f2\u0006\u0010#\u001a\u00020\u001bJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001a2\u0006\u0010$\u001a\u00020\u0014J\b\u0010%\u001a\u00020\u0018H\u0016J\b\u0010&\u001a\u00020\bH\u0002J\b\u0010'\u001a\u00020\bH\u0002R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "doubleClickHandler", "Lkotlin/Function1;", "Lgit4idea/ui/branch/dashboard/BranchTreeNode;", "", "getDoubleClickHandler", "()Lkotlin/jvm/functions/Function1;", "setDoubleClickHandler", "(Lkotlin/jvm/functions/Function1;)V", "searchField", "Lcom/intellij/ui/SearchTextField;", "getSearchField", "()Lcom/intellij/ui/SearchTextField;", "setSearchField", "(Lcom/intellij/ui/SearchTextField;)V", "findNodeDescriptorInPath", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "path", "Ljavax/swing/tree/TreePath;", "condition", "", "getSelectedBranches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "getSelectedNodes", "Lkotlin/sequences/Sequence;", "getSelectedRemotes", "", "Lgit4idea/ui/branch/dashboard/RemoteInfo;", "getSelectedRepositories", "Lgit4idea/repo/GitRepository;", "branchInfo", "descriptor", "hasFocus", "initDnD", "installDoubleClickHandler", "BranchTreeCellRenderer", "NodeIcon", "intellij.vcs.git"})
public final class BranchesTreeComponent
extends DnDAwareTree {
    @NotNull
    private Function1<? super BranchTreeNode, Unit> doubleClickHandler;
    @Nullable
    private SearchTextField searchField;

    @NotNull
    public final Function1<BranchTreeNode, Unit> getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public final void setDoubleClickHandler(@NotNull Function1<? super BranchTreeNode, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.doubleClickHandler = function1;
    }

    @Nullable
    public final SearchTextField getSearchField() {
        return this.searchField;
    }

    public final void setSearchField(@Nullable SearchTextField searchTextField) {
        this.searchField = searchTextField;
    }

    public boolean hasFocus() {
        SearchTextField searchTextField;
        return super.hasFocus() || ((searchTextField = this.searchField) != null && (searchTextField = searchTextField.getTextEditor()) != null ? searchTextField.hasFocus() : false);
    }

    private final void installDoubleClickHandler() {
        new DoubleClickListener(this){
            final /* synthetic */ BranchesTreeComponent this$0;

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TreePath treePath = this.this$0.getClosestPathForLocation(e.getX(), e.getY());
                if (treePath == null) {
                    return false;
                }
                TreePath clickPath = treePath;
                TreePath selectionPath = this.this$0.getSelectionPath();
                if (selectionPath == null || Intrinsics.areEqual((Object)clickPath, (Object)selectionPath) ^ true) {
                    return false;
                }
                Object object = selectionPath.getLastPathComponent();
                if (!(object instanceof BranchTreeNode)) {
                    object = null;
                }
                BranchTreeNode branchTreeNode = (BranchTreeNode)object;
                if (branchTreeNode == null) {
                    return false;
                }
                BranchTreeNode node2 = branchTreeNode;
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)this.this$0)), (MouseEvent)e)) {
                    return false;
                }
                this.this$0.getDoubleClickHandler().invoke((Object)node2);
                return true;
            }
            {
                this.this$0 = this$0;
            }
        }.installOn((Component)((Object)this));
    }

    private final void initDnD() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.setTransferHandler(BranchesTreeKt.access$getBRANCH_TREE_TRANSFER_HANDLER$p());
        }
    }

    @NotNull
    public final List<BranchInfo> getSelectedBranches() {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull(this.getSelectedNodes(), (Function1)getSelectedBranches.1.INSTANCE));
    }

    @NotNull
    public final Sequence<BranchTreeNode> getSelectedNodes() {
        Object[] objectArray = this.getSelectionPaths();
        if (objectArray == null) {
            return SequencesKt.emptySequence();
        }
        Object[] paths = objectArray;
        return SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])paths), (Function1)getSelectedNodes.1.INSTANCE), (Function1)getSelectedNodes.2.INSTANCE);
    }

    @NotNull
    public final Set<RemoteInfo> getSelectedRemotes() {
        Object[] objectArray = this.getSelectionPaths();
        if (objectArray == null) {
            return SetsKt.emptySet();
        }
        Object[] paths = objectArray;
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])paths), (Function1)getSelectedRemotes.1.INSTANCE), (Function1)getSelectedRemotes.2.INSTANCE), (Function1)getSelectedRemotes.3.INSTANCE), (Function1)getSelectedRemotes.4.INSTANCE));
    }

    @NotNull
    public final List<GitRepository> getSelectedRepositories(@NotNull BranchNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        for (BranchNodeDescriptor parent = descriptor.getParent(); parent != null; parent = parent.getParent()) {
            GitRepository repository = parent.getRepository();
            if (repository == null) continue;
            return CollectionsKt.listOf((Object)repository);
        }
        Object object = descriptor.getBranchInfo();
        if (object == null || (object = ((BranchInfo)object).getRepositories()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final Set<GitRepository> getSelectedRepositories(@NotNull BranchInfo branchInfo) {
        Intrinsics.checkNotNullParameter((Object)branchInfo, (String)"branchInfo");
        Object[] objectArray = this.getSelectionPaths();
        if (objectArray == null) {
            return SetsKt.emptySet();
        }
        Object[] paths = objectArray;
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])paths), (Function1)((Function1)new Function1<TreePath, Boolean>(branchInfo){
            final /* synthetic */ BranchInfo $branchInfo;

            public final boolean invoke(TreePath it) {
                TreePath treePath = it;
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"it");
                Object lastPathComponent = treePath.getLastPathComponent();
                return lastPathComponent instanceof BranchTreeNode && Intrinsics.areEqual((Object)((BranchTreeNode)lastPathComponent).getNodeDescriptor().getBranchInfo(), (Object)this.$branchInfo);
            }
            {
                this.$branchInfo = branchInfo;
                super(1);
            }
        })), (Function1)((Function1)new Function1<TreePath, BranchNodeDescriptor>(this){
            final /* synthetic */ BranchesTreeComponent this$0;

            @Nullable
            public final BranchNodeDescriptor invoke(TreePath it) {
                TreePath treePath = it;
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"it");
                return BranchesTreeComponent.access$findNodeDescriptorInPath(this.this$0, treePath, getSelectedRepositories.1.INSTANCE);
            }
            {
                this.this$0 = branchesTreeComponent;
                super(1);
            }
        })), (Function1)((Function1)BranchesTreeComponent$getSelectedRepositories$3.INSTANCE)));
    }

    private final BranchNodeDescriptor findNodeDescriptorInPath(TreePath path, Function1<? super BranchNodeDescriptor, Boolean> condition) {
        for (TreePath curPath = path; curPath != null; curPath = curPath.getParentPath()) {
            BranchTreeNode node2;
            Object object = curPath.getLastPathComponent();
            if (!(object instanceof BranchTreeNode)) {
                object = null;
            }
            if ((node2 = (BranchTreeNode)object) == null || !((Boolean)condition.invoke((Object)node2.getNodeDescriptor())).booleanValue()) continue;
            return node2.getNodeDescriptor();
        }
        return null;
    }

    public BranchesTreeComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.doubleClickHandler = doubleClickHandler.1.INSTANCE;
        this.putClientProperty(DnDAwareTree.AUTO_SELECT_ON_MOUSE_PRESSED, false);
        this.setCellRenderer((TreeCellRenderer)((Object)new BranchTreeCellRenderer(project)));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setOpaque(false);
        this.setHorizontalAutoScrollingEnabled(false);
        this.installDoubleClickHandler();
        SmartExpander.installOn((JTree)((JTree)((Object)this)));
        TreeHoverListener.DEFAULT.addTo((JComponent)((Object)this));
        this.initDnD();
    }

    public static final /* synthetic */ BranchNodeDescriptor access$findNodeDescriptorInPath(BranchesTreeComponent $this, TreePath path, Function1 condition) {
        return $this.findNodeDescriptorInPath(path, (Function1<? super BranchNodeDescriptor, Boolean>)condition);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0014JB\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0016J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&H\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesTreeComponent$BranchTreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;Lcom/intellij/openapi/project/Project;)V", "branchSettings", "Lcom/intellij/dvcs/branch/DvcsBranchSettings;", "Lorg/jetbrains/annotations/NotNull;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManagerImpl;", "incomingOutgoingIcon", "Lgit4idea/ui/branch/dashboard/BranchesTreeComponent$NodeIcon;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "calcFocusedState", "", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "expanded", "leaf", "row", "", "hasFocus", "getBranchesTooltipData", "", "Lcom/intellij/vcs/branch/BranchData;", "branchName", "", "repositories", "", "Lgit4idea/repo/GitRepository;", "paint", "g", "Ljava/awt/Graphics;", "intellij.vcs.git"})
    private final class BranchTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final GitRepositoryManager repositoryManager;
        private final VcsLogColorManagerImpl colorManager;
        private final DvcsBranchSettings branchSettings;
        private NodeIcon incomingOutgoingIcon;

        /*
         * WARNING - void declaration
         */
        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object object;
            Object object2;
            Object object3;
            Object it;
            Object object4;
            boolean bl;
            boolean bl2;
            Object object5;
            Icon icon;
            boolean isRepositoryNode;
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            if (!(value instanceof BranchTreeNode)) {
                return;
            }
            BranchNodeDescriptor descriptor = ((BranchTreeNode)value).getNodeDescriptor();
            BranchInfo branchInfo = descriptor.getBranchInfo();
            boolean isBranchNode = descriptor.getType() == NodeType.BRANCH;
            boolean isGroupNode = descriptor.getType() == NodeType.GROUP_NODE;
            boolean bl3 = isRepositoryNode = descriptor.getType() == NodeType.GROUP_REPOSITORY_NODE;
            if (isBranchNode && branchInfo != null && branchInfo.isCurrent() && branchInfo.isFavorite()) {
                icon = DvcsImplIcons.CurrentBranchFavoriteLabel;
            } else if (isBranchNode && branchInfo != null && branchInfo.isCurrent()) {
                icon = DvcsImplIcons.CurrentBranchLabel;
            } else if (isBranchNode && branchInfo != null && branchInfo.isFavorite()) {
                icon = AllIcons.Nodes.Favorite;
            } else if (isBranchNode) {
                icon = AllIcons.Vcs.BranchNode;
            } else if (isGroupNode) {
                icon = PlatformIcons.FOLDER_ICON;
            } else if (isRepositoryNode) {
                GitRepository gitRepository = descriptor.getRepository();
                Intrinsics.checkNotNull((Object)gitRepository);
                icon = (Icon)RepositoryChangesBrowserNode.Companion.getRepositoryIcon((Repository)gitRepository, (VcsLogColorManager)this.colorManager);
            } else {
                icon = null;
            }
            this.setIcon(icon);
            this.setToolTipText(branchInfo != null && branchInfo.isLocal() ? BranchPresentation.INSTANCE.getTooltip((Collection)this.getBranchesTooltipData(branchInfo.getBranchName(), (Collection<? extends GitRepository>)BranchesTreeComponent.this.getSelectedRepositories(descriptor))) : null);
            this.append(((BranchTreeNode)value).getTextRepresentation(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            boolean repositoryGrouping = DvcsBranchSettingsKt.isGroupingEnabled((DvcsBranchSettings)this.branchSettings, (GroupingKey)GroupingKey.GROUPING_BY_REPOSITORY);
            if (!repositoryGrouping && branchInfo != null && branchInfo.getRepositories().size() < this.repositoryManager.getRepositories().size()) {
                this.append(" (" + DvcsUtil.getShortNames((Collection)branchInfo.getRepositories()) + ')', SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            BranchInfo branchInfo2 = branchInfo;
            IncomingOutgoing incomingOutgoingState = branchInfo2 != null ? branchInfo2.getIncomingOutgoingState() : null;
            BranchTreeCellRenderer branchTreeCellRenderer = this;
            Object object6 = incomingOutgoingState;
            if (object6 != null && (object6 = object6.getIcon()) != null) {
                object5 = object6;
                bl2 = false;
                bl = false;
                Object object7 = object5;
                object4 = branchTreeCellRenderer;
                boolean bl4 = false;
                object3 = new NodeIcon((Icon)it, this.getPreferredSize().width + tree.getInsets().left);
                branchTreeCellRenderer = object4;
                object2 = object3;
            } else {
                object2 = null;
            }
            branchTreeCellRenderer.incomingOutgoingIcon = object2;
            Object object8 = tree;
            IncomingOutgoing incomingOutgoing = incomingOutgoingState;
            if (incomingOutgoing != null) {
                void $this$run;
                object5 = incomingOutgoing;
                bl2 = false;
                bl = false;
                it = object5;
                object4 = object8;
                boolean bl5 = false;
                object3 = GitBranchPopupActions.LocalBranchActions.constructIncomingOutgoingTooltip($this$run.hasIncoming(), $this$run.hasOutgoing());
                object8 = object4;
                object = object3;
            } else {
                object = null;
            }
            object8.setToolTipText((String)object);
        }

        protected boolean calcFocusedState() {
            SearchTextField searchTextField;
            return super.calcFocusedState() || ((searchTextField = BranchesTreeComponent.this.getSearchField()) != null && (searchTextField = searchTextField.getTextEditor()) != null ? searchTextField.hasFocus() : false);
        }

        /*
         * WARNING - void declaration
         */
        private final List<BranchData> getBranchesTooltipData(String branchName, Collection<? extends GitRepository> repositories) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = repositories;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String presentableRootName;
                void repo;
                GitRepository gitRepository = (GitRepository)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GitBranch gitBranch = repo.getBranches().findLocalBranch(branchName);
                String trackedBranchName = gitBranch != null && (gitBranch = ((GitLocalBranch)gitBranch).findTrackedBranch((GitRepository)repo)) != null ? gitBranch.getName() : null;
                Intrinsics.checkNotNullExpressionValue((Object)VcsImplUtil.getShortVcsRootName((Project)repo.getProject(), (VirtualFile)repo.getRoot()), (String)"VcsImplUtil.getShortVcsR\u2026(repo.project, repo.root)");
                LinkedBranchDataImpl linkedBranchDataImpl = new LinkedBranchDataImpl(presentableRootName, branchName, trackedBranchName);
                collection.add(linkedBranchDataImpl);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        public void paint(@NotNull Graphics g) {
            block0: {
                void icon;
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paint(g);
                NodeIcon nodeIcon = this.incomingOutgoingIcon;
                if (nodeIcon == null) break block0;
                NodeIcon nodeIcon2 = nodeIcon;
                boolean bl = false;
                boolean bl2 = false;
                NodeIcon $dstr$icon$locationX = nodeIcon2;
                boolean bl3 = false;
                Icon icon2 = $dstr$icon$locationX.component1();
                int locationX = $dstr$icon$locationX.component2();
                icon.paintIcon((Component)((Object)this), g, locationX, JBUIScale.scale((int)2));
            }
        }

        public BranchTreeCellRenderer(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
            this.repositoryManager = gitRepositoryManager;
            this.colorManager = RepositoryChangesBrowserNode.Companion.getColorManager(project);
            GitVcsSettings gitVcsSettings = GitVcsSettings.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcsSettings), (String)"GitVcsSettings.getInstance(project)");
            DvcsBranchSettings dvcsBranchSettings = gitVcsSettings.getBranchSettings();
            Intrinsics.checkNotNullExpressionValue((Object)dvcsBranchSettings, (String)"GitVcsSettings.getInstance(project).branchSettings");
            this.branchSettings = dvcsBranchSettings;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesTreeComponent$NodeIcon;", "", "icon", "Ljavax/swing/Icon;", "locationX", "", "(Ljavax/swing/Icon;I)V", "getIcon", "()Ljavax/swing/Icon;", "getLocationX", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.vcs.git"})
    private static final class NodeIcon {
        @NotNull
        private final Icon icon;
        private final int locationX;

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        public final int getLocationX() {
            return this.locationX;
        }

        public NodeIcon(@NotNull Icon icon, int locationX) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            this.icon = icon;
            this.locationX = locationX;
        }

        @NotNull
        public final Icon component1() {
            return this.icon;
        }

        public final int component2() {
            return this.locationX;
        }

        @NotNull
        public final NodeIcon copy(@NotNull Icon icon, int locationX) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            return new NodeIcon(icon, locationX);
        }

        public static /* synthetic */ NodeIcon copy$default(NodeIcon nodeIcon, Icon icon, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                icon = nodeIcon.icon;
            }
            if ((n2 & 2) != 0) {
                n = nodeIcon.locationX;
            }
            return nodeIcon.copy(icon, n);
        }

        @NotNull
        public String toString() {
            return "NodeIcon(icon=" + this.icon + ", locationX=" + this.locationX + ")";
        }

        public int hashCode() {
            Icon icon = this.icon;
            return (icon != null ? icon.hashCode() : 0) * 31 + Integer.hashCode(this.locationX);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NodeIcon)) break block3;
                    NodeIcon nodeIcon = (NodeIcon)object;
                    if (!Intrinsics.areEqual((Object)this.icon, (Object)nodeIcon.icon) || this.locationX != nodeIcon.locationX) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

