/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.testing.ctest;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestBundle;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectState;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectTestInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CTestAvailableTestsDialog
extends DialogWrapper {
    private final List<CidrCTestProjectTestInfo> myTests;
    private final List<Boolean> myEnabledTests;
    private final boolean myIsReadOnly;
    private final Project myProject;
    private TableSpeedSearch myTableSpeedSearch;

    @NotNull
    public List<CidrCTestProjectTestInfo> getEnabledTests() {
        ArrayList<CidrCTestProjectTestInfo> result = new ArrayList<CidrCTestProjectTestInfo>(this.myTests.size());
        for (int i = 0; i < this.myTests.size(); ++i) {
            if (!this.myEnabledTests.get(i).booleanValue()) continue;
            result.add(this.myTests.get(i));
        }
        ArrayList<CidrCTestProjectTestInfo> arrayList = result;
        if (arrayList == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    protected CTestAvailableTestsDialog(@NotNull Project project, @NotNull List<CidrCTestProjectTestInfo> tests, @NotNull List<CidrCTestProjectTestInfo> selectedTests, boolean isReadOnlyMode) {
        if (project == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(1);
        }
        if (tests == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(2);
        }
        if (selectedTests == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(3);
        }
        super(project, false);
        this.myTests = tests;
        this.myProject = project;
        HashSet selectedTestNames = new HashSet(ContainerUtil.map(selectedTests, CidrCTestProjectTestInfo::getTestName));
        this.myEnabledTests = ContainerUtil.map(tests, test -> selectedTestNames.contains(test.getTestName()));
        this.myIsReadOnly = isReadOnlyMode;
        this.setTitle(CidrCTestBundle.message("ctest.available.tests.link", new Object[0]));
        this.init();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray;
        if (this.myIsReadOnly) {
            Action[] actionArray2 = new Action[1];
            actionArray = actionArray2;
            actionArray2[0] = this.myOKAction;
        } else {
            Action[] actionArray3 = new Action[2];
            actionArray3[0] = this.myOKAction;
            actionArray = actionArray3;
            actionArray3[1] = this.myCancelAction;
        }
        if (actionArray == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        if (this.myTests.isEmpty()) {
            return CTestAvailableTestsDialog.createNoTestsFoundLabel(this.myProject);
        }
        FormBuilder builder = new FormBuilder();
        JBTable table = this.createTable();
        this.myTableSpeedSearch = new TableSpeedSearch((JTable)table);
        this.myTableSpeedSearch.setClearSearchOnNavigateNoMatch(true);
        builder.addComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)table));
        if (!this.myIsReadOnly) {
            builder.addComponent(this.createTableSelectActions(table));
        }
        builder.getPanel().setPreferredSize(CTestAvailableTestsDialog.getPreferredDialogDimension((JTable)table));
        return builder.getPanel();
    }

    private static Dimension getPreferredDialogDimension(@NotNull JTable table) {
        if (table == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(5);
        }
        int VISIBLE_ROWS = 10;
        int height = table.getRowHeight() * 10 + table.getIntercellSpacing().height * 11 + table.getTableHeader().getPreferredSize().height + 50;
        return new Dimension(400, height);
    }

    private JComponent createTableSelectActions(@NotNull JBTable table) {
        if (table == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(6);
        }
        JPanel panel = new JPanel((LayoutManager)new HorizontalLayout(0));
        panel.add(this.createSelectionButton(CidrCTestBundle.message("ctest.select.all.tests.button", new Object[0]), true, (JTable)table));
        panel.add(this.createSelectionButton(CidrCTestBundle.message("ctest.unselect.all.tests.button", new Object[0]), false, (JTable)table));
        return panel;
    }

    private JButton createSelectionButton(@NotNull @Nls String buttonText, final boolean selectAll, final @NotNull JTable table) {
        if (buttonText == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(7);
        }
        if (table == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(8);
        }
        JButton button = new JButton(buttonText);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableModel model = table.getModel();
                for (int row = 0; row < model.getRowCount(); ++row) {
                    model.setValueAt(selectAll, row, 0);
                }
                table.updateUI();
                CTestAvailableTestsDialog.this.myOKAction.setEnabled(selectAll);
            }
        });
        return button;
    }

    @NotNull
    private JBTable createTable() {
        DefaultTableModel model = this.createTableModel();
        JBTable table = new JBTable((TableModel)model);
        this.setHeaderValues(table);
        this.setColumnRenderers(table);
        this.setColumnWidths((JTable)table);
        table.setFillsViewportHeight(true);
        JBTable.setupCheckboxShortcut((JTable)table, (int)0);
        JBTable jBTable = table;
        if (jBTable == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(9);
        }
        return jBTable;
    }

    private void setColumnRenderers(@NotNull JBTable table) {
        if (table == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(10);
        }
        TableColumnModel columnModel = table.getColumnModel();
        int startIndex = 0;
        if (!this.myIsReadOnly) {
            TableColumn column = columnModel.getColumn(0);
            column.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
            column.setCellEditor((TableCellEditor)new BooleanTableCellEditor());
            column.setHeaderRenderer(CTestAvailableTestsDialog.createDefaultTableCellRenderer());
            startIndex = 1;
        }
        for (int i = startIndex; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            column.setCellRenderer(this.createColoredTableCellRenderer());
            column.setHeaderRenderer(CTestAvailableTestsDialog.createDefaultTableCellRenderer());
        }
    }

    private TableCellRenderer createColoredTableCellRenderer() {
        ColoredTableCellRenderer renderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value == null || CTestAvailableTestsDialog.this.myTableSpeedSearch == null) {
                    return;
                }
                SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                SearchUtil.appendFragments((String)CTestAvailableTestsDialog.this.myTableSpeedSearch.getEnteredPrefix(), (String)value.toString(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestAvailableTestsDialog$2", "customizeCellRenderer"));
            }
        };
        renderer.setTextAlign(0);
        return renderer;
    }

    private static TableCellRenderer createDefaultTableCellRenderer() {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        return renderer;
    }

    private void setColumnWidths(@NotNull JTable table) {
        if (table == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(11);
        }
        TableColumnModel columnModel = table.getColumnModel();
        if (this.myIsReadOnly) {
            TableColumn testNumberColumn = columnModel.getColumn(0);
            testNumberColumn.setMaxWidth(100);
        } else {
            TableColumn enableColumn = columnModel.getColumn(0);
            enableColumn.setMaxWidth(100);
            TableColumn testNumberColumn = columnModel.getColumn(1);
            testNumberColumn.setMaxWidth(100);
        }
    }

    private void setHeaderValues(@NotNull JBTable table) {
        if (table == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(12);
        }
        TableColumnModel columnModel = table.getColumnModel();
        if (this.myIsReadOnly) {
            columnModel.getColumn(0).setHeaderValue(CidrCTestBundle.message("ctest.test.number.column.header", new Object[0]));
            columnModel.getColumn(1).setHeaderValue(CidrCTestBundle.message("ctest.test.name.column.header", new Object[0]));
        } else {
            columnModel.getColumn(0).setHeaderValue(CidrCTestBundle.message("ctest.test.number.column.enabled", new Object[0]));
            columnModel.getColumn(1).setHeaderValue(CidrCTestBundle.message("ctest.test.number.column.header", new Object[0]));
            columnModel.getColumn(2).setHeaderValue(CidrCTestBundle.message("ctest.test.name.column.header", new Object[0]));
        }
    }

    @NotNull
    private DefaultTableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel(this.myTests.size(), this.myIsReadOnly ? 2 : 3){

            @Override
            public boolean isCellEditable(int row, int column) {
                return !CTestAvailableTestsDialog.this.myIsReadOnly && column == 0;
            }

            @Override
            public Object getValueAt(int row, int column) {
                switch (column) {
                    case 0: {
                        return !CTestAvailableTestsDialog.this.myIsReadOnly ? (Serializable)CTestAvailableTestsDialog.this.myEnabledTests.get(row) : Integer.valueOf(CTestAvailableTestsDialog.this.myTests.get(row).getTestNumber());
                    }
                    case 1: {
                        return !CTestAvailableTestsDialog.this.myIsReadOnly ? Integer.valueOf(CTestAvailableTestsDialog.this.myTests.get(row).getTestNumber()) : CTestAvailableTestsDialog.this.myTests.get(row).getTestName();
                    }
                    case 2: {
                        return !CTestAvailableTestsDialog.this.myIsReadOnly ? CTestAvailableTestsDialog.this.myTests.get(row).getTestName() : "";
                    }
                }
                return "";
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (CTestAvailableTestsDialog.this.myIsReadOnly || column != 0) {
                    return;
                }
                CTestAvailableTestsDialog.this.myEnabledTests.set(row, (boolean)((Boolean)aValue));
                CTestAvailableTestsDialog.this.myOKAction.setEnabled(CTestAvailableTestsDialog.this.myEnabledTests.stream().anyMatch(t -> t));
            }
        };
        model.setRowCount(this.myTests.size());
        DefaultTableModel defaultTableModel = model;
        if (defaultTableModel == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(13);
        }
        return defaultTableModel;
    }

    @NotNull
    private static JComponent createNoTestsFoundLabel(@NotNull Project project) {
        CidrCTestProjectState state;
        if (project == null) {
            CTestAvailableTestsDialog.$$$reportNull$$$0(14);
        }
        return new JBLabel((state = (CidrCTestProjectState)project.getService(CidrCTestProjectState.class)).getBuildConfiguration() == null ? CidrCTestBundle.message("ctest.build.configuration.is.not.selected", new Object[0]) : CidrCTestBundle.message("ctest.no.available.tests", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestAvailableTestsDialog";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tests";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedTests";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttonText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledTests";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestAvailableTestsDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredDialogDimension";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTableSelectActions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSelectionButton";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setColumnRenderers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setColumnWidths";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setHeaderValues";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createNoTestsFoundLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

