/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.impl.stubs.index.CssAttributeIndex;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssAttributeDescriptorsProvider
implements XmlAttributeDescriptorsProvider {
    private static final Key<CachedValue<ConcurrentMap<String, CachedValue<XmlAttributeDescriptor[]>>>> CACHE = Key.create((String)"css.attr.cache");
    public static final Key<Boolean> DO_NOT_PROVIDE_ATTRIBUTES_FROM_CSS = Key.create((String)"do.not.provide.attributes.from.css");

    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag context) {
        if (!HtmlUtil.isHtmlTag((XmlTag)context) || ((Boolean)DO_NOT_PROVIDE_ATTRIBUTES_FROM_CSS.get((UserDataHolder)context, (Object)false)).booleanValue()) {
            return XmlAttributeDescriptor.EMPTY;
        }
        final String name = context.getLocalName();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        final Project project = context.getProject();
        Module holder = module != null ? module : project;
        final GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context);
        ConcurrentMap<String, CachedValue<XmlAttributeDescriptor[]>> cache = CssAttributeDescriptorsProvider.getCache((ComponentManager)holder, project);
        CachedValue<XmlAttributeDescriptor[]> value = (CachedValue<XmlAttributeDescriptor[]>)cache.get(name);
        if (value == null) {
            final PsiManager manager = PsiManager.getInstance((Project)project);
            CachedValue<XmlAttributeDescriptor[]> newValue = new CachedValue<XmlAttributeDescriptor[]>(manager, (CachedValueProvider)new CachedValueProvider<XmlAttributeDescriptor[]>(){

                @NotNull
                public CachedValueProvider.Result<XmlAttributeDescriptor[]> compute() {
                    Collection keys = StubIndex.getInstance().getAllKeys(CssAttributeIndex.KEY, project);
                    if (keys.isEmpty()) {
                        CachedValueProvider.Result<XmlAttributeDescriptor[]> result = this.emptyResult();
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return result;
                    }
                    ArrayList descriptors = new ArrayList();
                    for (String key : keys) {
                        if (!key.startsWith(name + ".") && !key.startsWith("*.")) continue;
                        ContainerUtil.addIfNotNull(descriptors, (Object)CssAttributeDescriptorsProvider.getDescriptor(key, scope, project));
                    }
                    if (descriptors.isEmpty()) {
                        CachedValueProvider.Result<XmlAttributeDescriptor[]> result = this.emptyResult();
                        if (result == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return result;
                    }
                    XmlAttributeDescriptor[] result = descriptors.toArray(XmlAttributeDescriptor.EMPTY);
                    ArrayList dependencies = ContainerUtil.newArrayList((Object[])new Object[]{CssAttributeDescriptorsProvider.getCssModificationTracker(manager)});
                    for (XmlAttributeDescriptor descriptor : descriptors) {
                        ContainerUtil.addIfNotNull((Collection)dependencies, (Object)descriptor.getDeclaration());
                    }
                    CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)result, (Collection)dependencies);
                    if (result2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return result2;
                }

                private CachedValueProvider.Result<XmlAttributeDescriptor[]> emptyResult() {
                    return CachedValueProvider.Result.create((Object)XmlAttributeDescriptor.EMPTY, (Object[])new Object[]{CssAttributeDescriptorsProvider.getCssModificationTracker(manager)});
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssAttributeDescriptorsProvider$1", "compute"));
                }
            });
            value = cache.putIfAbsent(name, newValue);
            value = value == null ? newValue : value;
        }
        return (XmlAttributeDescriptor[])value.getValue();
    }

    @NotNull
    private static ConcurrentMap<String, CachedValue<XmlAttributeDescriptor[]>> getCache(@NotNull ComponentManager holder, @NotNull Project project) {
        if (holder == null) {
            CssAttributeDescriptorsProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CssAttributeDescriptorsProvider.$$$reportNull$$$0(1);
        }
        ConcurrentMap concurrentMap = (ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)holder, CACHE, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}), false);
        if (concurrentMap == null) {
            CssAttributeDescriptorsProvider.$$$reportNull$$$0(2);
        }
        return concurrentMap;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        if (!HtmlUtil.isHtmlTag((XmlTag)context) || DumbService.isDumb((Project)context.getProject())) {
            return null;
        }
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context);
        XmlAttributeDescriptor descriptor = CssAttributeDescriptorsProvider.getDescriptor(context.getLocalName() + "." + attributeName, scope, context.getProject());
        return descriptor != null ? descriptor : CssAttributeDescriptorsProvider.getDescriptor("*." + attributeName, scope, context.getProject());
    }

    private static XmlAttributeDescriptor getDescriptor(String attributeIndexKey, GlobalSearchScope scope, Project project) {
        Ref result = Ref.create();
        StubIndex.getInstance().processElements(CssAttributeIndex.KEY, (Object)attributeIndexKey, project, scope, CssAttribute.class, attribute -> {
            result.set((Object)new CssAttributeDescriptor((CssAttribute)attribute));
            return false;
        });
        return (XmlAttributeDescriptor)result.get();
    }

    @NotNull
    static ModificationTracker getCssModificationTracker(@NotNull PsiManager manager) {
        if (manager == null) {
            CssAttributeDescriptorsProvider.$$$reportNull$$$0(3);
        }
        ModificationTracker modificationTracker = manager.getModificationTracker().forLanguages(language -> language.isKindOf((Language)CSSLanguage.INSTANCE));
        if (modificationTracker == null) {
            CssAttributeDescriptorsProvider.$$$reportNull$$$0(4);
        }
        return modificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/CssAttributeDescriptorsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/CssAttributeDescriptorsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCache";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCssModificationTracker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CssAttributeDescriptor
    extends BasicXmlAttributeDescriptor
    implements XmlAttributeDescriptorEx {
        private final CssAttribute myAttribute;

        CssAttributeDescriptor(CssAttribute attribute) {
            this.myAttribute = attribute;
        }

        @Nullable
        public String handleTargetRename(@NotNull @NonNls String newTargetName) {
            if (newTargetName == null) {
                CssAttributeDescriptor.$$$reportNull$$$0(0);
            }
            return null;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean hasIdType() {
            return false;
        }

        public boolean hasIdRefType() {
            return false;
        }

        public boolean isEnumerated() {
            return false;
        }

        public PsiElement getDeclaration() {
            return this.myAttribute;
        }

        public String getName() {
            return this.myAttribute.getAttributeName();
        }

        public void init(PsiElement element) {
        }

        public Object @NotNull [] getDependencies() {
            Object[] objectArray = new Object[]{this.myAttribute};
            if (objectArray == null) {
                CssAttributeDescriptor.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        public boolean isFixed() {
            return false;
        }

        public String getDefaultValue() {
            return null;
        }

        public String[] getEnumeratedValues() {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newTargetName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/CssAttributeDescriptorsProvider$CssAttributeDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/CssAttributeDescriptorsProvider$CssAttributeDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTargetRename";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

