/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CssTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        char prevChar;
        int offset;
        if (project == null) {
            CssTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CssTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CssTypedHandler.$$$reportNull$$$0(2);
        }
        if (!(file instanceof StylesheetFile) && !CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file)) {
            TypedHandlerDelegate.Result result = super.checkAutoPopup(charTyped, project, editor, file);
            if (result == null) {
                CssTypedHandler.$$$reportNull$$$0(3);
            }
            return result;
        }
        AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)project);
        if (charTyped == '#' && CssTypedHandler.insideStylesheet(editor, file)) {
            autoPopupController.autoPopupMemberLookup(editor, null);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                CssTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (charTyped == '-' || charTyped == '!') {
            boolean insideBlock;
            boolean bl = insideBlock = PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), CssBlock.class) != null;
            if (insideBlock) {
                autoPopupController.autoPopupMemberLookup(editor, null);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    CssTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
        } else if (charTyped == ' ' && CssTypedHandler.insideStylesheet(editor, file) && (offset = editor.getCaretModel().getOffset()) > 0 && ('{' == (prevChar = editor.getDocument().getCharsSequence().charAt(offset - 1)) || ';' == prevChar || ':' == prevChar)) {
            autoPopupController.autoPopupMemberLookup(editor, null);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                CssTypedHandler.$$$reportNull$$$0(6);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = super.checkAutoPopup(charTyped, project, editor, file);
        if (result == null) {
            CssTypedHandler.$$$reportNull$$$0(7);
        }
        return result;
    }

    private static boolean insideStylesheet(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            CssTypedHandler.$$$reportNull$$$0(8);
        }
        if (file == null) {
            CssTypedHandler.$$$reportNull$$$0(9);
        }
        return file instanceof StylesheetFile || CssPsiUtil.getStylesheetLanguage((PsiElement)file.findElementAt(editor.getCaretModel().getOffset())) != null;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        Document document;
        int offset;
        if (project == null) {
            CssTypedHandler.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            CssTypedHandler.$$$reportNull$$$0(11);
        }
        if (file == null) {
            CssTypedHandler.$$$reportNull$$$0(12);
        }
        if (fileType == null) {
            CssTypedHandler.$$$reportNull$$$0(13);
        }
        if (!(file instanceof StylesheetFile) && !CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file)) {
            TypedHandlerDelegate.Result result = super.beforeCharTyped(c, project, editor, file, fileType);
            if (result == null) {
                CssTypedHandler.$$$reportNull$$$0(14);
            }
            return result;
        }
        String terminator = CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)file);
        if (terminator.length() == 1 && c == terminator.charAt(0) && (offset = editor.getCaretModel().getOffset()) < (document = editor.getDocument()).getTextLength() && document.getCharsSequence().charAt(offset) == c && this.isEditableOffset(project, document, offset)) {
            editor.getCaretModel().moveToOffset(offset + 1);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                CssTypedHandler.$$$reportNull$$$0(15);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = super.beforeCharTyped(c, project, editor, file, fileType);
        if (result == null) {
            CssTypedHandler.$$$reportNull$$$0(16);
        }
        return result;
    }

    private boolean isEditableOffset(Project project, Document document, int offset) {
        if (document instanceof DocumentWindow) {
            for (TextRange fragment : InjectedLanguageManager.getInstance((Project)project).getNonEditableFragments((DocumentWindow)document)) {
                if (!fragment.contains(offset)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/CssTypedHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/CssTypedHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "insideStylesheet";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

