/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.actions.CssBaseElementAtCaretIntentionAction;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CssExpandShorthandPropertyAction
extends CssBaseElementAtCaretIntentionAction {
    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"expand.shorthand.action", (Object[])new Object[0]);
        if (string == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(2);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        CssDeclaration cssDeclaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
        if (cssDeclaration == null || !cssDeclaration.isShorthandProperty()) {
            return false;
        }
        CssTermList termList = cssDeclaration.getValue();
        if (termList == null) {
            return false;
        }
        for (PsiElement child : termList.getChildren()) {
            if (child instanceof PsiErrorElement) {
                return false;
            }
            if (!(child instanceof CssTerm) || ((CssTerm)child).getTermType() != CssTermTypes.IDENT) continue;
            PsiElement identChild = child.getFirstChild();
            if (identChild == null) {
                return false;
            }
            IElementType elementType = identChild.getNode().getElementType();
            if (elementType == CssElementTypes.CSS_IDENT) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"expand.shorthand.family", (Object[])new Object[0]);
        if (string == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        CssDeclaration declaration;
        if (project == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            CssExpandShorthandPropertyAction.$$$reportNull$$$0(5);
        }
        if ((declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class)) != null && declaration.isShorthandProperty()) {
            String[] properties = declaration.expandShorthandProperty();
            Map<String, String> name2value = CssPropertyUtil.getExpandedShorthandValues(declaration, properties);
            PsiElement parent1 = declaration.getParent();
            if (parent1 instanceof CssBlock) {
                if (!name2value.isEmpty()) {
                    CssBlock block = (CssBlock)parent1;
                    for (String name : name2value.keySet()) {
                        block.addDeclaration(name, name2value.get(name), declaration);
                    }
                    block.removeDeclaration(declaration);
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                } else {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message((String)"expand.shorthand.error", (Object[])new Object[0]), (String)"", null);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/CssExpandShorthandPropertyAction";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/CssExpandShorthandPropertyAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

