/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CssInvalidImportInspection
extends CssBaseInspection {
    private static final LocalQuickFix REMOVE_MISPLACED_IMPORT = new LocalQuickFix(){

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message((String)"css.invalid.import.remove.fix.name", (Object[])new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                1.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                1.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) instanceof CssImport) {
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).run(() -> element.delete());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final LocalQuickFix MOVE_IMPORT_TO_IMPORT_LIST_FIX = new LocalQuickFix(){

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message((String)"css.invalid.import.fix.name", (Object[])new Object[0]);
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                2.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                2.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor.getPsiElement()) instanceof CssImport)) {
                return;
            }
            CssStylesheet stylesheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)element, CssStylesheet.class);
            if (stylesheet != null) {
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).run(() -> {
                    CssImport lastImport = (CssImport)ContainerUtil.getLastItem((List)stylesheet.getImports());
                    if (lastImport != null) {
                        PsiElement importList = lastImport.getParent();
                        if (importList != null) {
                            importList.addAfter(element, (PsiElement)lastImport);
                        }
                    } else {
                        CssElementFactory elementFactory = CssElementFactory.getInstance((Project)project);
                        CssImportList importList = elementFactory.createImportList(CssPsiUtil.getStylesheetLanguage((PsiElement)element), new String[]{element.getText()});
                        stylesheet.addBefore((PsiElement)importList, (PsiElement)stylesheet.getRulesetList());
                    }
                    element.delete();
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection$2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidImportInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            public void visitCssImport(CssImport cssImport) {
                if (!CssInvalidImportInspection.isSuitableElement((PsiElement)cssImport)) {
                    return;
                }
                PsiElement parent = cssImport.getParent();
                ASTNode node = parent.getNode();
                if (node != null && node.getElementType() != CssElementTypes.CSS_IMPORT_LIST) {
                    holder.registerProblem((PsiElement)cssImport, CssBundle.message((String)"css.inspections.invalid.import", (Object[])new Object[0]), new LocalQuickFix[]{MOVE_IMPORT_TO_IMPORT_LIST_FIX, REMOVE_MISPLACED_IMPORT});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection", "buildVisitor"));
    }
}

