/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.lineIndent.FormatterBasedLineIndentProvider;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuoteImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItemImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0012\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListIndentProvider;", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/FormatterBasedLineIndentProvider;", "()V", "doGetLineIndent", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "offset", "", "getLineIndent", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "isInBlockQuoteOrCodeFence", "", "isSuitableFor", "intellij.markdown"})
public final class MarkdownListIndentProvider
extends FormatterBasedLineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor2, @Nullable Language language, int offset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiFile psiFile = PsiEditorUtil.getPsiFile((Editor)editor2);
        if (!(psiFile instanceof MarkdownFile)) {
            psiFile = null;
        }
        MarkdownFile markdownFile = (MarkdownFile)psiFile;
        if (markdownFile == null) {
            return null;
        }
        MarkdownFile file = markdownFile;
        String string = this.doGetLineIndent(editor2, file, offset);
        if (string == null) {
            string = super.getLineIndent(project, editor2, language, offset);
        }
        return string;
    }

    private final String doGetLineIndent(Editor editor2, MarkdownFile file, int offset) {
        if (this.isInBlockQuoteOrCodeFence(editor2, file)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)((Boolean)editor2.getUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY)), (Object)true)) {
            return null;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        int prevLine = document2.getLineNumber(offset) - 1;
        MarkdownListItemImpl markdownListItemImpl = ListUtils.INSTANCE.getListItemAtLineSafely(file, prevLine, document2);
        if (markdownListItemImpl == null) {
            markdownListItemImpl = ListUtils.INSTANCE.getListItemAtLineSafely(file, prevLine - 1, document2);
        }
        if (markdownListItemImpl == null) {
            return null;
        }
        MarkdownListItemImpl listItem = markdownListItemImpl;
        int firstLine = document2.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)listItem)));
        TextRange indentRange = ListUtils.INSTANCE.getLineIndentRange(document2, firstLine);
        return document2.getText(indentRange);
    }

    private final boolean isInBlockQuoteOrCodeFence(Editor editor2, MarkdownFile file) {
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int prevLine = document2.getLineNumber(caretModel.getOffset()) - 1;
        if (prevLine == -1) {
            return false;
        }
        int prevLineEnd = document2.getLineEndOffset(prevLine);
        int beforeWhitespaceOffset = CharArrayUtil.shiftBackward((CharSequence)document2.getText(), (int)(prevLineEnd - 1), (String)" \t");
        if (beforeWhitespaceOffset == -1) {
            return false;
        }
        PsiElement psiElement = file.findElementAt(beforeWhitespaceOffset);
        return (psiElement != null ? PsiTreeUtilKt.parentOfTypes$default((PsiElement)psiElement, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(MarkdownBlockQuoteImpl.class), Reflection.getOrCreateKotlinClass(MarkdownCodeFenceImpl.class)}, (boolean)false, (int)2, null) : null) != null;
    }

    public boolean isSuitableFor(@Nullable Language language) {
        return language instanceof MarkdownLanguage;
    }
}

