/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.MarkdownListMarkerBackspaceHandlerDelegate$charDeleted$;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItemImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListMarkerBackspaceHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "()V", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItemImpl;", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "", "listWillBeSplitToTwoLists", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.markdown"})
public final class MarkdownListMarkerBackspaceHandlerDelegate
extends BackspaceHandlerDelegate {
    private MarkdownListItemImpl item;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.item = null;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int deletedOffset = caretModel.getOffset() - 1;
        if (!(file instanceof MarkdownFile) || deletedOffset < 0) {
            return;
        }
        PsiDocumentManager.getInstance((Project)((MarkdownFile)file).getProject()).commitDocument(editor2.getDocument());
        PsiElement psiElement = file.findElementAt(deletedOffset);
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"file.findElementAt(deletedOffset) ?: return");
        PsiElement marker2 = psiElement;
        if (MarkdownTokenTypeSets.LIST_MARKERS.contains(PsiTreeUtilKt.getElementType((PsiElement)marker2))) {
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            int nonWsStartOffset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)UtilsKt.getStartOffset((PsiElement)marker2), (String)" \t");
            if (nonWsStartOffset <= deletedOffset) {
                PsiElement $this$parentOfType$iv = marker2;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                this.item = (MarkdownListItemImpl)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownListItemImpl.class, (boolean)true);
            }
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        block5: {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            MarkdownListItemImpl markdownListItemImpl = this.item;
            if (markdownListItemImpl == null) {
                return false;
            }
            MarkdownListItemImpl item = markdownListItemImpl;
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            Document document2 = document;
            boolean createsNewList = this.listWillBeSplitToTwoLists(item, document2);
            Object $this$descendantsOfType$iv = (PsiElement)ListUtils.INSTANCE.getList(item);
            boolean childrenFirst$iv = false;
            boolean $i$f$descendantsOfType = false;
            Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType$iv, (boolean)childrenFirst$iv, null, (int)2, null);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)charDeleted$$inlined$descendantsOfType$1.INSTANCE);
            if (sequence == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            MarkdownListItemImpl markdownListItemImpl2 = (MarkdownListItemImpl)SequencesKt.firstOrNull((Sequence)SequencesKt.drop((Sequence)SequencesKt.dropWhile((Sequence)sequence, (Function1)((Function1)new Function1<MarkdownListItemImpl, Boolean>(item){
                final /* synthetic */ MarkdownListItemImpl $item;

                public final boolean invoke(@NotNull MarkdownListItemImpl it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$item) ^ true;
                }
                {
                    this.$item = markdownListItemImpl;
                    super(1);
                }
            })), (int)1));
            if (markdownListItemImpl2 != null) {
                $this$descendantsOfType$iv = markdownListItemImpl2;
                childrenFirst$iv = false;
                boolean bl = false;
                Object it = $this$descendantsOfType$iv;
                boolean bl2 = false;
                n = document2.getLineNumber(UtilsKt.getStartOffset((PsiElement)it));
            } else {
                n = null;
            }
            Integer nextItemFirstLine2 = n;
            PsiElement psiElement = item.getMarkerElement();
            Intrinsics.checkNotNull((Object)psiElement);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"item.markerElement!!");
            TextRange range = psiElement.getTextRange();
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(document2, range){
                final /* synthetic */ Document $document$inlined;
                final /* synthetic */ TextRange $range$inlined;
                {
                    this.$document$inlined = document;
                    this.$range$inlined = textRange;
                }

                public final T compute() {
                    boolean bl = false;
                    TextRange textRange = this.$range$inlined;
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
                    int n = textRange.getStartOffset();
                    TextRange textRange2 = this.$range$inlined;
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"range");
                    this.$document$inlined.deleteString(n, textRange2.getEndOffset() - 1);
                    return (T)Unit.INSTANCE;
                }
            });
            if (nextItemFirstLine2 == null || createsNewList) break block5;
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document2);
            MarkdownCompositePsiElementBase markdownCompositePsiElementBase = ListUtils.INSTANCE.getListItemAtLine((MarkdownFile)file, nextItemFirstLine2, document2);
            if (markdownCompositePsiElementBase != null && (markdownCompositePsiElementBase = ListUtils.INSTANCE.getList((MarkdownListItemImpl)markdownCompositePsiElementBase)) != null) {
                ListRenumberUtils.INSTANCE.renumberInBulk((MarkdownListImpl)markdownCompositePsiElementBase, document2, false, false);
            }
        }
        return true;
    }

    private final boolean listWillBeSplitToTwoLists(MarkdownListItemImpl item, Document document) {
        int itemFirstLine = document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)item)));
        int n = UtilsKt.getEndOffset((PsiElement)((PsiElement)item)) - 1;
        int n2 = document.getTextLength();
        boolean bl = false;
        int itemLastLine = document.getLineNumber(Math.min(n, n2));
        boolean emptyLineBefore = itemFirstLine > 0 && DocumentUtil.isLineEmpty((Document)document, (int)(itemFirstLine - 1));
        boolean emptyLineAfter = itemLastLine + 1 < document.getLineCount() && DocumentUtil.isLineEmpty((Document)document, (int)(itemFirstLine + 1));
        boolean nearEmptyLine = emptyLineBefore || emptyLineAfter;
        CharSequence charSequence = document.getText();
        PsiElement psiElement = item.getMarkerElement();
        Intrinsics.checkNotNull((Object)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"item.markerElement!!");
        boolean onlyMarkerLine = CharArrayUtil.shiftForward((CharSequence)charSequence, (int)(UtilsKt.getEndOffset((PsiElement)psiElement) - 1), (String)" \t") == document.getLineEndOffset(itemFirstLine);
        PsiElement $this$parentsOfType$iv = (PsiElement)item;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        boolean hasPreviousItem = Intrinsics.areEqual((Object)((MarkdownListItemImpl)CollectionsKt.first(ListUtils.INSTANCE.getItems((MarkdownListImpl)SequencesKt.last((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, MarkdownListImpl.class, (boolean)withSelf$iv))))), (Object)item) ^ true;
        return hasPreviousItem && nearEmptyLine && onlyMarkerLine;
    }
}

